/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep.app;

import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.testtype.IRemoteTest;
import java.util.ArrayList;

@OptionClass(alias="no-apk-skipper")
public final class NoApkTestSkipper
extends BaseTargetPreparer
implements IConfigurationReceiver {
    private IConfiguration mConfiguration;

    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (testInfo.getBuildInfo().getAppPackageFiles().isEmpty()) {
            LogUtil.CLog.d("No app to install, skipping the tests");
            for (IDeviceConfiguration deviceConfig : this.mConfiguration.getDeviceConfig()) {
                for (ITargetPreparer preparer : deviceConfig.getTargetPreparers()) {
                    preparer.setDisable(true);
                }
            }
            this.mConfiguration.setTests(new ArrayList<IRemoteTest>());
        }
    }

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.mConfiguration = configuration;
    }
}

