/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep.companion;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceSelectionOptions;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.targetprep.companion.CompanionDeviceTracker;

public abstract class CompanionAllocator
extends BaseTargetPreparer {
    @Override
    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice companionDevice = this.getCompanionDeviceTracker().allocateCompanionDevice(device, this.getCompanionDeviceSelectionOptions());
        if (companionDevice == null) {
            throw new TargetSetupError(String.format("failed to allocate companion device for %s", device.getSerialNumber()), device.getDeviceDescriptor());
        }
    }

    protected abstract DeviceSelectionOptions getCompanionDeviceSelectionOptions();

    @Override
    public void tearDown(ITestDevice device, IBuildInfo buildInfo, Throwable e) throws DeviceNotAvailableException {
        this.getCompanionDeviceTracker().freeCompanionDevice(device);
    }

    private CompanionDeviceTracker getCompanionDeviceTracker() {
        return CompanionDeviceTracker.getInstance();
    }
}

