/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep.multi;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.targetprep.multi.BaseMultiTargetPreparer;
import java.util.Map;

public class HelloWorldMultiTargetPreparer
extends BaseMultiTargetPreparer {
    @Override
    public void setUp(TestInformation testInfo) throws TargetSetupError {
        Map<ITestDevice, IBuildInfo> deviceBuildInfo = testInfo.getContext().getDeviceBuildMap();
        if (deviceBuildInfo.entrySet().size() != 2) {
            ITestDevice device = testInfo.getContext().getDevices().get(0);
            throw new TargetSetupError("The HelloWorldMultiTargetPreparer assumes 2 devices only.", device.getDeviceDescriptor());
        }
        for (Map.Entry<ITestDevice, IBuildInfo> entry : deviceBuildInfo.entrySet()) {
            LogUtil.CLog.i("Hello World! multi preparer '%s' with build id '%s'", entry.getKey().getSerialNumber(), entry.getValue().getBuildId());
        }
        LogUtil.CLog.i("The device names configured are: %s", testInfo.getContext().getDeviceConfigNames());
    }

    @Override
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        Map<ITestDevice, IBuildInfo> deviceBuildInfo = testInfo.getContext().getDeviceBuildMap();
        for (Map.Entry<ITestDevice, IBuildInfo> entry : deviceBuildInfo.entrySet()) {
            LogUtil.CLog.i("Hello World! multi tear down '%s' with build id '%s'", entry.getKey().getSerialNumber(), entry.getValue().getBuildId());
        }
    }
}

