/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep.suite;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceFoldableState;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.TestErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;

public class FoldableModePreparer
extends BaseTargetPreparer {
    @Option(name="foldable-state-identifier", description="The integer state identifier of the foldable mode.")
    private Long mStateIdentifier = null;
    @Option(name="enforce-state", description="Ensure the state wasn't changed between setup & teardown.")
    private boolean mValidateSameState = true;

    public FoldableModePreparer() {
    }

    public FoldableModePreparer(long stateIdentifier) {
        this.mStateIdentifier = stateIdentifier;
    }

    @Override
    public void setUp(TestInformation testInformation) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (this.mStateIdentifier == null) {
            return;
        }
        CommandResult result = testInformation.getDevice().executeShellV2Command(String.format("cmd device_state state %s", this.mStateIdentifier));
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            throw new TargetSetupError(String.format("Could not set device_state %s. stderr: %s", this.mStateIdentifier, result.getStderr()), testInformation.getDevice().getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
        result = testInformation.getDevice().executeShellV2Command("input keyevent KEYCODE_WAKEUP");
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            throw new TargetSetupError(String.format("Could not wake up the screen. stderr: %s", result.getStderr()), testInformation.getDevice().getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
    }

    @Override
    public void tearDown(TestInformation testInformation, Throwable e) throws DeviceNotAvailableException {
        DeviceFoldableState state;
        if (this.mStateIdentifier == null) {
            return;
        }
        if (this.mValidateSameState && ((state = testInformation.getDevice().getCurrentFoldableState()) == null || state.getIdentifier() != this.mStateIdentifier.longValue())) {
            throw new HarnessRuntimeException(String.format("Device foldable state changed to '%s', it should have been '%s'", state, this.mStateIdentifier), TestErrorIdentifier.MODIFIED_FOLDABLE_STATE);
        }
        CommandResult result = testInformation.getDevice().executeShellV2Command("cmd device_state state reset");
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            throw new HarnessRuntimeException(String.format("Could not reset device_state. stderr: %s", result.getStderr()), DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
    }
}

