/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep.sync;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.RunUtil;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;

public class DeviceSyncHelper {
    private final ITestDevice mDevice;
    private final File mTargetFilesFolder;
    private static final Set<String> ADB_PARTITIONS = ImmutableSet.of("data", "odm", "oem", "product", "system", "system_ext", new String[]{"vendor"});

    public DeviceSyncHelper(ITestDevice device, File targetFilesFolder) {
        this.mDevice = device;
        this.mTargetFilesFolder = targetFilesFolder;
    }

    public boolean sync() throws DeviceNotAvailableException {
        try {
            Set<String> partitions = this.getPartitions(this.mTargetFilesFolder);
            partitions.add("data");
            LogUtil.CLog.d("Partitions: %s", partitions);
            this.lowerCaseDirectory(this.mTargetFilesFolder);
            this.syncFiles(this.mDevice, partitions);
            return true;
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
            return false;
        }
    }

    private Set<String> getPartitions(File rootFolder) throws IOException {
        File abPartitions = new File(rootFolder, "META/ab_partitions.txt");
        String partitionString = FileUtil.readStringFromFile(abPartitions);
        return new LinkedHashSet<String>(Arrays.asList(partitionString.split("\n")));
    }

    private void lowerCaseDirectory(File rootFolder) {
        for (File f : rootFolder.listFiles()) {
            if (!f.isDirectory()) continue;
            File newName = new File(f.getParentFile(), f.getName().toLowerCase());
            f.renameTo(newName);
        }
        LogUtil.CLog.d("Directory content: %s", Arrays.asList(rootFolder.listFiles()));
    }

    private void syncFiles(ITestDevice device, Set<String> partitions) throws DeviceNotAvailableException, IOException {
        device.enableAdbRoot();
        device.remountSystemWritable();
        device.enableAdbRoot();
        String outputRemount = device.executeAdbCommand("remount", "-R");
        LogUtil.CLog.d("%s", outputRemount);
        device.waitForDeviceAvailable();
        device.executeAdbCommand("shell", "stop");
        RunUtil.getDefault().sleep(20000L);
        device.setRecoveryMode(ITestDevice.RecoveryMode.NONE);
        try (CloseableTraceScope push = new CloseableTraceScope("sync all");){
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("ANDROID_PRODUCT_OUT", this.mTargetFilesFolder.getAbsolutePath());
            String output = device.executeAdbCommand(0L, env, "sync", "all");
            if (output == null) {
                throw new IOException("Failed to sync all");
            }
            LogUtil.CLog.d("%s", output);
        }
        for (String partition : partitions) {
            File localToPush = new File(this.mTargetFilesFolder, partition);
            if (!localToPush.exists()) {
                LogUtil.CLog.w("%s is in the partition but doesn't exist", partition);
                continue;
            }
            if (ADB_PARTITIONS.contains(partition)) continue;
            try (CloseableTraceScope push = new CloseableTraceScope("push " + partition);){
                String output = device.executeAdbCommand(0L, "push", localToPush.getAbsolutePath(), "/");
                if (output != null) continue;
                throw new IOException("Failed to push " + localToPush);
            }
        }
        try (CloseableTraceScope reboot = new CloseableTraceScope("reboot");){
            String output = device.executeAdbCommand("reboot");
            LogUtil.CLog.d("reboot output: %s", output);
            device.waitForDeviceNotAvailable(30000L);
            device.waitForDeviceAvailable(900000L);
        }
        device.enableAdbRoot();
    }
}

