/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.config.proto.ConfigurationDescription;
import com.android.tradefed.testtype.IAbi;
import com.google.common.base.Objects;

public class Abi
implements IAbi {
    private static final long serialVersionUID = 1L;
    private final String mName;
    private final String mBitness;

    public Abi(String name, String bitness) {
        this.mName = name;
        this.mBitness = bitness;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getBitness() {
        return this.mBitness;
    }

    public String toString() {
        return "{" + this.mName + ", bitness=" + this.mBitness + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Abi other = (Abi)obj;
        if (!this.mName.equals(other.mName)) {
            return false;
        }
        return this.mBitness.equals(other.mBitness);
    }

    public int hashCode() {
        return Objects.hashCode(this.mName, this.mBitness);
    }

    @Override
    public ConfigurationDescription.Abi toProto() {
        ConfigurationDescription.Abi.Builder abiBuilder = ConfigurationDescription.Abi.newBuilder();
        abiBuilder.setName(this.mName);
        abiBuilder.setBitness(this.mBitness);
        return abiBuilder.build();
    }

    public static IAbi fromProto(ConfigurationDescription.Abi protoAbi) {
        return new Abi(protoAbi.getName(), protoAbi.getBitness());
    }
}

