/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.targetprep.TestAppInstallSetup;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IRuntimeHintProvider;
import com.android.tradefed.testtype.IShardableTest;
import com.android.tradefed.testtype.ITestAnnotationFilterReceiver;
import com.android.tradefed.testtype.ITestFileFilterReceiver;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.testtype.InstrumentationTest;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.ListInstrumentationParser;
import com.android.tradefed.util.ResourceUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

@OptionClass(alias="android-junit")
public class AndroidJUnitTest
extends InstrumentationTest
implements IRuntimeHintProvider,
ITestFileFilterReceiver,
ITestFilterReceiver,
ITestAnnotationFilterReceiver,
IShardableTest {
    private static final String INCLUDE_CLASS_INST_ARGS_KEY = "class";
    private static final String EXCLUDE_CLASS_INST_ARGS_KEY = "notClass";
    private static final String INCLUDE_PACKAGE_INST_ARGS_KEY = "package";
    private static final String EXCLUDE_PACKAGE_INST_ARGS_KEY = "notPackage";
    private static final String INCLUDE_REGEX_INST_ARGS_KEY = "tests_regex";
    private static final String ANNOTATION_INST_ARGS_KEY = "annotation";
    private static final String NOT_ANNOTATION_INST_ARGS_KEY = "notAnnotation";
    private static final String TEST_FILE_INST_ARGS_KEY = "testFile";
    private static final String NOT_TEST_FILE_INST_ARGS_KEY = "notTestFile";
    private static final String SHARD_INDEX_INST_ARGS_KEY = "shardIndex";
    private static final String NUM_SHARD_INST_ARGS_KEY = "numShards";
    public static final String NEW_RUN_LISTENER_ORDER_KEY = "newRunListenerMode";
    public static final String USE_TEST_STORAGE_SERVICE = "useTestStorageService";
    public static final String INCLUDE_COLLECTOR_FILTER_KEY = "include-filter-group";
    public static final String EXCLUDE_COLLECTOR_FILTER_KEY = "exclude-filter-group";
    private static final String INCLUDE_FILE = "includes.txt";
    private static final String EXCLUDE_FILE = "excludes.txt";
    @Option(name="runtime-hint", isTimeVal=true, description="The hint about the test's runtime.")
    private long mRuntimeHint = 60000L;
    @Option(name="include-filter", description="The include filters of the test name to run.", requiredForRerun=true)
    private Set<String> mIncludeFilters = new HashSet<String>();
    @Option(name="exclude-filter", description="The exclude filters of the test name to run.", requiredForRerun=true)
    private Set<String> mExcludeFilters = new HashSet<String>();
    @Option(name="include-annotation", description="The annotation class name of the test name to run, can be repeated", requiredForRerun=true)
    private Set<String> mIncludeAnnotation = new HashSet<String>();
    @Option(name="exclude-annotation", description="The notAnnotation class name of the test name to run, can be repeated", requiredForRerun=true)
    private Set<String> mExcludeAnnotation = new HashSet<String>();
    @Option(name="test-file-include-filter", description="A file containing a list of line separated test classes and optionally methods to include")
    private File mIncludeTestFile = null;
    @Option(name="test-file-exclude-filter", description="A file containing a list of line separated test classes and optionally methods to exclude")
    private File mExcludeTestFile = null;
    @Option(name="test-filter-dir", description="The device directory path to which the test filtering files are pushed")
    private String mTestFilterDir = "/data/local/tmp/ajur";
    @Option(name="test-storage-dir", description="The device directory path where test storage read files.")
    private String mTestStorageInternalDir = "/sdcard/googletest/test_runfiles";
    @Option(name="use-test-storage", description="If set to true, we will push filters to the test storage instead of disk.")
    private boolean mUseTestStorage = true;
    @Option(name="ajur-max-shard", description="The maximum number of shard we want to allow the AJUR test to shard into")
    private Integer mMaxShard = 4;
    @Option(name="device-listeners", description="Specify device side instrumentation listeners to be added for the run. Can be repeated. Note that while the ordering here is followed for now, future versions of AndroidJUnitRunner might not preserve the listener ordering.")
    private List<String> mExtraDeviceListeners = new ArrayList<String>();
    @Option(name="use-new-run-listener-order", description="Enables the new RunListener Order for AJUR.")
    private boolean mNewRunListenerOrderMode = true;
    private String mDeviceIncludeFile = null;
    private String mDeviceExcludeFile = null;
    private int mTotalShards = 0;
    private int mShardIndex = 0;
    private boolean mIsSharded = false;

    public AndroidJUnitTest() {
        this.setEnforceFormat(true);
    }

    @Override
    public long getRuntimeHint() {
        return this.mRuntimeHint;
    }

    @Override
    public void addIncludeFilter(String filter) {
        this.mIncludeFilters.add(filter);
    }

    @Override
    public void addAllIncludeFilters(Set<String> filters) {
        this.mIncludeFilters.addAll(filters);
    }

    @Override
    public void addExcludeFilter(String filter) {
        this.mExcludeFilters.add(filter);
    }

    @Override
    public void addAllExcludeFilters(Set<String> filters) {
        this.mExcludeFilters.addAll(filters);
    }

    @Override
    public void clearIncludeFilters() {
        this.mIncludeFilters.clear();
    }

    @Override
    public Set<String> getIncludeFilters() {
        return this.mIncludeFilters;
    }

    @Override
    public Set<String> getExcludeFilters() {
        return this.mExcludeFilters;
    }

    @Override
    public void clearExcludeFilters() {
        this.mExcludeFilters.clear();
    }

    @Override
    public void setIncludeTestFile(File testFile) {
        this.mIncludeTestFile = testFile;
    }

    @Override
    public File getIncludeTestFile() {
        return this.mIncludeTestFile;
    }

    @Override
    public void setExcludeTestFile(File testFile) {
        this.mExcludeTestFile = testFile;
    }

    @Override
    public File getExcludeTestFile() {
        return this.mExcludeTestFile;
    }

    @Override
    public void addIncludeAnnotation(String annotation) {
        this.mIncludeAnnotation.add(annotation);
    }

    @Override
    public void addAllIncludeAnnotation(Set<String> annotations) {
        this.mIncludeAnnotation.addAll(annotations);
    }

    @Override
    public void addExcludeAnnotation(String excludeAnnotation) {
        this.mExcludeAnnotation.add(excludeAnnotation);
    }

    @Override
    public void addAllExcludeAnnotation(Set<String> excludeAnnotations) {
        this.mExcludeAnnotation.addAll(excludeAnnotations);
    }

    @Override
    public Set<String> getIncludeAnnotations() {
        return this.mIncludeAnnotation;
    }

    @Override
    public Set<String> getExcludeAnnotations() {
        return this.mExcludeAnnotation;
    }

    @Override
    public void clearIncludeAnnotations() {
        this.mIncludeAnnotation.clear();
    }

    @Override
    public void clearExcludeAnnotations() {
        this.mExcludeAnnotation.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.getDevice() == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        if (this.mUseTestStorage) {
            List<String> params = this.getConfiguration().getConfigurationDescription().getMetaData("active-parameter");
            if (params != null && params.contains("instant")) {
                this.mUseTestStorage = false;
                LogUtil.CLog.d("Disable test storage on instant app module.");
            } else {
                this.mUseTestStorage = this.getDevice().checkApiLevelAgainstNextRelease(34);
                if (!this.mUseTestStorage) {
                    LogUtil.CLog.d("Disabled test storage as it's not supported on that branch.");
                }
            }
        }
        boolean pushedFile = false;
        try (CloseableTraceScope filter = new CloseableTraceScope("push_filter_files");){
            if (this.mIncludeTestFile != null && this.mIncludeTestFile.length() > 0L) {
                this.mDeviceIncludeFile = this.mTestFilterDir.replaceAll("/$", "") + "/" + INCLUDE_FILE;
                this.pushTestFile(this.mIncludeTestFile, this.mDeviceIncludeFile, listener);
                if (this.mUseTestStorage) {
                    this.pushTestFile(this.mIncludeTestFile, this.mTestStorageInternalDir + this.mDeviceIncludeFile, listener);
                }
                pushedFile = true;
                this.setTestPackageName(null);
            }
            if (this.mExcludeTestFile != null && this.mExcludeTestFile.length() > 0L) {
                this.mDeviceExcludeFile = this.mTestFilterDir.replaceAll("/$", "") + "/" + EXCLUDE_FILE;
                this.pushTestFile(this.mExcludeTestFile, this.mDeviceExcludeFile, listener);
                if (this.mUseTestStorage) {
                    this.pushTestFile(this.mExcludeTestFile, this.mTestStorageInternalDir + this.mDeviceExcludeFile, listener);
                }
                pushedFile = true;
            }
        }
        TestAppInstallSetup serviceInstaller = null;
        if (this.mUseTestStorage) {
            File testServices;
            block35: {
                testServices = null;
                try (CloseableTraceScope serviceInstall = new CloseableTraceScope("install_service_apk");){
                    testServices = FileUtil.createTempFile("services", ".apk");
                    boolean extracted = ResourceUtil.extractResourceAsFile("/test-services-normalized.apk", testServices);
                    if (extracted) {
                        serviceInstaller = new TestAppInstallSetup();
                        serviceInstaller.setForceQueryable(true);
                        serviceInstaller.addTestFile(testServices);
                        if (testInfo != null && testInfo.properties().containsKey("RUN_TESTS_AS_USER")) {
                            serviceInstaller.setUserId(Integer.parseInt(testInfo.properties().get("RUN_TESTS_AS_USER")));
                        }
                        serviceInstaller.setUp(testInfo);
                        CommandResult dumpsys = this.getDevice().executeShellV2Command("dumpsys deviceidle whitelist +androidx.test.services");
                        LogUtil.CLog.d("stdout: %s\nstderr: %s", dumpsys.getStdout(), dumpsys.getStderr());
                        break block35;
                    }
                    throw new IOException("Failed to extract test-services.apk");
                }
                catch (BuildError | TargetSetupError | IOException e) {
                    try {
                        LogUtil.CLog.e(e);
                        this.mUseTestStorage = false;
                    }
                    catch (Throwable throwable) {
                        FileUtil.deleteFile(testServices);
                        throw throwable;
                    }
                    FileUtil.deleteFile(testServices);
                }
            }
            FileUtil.deleteFile(testServices);
        }
        if (this.mTotalShards > 0 && !this.isShardable() && this.mShardIndex != 0) {
            LogUtil.CLog.i("%s is not shardable.", this.getRunnerName());
            return;
        }
        super.run(testInfo, listener);
        if (serviceInstaller != null) {
            try (CloseableTraceScope serviceTeardown = new CloseableTraceScope("service_teardown");){
                serviceInstaller.tearDown(testInfo, null);
            }
        }
        if (pushedFile) {
            this.removeTestFilterDir();
        }
    }

    @Override
    protected void setRunnerArgs(IRemoteAndroidTestRunner runner) {
        super.setRunnerArgs(runner);
        if (this.mDeviceIncludeFile != null) {
            runner.addInstrumentationArg(TEST_FILE_INST_ARGS_KEY, this.mDeviceIncludeFile);
        }
        if (this.mDeviceExcludeFile != null) {
            runner.addInstrumentationArg(NOT_TEST_FILE_INST_ARGS_KEY, this.mDeviceExcludeFile);
        }
        ArrayList<String> classArg = new ArrayList<String>();
        ArrayList<String> notClassArg = new ArrayList<String>();
        ArrayList<String> packageArg = new ArrayList<String>();
        ArrayList<String> notPackageArg = new ArrayList<String>();
        ArrayList<String> regexArg = new ArrayList<String>();
        for (String test : this.mIncludeFilters) {
            if (this.isRegex(test)) {
                regexArg.add(test);
                continue;
            }
            if (this.isClassOrMethod(test)) {
                classArg.add(test);
                continue;
            }
            packageArg.add(test);
        }
        for (String test : this.mExcludeFilters) {
            if (this.isClassOrMethod(test)) {
                notClassArg.add(test);
                continue;
            }
            notPackageArg.add(test);
        }
        if (!classArg.isEmpty()) {
            runner.addInstrumentationArg(INCLUDE_CLASS_INST_ARGS_KEY, ArrayUtil.join(",", classArg));
        }
        if (!notClassArg.isEmpty()) {
            runner.addInstrumentationArg(EXCLUDE_CLASS_INST_ARGS_KEY, ArrayUtil.join(",", notClassArg));
        }
        if (!packageArg.isEmpty()) {
            runner.addInstrumentationArg(INCLUDE_PACKAGE_INST_ARGS_KEY, ArrayUtil.join(",", packageArg));
        }
        if (!notPackageArg.isEmpty()) {
            runner.addInstrumentationArg(EXCLUDE_PACKAGE_INST_ARGS_KEY, ArrayUtil.join(",", notPackageArg));
        }
        if (!regexArg.isEmpty()) {
            String regexFilter;
            if (regexArg.size() == 1) {
                regexFilter = (String)regexArg.get(0);
            } else {
                Collections.sort(regexArg);
                regexFilter = "\"(" + ArrayUtil.join("|", regexArg) + ")\"";
            }
            runner.addInstrumentationArg(INCLUDE_REGEX_INST_ARGS_KEY, regexFilter);
        }
        if (!this.mIncludeAnnotation.isEmpty()) {
            runner.addInstrumentationArg(ANNOTATION_INST_ARGS_KEY, ArrayUtil.join(",", this.mIncludeAnnotation));
        }
        if (!this.mExcludeAnnotation.isEmpty()) {
            runner.addInstrumentationArg(NOT_ANNOTATION_INST_ARGS_KEY, ArrayUtil.join(",", this.mExcludeAnnotation));
        }
        if (this.mTotalShards > 0 && this.isShardable()) {
            runner.addInstrumentationArg(SHARD_INDEX_INST_ARGS_KEY, Integer.toString(this.mShardIndex));
            runner.addInstrumentationArg(NUM_SHARD_INST_ARGS_KEY, Integer.toString(this.mTotalShards));
        }
        if (this.mNewRunListenerOrderMode) {
            runner.addInstrumentationArg(NEW_RUN_LISTENER_ORDER_KEY, Boolean.toString(this.mNewRunListenerOrderMode));
        }
        if (this.mUseTestStorage) {
            runner.addInstrumentationArg(USE_TEST_STORAGE_SERVICE, Boolean.toString(this.mUseTestStorage));
        }
        this.addDeviceListeners(this.mExtraDeviceListeners);
    }

    private void pushTestFile(File testFile, String destination, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (!testFile.canRead() || !testFile.isFile()) {
            String message2 = String.format("Cannot read test file %s", testFile.getAbsolutePath());
            this.reportEarlyFailure(listener, message2);
            throw new IllegalArgumentException(message2);
        }
        ITestDevice device = this.getDevice();
        try {
            LogUtil.CLog.d("Attempting to push filters to %s", destination);
            boolean filterDirExists = device.doesFileExist(this.mTestFilterDir);
            if (!device.pushFile(testFile, destination, true)) {
                String message3 = String.format("Failed to push file %s to %s for %s in pushTestFile", testFile.getAbsolutePath(), destination, device.getSerialNumber());
                this.reportEarlyFailure(listener, message3);
                throw new RuntimeException(message3);
            }
            if (!filterDirExists) {
                device.executeShellCommand(String.format("chown -R shell:shell %s", this.mTestFilterDir));
                boolean filterExists = device.doesFileExist(destination);
                if (!filterExists) {
                    LogUtil.CLog.e("Filter '%s' wasn't found on device after pushing.", destination);
                }
            }
        }
        catch (DeviceNotAvailableException e) {
            this.reportEarlyFailure(listener, e.getMessage());
            throw e;
        }
        try (FileInputStreamSource source = new FileInputStreamSource(testFile);){
            listener.testLog("filter-" + testFile.getName(), LogDataType.TEXT, source);
        }
    }

    private void removeTestFilterDir() throws DeviceNotAvailableException {
        this.getDevice().deleteFile(this.mTestFilterDir);
    }

    private void reportEarlyFailure(ITestInvocationListener listener, String errorMessage) {
        listener.testRunStarted("AndroidJUnitTest_setupError", 0);
        FailureDescription failure = FailureDescription.create(errorMessage);
        failure.setFailureStatus(TestRecordProto.FailureStatus.INFRA_FAILURE);
        listener.testRunFailed(failure);
        listener.testRunEnded(0L, new HashMap<String, MetricMeasurement.Metric>());
    }

    @VisibleForTesting
    public boolean isClassOrMethod(String filter) {
        if (filter.contains("#")) {
            return true;
        }
        String[] parts = filter.split("\\.");
        if (parts.length > 0) {
            return Character.isUpperCase(parts[parts.length - 1].charAt(0));
        }
        return false;
    }

    @VisibleForTesting
    public boolean isRegex(String filter) {
        if (Pattern.matches(".*[\\?\\*\\^\\$\\(\\)\\[\\]\\{\\}\\|\\\\].*", filter)) {
            try {
                Pattern.compile(filter);
            }
            catch (PatternSyntaxException e) {
                LogUtil.CLog.e("Filter %s is not a valid regular expression string.", filter);
                throw new RuntimeException(e);
            }
            return true;
        }
        return false;
    }

    private boolean isShardable() {
        if (this.getRunnerName() == null) {
            return true;
        }
        return ListInstrumentationParser.SHARDABLE_RUNNERS.contains(this.getRunnerName());
    }

    @Override
    public Collection<IRemoteTest> split(int shardCount) {
        if (!this.isShardable()) {
            return null;
        }
        if (this.mMaxShard != null) {
            shardCount = Math.min(shardCount, this.mMaxShard);
        }
        if (!this.mIsSharded && shardCount > 1) {
            this.mIsSharded = true;
            ArrayList<IRemoteTest> shards = new ArrayList<IRemoteTest>(shardCount);
            for (int index = 0; index < shardCount; ++index) {
                shards.add(this.getTestShard(shardCount, index));
            }
            return shards;
        }
        return null;
    }

    private IRemoteTest getTestShard(int shardCount, int shardIndex) {
        AndroidJUnitTest shard;
        try {
            shard = (AndroidJUnitTest)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        try {
            OptionCopier.copyOptions(this, shard);
        }
        catch (ConfigurationException e) {
            LogUtil.CLog.e("Failed to copy instrumentation options: %s", e.getMessage());
        }
        shard.mShardIndex = shardIndex;
        shard.mTotalShards = shardCount;
        shard.mIsSharded = true;
        shard.setAbi(this.getAbi());
        shard.mRuntimeHint = this.mRuntimeHint / (long)shardCount;
        return shard;
    }
}

