/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestCollector;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.util.AbiUtils;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.RunUtil;
import difflib.DiffUtils;
import difflib.Patch;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ArtRunTest
implements IRemoteTest,
IAbiReceiver,
ITestFilterReceiver,
ITestCollector {
    private static final String RUNTEST_TAG = "ArtRunTest";
    private static final Path ART_APEX_PATH = Paths.get("/apex", "com.android.art");
    private static final String DALVIKVM_CMD = "dalvikvm|#BITNESS#| -Xcompiler-option --compile-art-test -classpath |#CLASSPATH#| |#MAINCLASS#| >|#STDOUT#| 2>|#STDERR#|";
    private static final String STDOUT_FILE_NAME = "stdout.txt";
    private static final String STDERR_FILE_NAME = "stderr.txt";
    public static final String CHECKER_PAR_FILENAME = "art-run-test-checker";
    private static final long CHECKER_TIMEOUT_MS = 300000L;
    @Option(name="test-timeout", description="The max time in ms for an art run-test to run. Test run will be aborted if any test takes longer.", isTimeVal=true)
    private long mMaxTestTimeMs = 60000L;
    @Option(name="run-test-name", description="The name to use when reporting results.")
    private String mRunTestName;
    @Option(name="classpath", description="Holds the paths to search when loading tests.")
    private List<String> mClasspath = new ArrayList<String>();
    private ITestDevice mDevice = null;
    private IAbi mAbi = null;
    private final Set<String> mIncludeFilters = new LinkedHashSet<String>();
    private final Set<String> mExcludeFilters = new LinkedHashSet<String>();
    @Option(name="collect-tests-only", description="Do a dry-run of the tests in order to collect their names, but do not actually run them.")
    private boolean mCollectTestsOnly = false;

    @Override
    public void setAbi(IAbi abi) {
        this.mAbi = abi;
    }

    @Override
    public IAbi getAbi() {
        return this.mAbi;
    }

    @Override
    public void addIncludeFilter(String filter) {
        this.mIncludeFilters.add(filter);
    }

    @Override
    public void addAllIncludeFilters(Set<String> filters) {
        this.mIncludeFilters.addAll(filters);
    }

    @Override
    public void addExcludeFilter(String filter) {
        this.mExcludeFilters.add(filter);
    }

    @Override
    public void addAllExcludeFilters(Set<String> filters) {
        this.mExcludeFilters.addAll(filters);
    }

    @Override
    public Set<String> getIncludeFilters() {
        return this.mIncludeFilters;
    }

    @Override
    public Set<String> getExcludeFilters() {
        return this.mExcludeFilters;
    }

    @Override
    public void clearIncludeFilters() {
        this.mIncludeFilters.clear();
    }

    @Override
    public void clearExcludeFilters() {
        this.mExcludeFilters.clear();
    }

    @Override
    public void setCollectTestsOnly(boolean shouldCollectTest) {
        this.mCollectTestsOnly = shouldCollectTest;
    }

    @Override
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        this.mDevice = testInfo.getDevice();
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set.");
        }
        if (this.mAbi == null) {
            throw new IllegalArgumentException("ABI has not been set.");
        }
        if (this.mRunTestName == null) {
            throw new IllegalArgumentException("Run-test name has not been set.");
        }
        if (this.mClasspath.isEmpty()) {
            throw new IllegalArgumentException("Classpath is empty.");
        }
        this.runArtTest(testInfo, listener);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void runArtTest(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        block35: {
            block32: {
                block31: {
                    abi = this.mAbi.getName();
                    runName = String.format("%s_%s", new Object[]{"ArtRunTest", abi});
                    testId = new TestDescription(runName, this.mRunTestName);
                    if (this.shouldSkipCurrentTest(testId)) {
                        return;
                    }
                    deviceSerialNumber = this.mDevice.getSerialNumber();
                    LogUtil.CLog.i("Running ArtRunTest %s on %s", new Object[]{this.mRunTestName, deviceSerialNumber});
                    testCmd = "dalvikvm|#BITNESS#| -Xcompiler-option --compile-art-test -classpath |#CLASSPATH#| |#MAINCLASS#| >|#STDOUT#| 2>|#STDERR#|";
                    testCmd = testCmd.replace("|#BITNESS#|", AbiUtils.getBitness(abi));
                    testCmd = testCmd.replace("|#CLASSPATH#|", ArrayUtil.join(File.pathSeparator, new Object[]{this.mClasspath}));
                    testCmd = testCmd.replace("|#MAINCLASS#|", "Main");
                    LogUtil.CLog.d("About to run run-test command: `%s`", new Object[]{testCmd});
                    testCount = 1;
                    listener.testRunStarted(runName, testCount);
                    listener.testStarted(testId);
                    tmpTestLocalDir = null;
                    tmpTestRemoteDirPath = null;
                    try {
                        ignored = new CloseableTraceScope(testId.toString());
                        if (this.mCollectTestsOnly) {
                            ignored.close();
                            emptyTestMetrics = new HashMap<String, MetricMeasurement.Metric>();
                            break block31;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (AdbShellCommandException | IOException e) {
                        try {
                            listener.testFailed(testId, String.format("Error in `ArtRunTest` test runner: %s", new Object[]{e}));
                            throw new RuntimeException(e);
                        }
                        catch (Throwable var28_38) {
                            emptyTestMetrics = new HashMap<String, MetricMeasurement.Metric>();
                            listener.testEnded(testId, emptyTestMetrics);
                            emptyTestRunMetrics = new HashMap<String, MetricMeasurement.Metric>();
                            listener.testRunEnded(0L, emptyTestRunMetrics);
                            FileUtil.recursiveDelete(tmpTestLocalDir);
                            if (tmpTestRemoteDirPath == null) throw var28_38;
                            this.mDevice.deleteFile(tmpTestRemoteDirPath);
                            throw var28_38;
                        }
                    }
                }
                listener.testEnded(testId, emptyTestMetrics);
                emptyTestRunMetrics = new HashMap<String, MetricMeasurement.Metric>();
                listener.testRunEnded(0L, emptyTestRunMetrics);
                FileUtil.recursiveDelete(tmpTestLocalDir);
                if (tmpTestRemoteDirPath == null) return;
                this.mDevice.deleteFile(tmpTestRemoteDirPath);
                return;
lbl-1000:
                // 1 sources

                {
                    tmpTestRemoteDirPathTemplate = String.format("%s.XXXXXXXXXX", new Object[]{this.mRunTestName.replaceAll("/", "-")});
                    tmpTestRemoteDirPath = this.createTemporaryDirectoryOnDevice(tmpTestRemoteDirPathTemplate);
                    LogUtil.CLog.d("Created temporary remote directory `%s` for test", new Object[]{tmpTestRemoteDirPath});
                    remoteStdoutFilePath = String.format("%s/%s", new Object[]{tmpTestRemoteDirPath, "stdout.txt"});
                    testCmd = testCmd.replace("|#STDOUT#|", remoteStdoutFilePath);
                    remoteStderrFilePath = String.format("%s/%s", new Object[]{tmpTestRemoteDirPath, "stderr.txt"});
                    testCmd = testCmd.replace("|#STDERR#|", remoteStderrFilePath);
                    testResult = this.mDevice.executeShellV2Command(testCmd, this.mMaxTestTimeMs, TimeUnit.MILLISECONDS, 0);
                    if (testResult.getStatus() == CommandStatus.SUCCESS) break block32;
                    message = String.format("Test command execution failed with status %s: %s", new Object[]{testResult.getStatus(), testResult});
                    LogUtil.CLog.e(message);
                    listener.testFailed(testId, message);
                    ignored.close();
                    emptyTestMetrics = new HashMap<String, MetricMeasurement.Metric>();
                }
                listener.testEnded(testId, emptyTestMetrics);
                emptyTestRunMetrics = new HashMap<String, MetricMeasurement.Metric>();
                listener.testRunEnded(0L, emptyTestRunMetrics);
                FileUtil.recursiveDelete(tmpTestLocalDir);
                if (tmpTestRemoteDirPath == null) return;
                this.mDevice.deleteFile(tmpTestRemoteDirPath);
                return;
            }
            ** try [egrp 5[TRYBLOCK] [6 : 513->963)] { 
lbl72:
            // 1 sources

            exitCode = testResult.getExitCode();
            LogUtil.CLog.v("`%s` on %s returned exit code: %d", new Object[]{testCmd, deviceSerialNumber, exitCode});
            tmpTestLocalDir = this.createTestLocalTempDirectory(testInfo);
            LogUtil.CLog.d("Created temporary local directory `%s` for test", new Object[]{tmpTestLocalDir});
            localStdoutFile = new File(tmpTestLocalDir, "stdout.txt");
            if (!this.pullAndCheckFile(remoteStdoutFilePath, localStdoutFile)) {
                throw new IOException(String.format("Error while pulling remote file `%s` to local file `%s`", new Object[]{remoteStdoutFilePath, localStdoutFile}));
            }
            actualStdoutText = FileUtil.readStringFromFile(localStdoutFile);
            localStderrFile = new File(tmpTestLocalDir, "stderr.txt");
            if (!this.pullAndCheckFile(remoteStderrFilePath, localStderrFile)) {
                throw new IOException(String.format("Error while pulling remote file `%s` to local file `%s`", new Object[]{remoteStderrFilePath, localStderrFile}));
            }
            actualStderrText = FileUtil.readStringFromFile(localStderrFile);
            errors = new ArrayList<String>();
            exitCodeError = this.checkExitCode(exitCode);
            exitCodeError.ifPresent((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$runArtTest$0(java.util.List java.lang.String ), (Ljava/lang/String;)V)(errors));
            stdoutError = this.checkTestOutput(testInfo, actualStdoutText, "stdout", "standard output");
            if (stdoutError.isPresent()) {
                errors.add(stdoutError.get());
                source = new FileInputStreamSource(localStdoutFile);
                try {
                    listener.testLog("stdout.txt", LogDataType.TEXT, source);
                }
                finally {
                    source.close();
                }
            }
            if ((stderrError = this.checkTestOutput(testInfo, actualStderrText, "stderr", "standard error")).isPresent()) {
                errors.add(stderrError.get());
                source = new FileInputStreamSource(localStderrFile);
                try {
                    listener.testLog("stderr.txt", LogDataType.TEXT, source);
                }
                finally {
                    source.close();
                }
            }
            if (this.mRunTestName.contains("-checker-")) {
                checkerError = this.executeCheckerTest(testInfo, listener);
                checkerError.ifPresent((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$runArtTest$1(java.util.List java.lang.String ), (Ljava/lang/String;)V)(errors));
            }
            if (!errors.isEmpty()) {
                errorMessage = String.join((CharSequence)"\n", errors);
                listener.testFailed(testId, errorMessage);
            }
            break block35;
lbl117:
            // 1 sources

            finally {
                ignored.close();
            }
        }
        emptyTestMetrics = new HashMap<String, MetricMeasurement.Metric>();
        listener.testEnded(testId, emptyTestMetrics);
        emptyTestRunMetrics = new HashMap<String, MetricMeasurement.Metric>();
        listener.testRunEnded(0L, emptyTestRunMetrics);
        FileUtil.recursiveDelete(tmpTestLocalDir);
        if (tmpTestRemoteDirPath == null) return;
        this.mDevice.deleteFile(tmpTestRemoteDirPath);
    }

    protected File createTestLocalTempDirectory(TestInformation testInfo) throws IOException {
        return Files.createTempDirectory(testInfo.dependenciesFolder().toPath(), this.mRunTestName, new FileAttribute[0]).toFile();
    }

    protected Optional<String> checkExitCode(Integer exitCode) {
        if (exitCode != 0) {
            String errorMessage = String.format("Test `%s` exited with code %d", this.mRunTestName, exitCode);
            LogUtil.CLog.i(errorMessage);
            return Optional.of(errorMessage);
        }
        return Optional.empty();
    }

    protected Optional<String> checkTestOutput(TestInformation testInfo, String actualOutputText, String outputShortName, String outputPrettyName) {
        String expectedFileName = String.format("expected-%s.txt", outputShortName);
        String actualFileName = outputShortName;
        if (actualOutputText == null) {
            String errorMessage = String.format("No %s received to compare to for test `%s`", outputPrettyName, this.mRunTestName);
            LogUtil.CLog.e(errorMessage);
            return Optional.of(errorMessage);
        }
        try {
            String expectedOutputFileName = String.format("%s-%s", this.mRunTestName, expectedFileName);
            File expectedOutputFile = testInfo.getDependencyFile(expectedOutputFileName, true);
            LogUtil.CLog.i("Found expected %s for run-test `%s`: `%s`", outputPrettyName, this.mRunTestName, expectedOutputFile);
            String expectedOutputText = FileUtil.readStringFromFile(expectedOutputFile);
            if (!actualOutputText.equals(expectedOutputText)) {
                String diff = this.computeDiff(expectedOutputText, actualOutputText, expectedFileName, actualFileName);
                String errorMessage = String.format("The actual %s does not match the expected %s for test `%s`:\n%s", outputPrettyName, outputPrettyName, this.mRunTestName, diff);
                LogUtil.CLog.i(errorMessage);
                return Optional.of(errorMessage);
            }
        }
        catch (IOException ioe) {
            String errorMessage = String.format("I/O error while accessing expected %s for test `%s`: %s", outputPrettyName, this.mRunTestName, ioe);
            LogUtil.CLog.e(errorMessage);
            return Optional.of(errorMessage);
        }
        return Optional.empty();
    }

    protected Optional<String> executeCheckerTest(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException, AdbShellCommandException, IOException {
        String tmpCheckerRemoteDirPath;
        File tmpCheckerLocalDir;
        block16: {
            Optional<String> optional;
            tmpCheckerLocalDir = null;
            tmpCheckerRemoteDirPath = null;
            try {
                String tmpCheckerRemoteDirPathTemplate = String.format("%s.checker.XXXXXXXXXX", this.mRunTestName.replaceAll("/", "-"));
                tmpCheckerRemoteDirPath = this.createTemporaryDirectoryOnDevice(tmpCheckerRemoteDirPathTemplate);
                LogUtil.CLog.d("Created temporary remote directory `%s` for Checker test", tmpCheckerRemoteDirPath);
                String cfgPath = tmpCheckerRemoteDirPath + "/graph.cfg";
                String oatPath = tmpCheckerRemoteDirPath + "/output.oat";
                String abi = this.mAbi.getName();
                String dex2oatBinary = "dex2oat" + AbiUtils.getBitness(abi);
                Path dex2oatPath = Paths.get(ART_APEX_PATH.toString(), "bin", dex2oatBinary);
                String dex2oatCmd = String.format("%s --dex-file=%s --oat-file=%s --dump-cfg=%s -j1 --compile-art-test", dex2oatPath, this.mClasspath.get(0), oatPath, cfgPath);
                CommandResult dex2oatResult = this.mDevice.executeShellV2Command(dex2oatCmd);
                if (dex2oatResult.getStatus() != CommandStatus.SUCCESS) {
                    throw new AdbShellCommandException("Error while running dex2oat: %s", dex2oatResult.getStderr());
                }
                tmpCheckerLocalDir = Files.createTempDirectory(testInfo.dependenciesFolder().toPath(), this.mRunTestName, new FileAttribute[0]).toFile();
                LogUtil.CLog.d("Created temporary local directory `%s` for Checker test", tmpCheckerLocalDir);
                File localCfgPath = new File(tmpCheckerLocalDir, "graph.cfg");
                if (localCfgPath.isFile()) {
                    localCfgPath.delete();
                }
                if (!this.pullAndCheckFile(cfgPath, localCfgPath)) {
                    throw new IOException("Cannot pull CFG file from the device");
                }
                File tempJar = new File(tmpCheckerLocalDir, "temp.jar");
                if (!this.pullAndCheckFile(this.mClasspath.get(0), tempJar)) {
                    throw new IOException("Cannot pull JAR file from the device");
                }
                this.extractSourcesFromJar(tmpCheckerLocalDir, tempJar);
                String checkerArch = AbiUtils.getArchForAbi(this.mAbi.getName()).toUpperCase();
                File checkerBinary = this.getCheckerBinaryPath(testInfo);
                String[] checkerCommandLine = new String[]{checkerBinary.getAbsolutePath(), "--no-print-cfg", "-q", "--arch=" + checkerArch, localCfgPath.getAbsolutePath(), tmpCheckerLocalDir.getAbsolutePath()};
                Optional<String> checkerError = this.runChecker(checkerCommandLine);
                if (!checkerError.isPresent()) break block16;
                try (FileInputStreamSource source = new FileInputStreamSource(localCfgPath);){
                    listener.testLog("graph.cfg", LogDataType.CFG, source);
                }
                LogUtil.CLog.i(checkerError.get());
                optional = checkerError;
            }
            catch (AdbShellCommandException | IOException e) {
                try {
                    LogUtil.CLog.e("Exception while running Checker test: " + e.getMessage());
                    throw e;
                }
                catch (Throwable throwable) {
                    FileUtil.recursiveDelete(tmpCheckerLocalDir);
                    if (tmpCheckerRemoteDirPath != null) {
                        this.mDevice.deleteFile(tmpCheckerRemoteDirPath);
                    }
                    throw throwable;
                }
            }
            FileUtil.recursiveDelete(tmpCheckerLocalDir);
            if (tmpCheckerRemoteDirPath != null) {
                this.mDevice.deleteFile(tmpCheckerRemoteDirPath);
            }
            return optional;
        }
        FileUtil.recursiveDelete(tmpCheckerLocalDir);
        if (tmpCheckerRemoteDirPath != null) {
            this.mDevice.deleteFile(tmpCheckerRemoteDirPath);
        }
        return Optional.empty();
    }

    protected File getCheckerBinaryPath(TestInformation testInfo) {
        File checkerBinary;
        try {
            checkerBinary = testInfo.getDependencyFile(CHECKER_PAR_FILENAME, false);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(String.format("Couldn't find Checker binary file `%s`", CHECKER_PAR_FILENAME));
        }
        checkerBinary.setExecutable(true);
        return checkerBinary;
    }

    protected Optional<String> runChecker(String[] checkerCommandLine) {
        String checkerCommandLineString = String.join((CharSequence)" ", checkerCommandLine);
        LogUtil.CLog.d("About to run Checker command: %s", checkerCommandLineString);
        long startTime = System.currentTimeMillis();
        CommandResult result = RunUtil.getDefault().runTimedCmd(300000L, checkerCommandLine);
        long duration = System.currentTimeMillis() - startTime;
        LogUtil.CLog.i("Checker command `%s` executed in %s ms", checkerCommandLineString, duration);
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.ART_RUN_TEST_CHECKER_COMMAND_TIME_MS, duration);
        if (result.getStatus() != CommandStatus.SUCCESS) {
            String errorMessage = result.getStatus() == CommandStatus.TIMED_OUT ? String.format("Checker command timed out after %s ms", 300000L) : String.format("Checker command finished unsuccessfully: status=%s, exit code=%s,\nstdout=\n%s\nstderr=\n%s\n", new Object[]{result.getStatus(), result.getExitCode(), result.getStdout(), result.getStderr()});
            LogUtil.CLog.i(errorMessage);
            return Optional.of(errorMessage);
        }
        return Optional.empty();
    }

    protected void extractSourcesFromJar(File tmpCheckerLocalDir, File jar) throws IOException {
        try (ZipFile archive = new ZipFile(jar);){
            File srcFile = new File(tmpCheckerLocalDir, "src");
            if (srcFile.exists()) {
                FileUtil.recursiveDelete(srcFile);
            }
            List entries = archive.stream().sorted(Comparator.comparing(ZipEntry::getName)).collect(Collectors.toList());
            for (ZipEntry entry : entries) {
                if (!entry.getName().startsWith("src")) continue;
                Path entryDest = tmpCheckerLocalDir.toPath().resolve(entry.getName());
                if (entry.isDirectory()) {
                    Files.createDirectory(entryDest, new FileAttribute[0]);
                    continue;
                }
                Files.copy(archive.getInputStream(entry), entryDest, new CopyOption[0]);
            }
        }
    }

    private boolean shouldSkipCurrentTest(TestDescription description) {
        String testName = description.getTestName();
        String descString = description.toString();
        if (this.mExcludeFilters.contains(testName) || this.mExcludeFilters.contains(descString)) {
            return true;
        }
        if (!this.mIncludeFilters.isEmpty()) {
            return !this.mIncludeFilters.contains(testName) && !this.mIncludeFilters.contains(descString);
        }
        return false;
    }

    private String computeDiff(String expected, String actual, String expectedFileName, String actualFileName) {
        List<String> expectedLines = Arrays.asList(expected.split("\\r?\\n"));
        List<String> actualLines = Arrays.asList(actual.split("\\r?\\n"));
        try {
            Patch<String> diff = DiffUtils.diff(expectedLines, actualLines);
            List<String> unifiedDiff = DiffUtils.generateUnifiedDiff(expectedFileName, actualFileName, expectedLines, diff, 3);
            StringBuilder diffOutput = new StringBuilder();
            for (String delta : unifiedDiff) {
                diffOutput.append(delta).append('\n');
            }
            return diffOutput.toString();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private boolean pullAndCheckFile(String remoteFilePath, File localFile) throws DeviceNotAvailableException, AdbShellCommandException, IOException {
        long maxStatCmdTimeInMs = 10000L;
        String statCmd = String.format("stat --format %%s %s", remoteFilePath);
        CommandResult statResult = this.executeAndCheckShellCommand(statCmd, maxStatCmdTimeInMs);
        String remoteFileSizeStr = statResult.getStdout().strip();
        long remoteFileSize = Long.parseLong(remoteFileSizeStr);
        LogUtil.CLog.d("Size of remote file `%s` is %d bytes", remoteFilePath, remoteFileSize);
        long maxMd5sumCmdTimeInMs = 60000L;
        String md5sumCmd = String.format("md5sum -b %s", remoteFilePath);
        CommandResult md5sumResult = this.executeAndCheckShellCommand(md5sumCmd, maxMd5sumCmdTimeInMs);
        String remoteMd5Digest = md5sumResult.getStdout().strip();
        LogUtil.CLog.d("MD5 digest of remote file `%s` is %s", remoteFilePath, remoteMd5Digest);
        boolean result = this.mDevice.pullFile(remoteFilePath, localFile);
        long localFileSize = localFile.length();
        LogUtil.CLog.d("Size of local file `%s` is %d bytes", localFile, localFileSize);
        String localMd5Digest = FileUtil.calculateMd5(localFile);
        LogUtil.CLog.d("MD5 digest of local file `%s` is %s", localFile, localMd5Digest);
        if (localFileSize != remoteFileSize) {
            String message2 = String.format("Size of local file `%s` does not match size of remote file `%s` pulled from device: %d bytes vs %d bytes", localFile, remoteFilePath, localFileSize, remoteFileSize);
            LogUtil.CLog.e(message2);
            throw new IOException(message2);
        }
        if (!localMd5Digest.equals(remoteMd5Digest)) {
            String message3 = String.format("MD5 digest of local file `%s` does not match MD5 digest of remote file `%s` pulled from device: %s vs %s", localFile, remoteFilePath, localMd5Digest, remoteMd5Digest);
            LogUtil.CLog.e(message3);
            throw new IOException(message3);
        }
        return result;
    }

    private CommandResult executeAndCheckShellCommand(String command, long maxTimeoutForCommandInMs) throws DeviceNotAvailableException, AdbShellCommandException {
        CommandResult result = this.mDevice.executeShellV2Command(command, maxTimeoutForCommandInMs, TimeUnit.MILLISECONDS, 0);
        if (result.getStatus() != CommandStatus.SUCCESS || result.getExitCode() != 0) {
            String message2 = String.format("Command `%s` failed with status %s: %s", new Object[]{command, result.getStatus(), result});
            LogUtil.CLog.e(message2);
            throw new AdbShellCommandException(message2, new Object[0]);
        }
        return result;
    }

    private String createTemporaryDirectoryOnDevice(String template) throws DeviceNotAvailableException, AdbShellCommandException {
        long maxMktempCmdTimeInMs = 10000L;
        String mktempCmd = String.format("mktemp -d -p /data/local/tmp %s", template);
        CommandResult mktempResult = this.executeAndCheckShellCommand(mktempCmd, maxMktempCmdTimeInMs);
        return mktempResult.getStdout().strip();
    }

    private static /* synthetic */ void lambda$runArtTest$1(List errors, String e) {
        errors.add(e);
    }

    private static /* synthetic */ void lambda$runArtTest$0(List errors, String e) {
        errors.add(e);
    }

    public static class AdbShellCommandException
    extends Exception {
        AdbShellCommandException(String format, Object ... args) {
            super(String.format(format, args));
        }
    }
}

