/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ITestLifeCycleReceiver;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.TimeUtil;
import java.util.HashMap;
import org.junit.Assert;

@OptionClass(alias="battery-checker")
public class DeviceBatteryLevelChecker
implements IRemoteTest {
    private static final Integer IGNORE_CHARGE = -101;
    private ITestDevice mTestDevice = null;
    private TestDescription mTestDescription = new TestDescription("BatteryCharging", "charge");
    private TestDescription mChargingSpeed = new TestDescription("BatteryCharging", "speed");
    @Option(name="max-battery", description="Charge level below which we force the device to sit and charge.  Range: 0-100.")
    private Integer mMaxBattery = 20;
    @Option(name="resume-level", description="Charge level at which we release the device to begin testing again. Range: 0-100.")
    private int mResumeLevel = 80;
    @Option(name="poll-time", description="Time in minutes to wait between battery level polls. Decimal times accepted.")
    private double mChargingPollTime = 1.0;
    @Option(name="batt-log-period", description="Min time in minutes to wait between printing current battery level to log.  Decimal times accepted.")
    private double mLoggingPollTime = 10.0;
    @Option(name="reboot-charging-devices", description="Whether to reboot a device when we detect that it should be held for charging.  This would hopefully kill any battery-draining processes and allow the device to charge at its fastest rate.")
    private boolean mRebootChargeDevices = false;
    @Option(name="stop-runtime", description="Whether to stop runtime.")
    private boolean mStopRuntime = false;
    @Option(name="stop-logcat", description="Whether to stop logcat during the recharge. this option is enabled by default.")
    private boolean mStopLogcat = true;
    @Option(name="max-run-time", description="The max run time the battery level checker can run before stopping.", isTimeVal=true)
    private long mMaxRunTime = 1800000L;
    @Option(name="reference-charging-speed", description="The expected charging speed in % per hours.")
    private Integer mChargingSpeedCheck = 15;

    Integer checkBatteryLevel(ITestDevice device) {
        return device.getBattery();
    }

    private void stopDeviceRuntime() throws DeviceNotAvailableException {
        this.mTestDevice.executeShellCommand("stop");
    }

    private void startDeviceRuntime() throws DeviceNotAvailableException {
        this.mTestDevice.executeShellCommand("start");
        this.mTestDevice.waitForDeviceAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        this.mTestDevice = testInfo.getDevice();
        Assert.assertNotNull(this.mTestDevice);
        long startTime = System.currentTimeMillis();
        int testCount = 1;
        boolean chargeCheck = false;
        if (this.mChargingSpeedCheck != null && this.mChargingSpeedCheck > 0) {
            ++testCount;
            chargeCheck = true;
        }
        listener.testRunStarted("BatteryCharging", testCount);
        listener.testStarted(this.mTestDescription);
        try {
            Integer charge = null;
            long elapsedTimeMs = this.getCurrentTimeMs();
            try {
                charge = this.runTest(testInfo, listener);
                elapsedTimeMs = this.getCurrentTimeMs() - elapsedTimeMs;
            }
            catch (DeviceNotAvailableException e) {
                FailureDescription failure = FailureDescription.create(e.getMessage()).setCause(e).setErrorIdentifier(e.getErrorId()).setOrigin(e.getOrigin());
                if (e.getErrorId() != null) {
                    failure.setFailureStatus(e.getErrorId().status());
                }
                listener.testRunFailed(failure);
                throw e;
            }
            finally {
                listener.testEnded(this.mTestDescription, new HashMap<String, MetricMeasurement.Metric>());
            }
            if (chargeCheck) {
                listener.testStarted(this.mChargingSpeed);
                if (charge == null) {
                    FailureDescription failure = FailureDescription.create("No battery charge information");
                    failure.setFailureStatus(TestRecordProto.FailureStatus.NOT_EXECUTED);
                    listener.testFailed(this.mChargingSpeed, failure);
                } else if (IGNORE_CHARGE.equals(charge)) {
                    listener.testIgnored(this.mChargingSpeed);
                } else {
                    this.checkChargingSpeed(listener, charge, elapsedTimeMs);
                }
                listener.testEnded(this.mChargingSpeed, new HashMap<String, MetricMeasurement.Metric>());
            }
        }
        finally {
            listener.testRunEnded(System.currentTimeMillis() - startTime, new HashMap<String, MetricMeasurement.Metric>());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer runTest(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        this.mTestDevice = testInfo.getDevice();
        Assert.assertNotNull(this.mTestDevice);
        Integer batteryLevel = this.checkBatteryLevel(this.mTestDevice);
        if (batteryLevel == null) {
            LogUtil.CLog.w("Failed to determine battery level for device %s.", this.mTestDevice.getSerialNumber());
            listener.testFailed(this.mTestDescription, FailureDescription.create("Failed to determine battery level"));
            return null;
        }
        if (batteryLevel >= this.mMaxBattery) {
            LogUtil.CLog.d("Battery level %d is above the minimum of %d; %s is good to go.", batteryLevel, this.mMaxBattery, this.mTestDevice.getSerialNumber());
            return IGNORE_CHARGE;
        }
        LogUtil.CLog.w("Battery level %d is below the min level %d; holding for device %s to charge to level %d", batteryLevel, this.mMaxBattery, this.mTestDevice.getSerialNumber(), this.mResumeLevel);
        if (this.mRebootChargeDevices) {
            LogUtil.CLog.d("Rebooting device %s prior to holding", this.mTestDevice.getSerialNumber());
            this.mTestDevice.reboot();
        }
        this.turnScreenOff(this.mTestDevice);
        Integer finalBattery = null;
        try {
            if (this.mStopRuntime) {
                this.stopDeviceRuntime();
            }
            if (this.mStopLogcat) {
                this.mTestDevice.stopLogcat();
            }
            finalBattery = this.runBatteryCharging(listener, this.mTestDescription);
        }
        finally {
            if (this.mStopRuntime) {
                this.startDeviceRuntime();
            }
        }
        LogUtil.CLog.i("Device %s is now charged to battery level %d; releasing.", this.mTestDevice.getSerialNumber(), batteryLevel);
        if (finalBattery != null) {
            return finalBattery - batteryLevel;
        }
        return null;
    }

    private void turnScreenOff(ITestDevice device) throws DeviceNotAvailableException {
        device.executeShellCommand("svc power stayon false");
        device.executeShellCommand("settings put system screen_off_timeout 1000");
        this.getRunUtil().sleep(5000L);
    }

    private Integer runBatteryCharging(ITestLifeCycleReceiver listener, TestDescription test) {
        long lastReportTime = System.currentTimeMillis();
        Integer batteryLevel = this.checkBatteryLevel(this.mTestDevice);
        long startTime = System.currentTimeMillis();
        while (batteryLevel != null && batteryLevel < this.mResumeLevel) {
            if ((double)(System.currentTimeMillis() - lastReportTime) > this.mLoggingPollTime * 60.0 * 1000.0) {
                LogUtil.CLog.i("Battery level for device %s is currently %d", this.mTestDevice.getSerialNumber(), batteryLevel);
                lastReportTime = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - startTime > this.mMaxRunTime) {
                LogUtil.CLog.i("DeviceBatteryLevelChecker has been running for %s. terminating.", TimeUtil.formatElapsedTime(this.mMaxRunTime));
                break;
            }
            this.getRunUtil().sleep((long)(this.mChargingPollTime * 60.0 * 1000.0));
            Integer newLevel = this.checkBatteryLevel(this.mTestDevice);
            if (newLevel == null) {
                LogUtil.CLog.w("Breaking out of wait loop because battery level read failed for device %s", this.mTestDevice.getSerialNumber());
                listener.testFailed(test, FailureDescription.create("Failed to read battery level"));
                return null;
            }
            if (newLevel < batteryLevel) {
                LogUtil.CLog.w("Warning: battery discharged from %d to %d on device %s during the last %.02f minutes.", batteryLevel, newLevel, this.mTestDevice.getSerialNumber(), this.mChargingPollTime);
            } else {
                LogUtil.CLog.v("Battery level for device %s is currently %d", this.mTestDevice.getSerialNumber(), newLevel);
            }
            batteryLevel = newLevel;
        }
        return batteryLevel;
    }

    private void checkChargingSpeed(ITestInvocationListener listener, Integer charge, long chargingTime) {
        double speedPerHours = (double)charge.intValue() / ((double)chargingTime / 3600.0);
        if (speedPerHours < (double)this.mChargingSpeedCheck.intValue()) {
            listener.testFailed(this.mChargingSpeed, FailureDescription.create(String.format("Device charged %s%% in %s = %s%%/hours. This is below %s", charge, TimeUtil.formatElapsedTime(chargingTime), speedPerHours, this.mChargingSpeedCheck)));
            this.mTestDevice.logBugreport("low-charging-speed-bugreport", listener);
        }
        LogUtil.CLog.d("Device charged %s%% in %s", charge, TimeUtil.formatElapsedTime(chargingTime));
    }

    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    protected void setResumeLevel(int level) {
        this.mResumeLevel = level;
    }

    long getCurrentTimeMs() {
        return System.currentTimeMillis();
    }
}

