/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.JUnitToInvocationResultForwarder;
import com.android.tradefed.testtype.MetricTestCase;
import com.android.tradefed.testtype.junit4.CarryInterruptedException;
import com.android.tradefed.util.StreamUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;

public class DeviceTestResult
extends TestResult {
    private TestInformation mTestInfo;

    public void setTestInfo(TestInformation testInfo) {
        this.mTestInfo = testInfo;
    }

    @Override
    public void runProtected(Test test, Protectable p) {
        try {
            p.protect();
        }
        catch (AssertionFailedError e) {
            this.addFailure(test, e);
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (DeviceNotAvailableException e) {
            this.addError(test, e);
            throw new RuntimeDeviceNotAvailableException(e);
        }
        catch (InterruptedException e) {
            this.addError(test, e);
            throw new CarryInterruptedException(e);
        }
        catch (Throwable e) {
            this.addError(test, e);
        }
    }

    @Override
    protected void run(final TestCase test) {
        Protectable p = new Protectable(){

            @Override
            public void protect() throws Throwable {
                test.runBare();
            }
        };
        try {
            this.startTest(test);
            this.runProtected(test, p);
        }
        finally {
            this.endTest(test);
        }
    }

    @Override
    public void startTest(Test test) {
        super.startTest(test);
        if (this.mTestInfo != null && this.mTestInfo.isTestTimedOut()) {
            InterruptedException e = new InterruptedException();
            this.addError(test, e);
            throw new CarryInterruptedException(e);
        }
    }

    @Override
    public void endTest(Test test) {
        HashMap<String, MetricMeasurement.Metric> metrics = new HashMap<String, MetricMeasurement.Metric>();
        if (test instanceof MetricTestCase) {
            MetricTestCase metricTest = (MetricTestCase)test;
            metrics.putAll(metricTest.mMetrics);
            metricTest.mMetrics = new HashMap();
            for (TestListener each : this.cloneListeners()) {
                for (MetricTestCase.LogHolder log : metricTest.mLogs) {
                    if (each instanceof JUnitToInvocationResultForwarder) {
                        ((JUnitToInvocationResultForwarder)each).testLog(log.mDataName, log.mDataType, log.mDataStream);
                    }
                    StreamUtil.cancel(log.mDataStream);
                }
            }
            metricTest.mLogs.clear();
        }
        for (TestListener each : this.cloneListeners()) {
            if (!metrics.isEmpty() && each instanceof JUnitToInvocationResultForwarder) {
                ((JUnitToInvocationResultForwarder)each).endTest(test, metrics);
                continue;
            }
            each.endTest(test);
        }
    }

    private synchronized List<TestListener> cloneListeners() {
        ArrayList<TestListener> result = new ArrayList<TestListener>();
        result.addAll(this.fListeners);
        return result;
    }

    public class RuntimeDeviceNotAvailableException
    extends RuntimeException {
        private DeviceNotAvailableException mException;

        RuntimeDeviceNotAvailableException(DeviceNotAvailableException e) {
            super(e.getMessage());
            this.mException = e;
        }

        DeviceNotAvailableException getDeviceException() {
            return this.mException;
        }
    }
}

