/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.util.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DynamicFileStubTest
implements IRemoteTest {
    @Option(name="dynamic-file", description="To test tradefed can resolve dynamic file for file option.")
    private File mFile;
    @Option(name="dynamic-file-list", description="To test tradefed can resolve dynamic files in list option.")
    private List<File> mFileList = new ArrayList<File>();
    @Option(name="dynamic-file-map", description="To test tradefed can resolve dynamic files in map option.")
    private Map<File, File> mFileMap = new HashMap<File, File>();
    @Option(name="dynamic-file-multimap", description="To test tradefed can resolve dynamic files in multimap option.")
    private MultiMap<File, File> mFileMultiMap = new MultiMap();

    @Override
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        listener.testRunStarted(this.getClass().getName(), 1);
        this.checkDynamicFile(listener);
        this.checkDynamicFileList(listener);
        this.checkDynamicFileMap(listener);
        this.checkDynamicFileMultiMap(listener);
        listener.testRunEnded(System.currentTimeMillis() - startTime, (HashMap<String, MetricMeasurement.Metric>)new LinkedHashMap<String, MetricMeasurement.Metric>());
    }

    private void checkDynamicFile(ITestInvocationListener listener) {
        TestDescription testId = new TestDescription(this.getClass().getName(), "DynamicFile");
        listener.testStarted(testId);
        if (this.mFile != null && !this.mFile.exists()) {
            listener.testFailed(testId, String.format("%s doesn't exist.", this.mFile.getPath()));
        }
        listener.testEnded(testId, (HashMap<String, MetricMeasurement.Metric>)new LinkedHashMap<String, MetricMeasurement.Metric>());
    }

    private void checkDynamicFileList(ITestInvocationListener listener) {
        TestDescription testId = new TestDescription(this.getClass().getName(), "DynamicFileList");
        listener.testStarted(testId);
        ArrayList<String> nonExistFiles = new ArrayList<String>();
        if (this.mFileList != null && !this.mFileList.isEmpty()) {
            for (File file2 : this.mFileList) {
                if (file2.exists()) continue;
                nonExistFiles.add(file2.getPath());
            }
            if (!nonExistFiles.isEmpty()) {
                listener.testFailed(testId, String.format("%s doesn't exist.", nonExistFiles));
            }
        }
        listener.testEnded(testId, (HashMap<String, MetricMeasurement.Metric>)new LinkedHashMap<String, MetricMeasurement.Metric>());
    }

    private void checkDynamicFileMap(ITestInvocationListener listener) {
        TestDescription testId = new TestDescription(this.getClass().getName(), "DynamicFileMap");
        listener.testStarted(testId);
        ArrayList<String> nonExistFiles = new ArrayList<String>();
        if (this.mFileMap != null && !this.mFileMap.isEmpty()) {
            for (Map.Entry<File, File> entry : this.mFileMap.entrySet()) {
                if (!entry.getKey().exists()) {
                    nonExistFiles.add(entry.getKey().getPath());
                }
                if (entry.getValue().exists()) continue;
                nonExistFiles.add(entry.getValue().getPath());
            }
            if (!nonExistFiles.isEmpty()) {
                listener.testFailed(testId, String.format("%s doesn't exist.", nonExistFiles));
            }
        }
        listener.testEnded(testId, (HashMap<String, MetricMeasurement.Metric>)new LinkedHashMap<String, MetricMeasurement.Metric>());
    }

    private void checkDynamicFileMultiMap(ITestInvocationListener listener) {
        TestDescription testId = new TestDescription(this.getClass().getName(), "DynamicFileMultiMap");
        listener.testStarted(testId);
        ArrayList<String> nonExistFiles = new ArrayList<String>();
        if (this.mFileMultiMap != null && !this.mFileMultiMap.isEmpty()) {
            for (File key : this.mFileMultiMap.keySet()) {
                if (!key.exists()) {
                    nonExistFiles.add(key.getPath());
                }
                for (File value : this.mFileMultiMap.get(key)) {
                    if (value.exists()) continue;
                    nonExistFiles.add(value.getPath());
                }
            }
            if (!nonExistFiles.isEmpty()) {
                listener.testFailed(testId, String.format("%s doesn't exist.", nonExistFiles));
            }
        }
        listener.testEnded(testId, (HashMap<String, MetricMeasurement.Metric>)new LinkedHashMap<String, MetricMeasurement.Metric>());
    }
}

