/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@OptionClass(alias="faketest")
public class FakeTest
implements IDeviceTest,
IRemoteTest {
    @Option(name="run", description="Specify a new run to include.  The key should be the unique name of the TestRun (which may be a Java class name).  The value should specify the sequence of test results, using the characters P[ass], F[ail], A[ssumption failure] or I[gnored].  You may use run-length encoding to specify repeats, and you may use parentheses for grouping.  So \"(PF)4\" and \"((PF)2)2\" will both expand to \"PFPFPFPF\".", importance=Option.Importance.IF_UNSET)
    private Map<String, String> mRuns = new LinkedHashMap<String, String>();
    @Option(name="fail-invocation-with-cause", description="If set, the invocation will be reported as a failure, with the specified message as the cause.")
    private String mFailInvocationWithCause = null;
    @Option(name="test-log", description="Name of the file to report as a log generated by each test")
    private List<String> mTestLogs = new ArrayList<String>();
    @Option(name="test-run-log", description="Name of a file to report as a log for each test run")
    private List<String> mTestRunLogs = new ArrayList<String>();
    @Option(name="test-invocation-log", description="Name of the file to report as log at the end of the invocation")
    private List<String> mInvocationLogs = new ArrayList<String>();
    private static final Pattern INNER_PAREN_SEGMENT = Pattern.compile("(.*?)   \\(([^()]*)\\)   (\\d+)?   (.*?)", 4);
    private static final Pattern RLE_SEGMENT = Pattern.compile("^(([PFAI])(\\d+)?)");
    static final HashMap<String, MetricMeasurement.Metric> EMPTY_MAP = new HashMap();
    private ITestDevice mDevice = null;

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    int toIntOrDefault(String number, int defValue) throws IllegalArgumentException {
        if (number == null) {
            return defValue;
        }
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    String decodeRle(String encoded) throws IllegalArgumentException {
        Matcher m;
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < encoded.length(); i += m.group(1).length()) {
            m = RLE_SEGMENT.matcher(encoded.substring(i));
            if (m.find()) {
                String c = m.group(2);
                int repeat = this.toIntOrDefault(m.group(3), 1);
                if (repeat < 1) {
                    throw new IllegalArgumentException(String.format("Encountered illegal repeat length %d; expecting a length >= 1", repeat));
                }
                for (int k = 0; k < repeat; ++k) {
                    out.append(c);
                }
                continue;
            }
            throw new IllegalArgumentException(String.format("Encountered illegal character \"%s\" while parsing segment \"%s\"", encoded.substring(i, i + 1), encoded));
        }
        return out.toString();
    }

    String decode(String encoded) throws IllegalArgumentException {
        String work = encoded.toUpperCase();
        Matcher m = INNER_PAREN_SEGMENT.matcher(work);
        while (m.matches()) {
            String prefix = m.group(1);
            String subsection = m.group(2);
            int repeat = this.toIntOrDefault(m.group(3), 1);
            if (repeat < 1) {
                throw new IllegalArgumentException(String.format("Encountered illegal repeat length %d; expecting a length >= 1", repeat));
            }
            String suffix = m.group(4);
            StringBuilder nextState = new StringBuilder(prefix);
            for (int k = 0; k < repeat; ++k) {
                nextState.append(subsection);
            }
            nextState.append(suffix);
            work = nextState.toString();
            m = INNER_PAREN_SEGMENT.matcher(work);
        }
        return this.decodeRle(work);
    }

    void executeTestRun(ITestInvocationListener listener, String runName, String spec) throws IllegalArgumentException {
        listener.testRunStarted(runName, spec.length());
        int i = 0;
        for (char c : spec.toCharArray()) {
            if (c != 'P' && c != 'F' && c != 'A' && c != 'I') {
                throw new IllegalArgumentException(String.format("Received unexpected test spec character '%c' in spec \"%s\"", Character.valueOf(c), spec));
            }
            String testName = String.format("testMethod%d", ++i);
            TestDescription test = new TestDescription(runName, testName);
            listener.testStarted(test);
            switch (c) {
                case 'P': {
                    break;
                }
                case 'F': {
                    listener.testFailed(test, String.format("Test %s had a predictable boo-boo.", testName));
                    break;
                }
                case 'A': {
                    listener.testAssumptionFailure(test, String.format("Test %s had an assumption failure", testName));
                    break;
                }
                case 'I': {
                    listener.testIgnored(test);
                }
            }
            this.saveLogs(listener, this.mTestLogs);
            listener.testEnded(test, EMPTY_MAP);
        }
        this.saveLogs(listener, this.mTestRunLogs);
        listener.testRunEnded(0L, EMPTY_MAP);
    }

    @Override
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        for (Map.Entry<String, String> run : this.mRuns.entrySet()) {
            String name = run.getKey();
            String testSpec = this.decode(run.getValue());
            this.executeTestRun(listener, name, testSpec);
        }
        this.saveLogs(listener, this.mInvocationLogs);
        if (this.mFailInvocationWithCause != null) {
            throw new RuntimeException(this.mFailInvocationWithCause);
        }
    }

    private void saveLogs(ITestInvocationListener listener, List<String> logs) {
        for (String filename : logs) {
            File log = new File(filename);
            if (!log.isFile()) continue;
            try (FileInputStreamSource in = new FileInputStreamSource(log);){
                listener.testLog(log.getName(), LogDataType.UNKNOWN, in);
            }
        }
    }
}

