/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.GTestBase;
import com.android.tradefed.testtype.GTestResultParser;
import com.android.tradefed.testtype.GTestXmlResultParser;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.util.AbiUtils;
import com.android.tradefed.util.FileUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

@OptionClass(alias="gtest")
public class GTest
extends GTestBase
implements IDeviceTest {
    static final String DEFAULT_NATIVETEST_PATH = "/data/nativetest";
    private ITestDevice mDevice = null;
    @Option(name="native-test-device-path", description="The path on the device where native tests are located.")
    private String mNativeTestDevicePath = "/data/nativetest";
    @Option(name="reboot-before-test", description="Reboot the device before the test suite starts.")
    private boolean mRebootBeforeTest = false;
    @Option(name="stop-runtime", description="Stops the Java application runtime before test execution.")
    private boolean mStopRuntime = false;
    @Deprecated
    @Option(name="coverage-flush", description="Forces coverage data to be flushed at the end of the test.")
    private boolean mCoverageFlush = false;
    @Deprecated
    @Option(name="coverage-processes", description="Name of processes to collect coverage data from.")
    private List<String> mCoverageProcesses = new ArrayList<String>();
    @Deprecated
    @Option(name="coverage-clear-before-test", description="Clears all coverage counters before test execution.")
    private boolean mCoverageClearBeforeTest = true;
    @Option(name="filter-non-matching-abi-folders", description="If an abi specific hierarchy seem to exists, only run the parts that match abi under test.")
    private boolean mFilterAbiFolders = true;
    @Option(name="use-updated-shard-retry", description="Whether to use the updated logic for retry with sharding.")
    private boolean mUseUpdatedShardRetry = true;
    private boolean mIncompleteTestFound = false;
    private Set<String> mCurFailedTests = new LinkedHashSet<String>();
    private static final int GTEST_CMD_CHAR_LIMIT = 1000;

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    @Override
    protected String loadFilter(String binaryOnDevice) throws DeviceNotAvailableException {
        try {
            String filterKey = this.getTestFilterKey();
            LogUtil.CLog.i("Loading filter from file for key: '%s'", filterKey);
            String filterFile = String.format("%s%s", binaryOnDevice, ".filter");
            if (this.getDevice().doesFileExist(filterFile)) {
                String content = this.getDevice().executeShellCommand(String.format("cat \"%s\"", filterFile));
                if (content != null && !content.isEmpty()) {
                    JSONObject filter = new JSONObject(content);
                    JSONObject filterObject = filter.getJSONObject(filterKey);
                    return filterObject.getString("filter");
                }
                LogUtil.CLog.e("Error with content of the filter file %s: %s", filterFile, content);
            } else {
                LogUtil.CLog.e("Filter file %s not found", filterFile);
            }
        }
        catch (JSONException e) {
            LogUtil.CLog.e(e);
        }
        return null;
    }

    private String getTestPath() {
        StringBuilder testPath = new StringBuilder(this.mNativeTestDevicePath);
        String testModule = this.getTestModule();
        if (testModule != null) {
            testPath.append("/");
            testPath.append(testModule);
        }
        return testPath.toString();
    }

    public void setNativeTestDevicePath(String path) {
        this.mNativeTestDevicePath = path;
    }

    @VisibleForTesting
    void doRunAllTestsInSubdirectory(String root, ITestDevice testDevice, ITestInvocationListener listener) throws DeviceNotAvailableException {
        LinkedHashSet<String> excludeDirectories = new LinkedHashSet<String>();
        if (this.mFilterAbiFolders && this.getAbi() != null) {
            String currentArch = AbiUtils.getArchForAbi(this.getAbi().getName());
            for (String supportedArch : AbiUtils.getArchSupported()) {
                if (supportedArch.equals(currentArch)) continue;
                excludeDirectories.add(supportedArch);
            }
        }
        String[] executableFiles = this.getExecutableFiles(testDevice, root, excludeDirectories);
        for (String filePath : executableFiles) {
            if (!this.shouldRunFile(filePath)) continue;
            IShellOutputReceiver resultParser = this.createResultParser(this.getFileName(filePath), listener);
            String flags = this.getAllGTestFlags(filePath);
            LogUtil.CLog.i("Running gtest %s %s on %s", filePath, flags, testDevice.getSerialNumber());
            if (this.isEnableXmlOutput()) {
                this.runTestXml(testDevice, filePath, flags, listener);
                continue;
            }
            this.runTest(testDevice, resultParser, filePath, flags);
        }
    }

    String getFileName(String fullPath) {
        int pos = fullPath.lastIndexOf(47);
        if (pos == -1) {
            return fullPath;
        }
        String fileName = fullPath.substring(pos + 1);
        if (fileName.isEmpty()) {
            throw new IllegalArgumentException("input should not end with \"/\"");
        }
        return fileName;
    }

    protected boolean shouldRunFile(String fullPath) {
        if (fullPath == null || fullPath.isEmpty()) {
            return false;
        }
        String moduleName = this.getTestModule();
        String fileName = this.getFileName(fullPath);
        if (moduleName != null && !fileName.startsWith(moduleName)) {
            return false;
        }
        List<String> fileExclusionFilterRegex = this.getFileExclusionFilterRegex();
        for (String regex : fileExclusionFilterRegex) {
            if (!fullPath.matches(regex)) continue;
            LogUtil.CLog.i("File %s matches exclusion file regex %s, skipping", fullPath, regex);
            return false;
        }
        return true;
    }

    protected void executeCommandByScript(ITestDevice testDevice, String cmd, IShellOutputReceiver resultParser) throws DeviceNotAvailableException {
        String tmpFileDevice = "/data/local/tmp/gtest_script.sh";
        testDevice.pushString(String.format("#!/bin/bash\n%s", cmd), tmpFileDevice);
        testDevice.executeShellCommand(String.format("chmod 755 %s", tmpFileDevice));
        testDevice.executeShellCommand(String.format("sh %s", tmpFileDevice), resultParser, this.getMaxTestTimeMs(), TimeUnit.MILLISECONDS, 0);
        testDevice.deleteFile(tmpFileDevice);
    }

    @Override
    protected String getGTestCmdLine(String fullPath, String flags) {
        StringBuilder sb = new StringBuilder();
        if (this.getShardCount() > 0) {
            if (this.isCollectTestsOnly()) {
                LogUtil.CLog.w("--collect-tests-only option ignores sharding parameters, and will cause each shard to collect all tests.");
            }
            sb.append(String.format("GTEST_SHARD_INDEX=%s ", this.getShardIndex()));
            sb.append(String.format("GTEST_TOTAL_SHARDS=%s ", this.getShardCount()));
        }
        sb.append(super.getGTestCmdLine(fullPath, flags));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String createFlagFile(String filter) throws DeviceNotAvailableException {
        String flagPath = super.createFlagFile(filter);
        if (flagPath == null) {
            return null;
        }
        File flagFile = new File(flagPath);
        String devicePath = "/data/local/tmp/" + flagFile.getName();
        try {
            if (!this.mDevice.pushFile(flagFile, devicePath)) {
                String string = null;
                return string;
            }
        }
        finally {
            FileUtil.deleteFile(flagFile);
        }
        return devicePath;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runTest(ITestDevice testDevice, IShellOutputReceiver resultParser, String fullPath, String flags) throws DeviceNotAvailableException {
        Object cmd;
        try {
            for (String cmd2 : this.getBeforeTestCmd()) {
                testDevice.executeShellCommand(cmd2);
            }
            if (this.mRebootBeforeTest && !this.isCollectTestsOnly()) {
                LogUtil.CLog.d("Rebooting device before test starts as requested.");
                testDevice.reboot();
            }
            if (((String)(cmd = this.getGTestCmdLine(fullPath, flags))).length() < 1000) {
                testDevice.executeShellCommand((String)cmd, resultParser, this.getMaxTestTimeMs(), TimeUnit.MILLISECONDS, 0);
            } else {
                this.executeCommandByScript(testDevice, (String)cmd, resultParser);
            }
        }
        catch (DeviceNotAvailableException e) {
            try {
                throw e;
                catch (RuntimeException e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                resultParser.flush();
                if (resultParser instanceof GTestResultParser) {
                    if (((GTestResultParser)resultParser).isTestRunIncomplete()) {
                        this.mIncompleteTestFound = true;
                    } else {
                        this.mCurFailedTests.addAll(((GTestResultParser)resultParser).getFailedTests());
                    }
                }
                Iterator<String> iterator2 = this.getAfterTestCmd().iterator();
                while (true) {
                    if (!iterator2.hasNext()) {
                        throw throwable;
                    }
                    String cmd3 = iterator2.next();
                    testDevice.executeShellCommand(cmd3);
                }
            }
        }
        resultParser.flush();
        if (resultParser instanceof GTestResultParser) {
            if (((GTestResultParser)resultParser).isTestRunIncomplete()) {
                this.mIncompleteTestFound = true;
            } else {
                this.mCurFailedTests.addAll(((GTestResultParser)resultParser).getFailedTests());
            }
        }
        cmd = this.getAfterTestCmd().iterator();
        while (cmd.hasNext()) {
            String cmd2;
            cmd2 = (String)cmd.next();
            testDevice.executeShellCommand(cmd2);
        }
        return;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runTestXml(ITestDevice testDevice, String fullPath, String flags, ITestInvocationListener listener) throws DeviceNotAvailableException {
        Object testRunName;
        File tmpOutput;
        CollectingOutputReceiver outputCollector;
        block11: {
            outputCollector = new CollectingOutputReceiver();
            tmpOutput = null;
            try {
                testRunName = fullPath.substring(fullPath.lastIndexOf("/") + 1);
                tmpOutput = FileUtil.createTempFile((String)testRunName, ".xml");
                String tmpResName = fullPath + "_res.xml";
                String extraFlag = String.format("--gtest_output=xml:%s", tmpResName);
                String fullFlagCmd = String.format("%s %s", flags, extraFlag);
                this.runTest(testDevice, outputCollector, fullPath, fullFlagCmd);
                testDevice.pullFile(tmpResName, tmpOutput);
                testDevice.deleteFile(tmpResName);
                GTestXmlResultParser parser = this.createXmlParser((String)testRunName, listener);
                if (!tmpOutput.exists()) break block11;
                parser.parseResult(tmpOutput, outputCollector);
                if (parser.isTestRunIncomplete()) {
                    this.mIncompleteTestFound = true;
                } else {
                    this.mCurFailedTests.addAll(parser.getFailedTests());
                }
            }
            catch (DeviceNotAvailableException | RuntimeException e) {
                try {
                    throw e;
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                }
                catch (Throwable throwable) {
                    outputCollector.flush();
                    Iterator<String> iterator2 = this.getAfterTestCmd().iterator();
                    while (true) {
                        if (!iterator2.hasNext()) {
                            FileUtil.deleteFile(tmpOutput);
                            throw throwable;
                        }
                        String cmd = iterator2.next();
                        testDevice.executeShellCommand(cmd);
                    }
                }
            }
        }
        outputCollector.flush();
        testRunName = this.getAfterTestCmd().iterator();
        while (true) {
            if (!testRunName.hasNext()) {
                FileUtil.deleteFile(tmpOutput);
                return;
            }
            String cmd = (String)testRunName.next();
            testDevice.executeShellCommand(cmd);
        }
    }

    @Override
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        String testPath = this.getTestPath();
        if (!this.mDevice.doesFileExist(testPath)) {
            LogUtil.CLog.w("Could not find native test directory %s in %s!", testPath, this.mDevice.getSerialNumber());
            return;
        }
        this.mIncompleteTestFound = false;
        this.mCurFailedTests = new LinkedHashSet<String>();
        if (this.mStopRuntime) {
            this.mDevice.executeShellCommand("stop");
        }
        listener = this.getGTestListener(listener);
        Throwable throwable = null;
        try {
            this.doRunAllTestsInSubdirectory(testPath, this.mDevice, listener);
        }
        catch (Throwable t) {
            throwable = t;
            this.mIncompleteTestFound = true;
            throw t;
        }
        finally {
            if (this.mUseUpdatedShardRetry) {
                this.notifyTestExecution(this.mIncompleteTestFound, this.mCurFailedTests);
            }
            if (!(throwable instanceof DeviceNotAvailableException) && this.mStopRuntime) {
                this.mDevice.executeShellCommand("start");
                this.mDevice.waitForDeviceAvailable();
            }
        }
    }

    public boolean isRebootBeforeTestEnabled() {
        return this.mRebootBeforeTest;
    }

    private String[] getExecutableFiles(ITestDevice device, String deviceFilePath, Set<String> excludeDirectories) throws DeviceNotAvailableException {
        String output;
        String cmd = String.format("find -L %s -type f -perm -a=x", deviceFilePath);
        if (excludeDirectories != null && !excludeDirectories.isEmpty()) {
            for (String directoryName : excludeDirectories) {
                cmd = cmd + String.format(" -not -path \"*/%s/*\"", directoryName);
            }
        }
        if ((output = device.executeShellCommand(cmd)).trim().isEmpty()) {
            return new String[0];
        }
        return output.split("\r?\n");
    }
}

