/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.MultiLineReceiver;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GTestListTestParser
extends MultiLineReceiver {
    private String mLastTestClassName = null;
    private String mTestRunName = null;
    private ITestInvocationListener mTestRunListener = null;
    private boolean mPrependFileName = false;
    private static final Pattern TEST_CLASS = Pattern.compile("^([a-zA-Z]+.*)\\.$");
    private static final Pattern TEST_METHOD = Pattern.compile("\\s+([a-zA-Z_0-9]+[\\S]*)(.*)?(\\s+.*)?$");
    protected List<TestDescription> mTests = new ArrayList<TestDescription>();
    private boolean mIsDone = false;

    public GTestListTestParser(String testRunName, ITestInvocationListener listener) {
        this.mTestRunName = testRunName;
        this.mTestRunListener = listener;
        this.setTrimLine(false);
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public void processNewLines(String[] lines) {
        for (String line : lines) {
            this.parse(line);
        }
    }

    private String getTestClass(String name) {
        if (this.mPrependFileName) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.mTestRunName);
            sb.append(".");
            sb.append(name);
            return sb.toString();
        }
        return name;
    }

    private void parse(String line) {
        Matcher classMatcher = TEST_CLASS.matcher(line);
        Matcher methodMatcher = TEST_METHOD.matcher(line);
        if (classMatcher.matches()) {
            this.mLastTestClassName = classMatcher.group(1);
        } else if (methodMatcher.matches()) {
            if (this.mLastTestClassName == null) {
                throw new IllegalStateException(String.format("parsed new test case name %s but no test class name has been set", line));
            }
            this.mTests.add(new TestDescription(this.getTestClass(this.mLastTestClassName), methodMatcher.group(1)));
        } else {
            LogUtil.CLog.v("line ignored: %s", line);
        }
    }

    public void setPrependFileName(boolean prepend) {
        this.mPrependFileName = prepend;
    }

    public boolean getPrependFileName() {
        return this.mPrependFileName;
    }

    @Override
    public void done() {
        if (this.mIsDone) {
            return;
        }
        this.mTestRunListener.testRunStarted(this.mTestRunName, this.mTests.size());
        for (TestDescription id : this.mTests) {
            this.mTestRunListener.testStarted(id);
            this.mTestRunListener.testEnded(id, new HashMap<String, MetricMeasurement.Metric>());
        }
        this.mTestRunListener.testRunEnded(0L, new HashMap<String, MetricMeasurement.Metric>());
        super.done();
        this.mIsDone = true;
    }
}

