/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.MultiLineReceiver;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.result.proto.TestRecordProto;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GTestResultParser
extends MultiLineReceiver {
    private TestResult mCurrentTestResult = null;
    private int mNumTestsRun = 0;
    private int mNumTestsExpected = 0;
    private long mTotalRunTime = 0L;
    private boolean mTestInProgress = false;
    private CloseableTraceScope mMethodScope = null;
    private boolean mTestRunInProgress = false;
    private final String mTestRunName;
    private final Collection<ITestInvocationListener> mTestListeners;
    private boolean mTestRunStartReported = false;
    private boolean mSeenOneTestRunStart = false;
    private boolean mFailureReported = false;
    private List<String> mTrackLogsBeforeRunStart = new ArrayList<String>();
    private boolean mIsCancelled = false;
    private boolean mPrependFileName = false;
    private boolean mTestRunIncomplete = false;
    private Set<String> mFailedTests = new LinkedHashSet<String>();

    public void setPrependFileName(boolean prepend) {
        this.mPrependFileName = prepend;
    }

    public boolean getPrependFileName() {
        return this.mPrependFileName;
    }

    public GTestResultParser(String testRunName, Collection<ITestInvocationListener> listeners) {
        this.mTestRunName = testRunName;
        this.mTestListeners = new ArrayList<ITestInvocationListener>(listeners);
        this.setTrimLine(false);
    }

    public GTestResultParser(String testRunName, ITestInvocationListener listener) {
        this(testRunName, Arrays.asList(listener));
    }

    private TestResult getCurrentTestResult() {
        if (this.mCurrentTestResult == null) {
            this.mCurrentTestResult = new TestResult();
        }
        return this.mCurrentTestResult;
    }

    private void clearCurrentTestResult() {
        this.mCurrentTestResult = null;
    }

    @Override
    public void processNewLines(String[] lines) {
        if (!this.mSeenOneTestRunStart) {
            this.mTrackLogsBeforeRunStart.addAll(Arrays.asList(lines));
        }
        for (String line : lines) {
            this.parse(line);
            LogUtil.CLog.v(line);
        }
    }

    private void parse(String line) {
        String message2 = null;
        if (this.mTestRunInProgress || line.startsWith("[==========]")) {
            if (line.startsWith("[ RUN      ]")) {
                message2 = line.substring("[ RUN      ]".length()).trim();
                this.processTestStartedTag(message2);
            } else if (line.contains("[  SKIPPED ]")) {
                message2 = line.substring(line.indexOf("[  SKIPPED ]") + "[  SKIPPED ]".length()).trim();
                if (!this.testInProgress()) {
                    this.fakeRunMarker(message2);
                }
                this.processSkippedTag(message2);
                this.clearCurrentTestResult();
            } else if (line.contains("[       OK ]")) {
                message2 = line.substring(line.indexOf("[       OK ]") + "[       OK ]".length()).trim();
                if (!this.testInProgress()) {
                    LogUtil.CLog.e("Found %s without %s before, Ensure you are using GTest format", line, "[ RUN      ]");
                    return;
                }
                this.processOKTag(message2);
                this.clearCurrentTestResult();
            } else if (line.contains("[    OK    ]")) {
                message2 = line.substring(line.indexOf("[    OK    ]") + "[    OK    ]".length()).trim();
                this.fakeRunMarker(message2);
                this.processOKTag(message2);
                this.clearCurrentTestResult();
            } else if (line.contains("[  FAILED  ]")) {
                message2 = line.substring(line.indexOf("[  FAILED  ]") + "[  FAILED  ]".length()).trim();
                if (!this.testInProgress()) {
                    this.fakeRunMarker(message2);
                }
                this.processFailedTag(message2);
                this.clearCurrentTestResult();
            } else if (line.contains("[ TIMEOUT  ]")) {
                message2 = line.substring(line.indexOf("[ TIMEOUT  ]") + "[ TIMEOUT  ]".length()).trim();
                this.fakeRunMarker(message2);
                this.processFailedTag(message2);
                this.clearCurrentTestResult();
            } else if (line.startsWith("[==========] Running")) {
                message2 = line.substring("[==========]".length()).trim();
                this.processRunStartedTag(message2);
            } else if (line.startsWith("[==========]")) {
                message2 = line.substring("[==========]".length()).trim();
                this.processRunCompletedTag(message2);
            } else if (this.testInProgress()) {
                this.appendTestOutputLine(line);
            }
        }
    }

    @Override
    public boolean isCancelled() {
        return this.mIsCancelled;
    }

    private void fakeRunMarker(String message2) {
        String fakeRunMaker = message2.split(" +")[0];
        this.processTestStartedTag(fakeRunMaker);
    }

    public void cancel() {
        this.mIsCancelled = true;
    }

    private boolean testInProgress() {
        return this.mTestInProgress;
    }

    private void setTestStarted(TestDescription testId) {
        this.mTestInProgress = true;
        this.mMethodScope = new CloseableTraceScope(testId.toString());
    }

    private void setTestEnded() {
        this.mTestInProgress = false;
        if (this.mMethodScope != null) {
            this.mMethodScope.close();
            this.mMethodScope = null;
        }
    }

    private void reportTestRunStarted() {
        if (!this.mTestRunStartReported) {
            for (ITestInvocationListener listener : this.mTestListeners) {
                listener.testRunStarted(this.mTestRunName, this.mNumTestsExpected);
            }
            this.mTestRunStartReported = true;
            this.mSeenOneTestRunStart = true;
            this.mTrackLogsBeforeRunStart.clear();
            this.mTestRunIncomplete = false;
            this.mFailedTests = new LinkedHashSet<String>();
        }
    }

    private void reportTestRunEnded() {
        for (ITestInvocationListener listener : this.mTestListeners) {
            listener.testRunEnded(this.mTotalRunTime, this.getRunMetrics());
        }
        this.mTestRunStartReported = false;
        this.mTestRunIncomplete = false;
    }

    private HashMap<String, MetricMeasurement.Metric> getRunMetrics() {
        HashMap<String, MetricMeasurement.Metric> metricsMap = new HashMap<String, MetricMeasurement.Metric>();
        return metricsMap;
    }

    private ParsedTestInfo parseTestDescription(String identifier) {
        String[] testId;
        ParsedTestInfo returnInfo = new ParsedTestInfo("UNKNOWN_CLASS", "UNKNOWN_TEST", null);
        Pattern timePattern = Pattern.compile(".*(\\((\\d+) ms\\))");
        Matcher time = timePattern.matcher(identifier);
        if (time.find()) {
            String timeString = time.group(2);
            String discardPortion = time.group(1);
            identifier = identifier.substring(0, identifier.lastIndexOf(discardPortion)).trim();
            returnInfo.mTestRunTime = timeString;
        }
        if ((testId = identifier.split("\\.")).length < 2) {
            LogUtil.CLog.e("Could not detect the test class and test name, received: %s", identifier);
            returnInfo.mTestClassName = null;
            returnInfo.mTestName = null;
        } else {
            returnInfo.mTestClassName = testId[0];
            returnInfo.mTestName = testId[1];
        }
        return returnInfo;
    }

    private void processRunStartedTag(String identifier) {
        Pattern numTestsPattern = Pattern.compile("Running (\\d+) test[s]? from .*");
        Matcher numTests = numTestsPattern.matcher(identifier);
        if (numTests.find()) {
            try {
                this.mNumTestsExpected = Integer.parseInt(numTests.group(1));
            }
            catch (NumberFormatException e) {
                LogUtil.CLog.e("Unable to determine number of tests expected, received: %s", numTests.group(1));
            }
        }
        if (this.mNumTestsExpected > 0) {
            this.reportTestRunStarted();
            this.mNumTestsRun = 0;
            this.mTestRunInProgress = true;
        } else if (this.mNumTestsExpected == 0) {
            this.reportTestRunStarted();
        }
    }

    private void processRunCompletedTag(String identifier) {
        Pattern timePattern = Pattern.compile(".*\\((\\d+) ms total\\)");
        Matcher time = timePattern.matcher(identifier);
        if (time.find()) {
            try {
                this.mTotalRunTime = Long.parseLong(time.group(1));
            }
            catch (NumberFormatException e) {
                LogUtil.CLog.e("Unable to determine the total running time, received: %s", time.group(1));
            }
        }
        this.reportTestRunEnded();
        this.mTestRunInProgress = false;
    }

    private String getTestClass(TestResult testResult) {
        if (this.mPrependFileName) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.mTestRunName);
            sb.append(".");
            sb.append(testResult.mTestClass);
            return sb.toString();
        }
        return testResult.mTestClass;
    }

    private void processTestStartedTag(String identifier) {
        ParsedTestInfo parsedResults = this.parseTestDescription(identifier);
        TestResult testResult = this.getCurrentTestResult();
        testResult.mTestClass = parsedResults.mTestClassName;
        testResult.mTestName = parsedResults.mTestName;
        testResult.mStartTimeMs = System.currentTimeMillis();
        TestDescription testId = null;
        if (this.getTestClass(testResult) == null || testResult.mTestName == null) {
            LogUtil.CLog.e("Error during parsing, className: %s and testName: %s, should both be not null", this.getTestClass(testResult), testResult.mTestName);
            return;
        }
        testId = new TestDescription(this.getTestClass(testResult), testResult.mTestName);
        for (ITestInvocationListener listener : this.mTestListeners) {
            listener.testStarted(testId, testResult.mStartTimeMs);
        }
        this.setTestStarted(testId);
    }

    private void doTestEnded(String identifier, TestStatus testStatus) {
        ParsedTestInfo parsedResults = this.parseTestDescription(identifier);
        TestResult testResult = this.getCurrentTestResult();
        TestDescription testId = null;
        if (this.getTestClass(testResult) == null || testResult.mTestName == null) {
            LogUtil.CLog.e("Error during parsing, className: %s and testName: %s, should both be not null", this.getTestClass(testResult), testResult.mTestName);
            return;
        }
        testId = new TestDescription(this.getTestClass(testResult), testResult.mTestName);
        if (!this.testInProgress()) {
            LogUtil.CLog.e("Test currently not in progress when trying to end test: %s", identifier);
            return;
        }
        if (parsedResults.mTestRunTime != null) {
            try {
                testResult.mRunTime = Long.valueOf(parsedResults.mTestRunTime);
            }
            catch (NumberFormatException e) {
                LogUtil.CLog.e("Test run time value is invalid, received: %s", parsedResults.mTestRunTime);
            }
        } else {
            LogUtil.CLog.d("No runtime for %s, defaulting to 0ms.", testId);
            testResult.mRunTime = 0L;
        }
        boolean encounteredUnexpectedTest = false;
        if (!testResult.isComplete()) {
            LogUtil.CLog.e("No test/class name is currently recorded as running!");
        } else {
            if (testResult.mTestClass.compareTo(parsedResults.mTestClassName) != 0) {
                LogUtil.CLog.e("Name for current test class does not match class we started with, expected: %s but got:%s ", testResult.mTestClass, parsedResults.mTestClassName);
                encounteredUnexpectedTest = true;
            }
            if (testResult.mTestName.compareTo(parsedResults.mTestName) != 0) {
                LogUtil.CLog.e("Name for current test does not match test we started with, expected: %s  but got: %s", testResult.mTestName, parsedResults.mTestName);
                encounteredUnexpectedTest = true;
            }
        }
        if (encounteredUnexpectedTest) {
            for (ITestInvocationListener listener : this.mTestListeners) {
                listener.testFailed(testId, this.mCurrentTestResult.getTrace());
            }
        } else if (TestStatus.FAILED.equals((Object)testStatus)) {
            for (ITestInvocationListener listener : this.mTestListeners) {
                listener.testFailed(testId, this.mCurrentTestResult.getTrace());
            }
            this.mFailedTests.add(String.format("%s.%s", testId.getClassName(), testId.getTestName()));
        } else if (TestStatus.SKIPPED.equals((Object)testStatus)) {
            for (ITestInvocationListener listener : this.mTestListeners) {
                listener.testIgnored(testId);
            }
        }
        HashMap<String, MetricMeasurement.Metric> emptyMap = new HashMap<String, MetricMeasurement.Metric>();
        long endTimeMs = testResult.mStartTimeMs + testResult.mRunTime;
        for (ITestInvocationListener listener : this.mTestListeners) {
            listener.testEnded(testId, endTimeMs, emptyMap);
        }
        this.setTestEnded();
        ++this.mNumTestsRun;
    }

    private void processOKTag(String identifier) {
        this.doTestEnded(identifier, TestStatus.OK);
    }

    private void processFailedTag(String identifier) {
        this.doTestEnded(identifier, TestStatus.FAILED);
    }

    private void processSkippedTag(String identifier) {
        this.doTestEnded(identifier, TestStatus.SKIPPED);
    }

    private void appendTestOutputLine(String line) {
        TestResult testResult = this.getCurrentTestResult();
        if (testResult.mStackTrace == null) {
            testResult.mStackTrace = new StringBuilder();
        } else {
            testResult.mStackTrace.append("\r\n");
        }
        testResult.mStackTrace.append(line);
    }

    private void handleTestRunFailed(String errorMsg, ErrorIdentifier errorId) {
        errorMsg = errorMsg == null ? "Unknown error" : errorMsg;
        LogUtil.CLog.i("Test run failed: %s", errorMsg);
        String testRunStackTrace = "";
        if (this.mCurrentTestResult != null && this.mCurrentTestResult.isComplete()) {
            TestDescription testId = new TestDescription(this.getTestClass(this.mCurrentTestResult), this.mCurrentTestResult.mTestName);
            HashMap<String, MetricMeasurement.Metric> emptyMap = new HashMap<String, MetricMeasurement.Metric>();
            if (this.mCurrentTestResult.hasStackTrace()) {
                testRunStackTrace = this.mCurrentTestResult.getTrace();
            }
            FailureDescription testFailure = FailureDescription.create("No test results.\r\n" + testRunStackTrace).setFailureStatus(TestRecordProto.FailureStatus.TEST_FAILURE);
            for (ITestInvocationListener listener : this.mTestListeners) {
                listener.testFailed(testId, testFailure);
                listener.testEnded(testId, emptyMap);
            }
            if (this.mMethodScope != null) {
                this.mMethodScope.close();
                this.mMethodScope = null;
            }
            this.clearCurrentTestResult();
        }
        FailureDescription error = FailureDescription.create(errorMsg).setFailureStatus(TestRecordProto.FailureStatus.TEST_FAILURE);
        if (errorId != null) {
            error.setErrorIdentifier(errorId);
        }
        for (ITestInvocationListener listener : this.mTestListeners) {
            listener.testRunFailed(error);
            listener.testRunEnded(this.mTotalRunTime, this.getRunMetrics());
        }
    }

    @Override
    public void done() {
        super.done();
        if (this.mMethodScope != null) {
            this.mMethodScope.close();
            this.mMethodScope = null;
        }
        if (this.mTestRunStartReported && this.mNumTestsExpected > this.mNumTestsRun) {
            this.handleTestRunFailed(String.format("Test run incomplete. Expected %d tests, received %d", this.mNumTestsExpected, this.mNumTestsRun), InfraErrorIdentifier.EXPECTED_TESTS_MISMATCH);
            this.mTestRunIncomplete = true;
            this.mTestRunStartReported = false;
            this.mTestRunInProgress = false;
        } else if (this.mTestRunInProgress) {
            LogUtil.CLog.e("All tests were executed, but test run completion not reported.Unable to determine the total run time.");
            this.reportTestRunEnded();
            this.mTestRunInProgress = false;
        } else if (!this.mSeenOneTestRunStart && !this.mFailureReported) {
            for (ITestInvocationListener listener : this.mTestListeners) {
                listener.testRunStarted(this.mTestRunName, 0);
                listener.testRunFailed(this.createFailure(String.format("%s did not report any run:\n%s", this.mTestRunName, String.join((CharSequence)"\n", this.mTrackLogsBeforeRunStart))));
                listener.testRunEnded(0L, new HashMap<String, MetricMeasurement.Metric>());
            }
            this.mFailureReported = true;
        }
    }

    public boolean isTestRunIncomplete() {
        return this.mTestRunIncomplete;
    }

    public Set<String> getFailedTests() {
        return this.mFailedTests;
    }

    private FailureDescription createFailure(String message2) {
        return FailureDescription.create(message2, TestRecordProto.FailureStatus.TEST_FAILURE);
    }

    private static class TestResult {
        private String mTestName = null;
        private String mTestClass = null;
        private StringBuilder mStackTrace = null;
        private long mStartTimeMs;
        private Long mRunTime = null;

        private TestResult() {
        }

        boolean isComplete() {
            return this.mTestName != null && this.mTestClass != null;
        }

        boolean hasStackTrace() {
            return this.mStackTrace != null;
        }

        String getTrace() {
            if (this.hasStackTrace()) {
                return this.mStackTrace.toString();
            }
            LogUtil.CLog.e("Could not find stack trace for failed test");
            return new Throwable("Unknown failure").toString();
        }

        public String toString() {
            StringBuilder output = new StringBuilder();
            if (this.mTestClass != null) {
                output.append(this.mTestClass);
                output.append('#');
            }
            if (this.mTestName != null) {
                output.append(this.mTestName);
            }
            if (output.length() > 0) {
                return output.toString();
            }
            return "unknown result";
        }
    }

    private static class Prefixes {
        private static final String INFORMATIONAL_MARKER = "[----------]";
        private static final String START_TEST_RUN_MARKER = "[==========] Running";
        private static final String TEST_RUN_MARKER = "[==========]";
        private static final String START_TEST_MARKER = "[ RUN      ]";
        private static final String OK_TEST_MARKER = "[       OK ]";
        private static final String SKIPPED_TEST_MARKER = "[  SKIPPED ]";
        private static final String FAILED_TEST_MARKER = "[  FAILED  ]";
        private static final String ALT_OK_MARKER = "[    OK    ]";
        private static final String TIMEOUT_MARKER = "[ TIMEOUT  ]";

        private Prefixes() {
        }
    }

    private static class ParsedTestInfo {
        String mTestName = null;
        String mTestClassName = null;
        String mTestRunTime = null;

        public ParsedTestInfo(String testName, String testClassName, String testRunTime) {
            this.mTestName = testName;
            this.mTestClassName = testClassName;
            this.mTestRunTime = testRunTime;
        }
    }

    static enum TestStatus {
        OK,
        FAILED,
        SKIPPED;

    }
}

