/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GTestXmlResultParser {
    private static final String TEST_SUITE_TAG = "testsuite";
    private static final String TEST_CASE_TAG = "testcase";
    private static final String RESULT_ATTRIBUTE = "result";
    private static final String SKIPPED_VALUE = "skipped";
    private final String mTestRunName;
    private int mNumTestsRun = 0;
    private int mNumTestsExpected = 0;
    private long mTotalRunTime = 0L;
    private final Collection<ITestInvocationListener> mTestListeners;
    private boolean mTestRunIncomplete = false;
    private Set<String> mFailedTests = new LinkedHashSet<String>();

    public GTestXmlResultParser(String testRunName, Collection<ITestInvocationListener> listeners) {
        this.mTestRunName = testRunName;
        this.mTestListeners = new ArrayList<ITestInvocationListener>(listeners);
    }

    public GTestXmlResultParser(String testRunName, ITestInvocationListener listener) {
        this.mTestRunName = testRunName;
        this.mTestListeners = new ArrayList<ITestInvocationListener>();
        if (listener != null) {
            this.mTestListeners.add(listener);
        }
    }

    public void parseResult(File f, CollectingOutputReceiver output) {
        this.mTestRunIncomplete = false;
        this.mFailedTests = new LinkedHashSet<String>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document result = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(new DefaultHandler());
            result = db.parse(f);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.reportTestRunStarted();
            for (ITestInvocationListener listener : this.mTestListeners) {
                String errorMessage = String.format("Failed to get an xml output from tests, it probably crashed", new Object[0]);
                if (output != null) {
                    errorMessage = errorMessage + "\nlogs:\n" + output.getOutput();
                    LogUtil.CLog.e(errorMessage);
                }
                listener.testRunFailed(errorMessage);
                listener.testRunEnded(this.mTotalRunTime, new HashMap<String, MetricMeasurement.Metric>());
            }
            return;
        }
        Element rootNode = result.getDocumentElement();
        this.getTestSuitesInfo(rootNode);
        this.reportTestRunStarted();
        NodeList testSuiteList = rootNode.getElementsByTagName(TEST_SUITE_TAG);
        if (testSuiteList != null && testSuiteList.getLength() > 0) {
            for (int i = 0; i < testSuiteList.getLength(); ++i) {
                NodeList testcasesList = ((Element)testSuiteList.item(i)).getElementsByTagName(TEST_CASE_TAG);
                if (testcasesList == null || testcasesList.getLength() <= 0) continue;
                for (int j = 0; j < testcasesList.getLength(); ++j) {
                    this.processTestResult((Element)testcasesList.item(j));
                }
            }
        }
        if (this.mNumTestsExpected > this.mNumTestsRun) {
            this.mTestRunIncomplete = true;
            for (ITestInvocationListener listener : this.mTestListeners) {
                listener.testRunFailed(String.format("Test run incomplete. Expected %d tests, received %d", this.mNumTestsExpected, this.mNumTestsRun));
            }
        }
        for (ITestInvocationListener listener : this.mTestListeners) {
            listener.testRunEnded(this.mTotalRunTime, new HashMap<String, MetricMeasurement.Metric>());
        }
    }

    private void getTestSuitesInfo(Element rootNode) {
        this.mNumTestsExpected = Integer.parseInt(rootNode.getAttribute("tests"));
        this.mTotalRunTime = (long)(Double.parseDouble(rootNode.getAttribute("time")) * 1000.0);
    }

    private void reportTestRunStarted() {
        for (ITestInvocationListener listener : this.mTestListeners) {
            listener.testRunStarted(this.mTestRunName, this.mNumTestsExpected);
        }
    }

    private void processTestResult(Element testcase) {
        String classname = testcase.getAttribute("classname");
        String testname = testcase.getAttribute("name");
        String runtime = testcase.getAttribute("time");
        boolean skipped = false;
        if (testcase.hasAttribute(RESULT_ATTRIBUTE)) {
            skipped = SKIPPED_VALUE.equals(testcase.getAttribute(RESULT_ATTRIBUTE));
        }
        ParsedTestInfo parsedResults = new ParsedTestInfo(testname, classname, runtime);
        long runtimeMs = 0L;
        if (parsedResults.mTestRunTime != null) {
            try {
                Double parsedRuntime = Double.valueOf(parsedResults.mTestRunTime);
                runtimeMs = (long)(parsedRuntime * 1000.0);
            }
            catch (NumberFormatException e) {
                LogUtil.CLog.e("Test run time value is invalid, received: %s", parsedResults.mTestRunTime);
            }
        }
        TestDescription testId = new TestDescription(parsedResults.mTestClassName, parsedResults.mTestName);
        ++this.mNumTestsRun;
        long startTimeMs = System.currentTimeMillis();
        for (ITestInvocationListener iTestInvocationListener : this.mTestListeners) {
            iTestInvocationListener.testStarted(testId, startTimeMs);
        }
        if (skipped) {
            for (ITestInvocationListener iTestInvocationListener : this.mTestListeners) {
                iTestInvocationListener.testIgnored(testId);
            }
        }
        if (testcase.getElementsByTagName("failure").getLength() != 0) {
            this.mFailedTests.add(String.format("%s.%s", testId.getClassName(), testId.getTestName()));
            String trace = ((Element)testcase.getElementsByTagName("failure").item(0)).getAttribute("message");
            if (!trace.contains("Failed")) {
                trace = trace + "\nFailed";
            }
            for (ITestInvocationListener listener : this.mTestListeners) {
                listener.testFailed(testId, trace);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("runtime", Long.toString(runtimeMs));
        long l = startTimeMs + runtimeMs;
        for (ITestInvocationListener listener : this.mTestListeners) {
            listener.testEnded(testId, l, TfMetricProtoUtil.upgradeConvert(map));
        }
    }

    public boolean isTestRunIncomplete() {
        return this.mTestRunIncomplete;
    }

    public Set<String> getFailedTests() {
        return this.mFailedTests;
    }

    private static class ParsedTestInfo {
        String mTestName = null;
        String mTestClassName = null;
        String mTestRunTime = null;

        public ParsedTestInfo(String testName, String testClassName, String testRunTime) {
            this.mTestName = testName;
            this.mTestClassName = testClassName;
            this.mTestRunTime = testRunTime;
        }
    }
}

