/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.error.TestErrorIdentifier;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleBenchmarkResultParser {
    private String mTestClassName;
    private final ITestInvocationListener mTestListener;

    public GoogleBenchmarkResultParser(String testClassName, ITestInvocationListener listener) {
        this.mTestClassName = testClassName;
        this.mTestListener = listener;
    }

    public Map<String, String> parse(CollectingOutputReceiver output) {
        String outputLogs = output.getOutput();
        Map<Object, Object> results = new HashMap();
        JSONObject res = null;
        outputLogs = this.sanitizeOutput(outputLogs);
        try {
            res = new JSONObject(outputLogs);
            JSONObject context = res.getJSONObject("context");
            results = this.parseJsonToMap(context);
        }
        catch (JSONException e) {
            boolean isTestAborted;
            String testAbortedMessage = this.causeIfTestAborted(outputLogs);
            boolean bl = isTestAborted = testAbortedMessage != null;
            if (isTestAborted) {
                String errorMessage = String.format("Test aborted with the error: '%s'", testAbortedMessage);
                LogUtil.CLog.e(errorMessage);
                FailureDescription failure = FailureDescription.create(errorMessage).setErrorIdentifier(TestErrorIdentifier.TEST_ABORTED);
                this.mTestListener.testRunFailed(failure);
            } else {
                String parserFailedMessage = "Failed to Parse context:";
                LogUtil.CLog.e(parserFailedMessage);
                LogUtil.CLog.e(e);
                FailureDescription failure = FailureDescription.create(parserFailedMessage).setCause(e).setErrorIdentifier(TestErrorIdentifier.OUTPUT_PARSER_ERROR);
                this.mTestListener.testRunFailed(failure);
            }
            LogUtil.CLog.d("output was:\n%s\n", outputLogs);
            return results;
        }
        try {
            JSONArray benchmarks = res.getJSONArray("benchmarks");
            for (int i = 0; i < benchmarks.length(); ++i) {
                Map<Object, Object> testResults = new HashMap();
                JSONObject testRes = (JSONObject)benchmarks.get(i);
                String name = testRes.getString("name");
                TestDescription testId = new TestDescription(this.mTestClassName, name);
                this.mTestListener.testStarted(testId);
                try (CloseableTraceScope ignore = new CloseableTraceScope(testId.toString());){
                    boolean errorOccurred;
                    try {
                        testResults = this.parseJsonToMap(testRes);
                    }
                    catch (JSONException e) {
                        LogUtil.CLog.e(e);
                        this.mTestListener.testFailed(testId, String.format("Test failed to generate proper results: %s", e.getMessage()));
                    }
                    String iterations = (String)testResults.get("iterations");
                    if (iterations != null && "0".equals(iterations.trim())) {
                        this.mTestListener.testIgnored(testId);
                    }
                    if (testRes.has("error_occurred") && (errorOccurred = testRes.getBoolean("error_occurred"))) {
                        String errorMessage = (String)testResults.get("error_message");
                        if (Strings.isNullOrEmpty(errorMessage)) {
                            this.mTestListener.testFailed(testId, "Benchmark reported an unspecified error");
                        } else {
                            this.mTestListener.testFailed(testId, String.format("Benchmark reported an error: %s", errorMessage));
                        }
                    }
                }
                this.mTestListener.testEnded(testId, TfMetricProtoUtil.upgradeConvert(testResults));
            }
            results.put("Pass", Integer.toString(benchmarks.length()));
        }
        catch (JSONException e) {
            LogUtil.CLog.e(e);
            results.put("ERROR", e.getMessage());
            this.mTestListener.testRunFailed(String.format("Failed to parse benchmarks results: %s", e));
        }
        return results;
    }

    private String causeIfTestAborted(String outputLogs) {
        String errorMessage = null;
        Pattern pattern = Pattern.compile("\\n(.*)\\nAborted\\s+$");
        Matcher matcher = pattern.matcher(outputLogs);
        if (matcher.find()) {
            errorMessage = matcher.group(1).trim();
        }
        return errorMessage;
    }

    protected Map<String, String> parseJsonToMap(JSONObject j) throws JSONException {
        HashMap<String, String> testResults = new HashMap<String, String>();
        Iterator i = j.keys();
        while (i.hasNext()) {
            String key = (String)i.next();
            testResults.put(key, j.get(key).toString());
        }
        return testResults;
    }

    private String sanitizeOutput(String output) {
        if (output.startsWith("{")) {
            return output;
        }
        int indexStart = output.indexOf(123);
        if (indexStart == -1) {
            LogUtil.CLog.w("Output does not look like a proper JSON.");
            return output;
        }
        String newOuput = output.substring(indexStart);
        LogUtil.CLog.d("We removed the following from the output: '%s'", output.subSequence(0, indexStart));
        return newOuput;
    }
}

