/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.GoogleBenchmarkResultParser;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.util.StringEscapeUtils;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@OptionClass(alias="gbenchmark")
public class GoogleBenchmarkTest
implements IDeviceTest,
IRemoteTest,
ITestFilterReceiver {
    static final String DEFAULT_TEST_PATH = "/data/benchmarktest";
    static final String GBENCHMARK_FILTER_OPTION = "--benchmark_filter";
    static final int ADB_CMD_CHAR_LIMIT = 4000;
    private static final String GBENCHMARK_LIST_TESTS_OPTION = "--benchmark_list_tests=true";
    private static final List<String> DEFAULT_FILE_EXCLUDE_FILTERS = new ArrayList<String>();
    @VisibleForTesting
    static final String GBENCHMARK_JSON_OUTPUT_FORMAT = "--benchmark_format=json";
    @Option(name="file-exclusion-filter-regex", description="Regex to exclude certain files from executing. Can be repeated")
    private List<String> mFileExclusionFilterRegex = new ArrayList<String>(DEFAULT_FILE_EXCLUDE_FILTERS);
    @Option(name="native-benchmark-device-path", description="The path on the device where native stress tests are located.")
    private String mDeviceTestPath = "/data/benchmarktest";
    @Option(name="benchmark-module-name", description="The name of the native benchmark test module to run. If not specified all tests in --native-benchmark-device-path will be run. Can be repeated")
    private List<String> mTestModules = new ArrayList<String>();
    @Option(name="benchmark-run-name", description="Optional name to pass to test reporters. If unspecified, will use test binary as run name.")
    private String mReportRunName = null;
    @Option(name="max-run-time", description="The maximum time to allow for each benchmark run in ms.", isTimeVal=true)
    private long mMaxRunTime = 900000L;
    @Option(name="include-filter", description="The benchmark (regex) filters used to match benchmarks to include.")
    private Set<String> mIncludeFilters = new LinkedHashSet<String>();
    @Option(name="exclude-filter", description="The benchmark (regex) filters used to match benchmarks to exclude.")
    private Set<String> mExcludeFilters = new LinkedHashSet<String>();
    @Option(name="ld-library-path", description="LD_LIBRARY_PATH value to include in the Google Benchmark Test execution command.")
    private String mLdLibraryPath = null;
    private ITestDevice mDevice = null;
    private String mLdCommand = "";

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void addModuleName(String moduleName) {
        this.mTestModules.add(moduleName);
    }

    public List<String> getModuleNames() {
        return this.mTestModules;
    }

    public void setReportRunName(String reportRunName) {
        this.mReportRunName = reportRunName;
    }

    void addFileExclusionFilterRegex(String regex) {
        this.mFileExclusionFilterRegex.add(regex);
    }

    private String getTestPath(String root, String child) {
        StringBuilder testPath = new StringBuilder(root);
        if (child != null) {
            testPath.append("/");
            testPath.append(child);
        }
        return testPath.toString();
    }

    private void doRunAllTestsInSubdirectory(String root, ITestDevice testDevice, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (testDevice.isDirectory(root)) {
            for (String child : testDevice.getChildren(root)) {
                this.doRunAllTestsInSubdirectory(root + "/" + child, testDevice, listener);
            }
        } else {
            String rootEntry = root.substring(root.lastIndexOf("/") + 1);
            String runName = this.mReportRunName == null ? rootEntry : this.mReportRunName;
            testDevice.executeShellCommand(String.format("chmod 755 %s", root));
            if (this.shouldSkipFile(root)) {
                return;
            }
            long startTime = System.currentTimeMillis();
            Set<String> filteredTests = this.getFilteredTests(testDevice, root);
            LogUtil.CLog.d("List that will be used: %s", Arrays.asList(filteredTests));
            int numTests = filteredTests.size();
            if (numTests == 0) {
                LogUtil.CLog.d("No tests to run.");
                return;
            }
            Map<String, String> metricMap = new HashMap<String, String>();
            CollectingOutputReceiver outputCollector = this.createOutputCollector();
            GoogleBenchmarkResultParser resultParser = this.createResultParser(runName, listener);
            listener.testRunStarted(runName, numTests);
            try (CloseableTraceScope ignore = new CloseableTraceScope(runName);){
                String cmd = String.format("%s%s%s %s", this.mLdCommand, root, this.getFilterFlagForTests(filteredTests), GBENCHMARK_JSON_OUTPUT_FORMAT);
                LogUtil.CLog.i(String.format("Running google benchmark test on %s: %s", this.mDevice.getSerialNumber(), cmd));
                this.executeCommand(testDevice, cmd, outputCollector);
                metricMap = resultParser.parse(outputCollector);
            }
            catch (DeviceNotAvailableException e) {
                listener.testRunFailed(e.getMessage());
                throw e;
            }
            finally {
                long elapsedTime = System.currentTimeMillis() - startTime;
                listener.testRunEnded(elapsedTime, TfMetricProtoUtil.upgradeConvert(metricMap));
            }
        }
    }

    private Set<String> getFilteredTests(ITestDevice testDevice, String fullBinaryPath) throws DeviceNotAvailableException {
        Set<String> filteredTests = this.getTestsForFilters(testDevice, fullBinaryPath, this.mIncludeFilters);
        if (!this.mExcludeFilters.isEmpty()) {
            filteredTests.removeAll(this.getTestsForFilters(testDevice, fullBinaryPath, this.mExcludeFilters));
        }
        return filteredTests;
    }

    private Set<String> getTestsForFilters(ITestDevice testDevice, String fullBinaryPath, Set<String> filters) throws DeviceNotAvailableException {
        String cmd = String.format("%s%s%s %s", this.mLdCommand, fullBinaryPath, this.getFilterFlagForFilters(filters), GBENCHMARK_LIST_TESTS_OPTION);
        String list_output = this.executeCommand(testDevice, cmd, null);
        String[] list2 = list_output.trim().split("\n");
        if (this.noMatchesFound(list2)) {
            list2 = new String[]{};
        }
        return new LinkedHashSet<String>(Arrays.asList(list2));
    }

    private boolean noMatchesFound(String[] list2) {
        if (list2.length == 0) {
            return true;
        }
        return list2[0].indexOf(32) >= 0;
    }

    protected boolean shouldSkipFile(String fullPath) {
        if (fullPath == null || fullPath.isEmpty()) {
            return true;
        }
        if (this.mFileExclusionFilterRegex == null || this.mFileExclusionFilterRegex.isEmpty()) {
            return false;
        }
        for (String regex : this.mFileExclusionFilterRegex) {
            if (!fullPath.matches(regex)) continue;
            LogUtil.CLog.i(String.format("File %s matches exclusion file regex %s, skipping", fullPath, regex));
            return true;
        }
        return false;
    }

    CollectingOutputReceiver createOutputCollector() {
        return new CollectingOutputReceiver();
    }

    GoogleBenchmarkResultParser createResultParser(String runName, ITestInvocationListener listener) {
        return new GoogleBenchmarkResultParser(runName, listener);
    }

    @Override
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        if (this.mTestModules.isEmpty()) {
            this.addModuleName(null);
        }
        for (String testModule : this.mTestModules) {
            String testPath = this.getTestPath(this.mDeviceTestPath, testModule);
            if (!Strings.isNullOrEmpty(this.mLdLibraryPath)) {
                this.mLdCommand = String.format("LD_LIBRARY_PATH=%s ", this.mLdLibraryPath);
            }
            if (!this.mDevice.doesFileExist(testPath)) {
                LogUtil.CLog.w(String.format("Could not find native benchmark test directory %s in %s!", testPath, this.mDevice.getSerialNumber()));
                throw new RuntimeException(String.format("Could not find native benchmark test directory %s", testPath));
            }
            this.doRunAllTestsInSubdirectory(testPath, this.mDevice, listener);
        }
    }

    public String cleanFilter(String filter) {
        Integer index = filter.indexOf(35);
        if (index >= 0) {
            String benchmark = filter.substring(index + 1);
            if (benchmark.isEmpty()) {
                LogUtil.CLog.e("Invalid filter %s. Result could be unexpected.", filter);
            } else {
                return benchmark;
            }
        }
        return filter;
    }

    @Override
    public void addIncludeFilter(String filter) {
        this.mIncludeFilters.add(this.cleanFilter(filter));
    }

    @Override
    public void addAllIncludeFilters(Set<String> filters) {
        for (String filter : filters) {
            this.mIncludeFilters.add(this.cleanFilter(filter));
        }
    }

    @Override
    public void addExcludeFilter(String filter) {
        this.mExcludeFilters.add(this.cleanFilter(filter));
    }

    @Override
    public void addAllExcludeFilters(Set<String> filters) {
        for (String filter : filters) {
            this.mExcludeFilters.add(this.cleanFilter(filter));
        }
    }

    @Override
    public Set<String> getIncludeFilters() {
        return this.mIncludeFilters;
    }

    @Override
    public Set<String> getExcludeFilters() {
        return this.mExcludeFilters;
    }

    @Override
    public void clearIncludeFilters() {
        this.mIncludeFilters.clear();
    }

    @Override
    public void clearExcludeFilters() {
        this.mExcludeFilters.clear();
    }

    @VisibleForTesting
    protected String getFilterFlagForFilters(Set<String> filters) {
        StringBuilder filterFlag = new StringBuilder();
        Iterator<String> iterator2 = filters.iterator();
        if (iterator2.hasNext()) {
            filterFlag.append(String.format(" %s=%s", GBENCHMARK_FILTER_OPTION, iterator2.next()));
            while (iterator2.hasNext()) {
                filterFlag.append(String.format("|%s", iterator2.next()));
            }
        }
        return filterFlag.toString();
    }

    @VisibleForTesting
    protected String getFilterFlagForTests(Set<String> fitlererTests) {
        StringBuilder filterFlag = new StringBuilder();
        Iterator<String> iterator2 = fitlererTests.iterator();
        if (iterator2.hasNext()) {
            filterFlag.append(String.format(" %s=^%s$", GBENCHMARK_FILTER_OPTION, iterator2.next()));
            while (iterator2.hasNext()) {
                filterFlag.append(String.format("|^%s$", iterator2.next()));
            }
        }
        return filterFlag.toString();
    }

    protected String executeCommand(ITestDevice testDevice, String cmd, IShellOutputReceiver outputReceiver) throws DeviceNotAvailableException {
        String shellCmd = StringEscapeUtils.escapeShell(cmd);
        if (shellCmd.length() < 4000) {
            if (outputReceiver == null) {
                if (cmd.contains(GBENCHMARK_LIST_TESTS_OPTION)) {
                    return testDevice.executeShellV2Command(shellCmd).getStdout();
                }
                return testDevice.executeShellCommand(shellCmd);
            }
            testDevice.executeShellCommand(shellCmd, outputReceiver, this.mMaxRunTime, TimeUnit.MILLISECONDS, 0);
            return null;
        }
        return this.executeCommandByScript(testDevice, shellCmd, outputReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeCommandByScript(ITestDevice testDevice, String cmd, IShellOutputReceiver outputReceiver) throws DeviceNotAvailableException {
        String tmpFileDevice = "/data/local/tmp/gbenchmarktest_script.sh";
        testDevice.pushString(String.format("#!/bin/bash\n%s", cmd), tmpFileDevice);
        String shellOutput = null;
        try {
            if (outputReceiver == null) {
                shellOutput = cmd.contains(GBENCHMARK_LIST_TESTS_OPTION) ? testDevice.executeShellV2Command(String.format("sh %s", tmpFileDevice)).getStdout() : testDevice.executeShellCommand(String.format("sh %s", tmpFileDevice));
            } else {
                testDevice.executeShellCommand(String.format("sh %s", tmpFileDevice), outputReceiver, this.mMaxRunTime, TimeUnit.MILLISECONDS, 0);
            }
        }
        finally {
            testDevice.deleteFile(tmpFileDevice);
        }
        return shellOutput;
    }

    static {
        DEFAULT_FILE_EXCLUDE_FILTERS.add(".*\\.config$");
    }
}

