/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.build.BuildInfoKey;
import com.android.tradefed.build.DeviceBuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.TestInvocation;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.error.TestErrorIdentifier;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.testtype.GTestBase;
import com.android.tradefed.testtype.GTestResultParser;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.ShellOutputReceiverStream;
import com.android.tradefed.util.TestRunnerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONException;
import org.json.JSONObject;

@OptionClass(alias="hostgtest")
public class HostGTest
extends GTestBase
implements IBuildReceiver {
    private static final long DEFAULT_HOST_COMMAND_TIMEOUT_MS = 120000L;
    private IBuildInfo mBuildInfo = null;
    @Option(name="use-updated-shard-retry", description="Whether to use the updated logic for retry with sharding.")
    private boolean mUseUpdatedShardRetry = true;
    private boolean mIncompleteTestFound = false;
    private Set<String> mCurFailedTests = new LinkedHashSet<String>();

    @Override
    public void setBuild(IBuildInfo buildInfo) {
        this.mBuildInfo = buildInfo;
    }

    public CommandResult executeHostCommand(String cmd) {
        return this.executeHostCommand(cmd, 120000L);
    }

    public CommandResult executeHostCommand(String cmd, long timeoutMs) {
        String[] cmds = cmd.split("\\s+");
        return RunUtil.getDefault().runTimedCmd(timeoutMs, cmds);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CommandResult executeHostGTestCommand(File gtestFile, String cmd, long timeoutMs, IShellOutputReceiver receiver, ITestLogger logger) {
        RunUtil runUtil = new RunUtil();
        String[] cmds = cmd.split("\\s+");
        if (this.getShardCount() > 0) {
            if (this.isCollectTestsOnly()) {
                LogUtil.CLog.w("--collect-tests-only option ignores sharding parameters, and will cause each shard to collect all tests.");
            }
            runUtil.setEnvVariable("GTEST_SHARD_INDEX", Integer.toString(this.getShardIndex()));
            runUtil.setEnvVariable("GTEST_TOTAL_SHARDS", Integer.toString(this.getShardCount()));
        }
        runUtil.setRedirectStderrToStdout(true);
        runUtil.setWorkingDir(gtestFile.getParentFile());
        String separator = System.getProperty("path.separator");
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(System.getenv("PATH"));
        paths.add(gtestFile.getParentFile().getAbsolutePath());
        String path = paths.stream().distinct().collect(Collectors.joining(separator));
        LogUtil.CLog.d("Using updated $PATH: %s", path);
        runUtil.setEnvVariablePriority(IRunUtil.EnvPriority.SET);
        runUtil.setEnvVariable("PATH", path);
        String ldLibraryPath = TestRunnerUtil.getLdLibraryPath(gtestFile);
        if (ldLibraryPath != null) {
            runUtil.setEnvVariable("LD_LIBRARY_PATH", ldLibraryPath);
        }
        CommandResult result = null;
        File stdout = null;
        try {
            stdout = FileUtil.createTempFile(String.format("%s-output", gtestFile.getName()), ".txt");
            try (ShellOutputReceiverStream stream = new ShellOutputReceiverStream(receiver, new FileOutputStream(stdout));){
                result = runUtil.runTimedCmd(timeoutMs, stream, null, cmds);
            }
            catch (IOException e) {
                throw new RuntimeException("Should never happen, ShellOutputReceiverStream.close is a no-op", e);
            }
            receiver.flush();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                receiver.flush();
                try {
                    FileUtil.writeToFile(String.format("\nBinary '%s' still exists: %s", gtestFile, gtestFile.exists()), stdout, true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (stdout != null && stdout.length() > 0L) {
                    try (FileInputStreamSource source = new FileInputStreamSource(stdout);){
                        logger.testLog(String.format("%s-output", gtestFile.getName()), LogDataType.TEXT, source);
                    }
                }
                FileUtil.deleteFile(stdout);
                throw throwable;
            }
        }
        try {
            FileUtil.writeToFile(String.format("\nBinary '%s' still exists: %s", gtestFile, gtestFile.exists()), stdout, true);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (stdout != null && stdout.length() > 0L) {
            try (FileInputStreamSource source = new FileInputStreamSource(stdout);){
                logger.testLog(String.format("%s-output", gtestFile.getName()), LogDataType.TEXT, source);
            }
        }
        FileUtil.deleteFile(stdout);
        return result;
    }

    @Override
    public String loadFilter(String binaryOnHost) {
        try {
            LogUtil.CLog.i("Loading filter from file for key: '%s'", this.getTestFilterKey());
            String filterFileName = String.format("%s%s", binaryOnHost, ".filter");
            File filterFile = new File(filterFileName);
            if (filterFile.exists()) {
                CommandResult cmdResult = this.executeHostCommand(String.format("cat %s", filterFileName));
                String content = cmdResult.getStdout();
                if (content != null && !content.isEmpty()) {
                    JSONObject filter = new JSONObject(content);
                    String key = this.getTestFilterKey();
                    JSONObject filterObject = filter.getJSONObject(key);
                    return filterObject.getString("filter");
                }
                LogUtil.CLog.e("Error with content of the filter file %s: %s", filterFile, content);
            } else {
                LogUtil.CLog.e("Filter file %s not found", filterFile);
            }
        }
        catch (JSONException e) {
            LogUtil.CLog.e(e);
        }
        return null;
    }

    private void runTest(IShellOutputReceiver resultParser, File gtestFile, String flags, ITestLogger logger) {
        for (String cmd : this.getBeforeTestCmd()) {
            CommandResult result = this.executeHostCommand(cmd);
            if (result.getStatus().equals((Object)CommandStatus.SUCCESS)) continue;
            throw new RuntimeException("'Before test' command failed: " + result.getStderr());
        }
        long maxTestTimeMs = this.getMaxTestTimeMs();
        String cmd = this.getGTestCmdLine(gtestFile.getAbsolutePath(), flags);
        CommandResult testResult = this.executeHostGTestCommand(gtestFile, cmd, maxTestTimeMs, resultParser, logger);
        switch (testResult.getStatus()) {
            case TIMED_OUT: {
                throw new HarnessRuntimeException(String.format("Command run timed out after %d ms", maxTestTimeMs), TestErrorIdentifier.TEST_BINARY_TIMED_OUT);
            }
            case EXCEPTION: {
                throw new RuntimeException("Command run failed with exception");
            }
            case FAILED: {
                Integer exitCode = testResult.getExitCode();
                if (exitCode != null && exitCode == 1) break;
                LogUtil.CLog.e("Command run failed with exit code %s", exitCode);
                break;
            }
        }
        for (String afterCmd : this.getAfterTestCmd()) {
            CommandResult result = this.executeHostCommand(afterCmd);
            if (result.getStatus().equals((Object)CommandStatus.SUCCESS)) continue;
            throw new RuntimeException("'After test' command failed: " + result.getStderr());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        try {
            Set<File> gTestFiles;
            File testsDir;
            this.mIncompleteTestFound = false;
            this.mCurFailedTests = new LinkedHashSet<String>();
            ArrayList<File> scanDirs = new ArrayList<File>();
            File hostLinkedDir = this.mBuildInfo.getFile(BuildInfoKey.BuildInfoFileKey.HOST_LINKED_DIR);
            if (hostLinkedDir != null) {
                scanDirs.add(hostLinkedDir);
            }
            if ((testsDir = ((DeviceBuildInfo)this.mBuildInfo).getTestsDir()) != null) {
                scanDirs.add(testsDir);
            }
            String moduleName = this.getTestModule();
            try {
                gTestFiles = FileUtil.findFiles(moduleName, this.getAbi(), false, scanDirs.toArray(new File[0]));
                gTestFiles = this.applyFileExclusionFilters(gTestFiles);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (gTestFiles == null || gTestFiles.isEmpty()) {
                try {
                    gTestFiles = FileUtil.findFiles(moduleName + ".*", this.getAbi(), false, scanDirs.toArray(new File[0]));
                    gTestFiles = this.applyFileExclusionFilters(gTestFiles);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (gTestFiles == null || gTestFiles.isEmpty()) {
                throw new RuntimeException(String.format("Fail to find native test %s in directory %s.", moduleName, scanDirs));
            }
            gTestFiles = this.excludeDuplicateFiles(gTestFiles);
            for (File gTestFile : gTestFiles) {
                if (!gTestFile.canExecute()) {
                    LogUtil.CLog.i("%s is not executable! Skipping.", gTestFile.getAbsolutePath());
                    continue;
                }
                listener = this.getGTestListener(listener);
                IShellOutputReceiver resultParser = this.createResultParser(gTestFile.getName(), listener);
                String flags = this.getAllGTestFlags(gTestFile.getName());
                LogUtil.CLog.i("Running gtest %s %s", gTestFile.getName(), flags);
                try {
                    this.runTest(resultParser, gTestFile, flags, listener);
                }
                finally {
                    if (!(resultParser instanceof GTestResultParser)) continue;
                    if (((GTestResultParser)resultParser).isTestRunIncomplete()) {
                        this.mIncompleteTestFound = true;
                        continue;
                    }
                    this.mCurFailedTests.addAll(((GTestResultParser)resultParser).getFailedTests());
                }
            }
        }
        catch (Throwable t) {
            this.mIncompleteTestFound = true;
            throw t;
        }
        finally {
            if (this.mUseUpdatedShardRetry) {
                this.notifyTestExecution(this.mIncompleteTestFound, this.mCurFailedTests);
            }
        }
    }

    private void reportFailure(ITestInvocationListener listener, String runName, RuntimeException exception) {
        listener.testRunStarted(runName, 0);
        listener.testRunFailed(this.createFailure(exception));
        listener.testRunEnded(0L, new HashMap<String, MetricMeasurement.Metric>());
    }

    private FailureDescription createFailure(Exception e) {
        return TestInvocation.createFailureFromException(e, TestRecordProto.FailureStatus.TEST_FAILURE);
    }

    private Set<File> applyFileExclusionFilters(Set<File> filesToFilterFrom) {
        LinkedHashSet<File> retFiles = new LinkedHashSet<File>();
        List<String> fileExclusionFilterRegex = this.getFileExclusionFilterRegex();
        for (File file2 : filesToFilterFrom) {
            boolean matchedRegex = false;
            for (String regex : fileExclusionFilterRegex) {
                if (!file2.getPath().matches(regex)) continue;
                LogUtil.CLog.i("File %s matches exclusion file regex %s, skipping", file2.getPath(), regex);
                matchedRegex = true;
                break;
            }
            if (matchedRegex) continue;
            retFiles.add(file2);
        }
        return retFiles;
    }

    private Set<File> excludeDuplicateFiles(Set<File> files) {
        LinkedHashMap<String, File> seen = new LinkedHashMap<String, File>();
        for (File file2 : files) {
            if (seen.containsKey(file2.getName())) {
                LogUtil.CLog.i("File %s already exists in location %s. skipping %s.", file2.getName(), ((File)seen.get(file2.getName())).getAbsolutePath(), file2.getAbsolutePath());
                continue;
            }
            seen.put(file2.getName(), file2);
        }
        return new LinkedHashSet<File>(seen.values());
    }
}

