/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.CollectorHelper;
import com.android.tradefed.device.metric.IMetricCollector;
import com.android.tradefed.device.metric.IMetricCollectorReceiver;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.testtype.AndroidJUnitTest;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IShardableTest;
import com.android.tradefed.testtype.ITestFileFilterReceiver;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.testtype.InstrumentationTest;
import com.android.tradefed.testtype.retry.IAutoRetriableTest;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.ListInstrumentationParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@OptionClass(alias="installed-instrumentation")
public class InstalledInstrumentationsTest
implements IDeviceTest,
IShardableTest,
IMetricCollectorReceiver,
IAutoRetriableTest,
IConfigurationReceiver {
    private static final String PM_LIST_CMD = "pm list instrumentation";
    private static final String LINE_SEPARATOR = "\\r?\\n";
    private ITestDevice mDevice;
    @Option(name="shell-timeout", description="The defined timeout (in milliseconds) is used as a maximum waiting time when expecting the command output from the device. At any time, if the shell command does not output anything for a period longer than defined timeout the TF run terminates. For no timeout, set to 0.")
    private long mShellTimeout = 600000L;
    @Option(name="test-timeout", description="Sets timeout (in milliseconds) that will be applied to each test. In the event of a test timeout it will log the results and proceed with executing the next test. For no timeout, set to 0.")
    private long mTestTimeout = 300000L;
    @Option(name="size", description="Restrict tests to a specific test size. One of 'small', 'medium', 'large'", importance=Option.Importance.IF_UNSET)
    private String mTestSize = null;
    @Option(name="runner", description="Restrict tests executed to a specific instrumentation class runner. Installed instrumentations that do not have this runner will be skipped.")
    private String mRunner = null;
    @Option(name="rerun", description="Rerun unexecuted tests individually on same device if test run fails to complete.")
    private boolean mIsRerunMode = true;
    @Deprecated
    @Option(name="send-coverage", description="Send coverage target info to test listeners.")
    private boolean mSendCoverage = false;
    @Deprecated
    @Option(name="screenshot-on-failure", description="Take a screenshot on every test failure")
    private boolean mScreenshotOnFailure = false;
    @Deprecated
    @Option(name="logcat-on-failure", description="take a logcat snapshot on every test failure.")
    private boolean mLogcatOnFailures = false;
    @Option(name="class", description="Only run tests in specified class")
    private String mTestClass = null;
    @Option(name="package", description="Only run tests within this specific java package. Will be ignored if --class is set.")
    private String mTestPackageName = null;
    @Option(name="instrumentation-arg", description="Additional instrumentation arguments to provide.")
    private Map<String, String> mInstrArgMap = new HashMap<String, String>();
    @Option(name="rerun-from-file", description="Use test file instead of separate adb commands for each test when re-running instrumentations for tests that failed to run in previous attempts. ")
    private boolean mReRunUsingTestFile = false;
    @Option(name="rerun-from-file-attempts", description="Max attempts to rerun tests from file. -1 means rerun from file infinitely.")
    private int mReRunUsingTestFileAttempts = -1;
    @Option(name="disable", description="Disable the test by setting this flag to true.")
    private boolean mDisable = false;
    @Option(name="coverage", description="Collect code coverage for this test run. Note that the build under test must be a coverage build or else this will fail.")
    private boolean mCoverage = false;
    @Option(name="hidden-api-checks", description="If set to false, the '--no-hidden-api-checks' flag will be passed to the am instrument command. Only works for P or later.")
    private boolean mHiddenApiChecks = true;
    @Option(name="test-api-access", description="If set to false and hidden API checks are enabled, the '--no-test-api-access' flag will be passed to the am instrument command. Only works for R or later.")
    private boolean mTestApiAccess = true;
    @Option(name="isolated-storage", description="If set to false, the '--no-isolated-storage' flag will be passed to the am instrument command. Only works for Q or later.")
    private boolean mIsolatedStorage = true;
    @Option(name="window-animation", description="If set to false, the '--no-window-animation' flag will be passed to the am instrument command. Only works for ICS or later.")
    private boolean mWindowAnimation = true;
    @Option(name="disable-duplicate-test-check", description="If set to true, it will not check that a method is only run once by a given instrumentation.")
    private boolean mDisableDuplicateCheck = false;
    @Option(name="create-instrumentation-tests", description="Create InstrumentationTest type rather than more recent AndroidJUnitTest.")
    private boolean mDowngradeInstrumentation = false;
    @Option(name="test-storage-dir", description="The device directory path where test storage read files.")
    private String mTestStorageInternalDir = "/sdcard/googletest/test_runfiles";
    @Option(name="use-test-storage", description="If set to true, we will push filters to the test storage instead of disk.")
    private boolean mUseTestStorage = true;
    private int mTotalShards = 0;
    private int mShardIndex = 0;
    private List<IMetricCollector> mMetricCollectorList = new ArrayList<IMetricCollector>();
    private IConfiguration mConfiguration;
    private List<InstrumentationTest> mTests = null;
    private Map<String, Set<TestDescription>> mRunTestsFailureMap = null;
    @Option(name="force-abi", description="The abi to use, can be either 32 or 64.", importance=Option.Importance.IF_UNSET)
    private String mForceAbi = null;

    @Override
    public boolean shouldRetry(int attemptJustExecuted, List<TestRunResult> previousResults, Set<String> skipList) throws DeviceNotAvailableException {
        boolean retry = false;
        if (this.mRunTestsFailureMap == null) {
            this.mRunTestsFailureMap = new HashMap<String, Set<TestDescription>>();
        }
        for (TestRunResult run : previousResults) {
            if (run == null) continue;
            if (run.isRunFailure() || run.hasFailedTests()) {
                LinkedHashSet<TestDescription> excludes = new LinkedHashSet<TestDescription>(run.getTestsInState(Arrays.asList(TestResult.TestStatus.PASSED, TestResult.TestStatus.ASSUMPTION_FAILURE, TestResult.TestStatus.IGNORED)));
                if (this.mRunTestsFailureMap.get(run.getName()) != null) {
                    excludes.addAll((Collection<TestDescription>)this.mRunTestsFailureMap.get(run.getName()));
                }
                Set<TestDescription> skipListDescriptor = this.convertStringToDescription(skipList);
                excludes.addAll(skipListDescriptor);
                retry = this.shouldRetry(run, skipListDescriptor);
                this.mRunTestsFailureMap.put(run.getName(), excludes);
                continue;
            }
            this.mRunTestsFailureMap.put(run.getName(), null);
        }
        if (!retry) {
            LogUtil.CLog.d("No test run or test case failures. No need to retry.");
            this.mRunTestsFailureMap = null;
        }
        return retry;
    }

    private Set<TestDescription> convertStringToDescription(Set<String> skipList) {
        LinkedHashSet<TestDescription> descriptions = new LinkedHashSet<TestDescription>();
        for (String s : skipList) {
            String[] classMethod = s.split("#", 2);
            descriptions.add(new TestDescription(classMethod[0], classMethod[1]));
        }
        return descriptions;
    }

    private boolean shouldRetry(TestRunResult run, Set<TestDescription> skipList) {
        if (run.isRunFailure()) {
            return true;
        }
        Set<TestDescription> failedTests = run.getFailedTests();
        failedTests.removeAll(skipList);
        return !failedTests.isEmpty();
    }

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    List<InstrumentationTest> getTests() {
        return this.mTests;
    }

    void setTotalShards(int totalShards) {
        this.mTotalShards = totalShards;
    }

    void setShardIndex(int shardIndex) {
        this.mShardIndex = shardIndex;
    }

    @Override
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.getDevice() == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        if (this.mDisable) {
            return;
        }
        this.buildTests();
        this.doRun(testInfo, listener);
    }

    private void buildTests() throws DeviceNotAvailableException {
        if (this.mTests == null) {
            ListInstrumentationParser parser = new ListInstrumentationParser();
            CommandResult pmListResult = this.getDevice().executeShellV2Command(PM_LIST_CMD);
            if (!CommandStatus.SUCCESS.equals((Object)pmListResult.getStatus())) {
                throw new HarnessRuntimeException(String.format("Failed to execute '%s'.stdout: %s\nstderr: %s", PM_LIST_CMD, pmListResult.getStdout(), pmListResult.getStderr()), DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
            }
            String pmListOutput = pmListResult.getStdout();
            String[] pmListLines = pmListOutput.split(LINE_SEPARATOR);
            parser.processNewLines(pmListLines);
            if (parser.getInstrumentationTargets().isEmpty()) {
                throw new HarnessRuntimeException(String.format("No instrumentations were found on device %s - <%s>", this.getDevice().getSerialNumber(), pmListOutput), DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
            }
            int numUnshardedTests = 0;
            this.mTests = new LinkedList<InstrumentationTest>();
            for (ListInstrumentationParser.InstrumentationTarget target : parser.getInstrumentationTargets()) {
                if (this.mRunner != null && !this.mRunner.equals(target.runnerName) || this.mTotalShards > 0 && !target.isShardable() && (++numUnshardedTests - 1) % this.mTotalShards != this.mShardIndex) continue;
                List<IMetricCollector> collectors = CollectorHelper.cloneCollectors(this.mMetricCollectorList);
                InstrumentationTest t = this.createInstrumentationTest();
                try {
                    OptionCopier.copyOptions(this, t);
                }
                catch (ConfigurationException e) {
                    throw new RuntimeException("failed to copy instrumentation options", e);
                }
                t.setMetricCollectors(collectors);
                String targetPackageName = target.packageName;
                t.setPackageName(targetPackageName);
                if (this.mRunTestsFailureMap != null && this.mRunTestsFailureMap.containsKey(targetPackageName)) {
                    if (this.mRunTestsFailureMap.get(targetPackageName) == null) {
                        LogUtil.CLog.d("Skipping %s at retry, nothing to do.", targetPackageName);
                        continue;
                    }
                    if (t instanceof AndroidJUnitTest) {
                        AndroidJUnitTest filterable = (AndroidJUnitTest)t;
                        this.excludePassedTests(filterable, this.mRunTestsFailureMap.get(targetPackageName));
                    }
                }
                t.setRunnerName(target.runnerName);
                t.setCoverageTarget(target.targetName);
                if (this.mTotalShards > 0 && target.isShardable()) {
                    t.addInstrumentationArg("shardIndex", Integer.toString(this.mShardIndex));
                    t.addInstrumentationArg("numShards", Integer.toString(this.mTotalShards));
                }
                this.mTests.add(t);
            }
        }
    }

    private void excludePassedTests(ITestFilterReceiver test, Set<TestDescription> passedTests) {
        for (TestDescription testCase : passedTests) {
            String filter = String.format("%s#%s", testCase.getClassName(), testCase.getTestName());
            if (!(test instanceof ITestFileFilterReceiver)) {
                test.addExcludeFilter(filter);
                continue;
            }
            File excludeFilterFile = ((ITestFileFilterReceiver)((Object)test)).getExcludeTestFile();
            if (excludeFilterFile == null) {
                try {
                    excludeFilterFile = FileUtil.createTempFile("exclude-filter", ".txt");
                }
                catch (IOException e) {
                    throw new HarnessRuntimeException(e.getMessage(), e, InfraErrorIdentifier.FAIL_TO_CREATE_FILE);
                }
                ((ITestFileFilterReceiver)((Object)test)).setExcludeTestFile(excludeFilterFile);
            }
            try {
                FileUtil.writeToFile(filter + "\n", excludeFilterFile, true);
            }
            catch (IOException e) {
                LogUtil.CLog.e(e);
            }
        }
    }

    private void doRun(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        while (!this.mTests.isEmpty()) {
            InstrumentationTest test = this.mTests.get(0);
            if (test instanceof ITestFilterReceiver) {
                this.mConfiguration.getGlobalFilters().applyFiltersToTest((ITestFilterReceiver)((Object)test));
            }
            LogUtil.CLog.d("Running test %s on %s", test.getPackageName(), this.getDevice().getSerialNumber());
            test.setDevice(this.getDevice());
            test.setConfiguration(this.mConfiguration);
            if (this.mTestClass != null) {
                test.setClassName(this.mTestClass);
                if (this.mTestPackageName != null) {
                    LogUtil.CLog.e("Ignoring --package option with value '%s' since it's incompatible with using --class at the same time.", this.mTestPackageName);
                }
            } else if (this.mTestPackageName != null) {
                test.setTestPackageName(this.mTestPackageName);
            }
            test.run(testInfo, listener);
            this.mTests.remove(0);
        }
        this.mTests = null;
    }

    long getShellTimeout() {
        return this.mShellTimeout;
    }

    long getTestTimeout() {
        return this.mTestTimeout;
    }

    String getTestSize() {
        return this.mTestSize;
    }

    InstrumentationTest createInstrumentationTest() {
        InstrumentationTest test = null;
        test = this.mDowngradeInstrumentation ? new InstrumentationTest() : new AndroidJUnitTest();
        test.setEnforceFormat(false);
        return test;
    }

    @Override
    public void setMetricCollectors(List<IMetricCollector> collectors) {
        this.mMetricCollectorList = collectors;
    }

    @Override
    public Collection<IRemoteTest> split(int shardCountHint) {
        if (shardCountHint > 1) {
            ArrayList<IRemoteTest> shards = new ArrayList<IRemoteTest>(shardCountHint);
            for (int index = 0; index < shardCountHint; ++index) {
                shards.add(this.getTestShard(shardCountHint, index));
            }
            return shards;
        }
        return null;
    }

    private IRemoteTest getTestShard(int shardCount, int shardIndex) {
        InstalledInstrumentationsTest shard = new InstalledInstrumentationsTest();
        try {
            OptionCopier.copyOptions(this, shard);
        }
        catch (ConfigurationException e) {
            LogUtil.CLog.e("failed to copy instrumentation options: %s", e.getMessage());
        }
        shard.mShardIndex = shardIndex;
        shard.mTotalShards = shardCount;
        return shard;
    }
}

