/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogcatCrashResultForwarder;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.result.error.TestErrorIdentifier;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.util.ProcessInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

final class InstrumentationListener
extends LogcatCrashResultForwarder {
    private static final String DDMLIB_INSTRU_FAILURE_MSG = "Test run failed to complete";
    private static final String DDMLIB_SHELL_UNRESPONSIVE = "Failed to receive adb shell test output within";
    private static final String JUNIT4_TIMEOUT = "org.junit.runners.model.TestTimedOutException: test timed out";
    private static final String DDMLIB_UNEXPECTED_COUNT = "Instrumentation reported numtests=";
    private Set<TestDescription> mTests = new HashSet<TestDescription>();
    private Set<TestDescription> mDuplicateTests = new HashSet<TestDescription>();
    private final Collection<TestDescription> mExpectedTests;
    private boolean mDisableDuplicateCheck = false;
    private boolean mReportUnexecutedTests = false;
    private ProcessInfo mSystemServerProcess = null;
    private String runLevelError = null;
    private TestDescription mLastTest = null;
    private CloseableTraceScope mMethodScope = null;

    public InstrumentationListener(ITestDevice device, Collection<TestDescription> expectedTests, ITestInvocationListener ... listeners) {
        super(device, listeners);
        this.mExpectedTests = expectedTests;
    }

    public void addListener(ITestInvocationListener listener) {
        ArrayList<ITestInvocationListener> listeners = new ArrayList<ITestInvocationListener>();
        listeners.addAll(this.getListeners());
        listeners.add(listener);
        this.setListeners(listeners);
    }

    public void setDisableDuplicateCheck(boolean disable) {
        this.mDisableDuplicateCheck = disable;
    }

    public void setOriginalSystemServer(ProcessInfo info) {
        this.mSystemServerProcess = info;
    }

    public void setReportUnexecutedTests(boolean enable) {
        this.mReportUnexecutedTests = enable;
    }

    @Override
    public void testRunStarted(String runName, int testCount) {
        this.runLevelError = null;
        if (testCount == 0 && this.mExpectedTests != null && !this.mExpectedTests.isEmpty()) {
            LogUtil.CLog.e("Run reported 0 tests while we collected %s", this.mExpectedTests.size());
            super.testRunStarted(runName, this.mExpectedTests.size());
        } else {
            super.testRunStarted(runName, testCount);
        }
    }

    @Override
    public void testStarted(TestDescription test, long startTime) {
        this.mMethodScope = new CloseableTraceScope(test.toString());
        super.testStarted(test, startTime);
        if (!this.mTests.add(test)) {
            this.mDuplicateTests.add(test);
        }
    }

    @Override
    public void testFailed(TestDescription test, FailureDescription failure) {
        String message2 = failure.getErrorMessage();
        if (message2.startsWith(JUNIT4_TIMEOUT) || message2.contains(DDMLIB_SHELL_UNRESPONSIVE)) {
            failure.setErrorIdentifier(TestErrorIdentifier.TEST_TIMEOUT).setRetriable(false);
        }
        super.testFailed(test, failure);
    }

    @Override
    public void testEnded(TestDescription test, long endTime, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        this.mLastTest = test;
        super.testEnded(test, endTime, testMetrics);
        if (this.mMethodScope != null) {
            this.mMethodScope.close();
            this.mMethodScope = null;
        }
    }

    @Override
    public void testRunFailed(FailureDescription error) {
        if (error.getErrorMessage().startsWith(DDMLIB_INSTRU_FAILURE_MSG)) {
            if (this.mExpectedTests != null) {
                LinkedHashSet<TestDescription> expected = new LinkedHashSet<TestDescription>(this.mExpectedTests);
                expected.removeAll(this.mTests);
                String helpMessage = String.format("The following tests didn't run: %s", expected);
                error.setDebugHelpMessage(helpMessage);
            }
            error.setFailureStatus(TestRecordProto.FailureStatus.TEST_FAILURE);
            String wrapMessage = error.getErrorMessage();
            boolean restarted = false;
            if (this.mSystemServerProcess != null) {
                try {
                    restarted = this.getDevice().deviceSoftRestarted(this.mSystemServerProcess);
                }
                catch (DeviceNotAvailableException deviceNotAvailableException) {
                    // empty catch block
                }
                if (restarted) {
                    error.setFailureStatus(TestRecordProto.FailureStatus.SYSTEM_UNDER_TEST_CRASHED);
                    error.setErrorIdentifier(DeviceErrorIdentifier.DEVICE_CRASHED);
                    wrapMessage = String.format("Detected system_server restart causing instrumentation error: %s", error.getErrorMessage());
                }
            }
            if (!restarted && !TestDeviceState.ONLINE.equals((Object)this.getDevice().getDeviceState())) {
                error.setErrorIdentifier(DeviceErrorIdentifier.ADB_DISCONNECT);
                wrapMessage = String.format("Detected device offline causing instrumentation error: %s", error.getErrorMessage());
            }
            error.setErrorMessage(wrapMessage);
        } else if (error.getErrorMessage().startsWith(DDMLIB_SHELL_UNRESPONSIVE)) {
            String wrapMessage = String.format("Instrumentation did not output anything for the configured timeout. ddmlib reported error: %s.", error.getErrorMessage());
            error.setErrorMessage(wrapMessage);
            error.setFailureStatus(TestRecordProto.FailureStatus.TIMED_OUT);
            error.setErrorIdentifier(TestErrorIdentifier.INSTRUMENTATION_TIMED_OUT);
        } else if (error.getErrorMessage().startsWith(DDMLIB_UNEXPECTED_COUNT)) {
            error.setFailureStatus(TestRecordProto.FailureStatus.TEST_FAILURE);
            error.setErrorIdentifier(InfraErrorIdentifier.EXPECTED_TESTS_MISMATCH);
        }
        this.runLevelError = error.getErrorMessage();
        super.testRunFailed(error);
    }

    @Override
    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        if (!this.mDuplicateTests.isEmpty() && !this.mDisableDuplicateCheck) {
            FailureDescription error = FailureDescription.create(String.format("The following tests ran more than once: %s. Check your run configuration, you might be including the same test class several times.", this.mDuplicateTests));
            error.setFailureStatus(TestRecordProto.FailureStatus.TEST_FAILURE).setRetriable(false);
            super.testRunFailed(error);
        } else if (this.mReportUnexecutedTests && this.mExpectedTests != null && this.mExpectedTests.size() > this.mTests.size()) {
            LinkedHashSet<TestDescription> missingTests = new LinkedHashSet<TestDescription>(this.mExpectedTests);
            missingTests.removeAll(this.mTests);
            TestDescription lastTest = this.mLastTest;
            String lastExecutedLog = "";
            if (lastTest != null) {
                lastExecutedLog = "Last executed test was " + lastTest.toString() + ".";
            }
            this.runLevelError = this.runLevelError == null ? "Method was expected to run but didn't." : String.format("Run level error reported reason: '%s", this.runLevelError);
            for (TestDescription miss : missingTests) {
                super.testStarted(miss);
                FailureDescription failure = FailureDescription.create(String.format("Test did not run due to instrumentation issue. %s %s", lastExecutedLog, this.runLevelError), TestRecordProto.FailureStatus.NOT_EXECUTED);
                super.testFailed(miss, failure);
                super.testEnded(miss, new HashMap<String, MetricMeasurement.Metric>());
            }
        }
        this.runLevelError = null;
        super.testRunEnded(elapsedTime, runMetrics);
    }
}

