/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.build.BuildInfoKey;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.isolation.FilterSpec;
import com.android.tradefed.isolation.JUnitEvent;
import com.android.tradefed.isolation.RunnerMessage;
import com.android.tradefed.isolation.RunnerOp;
import com.android.tradefed.isolation.RunnerReply;
import com.android.tradefed.isolation.TestParameters;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestAnnotationFilterReceiver;
import com.android.tradefed.testtype.ITestCollector;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.testtype.TestTimeoutEnforcer;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.ResourceUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.SystemUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@OptionClass(alias="isolated-host-test")
public class IsolatedHostTest
implements IRemoteTest,
IBuildReceiver,
ITestAnnotationFilterReceiver,
ITestFilterReceiver,
IConfigurationReceiver,
ITestCollector {
    @Option(name="class", description="The JUnit test classes to run, in the format <package>.<class>. eg. \"com.android.foo.Bar\". This field can be repeated.", importance=Option.Importance.IF_UNSET)
    private Set<String> mClasses = new LinkedHashSet<String>();
    @Option(name="jar", description="The jars containing the JUnit test class to run.", importance=Option.Importance.IF_UNSET)
    private Set<String> mJars = new HashSet<String>();
    @Option(name="socket-timeout", description="The longest allowable time between messages from the subprocess before assuming that it has malfunctioned or died.", importance=Option.Importance.IF_UNSET)
    private int mSocketTimeout = 60000;
    @Option(name="include-annotation", description="The set of annotations a test must have to be run.")
    private Set<String> mIncludeAnnotations = new HashSet<String>();
    @Option(name="exclude-annotation", description="The set of annotations to exclude tests from running. A test must have none of the annotations in this list to run.")
    private Set<String> mExcludeAnnotations = new HashSet<String>();
    @Option(name="java-flags", description="The set of flags to pass to the Java subprocess for complicated test needs.")
    private List<String> mJavaFlags = new ArrayList<String>();
    @Option(name="use-robolectric-resources", description="Option to put the Robolectric specific resources directory option on the Java command line.")
    private boolean mRobolectricResources = false;
    @Option(name="exclude-paths", description="The (prefix) paths to exclude from searching in the jars.")
    private Set<String> mExcludePaths = new HashSet<String>(Arrays.asList("org/junit", "com/google/common/collect/testing/google"));
    @Option(name="exclude-robolectric-packages", description="Indicates whether to exclude 'org/robolectric' when robolectric resources. Defaults to be true.")
    private boolean mExcludeRobolectricPackages = true;
    @Option(name="java-folder", description="The JDK to be used. If unset, the JDK on $PATH will be used.")
    private File mJdkFolder = null;
    @Option(name="classpath-override", description="[Local Debug Only] Force a classpath (isolation runner dependencies are still added to this classpath)")
    private String mClasspathOverride = null;
    @Option(name="robolectric-android-all-name", description="The android-all resource jar to be used, e.g. 'android-all-R-robolectric-r0.jar'")
    private String mAndroidAllName = "android-all-current-robolectric-r0.jar";
    @Option(name="test-case-timeout", description="The timeout that will be applied to each test case of the run.")
    private Duration mTestCaseTimeout = Duration.ofSeconds(0L);
    private static final String QUALIFIED_PATH = "/com/android/tradefed/isolation";
    private IBuildInfo mBuildInfo;
    private Set<String> mIncludeFilters = new HashSet<String>();
    private Set<String> mExcludeFilters = new HashSet<String>();
    private boolean mCollectTestsOnly = false;
    private File mSubprocessLog;
    private File mWorkDir;
    private boolean mReportedFailure = false;
    private static final String ROOT_DIR = "ROOT_DIR";
    private ServerSocket mServer = null;
    private File mIsolationJar;
    private boolean debug = false;
    private IConfiguration mConfig = null;
    private File mCoverageExecFile;

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        this.mReportedFailure = false;
        Process isolationRunner = null;
        File artifactsDir = null;
        try {
            this.mServer = new ServerSocket(0);
            this.mServer.setSoTimeout(this.mSocketTimeout);
            artifactsDir = FileUtil.createTempDir("robolectric-screenshot-artifacts");
            String classpath = this.compileClassPath();
            List<String> cmdArgs = this.compileCommandArgs(classpath, artifactsDir);
            LogUtil.CLog.v(String.join((CharSequence)" ", cmdArgs));
            RunUtil runner = new RunUtil();
            String ldLibraryPath = this.compileLdLibraryPath();
            if (ldLibraryPath != null) {
                runner.setEnvVariable("LD_LIBRARY_PATH", ldLibraryPath);
            }
            this.mWorkDir = this.findJarDirectory();
            runner.setWorkingDir(this.mWorkDir);
            LogUtil.CLog.v("Using PWD: %s", this.mWorkDir.getAbsolutePath());
            this.mSubprocessLog = FileUtil.createTempFile("subprocess-logs", "");
            runner.setRedirectStderrToStdout(true);
            isolationRunner = runner.runCmdInBackground(ProcessBuilder.Redirect.to(this.mSubprocessLog), cmdArgs);
            LogUtil.CLog.v("Started subprocess.");
            Socket socket = this.mServer.accept();
            if (!this.debug) {
                socket.setSoTimeout(this.mSocketTimeout);
            }
            LogUtil.CLog.v("Connected to subprocess.");
            List<String> testJarAbsPaths = this.getJarPaths(this.mJars);
            TestParameters.Builder paramsBuilder = TestParameters.newBuilder().addAllTestClasses(this.mClasses).addAllTestJarAbsPaths(testJarAbsPaths).addAllExcludePaths(this.mExcludePaths).setDryRun(this.mCollectTestsOnly);
            if (!(this.mIncludeFilters.isEmpty() && this.mExcludeFilters.isEmpty() && this.mIncludeAnnotations.isEmpty() && this.mExcludeAnnotations.isEmpty())) {
                paramsBuilder.setFilter(FilterSpec.newBuilder().addAllIncludeFilters(this.mIncludeFilters).addAllExcludeFilters(this.mExcludeFilters).addAllIncludeAnnotations(this.mIncludeAnnotations).addAllExcludeAnnotations(this.mExcludeAnnotations));
            }
            this.executeTests(socket, listener, paramsBuilder.build());
            RunnerMessage.newBuilder().setCommand(RunnerOp.RUNNER_OP_STOP).build().writeDelimitedTo(socket.getOutputStream());
        }
        catch (IOException e) {
            if (!this.mReportedFailure) {
                FailureDescription failure = FailureDescription.create(StreamUtil.getStackTrace(e), TestRecordProto.FailureStatus.INFRA_FAILURE);
                listener.testRunFailed(failure);
                listener.testRunEnded(0L, new HashMap<String, MetricMeasurement.Metric>());
            }
        }
        finally {
            try {
                if (isolationRunner != null && isolationRunner.isAlive()) {
                    LogUtil.CLog.v("Subprocess is still alive after test phase - waiting for it to terminate.");
                    isolationRunner.waitFor(10L, TimeUnit.SECONDS);
                    if (isolationRunner.isAlive()) {
                        LogUtil.CLog.v("Subprocess is still alive after test phase - requesting termination.");
                        isolationRunner.destroy();
                        isolationRunner.waitFor(10L, TimeUnit.SECONDS);
                        if (isolationRunner.isAlive()) {
                            LogUtil.CLog.v("Subprocess is still alive after test phase - forcibly terminating it.");
                            isolationRunner.destroyForcibly();
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                throw new HarnessRuntimeException("Interrupted while stopping subprocess", e, InfraErrorIdentifier.INTERRUPTED_DURING_SUBPROCESS_SHUTDOWN);
            }
            if (this.isCoverageEnabled()) {
                this.logCoverageExecFile(listener);
            }
            FileUtil.deleteFile(this.mIsolationJar);
            this.uploadTestArtifacts(artifactsDir, listener);
        }
    }

    public List<String> compileCommandArgs(String classpath, File artifactsDir) {
        ArrayList<String> cmdArgs = new ArrayList<String>();
        if (this.mJdkFolder == null) {
            cmdArgs.add(SystemUtil.getRunningJavaBinaryPath().getAbsolutePath());
            LogUtil.CLog.v("Using host java version.");
        } else {
            File javaExec = FileUtil.findFile(this.mJdkFolder, "java");
            if (javaExec == null) {
                throw new IllegalArgumentException(String.format("Couldn't find java executable in given JDK folder: %s", this.mJdkFolder.getAbsolutePath()));
            }
            String javaPath = javaExec.getAbsolutePath();
            cmdArgs.add(javaPath);
            LogUtil.CLog.v("Using java executable at %s", javaPath);
        }
        if (this.isCoverageEnabled()) {
            if (this.mConfig.getCoverageOptions().getJaCoCoAgentPath() != null) {
                try {
                    this.mCoverageExecFile = FileUtil.createTempFile("coverage", ".exec");
                    String javaAgent = String.format("-javaagent:%s=destfile=%s,inclnolocationclasses=true,exclclassloader=jdk.internal.reflect.DelegatingClassLoader", this.mConfig.getCoverageOptions().getJaCoCoAgentPath(), this.mCoverageExecFile.getAbsolutePath());
                    cmdArgs.add(javaAgent);
                }
                catch (IOException e) {
                    LogUtil.CLog.e(e);
                }
            } else {
                LogUtil.CLog.e("jacocoagent path is not set.");
            }
        }
        cmdArgs.add("-cp");
        cmdArgs.add(classpath);
        cmdArgs.addAll(this.mJavaFlags);
        if (this.mRobolectricResources) {
            cmdArgs.addAll(this.compileRobolectricOptions(artifactsDir));
            if (this.mExcludeRobolectricPackages) {
                this.mExcludePaths.add("org/robolectric");
            }
        }
        if (this.debug) {
            cmdArgs.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=8656");
        }
        cmdArgs.addAll(List.of("com.android.tradefed.isolation.IsolationRunner", "-", "--port", Integer.toString(this.mServer.getLocalPort()), "--address", this.mServer.getInetAddress().getHostAddress(), "--timeout", Integer.toString(this.mSocketTimeout)));
        return cmdArgs;
    }

    private File findJarDirectory() {
        File testDir = this.findTestDirectory();
        for (String jar : this.mJars) {
            File f = FileUtil.findFile(testDir, jar);
            if (f == null || !f.exists()) continue;
            return f.getParentFile();
        }
        return null;
    }

    private File findTestDirectory() {
        File testsDir = this.mBuildInfo.getFile(BuildInfoKey.BuildInfoFileKey.HOST_LINKED_DIR);
        if (testsDir != null && testsDir.exists()) {
            return testsDir;
        }
        testsDir = this.mBuildInfo.getFile(BuildInfoKey.BuildInfoFileKey.TESTDIR_IMAGE);
        if (testsDir != null && testsDir.exists()) {
            return testsDir;
        }
        throw new IllegalArgumentException("Test directory not found, cannot proceed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadTestArtifacts(File logDir, ITestInvocationListener listener) {
        try {
            for (File subFile : logDir.listFiles()) {
                if (subFile.isDirectory()) {
                    this.uploadTestArtifacts(subFile, listener);
                    continue;
                }
                if (!subFile.exists()) continue;
                try (FileInputStreamSource dataStream = new FileInputStreamSource(subFile, true);){
                    String cleanName = subFile.getName().replace(",", "_");
                    LogDataType type = LogDataType.TEXT;
                    if (cleanName.endsWith(".png")) {
                        type = LogDataType.PNG;
                    } else if (cleanName.endsWith(".jpg") || cleanName.endsWith(".jpeg")) {
                        type = LogDataType.JPEG;
                    } else if (cleanName.endsWith(".pb")) {
                        type = LogDataType.PB;
                    }
                    listener.testLog(cleanName, type, dataStream);
                }
            }
        }
        finally {
            FileUtil.recursiveDelete(logDir);
        }
    }

    private String compileClassPath() {
        ArrayList<String> paths = new ArrayList<String>();
        File testDir = this.findTestDirectory();
        try {
            this.mIsolationJar = this.getIsolationJar(CurrentInvocation.getWorkFolder());
            paths.add(this.mIsolationJar.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.mClasspathOverride != null) {
            paths.add(this.mClasspathOverride);
        } else {
            if (this.mRobolectricResources) {
                File androidAllJar = FileUtil.findFile(testDir, this.mAndroidAllName);
                if (androidAllJar == null) {
                    throw new HarnessRuntimeException("Could not find android-all jar needed for test execution.", InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
                }
                paths.add(androidAllJar.getAbsolutePath());
            }
            for (String jar : this.mJars) {
                File f = FileUtil.findFile(testDir, jar);
                if (f == null || !f.exists()) continue;
                paths.add(f.getAbsolutePath());
                String parentPath = f.getParentFile().getAbsolutePath() + "/*";
                if (paths.contains(parentPath)) continue;
                paths.add(parentPath);
            }
        }
        String jarClasspath = String.join((CharSequence)File.pathSeparator, paths);
        return jarClasspath;
    }

    @VisibleForTesting
    String getEnvironment(String key) {
        return System.getenv(key);
    }

    @VisibleForTesting
    protected String compileLdLibraryPath() {
        if (this.mClasspathOverride != null) {
            return null;
        }
        File testDir = this.findTestDirectory();
        ArrayList<String> paths = new ArrayList<String>();
        for (String jar : this.mJars) {
            String[] libs;
            File f = FileUtil.findFile(testDir, jar);
            if (f == null || !f.exists()) continue;
            for (String lib : libs = new String[]{"lib", "lib64"}) {
                File libFile = new File(f.getParentFile().getAbsolutePath(), lib);
                if (!libFile.exists()) continue;
                paths.add(libFile.getAbsolutePath());
                libFile = new File(f.getParentFile().getParentFile().getAbsolutePath(), lib);
                if (libFile.exists()) {
                    paths.add(libFile.getAbsolutePath());
                }
                if (this.getEnvironment("ANDROID_HOST_OUT") == null || !(libFile = new File(this.getEnvironment("ANDROID_HOST_OUT"), lib)).exists()) continue;
                paths.add(libFile.getAbsolutePath());
            }
        }
        if (paths.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)File.pathSeparator, paths);
    }

    private List<String> compileRobolectricOptions(File artifactsDir) {
        ArrayList<String> options = new ArrayList<String>();
        File testDir = this.findTestDirectory();
        File androidAllDir = FileUtil.findFile(testDir, "android-all");
        if (androidAllDir == null) {
            throw new IllegalArgumentException("android-all directory not found, cannot proceed");
        }
        String dependencyDir = "-Drobolectric.dependency.dir=" + androidAllDir.getAbsolutePath() + "/";
        options.add(dependencyDir);
        if (artifactsDir != null) {
            String artifactsDirFull = "-Drobolectric.artifacts.dir=" + artifactsDir.getAbsolutePath() + "/";
            options.add(artifactsDirFull);
        }
        options.add("-Drobolectric.offline=true");
        options.add("-Drobolectric.logging=stdout");
        options.add("-Drobolectric.resourcesMode=binary");
        options.add("-Drobolectric.usePreinstrumentedJars=false");
        options.add("-Drobolectric.conscryptMode=OFF");
        if (this.debug) {
            options.add("-Drobolectric.logging.enabled=true");
        }
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeTests(Socket socket, ITestInvocationListener listener, TestParameters params) throws IOException {
        FailureDescription failure;
        Iterator iterator2;
        listener = this.wrapListener(listener);
        RunnerMessage.newBuilder().setCommand(RunnerOp.RUNNER_OP_RUN_TEST).setParams(params).build().writeDelimitedTo(socket.getOutputStream());
        TestDescription currentTest = null;
        Instant start = Instant.now();
        CloseableTraceScope methodScope = null;
        CloseableTraceScope runScope = null;
        boolean runStarted = false;
        try {
            block33: while (true) {
                RunnerReply reply;
                if ((reply = RunnerReply.parseDelimitedFrom(socket.getInputStream())) == null) {
                    if (currentTest != null) {
                        listener.testFailed(currentTest, "Subprocess died unexpectedly.");
                        listener.testEnded(currentTest, System.currentTimeMillis(), new HashMap<String, MetricMeasurement.Metric>());
                    }
                    List logFiles = Arrays.stream(this.mWorkDir.listFiles()).filter(f -> f.getName().startsWith("hs_err") && f.getName().endsWith(".log")).collect(Collectors.toList());
                    if (!runStarted) {
                        listener.testRunStarted(this.getClass().getCanonicalName(), 0);
                    }
                    iterator2 = logFiles.iterator();
                    break;
                }
                switch (reply.getRunnerStatus()) {
                    case RUNNER_STATUS_FINISHED_OK: {
                        LogUtil.CLog.v("Received message that runner finished successfully");
                        return;
                    }
                    case RUNNER_STATUS_FINISHED_ERROR: {
                        LogUtil.CLog.e("Received message that runner errored");
                        LogUtil.CLog.e("From Runner: " + reply.getMessage());
                        if (!runStarted) {
                            listener.testRunStarted(this.getClass().getCanonicalName(), 0);
                        }
                        failure = FailureDescription.create(reply.getMessage(), TestRecordProto.FailureStatus.INFRA_FAILURE);
                        listener.testRunFailed(failure);
                        listener.testRunEnded(0L, new HashMap<String, MetricMeasurement.Metric>());
                        return;
                    }
                    case RUNNER_STATUS_STARTING: {
                        LogUtil.CLog.v("Received message that runner is starting");
                        continue block33;
                    }
                }
                if (!reply.hasTestEvent()) continue;
                JUnitEvent event = reply.getTestEvent();
                switch (event.getTopic()) {
                    case TOPIC_FAILURE: {
                        TestDescription desc = new TestDescription(event.getClassName(), event.getMethodName());
                        listener.testFailed(desc, event.getMessage());
                        break;
                    }
                    case TOPIC_ASSUMPTION_FAILURE: {
                        TestDescription desc = new TestDescription(event.getClassName(), event.getMethodName());
                        listener.testAssumptionFailure(desc, reply.getMessage());
                        break;
                    }
                    case TOPIC_STARTED: {
                        TestDescription desc = new TestDescription(event.getClassName(), event.getMethodName());
                        listener.testStarted(desc, event.getStartTime());
                        currentTest = desc;
                        methodScope = new CloseableTraceScope(desc.toString());
                        break;
                    }
                    case TOPIC_FINISHED: {
                        TestDescription desc = new TestDescription(event.getClassName(), event.getMethodName());
                        listener.testEnded(desc, event.getEndTime(), new HashMap<String, MetricMeasurement.Metric>());
                        currentTest = null;
                        if (methodScope != null) {
                            methodScope.close();
                            methodScope = null;
                            break;
                        }
                        continue block33;
                    }
                    case TOPIC_IGNORED: {
                        TestDescription desc = new TestDescription(event.getClassName(), event.getMethodName());
                        listener.testStarted(desc, event.getEndTime());
                        listener.testIgnored(desc);
                        listener.testEnded(desc, event.getEndTime(), new HashMap<String, MetricMeasurement.Metric>());
                        break;
                    }
                    case TOPIC_RUN_STARTED: {
                        runStarted = true;
                        listener.testRunStarted(event.getClassName(), event.getTestCount());
                        runScope = new CloseableTraceScope(event.getClassName());
                        break;
                    }
                    case TOPIC_RUN_FINISHED: {
                        listener.testRunEnded(event.getElapsedTime(), new HashMap<String, MetricMeasurement.Metric>());
                        if (runScope != null) {
                            runScope.close();
                            runScope = null;
                            break;
                        } else {
                            break;
                        }
                    }
                }
            }
        }
        catch (SocketTimeoutException e) {
            this.mReportedFailure = true;
            failure = FailureDescription.create(StreamUtil.getStackTrace(e), TestRecordProto.FailureStatus.INFRA_FAILURE);
            listener.testRunFailed(failure);
            listener.testRunEnded(Duration.between(start, Instant.now()).toMillis(), new HashMap<String, MetricMeasurement.Metric>());
            return;
        }
        finally {
            try (FileInputStreamSource source = new FileInputStreamSource(this.mSubprocessLog, true);){
                listener.testLog("isolated-java-logs", LogDataType.TEXT, source);
            }
        }
        while (true) {
            if (!iterator2.hasNext()) {
                this.mReportedFailure = true;
                FailureDescription failure2 = FailureDescription.create("The subprocess died unexpectedly.", TestRecordProto.FailureStatus.TEST_FAILURE).setFullRerun(false);
                listener.testRunFailed(failure2);
                listener.testRunEnded(0L, new HashMap<String, MetricMeasurement.Metric>());
                return;
            }
            File f2 = (File)iterator2.next();
            FileInputStreamSource source = new FileInputStreamSource(f2, true);
            try {
                listener.testLog("hs_err_log-VM-crash", LogDataType.TEXT, source);
                continue;
            }
            finally {
                source.close();
                continue;
            }
            break;
        }
    }

    private List<String> getJarPaths(Set<String> jars) throws FileNotFoundException {
        HashSet<String> output = new HashSet<String>();
        for (String jar : jars) {
            File jarFile = this.getJarFile(jar, this.mBuildInfo);
            output.add(jarFile.getAbsolutePath());
        }
        return output.stream().collect(Collectors.toList());
    }

    private File getJarFile(String jarName, IBuildInfo buildInfo) throws FileNotFoundException {
        File testDir = buildInfo.getFile(BuildInfoKey.BuildInfoFileKey.TESTDIR_IMAGE);
        File jarFile = this.searchJarFile(testDir, jarName);
        if (jarFile != null) {
            return jarFile;
        }
        if (buildInfo.getBuildAttributes().get(ROOT_DIR) != null) {
            jarFile = this.searchJarFile(new File(buildInfo.getBuildAttributes().get(ROOT_DIR)), jarName);
        }
        if (jarFile != null) {
            return jarFile;
        }
        throw new FileNotFoundException(String.format("Could not find jar: %s", jarName));
    }

    @VisibleForTesting
    protected File getJarFile(String jarName, TestInformation testInfo) throws FileNotFoundException {
        return testInfo.getDependencyFile(jarName, false);
    }

    private File searchJarFile(File baseSearchFile, String jarName) {
        File jarFile;
        if (baseSearchFile != null && baseSearchFile.isDirectory() && (jarFile = FileUtil.findFile(baseSearchFile, jarName)) != null && jarFile.isFile()) {
            return jarFile;
        }
        return null;
    }

    private void logCoverageExecFile(ITestInvocationListener listener) {
        if (this.mCoverageExecFile == null) {
            LogUtil.CLog.e("Coverage execution file is null.");
            return;
        }
        if (this.mCoverageExecFile.length() == 0L) {
            LogUtil.CLog.e("Coverage execution file has 0 length.");
            return;
        }
        try (FileInputStreamSource source = new FileInputStreamSource(this.mCoverageExecFile, true);){
            listener.testLog("coverage", LogDataType.COVERAGE, source);
        }
    }

    private boolean isCoverageEnabled() {
        return this.mConfig != null && this.mConfig.getCoverageOptions().isCoverageEnabled();
    }

    @Override
    public void setBuild(IBuildInfo build) {
        this.mBuildInfo = build;
    }

    @Override
    public void addIncludeFilter(String filter) {
        this.mIncludeFilters.add(filter);
    }

    @Override
    public void addAllIncludeFilters(Set<String> filters) {
        this.mIncludeFilters.addAll(filters);
    }

    @Override
    public void addExcludeFilter(String filter) {
        this.mExcludeFilters.add(filter);
    }

    @Override
    public void addAllExcludeFilters(Set<String> filters) {
        this.mExcludeFilters.addAll(filters);
    }

    @Override
    public Set<String> getIncludeFilters() {
        return this.mIncludeFilters;
    }

    @Override
    public Set<String> getExcludeFilters() {
        return this.mExcludeFilters;
    }

    @Override
    public void clearIncludeFilters() {
        this.mIncludeFilters.clear();
    }

    @Override
    public void clearExcludeFilters() {
        this.mExcludeFilters.clear();
    }

    @Override
    public void setCollectTestsOnly(boolean shouldCollectTest) {
        this.mCollectTestsOnly = shouldCollectTest;
    }

    @Override
    public void addIncludeAnnotation(String annotation) {
        this.mIncludeAnnotations.add(annotation);
    }

    @Override
    public void addExcludeAnnotation(String notAnnotation) {
        this.mExcludeAnnotations.add(notAnnotation);
    }

    @Override
    public void addAllIncludeAnnotation(Set<String> annotations) {
        this.mIncludeAnnotations.addAll(annotations);
    }

    @Override
    public void addAllExcludeAnnotation(Set<String> notAnnotations) {
        this.mExcludeAnnotations.addAll(notAnnotations);
    }

    @Override
    public Set<String> getIncludeAnnotations() {
        return this.mIncludeAnnotations;
    }

    @Override
    public Set<String> getExcludeAnnotations() {
        return this.mExcludeAnnotations;
    }

    @Override
    public void clearIncludeAnnotations() {
        this.mIncludeAnnotations.clear();
    }

    @Override
    public void clearExcludeAnnotations() {
        this.mExcludeAnnotations.clear();
    }

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.mConfig = configuration;
    }

    public File getCoverageExecFile() {
        return this.mCoverageExecFile;
    }

    @VisibleForTesting
    protected void setServer(ServerSocket server) {
        this.mServer = server;
    }

    public boolean useRobolectricResources() {
        return this.mRobolectricResources;
    }

    private ITestInvocationListener wrapListener(ITestInvocationListener listener) {
        if (this.mTestCaseTimeout.toMillis() > 0L) {
            listener = new TestTimeoutEnforcer(this.mTestCaseTimeout.toMillis(), TimeUnit.MILLISECONDS, listener);
        }
        return listener;
    }

    private File getIsolationJar(File workDir) throws IOException {
        File isolationJar = FileUtil.createTempFile("tradefed-isolation", ".jar", workDir);
        boolean res = ResourceUtil.extractResourceWithAltAsFile("/tradefed-isolation.jar", "/com/android/tradefed/isolation/tradefed-isolation_deploy.jar", isolationJar);
        if (!res) {
            FileUtil.deleteFile(isolationJar);
            throw new RuntimeException("/tradefed-isolation.jar not found.");
        }
        return isolationJar;
    }
}

