/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.MultiLineReceiver;
import com.android.tradefed.log.LogUtil;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NativeBenchmarkTestParser
extends MultiLineReceiver {
    private static final String FLOAT_STRING = "\\s*(.*)\\s*";
    private static final String COMPLETE_STRING = String.format("Time per iteration min:%savg:%smax:%s", "\\s*(.*)\\s*", "\\s*(.*)\\s*", "\\s*(.*)\\s*");
    private static final Pattern COMPLETE_PATTERN = Pattern.compile(COMPLETE_STRING);
    private final String mTestRunName;
    private boolean mIsCanceled = false;
    private double mMinOpTime = 0.0;
    private double mAvgOpTime = 0.0;
    private double mMaxOpTime = 0.0;

    public NativeBenchmarkTestParser(String runName) {
        this.mTestRunName = runName;
    }

    @Override
    public void processNewLines(String[] lines) {
        for (String line : lines) {
            this.parseLine(line);
        }
    }

    private void parseLine(String line) {
        LogUtil.CLog.d(line);
        Matcher matcher = COMPLETE_PATTERN.matcher(line);
        if (matcher.find()) {
            LogUtil.CLog.i("Found result for benchmark %s: %s", this.getRunName(), line);
            this.mMinOpTime = this.parseDoubleValue(line, matcher.group(1));
            this.mAvgOpTime = this.parseDoubleValue(line, matcher.group(2));
            this.mMaxOpTime = this.parseDoubleValue(line, matcher.group(3));
        }
    }

    private double parseDoubleValue(String line, String valueString) {
        try {
            return Double.parseDouble(valueString);
        }
        catch (NumberFormatException numberFormatException) {
            LogUtil.CLog.w("Value was not a double (%s), trying for scientfic", line);
            DecimalFormat format = new DecimalFormat("0.0E0");
            try {
                Number num = format.parse(valueString);
                return num.doubleValue();
            }
            catch (ParseException e) {
                LogUtil.CLog.e("Could not parse double value in (%s)", line);
                return 0.0;
            }
        }
    }

    @Override
    public boolean isCancelled() {
        return this.mIsCanceled;
    }

    public String getRunName() {
        return this.mTestRunName;
    }

    public double getAvgOperationTime() {
        return this.mAvgOpTime;
    }

    public double getMinOperationTime() {
        return this.mMinOpTime;
    }

    public double getMaxOperationTime() {
        return this.mMaxOpTime;
    }
}

