/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.command.CommandFileParser;
import com.android.tradefed.command.CommandScheduler;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.SandboxConfigurationFactory;
import com.android.tradefed.config.proxy.TradefedDelegator;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ITestLifeCycleReceiver;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.sandbox.ISandbox;
import com.android.tradefed.sandbox.TradefedSandbox;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.QuotationAwareTokenizer;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.executor.ParallelDeviceExecutor;
import com.android.tradefed.util.keystore.DryRunKeyStore;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class NoisyDryRunTest
implements IRemoteTest {
    private static final long SLEEP_INTERVAL_MILLI_SEC = 5000L;
    @Option(name="cmdfile", description="The cmdfile to run noisy dry run on.")
    private File mCmdfile = null;
    @Option(name="timeout", description="The timeout to wait cmd file be ready.", isTimeVal=true)
    private long mTimeoutMilliSec = 0L;

    @Override
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        List<CommandFileParser.CommandLine> commands = this.testCommandFile(listener, this.mCmdfile);
        if (commands != null) {
            this.testCommandLines(listener, commands);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CommandFileParser.CommandLine> testCommandFile(ITestInvocationListener listener, File file2) {
        listener.testRunStarted(NoisyDryRunTest.class.getCanonicalName() + "_parseFile", 1);
        TestDescription parseFileTest = new TestDescription(NoisyDryRunTest.class.getCanonicalName(), "parseFile");
        listener.testStarted(parseFileTest);
        CommandFileParser parser = new CommandFileParser();
        try {
            CloseableTraceScope ignored = new CloseableTraceScope("parseCommandFile");
            try {
                this.checkFileWithTimeout(file2);
                List<CommandFileParser.CommandLine> list2 = parser.parseFile(file2);
                ignored.close();
                return list2;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (ConfigurationException | IOException e) {
                    listener.testFailed(parseFileTest, StreamUtil.getStackTrace(e));
                    List<CommandFileParser.CommandLine> list3 = null;
                    return list3;
                }
            }
        }
        finally {
            listener.testEnded(parseFileTest, new HashMap<String, MetricMeasurement.Metric>());
            listener.testRunEnded(0L, new HashMap<String, MetricMeasurement.Metric>());
        }
    }

    void checkFileWithTimeout(File file2) throws IOException {
        long timeout = this.currentTimeMillis() + this.mTimeoutMilliSec;
        boolean canRead = false;
        while (!(canRead = this.checkFile(file2)) && this.currentTimeMillis() < timeout) {
            LogUtil.CLog.w("Can not read %s, wait and recheck.", file2.getAbsoluteFile());
            this.sleep();
        }
        if (!canRead) {
            throw new IOException(String.format("Can not read %s.", file2.getAbsoluteFile()));
        }
    }

    private boolean checkFile(File file2) {
        if (!file2.exists()) {
            LogUtil.CLog.w("%s doesn't exist.", file2.getAbsoluteFile());
            return false;
        }
        if (!file2.canRead()) {
            LogUtil.CLog.w("No read access to %s.", file2.getAbsoluteFile());
            return false;
        }
        try {
            FileUtil.readStringFromFile(file2);
        }
        catch (IOException e) {
            LogUtil.CLog.w("Fail to read %s.", file2.getAbsoluteFile());
            return false;
        }
        return true;
    }

    long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    void sleep() {
        RunUtil.getDefault().sleep(5000L);
    }

    private void testCommandLines(ITestInvocationListener listener, List<CommandFileParser.CommandLine> commands) {
        listener.testRunStarted(NoisyDryRunTest.class.getCanonicalName() + "_parseCommands", commands.size());
        StoreAndForwardTestCases forwarder = new StoreAndForwardTestCases(listener);
        ParallelDeviceExecutor executor = new ParallelDeviceExecutor(Math.min(20, commands.size()));
        ArrayList callableTasks = new ArrayList();
        int i = 0;
        while (i < commands.size()) {
            int j = i++;
            Callable<Boolean> callableTask = () -> {
                String[] args = ((CommandFileParser.CommandLine)commands.get(j)).asArray();
                this.parseOneConfig(forwarder, args, j);
                return true;
            };
            callableTasks.add(callableTask);
        }
        executor.invokeAll(callableTasks, 0L, TimeUnit.HOURS);
        listener.testRunEnded(0L, new HashMap<String, MetricMeasurement.Metric>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseOneConfig(ITestLifeCycleReceiver listener, String[] args, int i) {
        TestDescription parseCmdTest = new TestDescription(NoisyDryRunTest.class.getCanonicalName(), "parseCommand" + i);
        try (CloseableTraceScope ignored = new CloseableTraceScope(parseCmdTest.toString());){
            listener.testStarted(parseCmdTest);
            String cmdLine = QuotationAwareTokenizer.combineTokens(args);
            try {
                TradefedDelegator delegator = CommandScheduler.checkDelegation(args);
                if (delegator.shouldUseDelegation()) {
                    return;
                }
                if (cmdLine.contains("--use-sandbox")) {
                    this.testSandboxCommand(args);
                } else {
                    IConfiguration config = ConfigurationFactory.getInstance().createConfigurationFromArgs(args, null, new DryRunKeyStore());
                    config.validateOptions();
                }
            }
            catch (ConfigurationException e) {
                String errorMessage = String.format("Failed to parse command line: %s.", cmdLine);
                LogUtil.CLog.e(errorMessage);
                LogUtil.CLog.e(e);
                listener.testFailed(parseCmdTest, String.format("%s\n%s", errorMessage, StreamUtil.getStackTrace(e)));
            }
            finally {
                listener.testEnded(parseCmdTest, new HashMap<String, MetricMeasurement.Metric>());
            }
        }
    }

    public void testSandboxCommand(String[] args) throws ConfigurationException {
        File globalConfig = null;
        try {
            globalConfig = FileUtil.createTempFile("noisy_dry_run_global_config", ".xml");
            FileUtil.writeToFile("<configuration></configuration>", globalConfig);
            IConfiguration config = SandboxConfigurationFactory.getInstance().createConfigurationFromArgs(args, new DryRunKeyStore(), this.createSandbox(), this.createRunUtil(), globalConfig, true);
            config.validateOptions();
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        finally {
            FileUtil.deleteFile(globalConfig);
        }
    }

    IRunUtil createRunUtil() {
        return new RunUtil();
    }

    ISandbox createSandbox() {
        return new TradefedSandbox();
    }

    private class StoreAndForwardTestCases
    implements ITestLifeCycleReceiver {
        private final ITestInvocationListener mForwarder;
        private Map<TestDescription, String> mTestTracker = Collections.synchronizedMap(new HashMap());

        public StoreAndForwardTestCases(ITestInvocationListener forwarder) {
            this.mForwarder = forwarder;
        }

        @Override
        public void testStarted(TestDescription test) {
            this.mTestTracker.put(test, null);
        }

        @Override
        public void testFailed(TestDescription test, String trace) {
            this.mTestTracker.put(test, trace);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void testEnded(TestDescription test, HashMap<String, MetricMeasurement.Metric> metrics) {
            ITestInvocationListener iTestInvocationListener = this.mForwarder;
            synchronized (iTestInvocationListener) {
                this.mForwarder.testStarted(test);
                if (this.mTestTracker.get(test) != null) {
                    this.mForwarder.testFailed(test, this.mTestTracker.get(test));
                }
                this.mForwarder.testEnded(test, metrics);
            }
            this.mTestTracker.remove(test);
        }
    }
}

