/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.Log;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IShardableTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class StubTest
implements IShardableTest,
IConfigurationReceiver,
IAbiReceiver {
    public static final String DNAE_MESSAGE = "StubTest DeviceNotAvailableException";
    @Option(name="num-shards", description="Shard this test into given number of separately runnable chunks")
    private int mNumShards = 1;
    @Option(name="test-throw-runtime", description="test option to force the stub test to throw a runtime exception.Used for testing.")
    private boolean mThrowRuntime = false;
    @Option(name="test-throw-not-available", description="test option to force the stub test to throw a DeviceNotAvailable exception. Used for testing.")
    private boolean mThrowNotAvailable = false;
    @Option(name="test-throw-unresponsive", description="test option to force the stub test to throw a DeviceUnresponsive exception. Used for testing.")
    private boolean mThrowUnresponsive = false;
    @Option(name="run-a-test", description="Test option to make the stub test trigger some test callbacks on the invocation.")
    private boolean mRunTest = false;
    private IConfiguration mConfig;
    private IAbi mAbi;

    public boolean getRunTest() {
        return this.mRunTest;
    }

    @Override
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.mThrowRuntime) {
            throw new RuntimeException("StubTest RuntimeException");
        }
        if (this.mThrowNotAvailable) {
            throw new DeviceNotAvailableException(DNAE_MESSAGE, "serial");
        }
        if (this.mThrowUnresponsive) {
            throw new DeviceUnresponsiveException("StubTest DeviceUnresponsiveException", "serial");
        }
        if (!this.mRunTest) {
            LogUtil.CLog.i("nothing to test!");
        } else {
            listener.testRunStarted("TestStub", 1);
            TestDescription testId = new TestDescription("StubTest", "StubMethod");
            listener.testStarted(testId);
            listener.testEnded(testId, (HashMap<String, MetricMeasurement.Metric>)new LinkedHashMap<String, MetricMeasurement.Metric>());
            listener.testRunEnded(500L, (HashMap<String, MetricMeasurement.Metric>)new LinkedHashMap<String, MetricMeasurement.Metric>());
        }
    }

    @Override
    public Collection<IRemoteTest> split() {
        if (this.mNumShards > 1) {
            ArrayList<IRemoteTest> shards = new ArrayList<IRemoteTest>(this.mNumShards);
            for (int i = 0; i < this.mNumShards; ++i) {
                shards.add(new StubTest());
            }
            LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, "splitting into %d shards", this.mNumShards);
            return shards;
        }
        return null;
    }

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.mConfig = configuration;
    }

    public IConfiguration getConfiguration() {
        return this.mConfig;
    }

    @Override
    public void setAbi(IAbi abi) {
        this.mAbi = abi;
    }

    @Override
    public IAbi getAbi() {
        return this.mAbi;
    }

    public String toString() {
        return super.toString() + this.mAbi;
    }
}

