/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IFolderBuildInfo;
import com.android.tradefed.config.GlobalConfiguration;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.proxy.AutomatedReporters;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.result.proto.StreamProtoReceiver;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.StringEscapeUtils;
import com.android.tradefed.util.SubprocessExceptionParser;
import com.android.tradefed.util.SubprocessTestResultsParser;
import com.android.tradefed.util.SystemUtil;
import com.android.tradefed.util.TimeUtil;
import com.android.tradefed.util.UniqueMultiMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;

public abstract class SubprocessTfLauncher
implements IBuildReceiver,
IInvocationContextReceiver,
IRemoteTest,
IConfigurationReceiver {
    public static final String SUBPROCESS_TAG_NAME = "subprocess";
    public static final String PARENT_PROC_TAG_NAME = "parentprocess";
    public static final String ANDROID_SERIAL_VAR = "ANDROID_SERIAL";
    @Option(name="max-run-time", description="The maximum time to allow for a TF test run.", isTimeVal=true)
    private long mMaxTfRunTime = 1200000L;
    @Option(name="remote-debug", description="Start the TF java process in remote debug mode.")
    private boolean mRemoteDebug = false;
    @Option(name="config-name", description="The config that runs the TF tests")
    private String mConfigName;
    @Option(name="local-sharding-mode", description="If sharding is requested, allow the launcher to run with local sharding.")
    private boolean mLocalShardingMode = false;
    @Option(name="use-event-streaming", description="Use a socket to receive results as theyarrived instead of using a temporary file and parsing at the end.")
    private boolean mEventStreaming = true;
    @Option(name="use-proto-reporting", description="Use a proto result reporter for the results from the subprocess.")
    private boolean mUseProtoReporting = true;
    @Option(name="sub-global-config", description="The global config name to pass to thesub process, can be local or from jar resources. Be careful of conflicts with parent process.")
    private String mGlobalConfig = null;
    @Option(name="inject-invocation-data", description="Pass the invocation-data to the subprocess if enabled.")
    private boolean mInjectInvocationData = true;
    @Option(name="ignore-test-log", description="Only rely on logAssociation for logs.")
    private boolean mIgnoreTestLog = true;
    @Option(name="disable-stderr-test", description="Whether or not to disable the stderr validation check.")
    private boolean mDisableStderrTest = false;
    @Option(name="disable-add-opens", description="Whether or not to add the java add-opens flags")
    private boolean mDisableJavaOpens = false;
    @Option(name="add-opens", description="Whether or not to add the java add-opens flags")
    private Set<String> mAddOpens = new LinkedHashSet<String>(Arrays.asList("java.base/java.nio", "java.base/sun.reflect.annotation", "java.base/java.io"));
    @Option(name="sub-params", description="Parameters to feed the subprocess.")
    private List<String> mSubParams = new ArrayList<String>();
    private String mFilteredGlobalConfig = null;
    private static final List<String> TRADEFED_JARS = new ArrayList<String>(Arrays.asList("loganalysis.jar", "loganalysis-tests.jar", "tradefed.jar", "tradefed-test-framework.jar", "tradefed-tests.jar", "tools-common-prebuilt.jar", "tf-prod-tests.jar", "tf-prod-metatests.jar", "tradefed-contrib.jar", "tf-contrib-tests.jar", "google-tf-prod-tests.jar", "google-tf-prod-metatests.jar", "google-tradefed.jar", "google-tradefed-tests.jar", "google-tradefed-contrib.jar", "jack-jacoco-reporter.jar", "emmalib.jar"));
    private static final long EVENT_THREAD_JOIN_TIMEOUT_MS = 30000L;
    protected IRunUtil mRunUtil = new RunUtil();
    protected IBuildInfo mBuildInfo = null;
    protected File mTmpDir = null;
    protected List<String> mCmdArgs = null;
    protected String mRootDir = null;
    protected IConfiguration mConfig;
    private IInvocationContext mContext;

    @Override
    public void setInvocationContext(IInvocationContext invocationContext) {
        this.mContext = invocationContext;
    }

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.mConfig = configuration;
    }

    protected void setProtoReporting(boolean protoReporting) {
        this.mUseProtoReporting = protoReporting;
    }

    protected void setEventStreaming(boolean eventStreaming) {
        this.mEventStreaming = eventStreaming;
    }

    protected void setRunUtil(IRunUtil runUtil) {
        this.mRunUtil = runUtil;
    }

    protected IRunUtil getRunUtil() {
        return this.mRunUtil;
    }

    protected void preRun() {
        Assert.assertNotNull(this.mBuildInfo);
        Assert.assertNotNull(this.mConfigName);
        IFolderBuildInfo tfBuild = (IFolderBuildInfo)this.mBuildInfo;
        File rootDirFile = tfBuild.getRootDir();
        this.mRootDir = rootDirFile.getAbsolutePath();
        String jarClasspath = "";
        ArrayList<String> paths = new ArrayList<String>();
        for (String string : TRADEFED_JARS) {
            File f = FileUtil.findFile(rootDirFile, string);
            if (f == null || !f.exists()) continue;
            paths.add(f.getAbsolutePath());
        }
        jarClasspath = String.join((CharSequence)":", paths);
        this.mCmdArgs = new ArrayList<String>();
        this.mCmdArgs.add(this.getJava());
        try {
            this.mTmpDir = FileUtil.createTempDir("subprocess-" + tfBuild.getBuildId());
            this.mCmdArgs.add(String.format("-Djava.io.tmpdir=%s", this.mTmpDir.getAbsolutePath()));
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
            throw new RuntimeException(e);
        }
        this.addJavaArguments(this.mCmdArgs);
        if (this.mRemoteDebug) {
            this.mCmdArgs.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=10088");
        }
        if (!this.mDisableJavaOpens) {
            for (String string : this.mAddOpens) {
                this.mCmdArgs.add("--add-opens=" + string + "=ALL-UNNAMED");
            }
        }
        this.mCmdArgs.add("-cp");
        this.mCmdArgs.add(jarClasspath);
        this.mCmdArgs.add("com.android.tradefed.command.CommandRunner");
        this.mCmdArgs.add(this.mConfigName);
        Integer shardCount = this.mConfig.getCommandOptions().getShardCount();
        if (this.mLocalShardingMode && shardCount != null & shardCount > 1) {
            this.mCmdArgs.add("--shard-count");
            this.mCmdArgs.add(Integer.toString(shardCount));
        }
        if (!this.mSubParams.isEmpty()) {
            this.mCmdArgs.addAll(StringEscapeUtils.paramsToArgs(this.mSubParams));
        }
        this.mRunUtil.unsetEnvVariable("TF_GLOBAL_CONFIG");
        this.mRunUtil.unsetEnvVariable("TF_GLOBAL_CONFIG_SERVER_CONFIG");
        this.mRunUtil.unsetEnvVariable(ANDROID_SERIAL_VAR);
        this.mRunUtil.unsetEnvVariable("START_FEATURE_SERVER");
        this.mRunUtil.unsetEnvVariable("DELEGATED_MODE");
        for (String variable : AutomatedReporters.REPORTER_MAPPING) {
            this.mRunUtil.unsetEnvVariable(variable);
        }
        if (this.mGlobalConfig == null) {
            try {
                File file2 = GlobalConfiguration.getInstance().cloneConfigWithFilter(new String[0]);
                this.mGlobalConfig = this.mFilteredGlobalConfig = file2.getAbsolutePath();
            }
            catch (IOException iOException) {
                LogUtil.CLog.e("Failed to create filtered global configuration");
                LogUtil.CLog.e(iOException);
            }
        }
        if (this.mGlobalConfig != null) {
            this.mRunUtil.setEnvVariablePriority(IRunUtil.EnvPriority.SET);
            this.mRunUtil.setEnvVariable("TF_GLOBAL_CONFIG", this.mGlobalConfig);
        }
    }

    protected void addJavaArguments(List<String> args) {
    }

    protected void postRun(ITestInvocationListener listener, boolean exception, long elapsedTime) {
    }

    private void addInvocationData() {
        if (!this.mInjectInvocationData) {
            return;
        }
        UniqueMultiMap<String, String> data = this.mConfig.getCommandOptions().getInvocationData();
        for (String key : data.keySet()) {
            for (String value : data.get(key)) {
                this.mCmdArgs.add("--invocation-data");
                this.mCmdArgs.add(key);
                this.mCmdArgs.add(value);
            }
        }
        this.mCmdArgs.add("--invocation-data");
        this.mCmdArgs.add(SUBPROCESS_TAG_NAME);
        this.mCmdArgs.add("true");
        this.mBuildInfo.addBuildAttribute(PARENT_PROC_TAG_NAME, "true");
    }

    @Override
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        long elapsedTime;
        boolean exception;
        FileOutputStream stderr;
        FileOutputStream stdout;
        StreamProtoReceiver protoReceiver;
        SubprocessTestResultsParser eventParser;
        File eventFile;
        File stderrFile;
        File stdoutFile;
        block24: {
            this.preRun();
            this.addInvocationData();
            stdoutFile = null;
            stderrFile = null;
            eventFile = null;
            eventParser = null;
            protoReceiver = null;
            stdout = null;
            stderr = null;
            exception = false;
            long startTime = 0L;
            elapsedTime = -1L;
            try {
                stdoutFile = FileUtil.createTempFile("stdout_subprocess_", ".log");
                stderrFile = FileUtil.createTempFile("stderr_subprocess_", ".log");
                stderr = new FileOutputStream(stderrFile);
                stdout = new FileOutputStream(stdoutFile);
                if (this.mUseProtoReporting) {
                    protoReceiver = new StreamProtoReceiver(listener, this.mContext, false, false, true, "subprocess-", false);
                    this.mCmdArgs.add("--proto-report-port");
                    this.mCmdArgs.add(Integer.toString(protoReceiver.getSocketServerPort()));
                } else {
                    eventParser = new SubprocessTestResultsParser(listener, this.mEventStreaming, this.mContext);
                    if (this.mEventStreaming) {
                        this.mCmdArgs.add("--subprocess-report-port");
                        this.mCmdArgs.add(Integer.toString(eventParser.getSocketServerPort()));
                    } else {
                        eventFile = FileUtil.createTempFile("event_subprocess_", ".log");
                        this.mCmdArgs.add("--subprocess-report-file");
                        this.mCmdArgs.add(eventFile.getAbsolutePath());
                    }
                    eventParser.setIgnoreTestLog(this.mIgnoreTestLog);
                }
                startTime = System.currentTimeMillis();
                CommandResult result = this.mRunUtil.runTimedCmd(this.mMaxTfRunTime, stdout, stderr, this.mCmdArgs.toArray(new String[0]));
                if (eventParser != null) {
                    if (eventParser.getStartTime() != null) {
                        startTime = eventParser.getStartTime();
                    }
                    elapsedTime = System.currentTimeMillis() - startTime;
                    if (!eventParser.joinReceiver(30000L)) {
                        elapsedTime = -1L;
                        throw new RuntimeException(String.format("Event receiver thread did not complete:\n%s", FileUtil.readStringFromFile(stderrFile)));
                    }
                } else if (protoReceiver != null) {
                    if (!protoReceiver.joinReceiver(30000L)) {
                        elapsedTime = -1L;
                        throw new RuntimeException(String.format("Event receiver thread did not complete:\n%s", FileUtil.readStringFromFile(stderrFile)));
                    }
                    protoReceiver.completeModuleEvents();
                }
                if (result.getStatus().equals((Object)CommandStatus.SUCCESS)) {
                    LogUtil.CLog.d("Successfully ran TF tests for build %s", this.mBuildInfo.getBuildId());
                    this.testCleanStdErr(stderrFile, listener);
                    break block24;
                }
                LogUtil.CLog.w("Failed ran TF tests for build %s, status %s", new Object[]{this.mBuildInfo.getBuildId(), result.getStatus()});
                LogUtil.CLog.v("TF tests output:\nstdout:\n%s\nstderr:\n%s", result.getStdout(), result.getStderr());
                exception = true;
                String errMessage = null;
                if (result.getStatus().equals((Object)CommandStatus.TIMED_OUT)) {
                    errMessage = String.format("Timeout after %s", TimeUtil.formatElapsedTime(this.mMaxTfRunTime));
                    throw new HarnessRuntimeException(String.format("%s Tests subprocess failed due to:\n%s\n", this.mConfigName, errMessage), InfraErrorIdentifier.INVOCATION_TIMEOUT);
                }
                if (eventParser == null || eventParser.reportedInvocationFailed()) break block24;
                SubprocessExceptionParser.handleStderrException(result);
            }
            catch (IOException e) {
                try {
                    exception = true;
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    StreamUtil.close(stdout);
                    StreamUtil.close(stderr);
                    this.logAndCleanFile(stdoutFile, listener);
                    this.logAndCleanFile(stderrFile, listener);
                    if (eventFile != null) {
                        eventParser.parseFile(eventFile);
                        this.logAndCleanFile(eventFile, listener);
                    }
                    StreamUtil.close(eventParser);
                    StreamUtil.close(protoReceiver);
                    if (this.mGlobalConfig != null) {
                        this.logAndCleanFile(new File(this.mGlobalConfig), listener);
                    }
                    this.postRun(listener, exception, elapsedTime);
                    if (this.mTmpDir != null) {
                        FileUtil.recursiveDelete(this.mTmpDir);
                    }
                    if (this.mFilteredGlobalConfig != null) {
                        FileUtil.deleteFile(new File(this.mFilteredGlobalConfig));
                    }
                    throw throwable;
                }
            }
        }
        StreamUtil.close(stdout);
        StreamUtil.close(stderr);
        this.logAndCleanFile(stdoutFile, listener);
        this.logAndCleanFile(stderrFile, listener);
        if (eventFile != null) {
            eventParser.parseFile(eventFile);
            this.logAndCleanFile(eventFile, listener);
        }
        StreamUtil.close(eventParser);
        StreamUtil.close(protoReceiver);
        if (this.mGlobalConfig != null) {
            this.logAndCleanFile(new File(this.mGlobalConfig), listener);
        }
        this.postRun(listener, exception, elapsedTime);
        if (this.mTmpDir != null) {
            FileUtil.recursiveDelete(this.mTmpDir);
        }
        if (this.mFilteredGlobalConfig != null) {
            FileUtil.deleteFile(new File(this.mFilteredGlobalConfig));
        }
    }

    private void logAndCleanFile(File fileToExport, ITestInvocationListener listener) {
        if (fileToExport == null) {
            return;
        }
        try (FileInputStreamSource inputStream = new FileInputStreamSource(fileToExport);){
            listener.testLog(fileToExport.getName(), LogDataType.TEXT, inputStream);
        }
        FileUtil.deleteFile(fileToExport);
    }

    @Override
    public void setBuild(IBuildInfo buildInfo) {
        this.mBuildInfo = buildInfo;
    }

    private void testCleanStdErr(File stdErrFile, ITestInvocationListener listener) throws IOException {
        if (this.mDisableStderrTest) {
            return;
        }
        listener.testRunStarted("StdErr", 1);
        TestDescription tid = new TestDescription("stderr-test", "checkIsEmpty");
        listener.testStarted(tid);
        if (!FileUtil.readStringFromFile(stdErrFile).isEmpty()) {
            String trace = String.format("Found some output in stderr:\n%s", FileUtil.readStringFromFile(stdErrFile));
            listener.testFailed(tid, FailureDescription.create(trace));
        }
        listener.testEnded(tid, new HashMap<String, MetricMeasurement.Metric>());
        listener.testRunEnded(0L, new HashMap<String, MetricMeasurement.Metric>());
    }

    protected String getJava() {
        return SystemUtil.getRunningJavaBinaryPath().getAbsolutePath();
    }
}

