/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.util.TimeUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class TestTimeoutEnforcer
extends ResultForwarder {
    public static final String TEST_CASE_TIMEOUT_OPTION = "test-case-timeout";
    public static final String TEST_CASE_TIMEOUT_DESCRIPTION = "The timeout that will be applied to each test case of the run.";
    private long mPerTestCaseTimeoutMs = 0L;
    private Map<TestDescription, Long> mTrackingStartTime = new HashMap<TestDescription, Long>();

    public TestTimeoutEnforcer(long perTestCaseTimeout, TimeUnit unit, ITestInvocationListener ... listeners) {
        super(listeners);
        this.mPerTestCaseTimeoutMs = unit.toMillis(perTestCaseTimeout);
    }

    public TestTimeoutEnforcer(long perTestCaseTimeout, TimeUnit unit, List<ITestInvocationListener> listeners) {
        super(listeners);
        this.mPerTestCaseTimeoutMs = unit.toMillis(perTestCaseTimeout);
    }

    @Override
    public void testStarted(TestDescription test, long startTime) {
        super.testStarted(test, startTime);
        if (this.mPerTestCaseTimeoutMs != 0L) {
            this.mTrackingStartTime.put(test, startTime);
        }
    }

    @Override
    public void testFailed(TestDescription test, String trace) {
        super.testFailed(test, trace);
        this.mTrackingStartTime.remove(test);
    }

    @Override
    public void testFailed(TestDescription test, FailureDescription failure) {
        super.testFailed(test, failure);
        this.mTrackingStartTime.remove(test);
    }

    @Override
    public void testIgnored(TestDescription test) {
        super.testIgnored(test);
        this.mTrackingStartTime.remove(test);
    }

    @Override
    public void testAssumptionFailure(TestDescription test, FailureDescription failure) {
        super.testAssumptionFailure(test, failure);
        this.mTrackingStartTime.remove(test);
    }

    @Override
    public void testAssumptionFailure(TestDescription test, String trace) {
        super.testAssumptionFailure(test, trace);
        this.mTrackingStartTime.remove(test);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testEnded(TestDescription test, long endTime, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        try {
            if (this.mPerTestCaseTimeoutMs == 0L) {
                return;
            }
            Long startTime = this.mTrackingStartTime.get(test);
            if (startTime == null) {
                return;
            }
            long elapsedTime = endTime - startTime;
            if (elapsedTime > this.mPerTestCaseTimeoutMs) {
                FailureDescription failure = FailureDescription.create(String.format("%s took %s while timeout is %s", test, TimeUtil.formatElapsedTime(elapsedTime), TimeUtil.formatElapsedTime(this.mPerTestCaseTimeoutMs)), TestRecordProto.FailureStatus.TIMED_OUT);
                super.testFailed(test, failure);
            }
        }
        catch (RuntimeException ignore) {
            LogUtil.CLog.e("Exception while attempting to apply timeout.");
            LogUtil.CLog.e(ignore);
        }
        finally {
            this.mTrackingStartTime.remove(test);
            super.testEnded(test, endTime, testMetrics);
        }
    }
}

