/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.build.IFolderBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.testtype.SubprocessTfLauncher;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.HprofAllocSiteParser;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.SystemUtil;
import com.android.tradefed.util.TarUtil;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class TfTestLauncher
extends SubprocessTfLauncher {
    @Option(name="jacoco-code-coverage", description="Enable jacoco code coverage on the java sub process. Run will be slightly slower because of the overhead.")
    private boolean mEnableCoverage = false;
    @Option(name="include-coverage", description="Patterns to include in the code coverage.")
    private Set<String> mIncludeCoverage = new LinkedHashSet<String>();
    @Option(name="exclude-coverage", description="Patterns to exclude in the code coverage.")
    private Set<String> mExcludeCoverage = new LinkedHashSet<String>();
    @Option(name="hprof-heap-memory", description="Enable hprof agent while running the javasub process. Run will be slightly slower because of the overhead.")
    private boolean mEnableHprof = false;
    @Option(name="ant-config-res", description="The name of the ant resource configuration to transform the results in readable format.")
    private String mAntConfigResource = "/jacoco/ant-tf-coverage.xml";
    @Option(name="sub-branch", description="The branch to be provided to the sub invocation, if null, the branch in build info will be used.")
    private String mSubBranch = null;
    @Option(name="sub-build-flavor", description="The build flavor to be provided to the sub invocation, if null, the build flavor in build info will be used.")
    private String mSubBuildFlavor = null;
    @Option(name="sub-build-id", description="The build id that the sub invocation will try to use in case where it needs its own device.")
    private String mSubBuildId = null;
    @Option(name="use-virtual-device", description="Flag if the subprocess is going to need to instantiate a virtual device to run.")
    private boolean mUseVirtualDevice = false;
    @Option(name="sub-apk-path", description="The name of all the Apks that needs to be installed by the subprocess invocation. Apk need to be inside the downloaded zip. Can be repeated.")
    private List<String> mSubApkPath = new ArrayList<String>();
    @Option(name="skip-temp-dir-check", description="Whether or not to skip temp dir check.")
    private boolean mSkipTmpDirCheck = false;
    private static final String[] EXPECTED_TMP_FILE_PATTERNS = new String[]{"inv_.*", "tradefed_global_log_.*", "lc_cache", "stage-android-build-api"};
    private File mHprofFile = null;

    @Override
    protected void addJavaArguments(List<String> args) {
        super.addJavaArguments(args);
        try {
            if (this.mEnableHprof) {
                this.mHprofFile = FileUtil.createTempFile("java.hprof", ".txt");
                String hprofAgent = String.format("-agentlib:hprof=heap=sites,cutoff=0.01,depth=16,verbose=n,file=%s", this.mHprofFile.getAbsolutePath());
                args.add(hprofAgent);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void preRun() {
        super.preRun();
        if (!this.mUseVirtualDevice) {
            this.mCmdArgs.add("-n");
        } else {
            this.mCmdArgs.add("--log-level");
            this.mCmdArgs.add("VERBOSE");
            this.mCmdArgs.add("--log-level-display");
            this.mCmdArgs.add("VERBOSE");
        }
        this.mCmdArgs.add("--test-tag");
        this.mCmdArgs.add(this.mBuildInfo.getTestTag());
        this.mCmdArgs.add("--build-id");
        if (this.mSubBuildId != null) {
            this.mCmdArgs.add(this.mSubBuildId);
        } else {
            this.mCmdArgs.add(this.mBuildInfo.getBuildId());
        }
        this.mCmdArgs.add("--branch");
        if (this.mSubBranch != null) {
            this.mCmdArgs.add(this.mSubBranch);
        } else if (this.mBuildInfo.getBuildBranch() != null) {
            this.mCmdArgs.add(this.mBuildInfo.getBuildBranch());
        } else {
            throw new RuntimeException("Branch option is required for the sub invocation.");
        }
        this.mCmdArgs.add("--build-flavor");
        if (this.mSubBuildFlavor != null) {
            this.mCmdArgs.add(this.mSubBuildFlavor);
        } else if (this.mBuildInfo.getBuildFlavor() != null) {
            this.mCmdArgs.add(this.mBuildInfo.getBuildFlavor());
        } else {
            throw new RuntimeException("Build flavor option is required for the sub invocation.");
        }
        for (String apk : this.mSubApkPath) {
            this.mCmdArgs.add("--apk-path");
            String apkPath = String.format("%s%s%s", ((IFolderBuildInfo)this.mBuildInfo).getRootDir().getAbsolutePath(), File.separator, apk);
            this.mCmdArgs.add(apkPath);
        }
        this.getRunUtil().unsetEnvVariable(SystemUtil.EnvVariable.ANDROID_HOST_OUT_TESTCASES.name());
        this.getRunUtil().unsetEnvVariable(SystemUtil.EnvVariable.ANDROID_TARGET_OUT_TESTCASES.name());
    }

    @Override
    protected void postRun(ITestInvocationListener listener, boolean exception, long elapsedTime) {
        super.postRun(listener, exception, elapsedTime);
        this.reportMetrics(elapsedTime, listener);
        if (this.mEnableHprof) {
            this.logHprofResults(this.mHprofFile, listener);
        }
        if (this.mTmpDir != null) {
            this.testTmpDirClean(this.mTmpDir, listener);
        }
        this.cleanTmpFile();
    }

    @VisibleForTesting
    void cleanTmpFile() {
        FileUtil.deleteFile(this.mHprofFile);
    }

    private void reportMetrics(long elapsedTime, ITestInvocationListener listener) {
        if (elapsedTime == -1L) {
            return;
        }
        listener.testRunStarted("elapsed-time", 1);
        TestDescription tid = new TestDescription("elapsed-time", "run-elapsed-time");
        listener.testStarted(tid);
        HashMap<String, MetricMeasurement.Metric> runMetrics = new HashMap<String, MetricMeasurement.Metric>();
        runMetrics.put("elapsed-time", TfMetricProtoUtil.stringToMetric(Long.toString(elapsedTime)));
        listener.testEnded(tid, runMetrics);
        listener.testRunEnded(0L, runMetrics);
    }

    @VisibleForTesting
    protected void testTmpDirClean(File tmpDir, ITestInvocationListener listener) {
        if (this.mSkipTmpDirCheck) {
            return;
        }
        listener.testRunStarted("temporaryFiles", 1);
        TestDescription tid = new TestDescription("temporary-files", "testIfClean");
        listener.testStarted(tid);
        String[] listFiles = tmpDir.list();
        ArrayList<String> unmatchedFiles = new ArrayList<String>();
        ArrayList<String> patterns = new ArrayList<String>(Arrays.asList(EXPECTED_TMP_FILE_PATTERNS));
        patterns.add(this.mBuildInfo.getBuildBranch());
        for (String file2 : Arrays.asList(listFiles)) {
            boolean matchFound = false;
            for (String pattern : patterns) {
                if (!Pattern.matches(pattern, file2)) continue;
                patterns.remove(pattern);
                matchFound = true;
                break;
            }
            if (matchFound) continue;
            unmatchedFiles.add(file2);
        }
        if (unmatchedFiles.size() > 0) {
            String trace = String.format("Found '%d' unexpected temporary files: %s.\nOnly expected files are: %s. And each should appears only once.", unmatchedFiles.size(), unmatchedFiles, patterns);
            listener.testFailed(tid, FailureDescription.create(trace));
        }
        listener.testEnded(tid, new HashMap<String, MetricMeasurement.Metric>());
        listener.testRunEnded(0L, new HashMap<String, MetricMeasurement.Metric>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logHprofResults(File hprofFile, ITestInvocationListener listener) {
        if (hprofFile == null) {
            LogUtil.CLog.w("Hprof file was null. Skipping parsing.");
            return;
        }
        if (!hprofFile.exists()) {
            LogUtil.CLog.w("Hprof file %s was not found. Skipping parsing.", hprofFile.getAbsolutePath());
            return;
        }
        FileInputStreamSource memory = null;
        File tmpGzip = null;
        try {
            tmpGzip = TarUtil.gzip(hprofFile);
            memory = new FileInputStreamSource(tmpGzip);
            listener.testLog("hprof", LogDataType.GZIP, memory);
            StreamUtil.cancel(memory);
        }
        catch (IOException e) {
            LogUtil.CLog.e(e);
            return;
        }
        finally {
            StreamUtil.cancel(memory);
            FileUtil.deleteFile(tmpGzip);
        }
        FileUtil.deleteFile(tmpGzip);
        HprofAllocSiteParser parser = new HprofAllocSiteParser();
        try {
            Map<String, String> results = parser.parse(hprofFile);
            if (results.isEmpty()) {
                LogUtil.CLog.d("No allocation site found from hprof file");
                return;
            }
            listener.testRunStarted("hprofAllocSites", 1);
            TestDescription tid = new TestDescription("hprof", "allocationSites");
            listener.testStarted(tid);
            listener.testEnded(tid, TfMetricProtoUtil.upgradeConvert(results));
            listener.testRunEnded(0L, new HashMap<String, MetricMeasurement.Metric>());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

