/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IFileEntry;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ITestLifeCycleReceiver;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.testtype.UiAutomatorRunner;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;

public class UiAutomatorTest
implements IRemoteTest,
IDeviceTest,
ITestFilterReceiver {
    private static final String SHELL_EXE_BASE = "/data/local/tmp/";
    private static final String TRACE_ITERATIONS = "traceIterations";
    private static final String TRACE_DEST_DIRECTORY = "destDirectory";
    private ITestDevice mDevice = null;
    private IRemoteAndroidTestRunner mRunner = null;
    protected Collection<ITestLifeCycleReceiver> mListeners = new ArrayList<ITestLifeCycleReceiver>();
    @Option(name="jar-path", description="path to jars containing UI Automator test cases and dependencies; May be repeated. If unspecified will use all jars found in /data/local/tmp/")
    private List<String> mJarPaths = new ArrayList<String>();
    @Option(name="class", description="test class to run, may be repeated; multiple classess will be run in the same order as provided in command line")
    private Set<String> mClasses = new LinkedHashSet<String>();
    @Option(name="sync-time", description="time to allow for initial sync, in ms")
    private long mSyncTime = 0L;
    @Option(name="run-arg", description="Additional test specific arguments to provide.")
    private Map<String, String> mArgMap = new LinkedHashMap<String, String>();
    @Option(name="timeout", description="Aborts the test run if any test takes longer than the specified timeout. For no timeout, set to 0.", isTimeVal=true)
    private long mTestTimeout = 1800000L;
    @Option(name="capture-logs", description="capture bugreport and screenshot as specified.")
    private LoggingOption mLoggingOption = LoggingOption.AFTER_FAILURE;
    @Option(name="runner-path", description="path to uiautomator runner; may be null and default will be used in this case")
    private String mRunnerPath = null;
    @Option(name="on-test-failure", description="sets the action to perform if a test fails")
    private TestFailureAction mFailureAction = TestFailureAction.BUGREPORT_AND_SCREENSHOT;
    @Option(name="ignore-sighup", description="allows uiautomator test to ignore SIGHUP signal")
    private boolean mIgnoreSighup = false;
    @Option(name="run-name", description="the run name to use when reporting test results.")
    private String mRunName = "uiautomator";
    @Option(name="instrumentation", description="the specified test should be driven with instrumentation.jar-path, runner-path, ignore-sighup are ignored when this is set.")
    private boolean mInstrumentation = false;
    @Option(name="package", description="The manifest package name of the UI test package.Only applies when 'instrumentation' option is set.")
    private String mPackage = null;
    @Option(name="runner", description="The instrumentation based test runner class name to use.Only applies when 'instrumentation' option is set.")
    private String mRunnerName = "android.support.test.uiautomator.UiAutomatorInstrumentationTestRunner";
    @Option(name="hidden-api-checks", description="If set to false, the '--no-hidden-api-checks' flag will be passed to the am instrument command. Only works for P or later.")
    private boolean mHiddenApiChecks = true;
    @Option(name="test-api-access", description="If set to false and hidden API checks are enabled, the '--no-test-api-access' flag will be passed to the am instrument command. Only works for R or later.")
    private boolean mTestApiAccess = true;
    @Option(name="isolated-storage", description="If set to false, the '--no-isolated-storage' flag will be passed to the am instrument command. Only works for Q or later.")
    private boolean mIsolatedStorage = true;
    @Option(name="window-animation", description="If set to false, the '--no-window-animation' flag will be passed to the am instrument command. Only works for ICS or later.")
    private boolean mWindowAnimation = true;

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setLoggingOption(LoggingOption loggingOption) {
        this.mLoggingOption = loggingOption;
    }

    @Deprecated
    public void setCaptureLogs(boolean captureLogs) {
        if (captureLogs) {
            this.setLoggingOption(LoggingOption.AFTER_FAILURE);
        } else {
            this.setLoggingOption(LoggingOption.OFF);
        }
    }

    public void setRunName(String runName) {
        this.mRunName = runName;
    }

    @Override
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        this.mListeners.add(listener);
        if (!this.isInstrumentationTest()) {
            this.buildJarPaths();
        }
        this.mRunner = this.createTestRunner();
        if (!this.mClasses.isEmpty()) {
            this.getTestRunner().setClassNames(this.mClasses.toArray(new String[0]));
        }
        this.getTestRunner().setRunName(this.mRunName);
        this.preTestSetup();
        this.getRunUtil().sleep(this.getSyncTime());
        this.getTestRunner().setMaxTimeToOutputResponse(this.mTestTimeout, TimeUnit.MILLISECONDS);
        for (Map.Entry<String, String> entry : this.getTestRunArgMap().entrySet()) {
            this.getTestRunner().addInstrumentationArg(entry.getKey(), entry.getValue());
        }
        if (!this.isInstrumentationTest()) {
            ((UiAutomatorRunner)this.getTestRunner()).setIgnoreSighup(this.mIgnoreSighup);
        }
        if (this.mLoggingOption != LoggingOption.OFF) {
            this.mListeners.add(new LoggingWrapper(listener));
            this.getDevice().runInstrumentationTests(this.getTestRunner(), this.mListeners);
        } else {
            this.getDevice().runInstrumentationTests(this.getTestRunner(), this.mListeners);
        }
        if (this.getTestRunArgMap().containsKey(TRACE_ITERATIONS) && this.getTestRunArgMap().containsKey(TRACE_DEST_DIRECTORY)) {
            try {
                this.logTraceFiles(listener, this.getTestRunArgMap().get(TRACE_DEST_DIRECTORY));
            }
            catch (IOException e) {
                LogUtil.CLog.e(e);
            }
        }
    }

    protected IRemoteAndroidTestRunner createTestRunner() throws DeviceNotAvailableException {
        if (this.isInstrumentationTest()) {
            int apiLevel;
            if (this.mPackage == null) {
                throw new IllegalArgumentException("package name has not been set");
            }
            RemoteAndroidTestRunner runner = new RemoteAndroidTestRunner(this.mPackage, this.mRunnerName, this.getDevice().getIDevice());
            String runOptions = "";
            int n = apiLevel = !this.mHiddenApiChecks || !this.mWindowAnimation ? this.getDevice().getApiLevel() : 0;
            if (!this.mHiddenApiChecks && apiLevel >= 28) {
                runOptions = runOptions + "--no-hidden-api-checks ";
            }
            if (this.mHiddenApiChecks && !this.mTestApiAccess && this.getDevice().checkApiLevelAgainstNextRelease(30)) {
                runOptions = runOptions + "--no-test-api-access ";
            }
            if (!this.mIsolatedStorage && this.getDevice().checkApiLevelAgainstNextRelease(29)) {
                runOptions = runOptions + "--no-isolated-storage ";
            }
            if (!this.mWindowAnimation && apiLevel >= 14) {
                runOptions = runOptions + "--no-window-animation ";
            }
            if (!runOptions.isEmpty()) {
                runner.setRunOptions(runOptions);
            }
            return runner;
        }
        return new UiAutomatorRunner(this.getDevice().getIDevice(), this.getTestJarPaths().toArray(new String[0]), this.mRunnerPath);
    }

    private void buildJarPaths() throws DeviceNotAvailableException {
        if (this.mJarPaths.isEmpty()) {
            String[] rawFiles;
            String rawFileString = this.getDevice().executeShellCommand(String.format("ls %s", SHELL_EXE_BASE));
            for (String rawFile : rawFiles = rawFileString.split("\r?\n")) {
                if (!rawFile.endsWith(".jar")) continue;
                this.mJarPaths.add(rawFile);
            }
            Assert.assertFalse(String.format("could not find jars in %s", SHELL_EXE_BASE), this.mJarPaths.isEmpty());
            LogUtil.CLog.d("built jar paths %s", this.mJarPaths);
        }
    }

    public void addRunArg(String key, String value) {
        this.getTestRunArgMap().put(key, value);
    }

    protected void preTestSetup() throws DeviceNotAvailableException {
        if (!this.isInstrumentationTest()) {
            String runnerPath = ((UiAutomatorRunner)this.getTestRunner()).getRunnerPath();
            if (!this.getDevice().doesFileExist(runnerPath)) {
                throw new RuntimeException("Missing UI Automator runner: " + runnerPath);
            }
            for (String jarPath : this.getTestJarPaths()) {
                if (!jarPath.startsWith("/")) {
                    jarPath = SHELL_EXE_BASE + jarPath;
                }
                if (this.getDevice().doesFileExist(jarPath)) continue;
                throw new RuntimeException("Missing UI Automator test jar on device: " + jarPath);
            }
        }
    }

    protected void onScreenshotAndBugreport(ITestDevice device, ITestInvocationListener listener, String prefix) {
        this.onScreenshotAndBugreport(device, listener, prefix, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onScreenshotAndBugreport(ITestDevice device, ITestInvocationListener listener, String prefix, TestFailureAction overrideAction) {
        if (overrideAction == null) {
            overrideAction = this.mFailureAction;
        }
        if (overrideAction == TestFailureAction.SCREENSHOT || overrideAction == TestFailureAction.BUGREPORT_AND_SCREENSHOT) {
            InputStreamSource screenshot = null;
            try {
                screenshot = device.getScreenshot();
                listener.testLog(prefix + "_screenshot", LogDataType.PNG, screenshot);
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e(e);
            }
            finally {
                StreamUtil.cancel(screenshot);
            }
        }
        if (overrideAction == TestFailureAction.BUGREPORT || overrideAction == TestFailureAction.BUGREPORT_AND_SCREENSHOT) {
            InputStreamSource data = null;
            data = device.getBugreport();
            listener.testLog(prefix + "_bugreport", LogDataType.BUGREPORT, data);
            StreamUtil.cancel(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logTraceFiles(ITestInvocationListener listener, String traceSrcDirectory) throws DeviceNotAvailableException, IOException {
        block15: {
            File tmpDestDir = null;
            try {
                tmpDestDir = FileUtil.createTempDir("atrace");
                IFileEntry traceSrcDir = this.mDevice.getFileEntry(traceSrcDirectory);
                if (traceSrcDir == null) break block15;
                for (IFileEntry testDirectory : traceSrcDir.getChildren(false)) {
                    File testTmpDirectory = new File(tmpDestDir, testDirectory.getName());
                    if (!testTmpDirectory.mkdir()) {
                        throw new IOException("Not able to create the atrace test directory");
                    }
                    for (IFileEntry traceFile : testDirectory.getChildren(false)) {
                        File pulledFile = new File(testTmpDirectory, traceFile.getName());
                        if (this.mDevice.pullFile(traceFile.getFullPath(), pulledFile)) continue;
                        throw new IOException("Not able to pull the trace file from test device");
                    }
                    File atraceZip = ZipUtil.createZip(testTmpDirectory);
                    try (FileInputStreamSource streamSource = new FileInputStreamSource(atraceZip);){
                        listener.testLog(String.format("atrace_%s", testTmpDirectory.getName()), LogDataType.ZIP, streamSource);
                    }
                    finally {
                        if (atraceZip == null) continue;
                        atraceZip.delete();
                    }
                }
            }
            finally {
                if (tmpDestDir != null) {
                    FileUtil.recursiveDelete(tmpDestDir);
                }
            }
        }
    }

    protected IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }

    public long getSyncTime() {
        return this.mSyncTime;
    }

    public void setSyncTime(long syncTime) {
        this.mSyncTime = syncTime;
    }

    public IRemoteAndroidTestRunner getTestRunner() {
        return this.mRunner;
    }

    public List<String> getTestJarPaths() {
        return this.mJarPaths;
    }

    public void setTestJarPaths(List<String> jarPaths) {
        this.mJarPaths = jarPaths;
    }

    public Map<String, String> getTestRunArgMap() {
        return this.mArgMap;
    }

    public void setTestRunArgMap(Map<String, String> runArgMap) {
        this.mArgMap = runArgMap;
    }

    public void addClassName(String className) {
        this.mClasses.add(className);
    }

    public void addClassNames(Collection<String> classNames) {
        this.mClasses.addAll(classNames);
    }

    public boolean isInstrumentationTest() {
        return this.mInstrumentation;
    }

    public void setRunnerName(String runnerName) {
        this.mRunnerName = runnerName;
    }

    public List<String> getClassNames() {
        return new ArrayList<String>(this.mClasses);
    }

    @Override
    public void addIncludeFilter(String filter) {
        this.mClasses.add(filter);
    }

    @Override
    public void addAllIncludeFilters(Set<String> filters) {
        this.mClasses.addAll(filters);
    }

    @Override
    public void addExcludeFilter(String filter) {
        throw new UnsupportedOperationException("Exclude filter is not supported.");
    }

    @Override
    public void addAllExcludeFilters(Set<String> filters) {
        throw new UnsupportedOperationException("Exclude filters is not supported.");
    }

    @Override
    public void clearIncludeFilters() {
        this.mClasses.clear();
    }

    @Override
    public Set<String> getIncludeFilters() {
        return this.mClasses;
    }

    @Override
    public Set<String> getExcludeFilters() {
        throw new UnsupportedOperationException("Exclude filters is not supported.");
    }

    @Override
    public void clearExcludeFilters() {
        throw new UnsupportedOperationException("Exclude filters is not supported.");
    }

    public static enum LoggingOption {
        AFTER_TEST,
        AFTER_FAILURE,
        OFF;

    }

    public static enum TestFailureAction {
        BUGREPORT,
        SCREENSHOT,
        BUGREPORT_AND_SCREENSHOT;

    }

    private class LoggingWrapper
    implements ITestInvocationListener {
        ITestInvocationListener mListener;
        private boolean mLoggedTestFailure = false;
        private boolean mLoggedTestRunFailure = false;

        public LoggingWrapper(ITestInvocationListener listener) {
            this.mListener = listener;
        }

        @Override
        public void testFailed(TestDescription test, String trace) {
            this.captureFailureLog(test);
        }

        @Override
        public void testAssumptionFailure(TestDescription test, String trace) {
            this.captureFailureLog(test);
        }

        private void captureFailureLog(TestDescription test) {
            if (UiAutomatorTest.this.mLoggingOption == LoggingOption.AFTER_FAILURE) {
                UiAutomatorTest.this.onScreenshotAndBugreport(UiAutomatorTest.this.getDevice(), this.mListener, String.format("%s_%s_failure", test.getClassName(), test.getTestName()));
                this.mLoggedTestFailure = true;
            }
        }

        @Override
        public void testRunFailed(String errorMessage) {
            if (UiAutomatorTest.this.mLoggingOption == LoggingOption.AFTER_FAILURE) {
                UiAutomatorTest.this.onScreenshotAndBugreport(UiAutomatorTest.this.getDevice(), this.mListener, "test_run_failure");
                this.mLoggedTestRunFailure = true;
            }
        }

        @Override
        public void testEnded(TestDescription test, HashMap<String, MetricMeasurement.Metric> testMetrics) {
            if (!this.mLoggedTestFailure && UiAutomatorTest.this.mLoggingOption == LoggingOption.AFTER_TEST) {
                UiAutomatorTest.this.onScreenshotAndBugreport(UiAutomatorTest.this.getDevice(), this.mListener, String.format("%s_%s_final", test.getClassName(), test.getTestName()));
            }
        }

        @Override
        public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
            if (!this.mLoggedTestRunFailure && UiAutomatorTest.this.mLoggingOption == LoggingOption.AFTER_TEST) {
                UiAutomatorTest.this.onScreenshotAndBugreport(UiAutomatorTest.this.getDevice(), this.mListener, "test_run_final");
            }
        }
    }
}

