/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.helper.aoa.UsbDevice;
import com.android.helper.aoa.UsbHelper;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.google.common.annotations.VisibleForTesting;

@OptionClass(alias="usb-reset-test")
public class UsbResetTest
implements IRemoteTest {
    @Override
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        try (UsbHelper usb = this.getUsbHelper();){
            String serial = device.getSerialNumber();
            try (UsbDevice usbDevice = usb.getDevice(serial);){
                if (usbDevice == null) {
                    throw new DeviceNotAvailableException(String.format("Device '%s' not found during USB reset.", serial), serial, (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNAVAILABLE);
                }
                LogUtil.CLog.d("Resetting USB port for device '%s'", serial);
                usbDevice.reset();
                this.getRunUtil().sleep(500L);
                TestDeviceState state = device.getDeviceState();
                if (TestDeviceState.RECOVERY.equals((Object)state) || device.isStateBootloaderOrFastbootd()) {
                    LogUtil.CLog.d("Device state is '%s', attempting reboot.", new Object[]{state});
                    device.reboot();
                } else {
                    device.waitForDeviceOnline();
                    device.reboot();
                }
            }
        }
    }

    @VisibleForTesting
    UsbHelper getUsbHelper() {
        return new UsbHelper();
    }

    @VisibleForTesting
    IRunUtil getRunUtil() {
        return RunUtil.getDefault();
    }
}

