/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.binary;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.binary.ExecutableBaseTest;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@OptionClass(alias="executable-target-test")
public class ExecutableTargetTest
extends ExecutableBaseTest
implements IDeviceTest {
    private ITestDevice mDevice = null;
    @Option(name="skip-binary-check", description="Skip the binary check in findBinary().")
    private boolean mSkipBinaryCheck = false;

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public String findBinary(String binary) throws DeviceNotAvailableException {
        if (this.mSkipBinaryCheck) {
            return binary;
        }
        for (String path : binary.split(" ")) {
            if (!this.mDevice.isExecutable(path)) continue;
            return binary;
        }
        return null;
    }

    @Override
    public void runBinary(String binaryPath, ITestInvocationListener listener, TestDescription description) throws DeviceNotAvailableException, IOException {
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        CommandResult result = this.mDevice.executeShellV2Command(binaryPath, this.getTimeoutPerBinaryMs(), TimeUnit.MILLISECONDS);
        this.checkCommandResult(result, listener, description);
    }

    protected void checkCommandResult(CommandResult result, ITestInvocationListener listener, TestDescription description) {
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            String error_message = String.format("binary returned non-zero. Exit code: %d, stderr: %s, stdout: %s", result.getExitCode(), result.getStderr(), result.getStdout());
            listener.testFailed(description, FailureDescription.create(error_message).setFailureStatus(TestRecordProto.FailureStatus.TEST_FAILURE));
        }
    }
}

