/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.coverage;

import com.android.tradefed.config.Option;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class CoverageOptions {
    @Option(name="coverage", description="Collect code coverage for this test run. Note that the build under test must be a coverage build or else this will fail.")
    private boolean mCoverage = false;
    @Option(name="coverage-toolchain", description="The coverage toolchains that were used to compile the coverage build to collect coverage from.")
    private List<Toolchain> mToolchains = new ArrayList<Toolchain>();
    @Option(name="coverage-flush", description="Forces coverage data to be flushed at the end of the test.")
    private boolean mCoverageFlush = false;
    @Option(name="coverage-processes", description="Name of processes to collect coverage data from.")
    private List<String> mCoverageProcesses = new ArrayList<String>();
    @Option(name="merge-coverage", description="Merge coverage measurements before logging.")
    private boolean mMergeCoverage = false;
    @Option(name="reset-coverage-before-test", description="Reset coverage before running each test.")
    private boolean mResetCoverageBeforeTest = true;
    @Option(name="llvm-profdata-path", description="Path to llvm-profdata tool.")
    private File mLlvmProfdataPath = null;
    @Option(name="profraw-filter", description="The regex of profraw files to merge for coverage measurements.  E.g. \"foo.*\\.profraw\".  Default: \".*\\.profraw\"")
    private String mProfrawFilter = ".*\\.profraw";
    @Option(name="pull-timeout", isTimeVal=true, description="Timeout in milliseconds to pull coverage metrics from the device.")
    private long mPullTimeout = 1200000L;
    @Option(name="jacocoagent-path", description="Path to jacocoagent.jar.")
    private File mJaCoCoAgentPath = null;

    public boolean isCoverageEnabled() {
        return this.mCoverage;
    }

    public List<Toolchain> getCoverageToolchains() {
        return ImmutableList.copyOf(this.mToolchains);
    }

    public boolean isCoverageFlushEnabled() {
        return this.mCoverageFlush;
    }

    public List<String> getCoverageProcesses() {
        return ImmutableList.copyOf(this.mCoverageProcesses);
    }

    public boolean shouldMergeCoverage() {
        return this.mMergeCoverage;
    }

    public boolean shouldResetCoverageBeforeTest() {
        return this.mResetCoverageBeforeTest;
    }

    public File getLlvmProfdataPath() {
        return this.mLlvmProfdataPath;
    }

    public String getProfrawFilter() {
        return this.mProfrawFilter;
    }

    public long getPullTimeout() {
        return this.mPullTimeout;
    }

    public File getJaCoCoAgentPath() {
        return this.mJaCoCoAgentPath;
    }

    public static enum Toolchain {
        CLANG,
        GCOV,
        JACOCO,
        GCOV_KERNEL;

    }
}

