/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.host;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class PrettyTestEventLogger
implements ITestInvocationListener {
    private static final String TAG = "TradefedEventsTag";
    private final List<ITestDevice> mDevices;
    private String mTrace = null;

    public PrettyTestEventLogger(List<ITestDevice> devices) {
        this.mDevices = devices;
    }

    @Override
    public void testStarted(TestDescription test) {
        Date date = new Date();
        this.mTrace = null;
        String message2 = String.format("==================== %s STARTED: %s ====================", test.toString(), date.toString());
        LogUtil.CLog.logAndDisplay(Log.LogLevel.DEBUG, "\n" + message2);
        this.logOnAllDevices(message2, new Object[0]);
    }

    @Override
    public void testFailed(TestDescription test, String trace) {
        this.mTrace = trace;
    }

    @Override
    public void testEnded(TestDescription test, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        Date date = new Date();
        String message2 = String.format("==================== %s ENDED: %s ====================", test.toString(), date.toString());
        LogUtil.CLog.logAndDisplay(Log.LogLevel.DEBUG, "\n" + message2);
        if (this.mTrace != null && this.mTrace.contains(DeviceNotAvailableException.class.getCanonicalName())) {
            LogUtil.CLog.d("Skip logging device side, device was unavailable.");
            return;
        }
        this.logOnAllDevices(message2, new Object[0]);
    }

    private void logOnAllDevices(String format, Object ... args) {
        for (ITestDevice device : this.mDevices) {
            if (device.getIDevice() instanceof StubDevice || !IDevice.DeviceState.ONLINE.equals((Object)device.getIDevice().getState()) || !TestDeviceState.ONLINE.equals((Object)device.getDeviceState())) continue;
            device.logOnDevice(TAG, Log.LogLevel.DEBUG, format, args);
        }
    }
}

