/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.junit4;

import com.android.tradefed.error.IHarnessException;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.TestErrorIdentifier;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.testtype.DeviceJUnit4ClassRunner;
import com.android.tradefed.testtype.MetricTestCase;
import com.android.tradefed.testtype.junit4.CarryDnaeError;
import com.android.tradefed.testtype.junit4.CarryInterruptedException;
import com.android.tradefed.util.StreamUtil;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runners.model.MultipleFailureException;

public class JUnit4ResultForwarder
extends RunListener {
    private ITestInvocationListener mListener;
    private List<Throwable> mTestCaseFailures;
    private Description mRunDescription;
    private boolean mBeforeClass = true;
    private CloseableTraceScope mMethodTrace = null;
    private LogUploaderThread mLogUploaderThread;

    public JUnit4ResultForwarder(ITestInvocationListener listener) {
        this.mListener = listener;
        this.mTestCaseFailures = new ArrayList<Throwable>();
    }

    @Override
    public void testFailure(Failure failure) throws Exception {
        Description description;
        if (this.mLogUploaderThread != null) {
            this.mLogUploaderThread.cancel();
        }
        if ((description = failure.getDescription()).getMethodName() == null) {
            Throwable error = failure.getException();
            String message2 = error.getMessage();
            if (message2 == null) {
                message2 = error instanceof CarryInterruptedException ? "Test Phase Timeout Reached." : "Exception with no error message";
            }
            FailureDescription failureDesc = FailureDescription.create(message2).setFailureStatus(TestRecordProto.FailureStatus.TEST_FAILURE);
            if (error instanceof CarryDnaeError) {
                error = ((CarryDnaeError)error).getDeviceNotAvailableException();
            }
            failureDesc.setCause(error);
            if (error instanceof IHarnessException) {
                ErrorIdentifier id = ((IHarnessException)((Object)error)).getErrorId();
                if (id != null) {
                    failureDesc.setFailureStatus(id.status());
                }
                failureDesc.setErrorIdentifier(((IHarnessException)((Object)error)).getErrorId());
                failureDesc.setOrigin(((IHarnessException)((Object)error)).getOrigin());
            } else if (error instanceof CarryInterruptedException) {
                failureDesc.setErrorIdentifier(TestErrorIdentifier.TEST_PHASE_TIMED_OUT);
            }
            this.mListener.testRunFailed(failureDesc);
            if (error instanceof CarryDnaeError) {
                throw ((CarryDnaeError)error).getDeviceNotAvailableException();
            }
            return;
        }
        this.mTestCaseFailures.add(failure.getException());
    }

    @Override
    public void testAssumptionFailure(Failure failure) {
        this.mTestCaseFailures.add(failure.getException());
    }

    @Override
    public void testRunStarted(Description description) throws Exception {
        this.mRunDescription = description;
    }

    @Override
    public void testRunFinished(Result result) throws Exception {
        if (!this.mTestCaseFailures.isEmpty()) {
            String stack = StreamUtil.getStackTrace(this.mTestCaseFailures.get(0));
            if (this.mBeforeClass) {
                for (Description test : this.mRunDescription.getChildren()) {
                    TestDescription testid = new TestDescription(test.getClassName(), test.getMethodName(), test.getAnnotations());
                    this.mListener.testStarted(testid);
                    this.mListener.testAssumptionFailure(testid, stack);
                    this.mListener.testEnded(testid, new HashMap<String, MetricMeasurement.Metric>());
                }
            } else {
                this.mListener.testRunFailed(stack);
            }
        }
    }

    @Override
    public void testStarted(Description description) throws Exception {
        this.mMethodTrace = new CloseableTraceScope(description.getMethodName());
        this.mBeforeClass = false;
        this.mTestCaseFailures.clear();
        TestDescription testid = new TestDescription(description.getClassName(), description.getMethodName(), description.getAnnotations());
        this.mListener.testStarted(testid);
        this.mLogUploaderThread = new LogUploaderThread(description);
        this.mLogUploaderThread.setDaemon(true);
        this.mLogUploaderThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testFinished(Description description) throws Exception {
        this.mLogUploaderThread.cancel();
        TestDescription testid = new TestDescription(description.getClassName(), description.getMethodName(), description.getAnnotations());
        try {
            this.handleFailures(testid);
        }
        catch (Throwable throwable) {
            this.mLogUploaderThread.join();
            this.pollLogsAndUpload(description);
            HashMap<String, MetricMeasurement.Metric> metrics = new HashMap<String, MetricMeasurement.Metric>();
            for (Description child : description.getChildren()) {
                for (Annotation a : child.getAnnotations()) {
                    if (!(a instanceof DeviceJUnit4ClassRunner.MetricAnnotation)) continue;
                    metrics.putAll(((DeviceJUnit4ClassRunner.MetricAnnotation)a).mMetrics);
                }
            }
            this.mListener.testEnded(testid, metrics);
            this.mTestCaseFailures.clear();
            if (this.mMethodTrace != null) {
                this.mMethodTrace.close();
                this.mMethodTrace = null;
            }
            throw throwable;
        }
        this.mLogUploaderThread.join();
        this.pollLogsAndUpload(description);
        HashMap<String, MetricMeasurement.Metric> metrics = new HashMap<String, MetricMeasurement.Metric>();
        for (Description child : description.getChildren()) {
            for (Annotation a : child.getAnnotations()) {
                if (!(a instanceof DeviceJUnit4ClassRunner.MetricAnnotation)) continue;
                metrics.putAll(((DeviceJUnit4ClassRunner.MetricAnnotation)a).mMetrics);
            }
        }
        this.mListener.testEnded(testid, metrics);
        this.mTestCaseFailures.clear();
        if (this.mMethodTrace != null) {
            this.mMethodTrace.close();
            this.mMethodTrace = null;
        }
    }

    @Override
    public void testIgnored(Description description) throws Exception {
        TestDescription testid = new TestDescription(description.getClassName(), description.getMethodName(), description.getAnnotations());
        this.mListener.testStarted(testid);
        this.mListener.testIgnored(testid);
        this.mListener.testEnded(testid, new HashMap<String, MetricMeasurement.Metric>());
    }

    private void handleFailures(TestDescription testid) {
        if (this.mTestCaseFailures.isEmpty()) {
            return;
        }
        if (this.mTestCaseFailures.size() == 1) {
            Throwable t = this.mTestCaseFailures.get(0);
            if (t instanceof AssumptionViolatedException) {
                this.mListener.testAssumptionFailure(testid, StreamUtil.getStackTrace(t));
            } else {
                this.mListener.testFailed(testid, StreamUtil.getStackTrace(t));
            }
        } else {
            MultipleFailureException multiException = new MultipleFailureException(this.mTestCaseFailures);
            this.mListener.testFailed(testid, this.getMultiFailureStack(multiException));
        }
    }

    private void pollLogsAndUpload(Description description) {
        for (Description child : description.getChildren()) {
            for (Annotation a : child.getAnnotations()) {
                if (!(a instanceof DeviceJUnit4ClassRunner.LogAnnotation)) continue;
                LinkedBlockingQueue<MetricTestCase.LogHolder> list2 = ((DeviceJUnit4ClassRunner.LogAnnotation)a).mLogs;
                while (!list2.isEmpty()) {
                    MetricTestCase.LogHolder log = list2.poll();
                    this.mListener.testLog(log.mDataName, log.mDataType, log.mDataStream);
                    StreamUtil.cancel(log.mDataStream);
                }
            }
        }
    }

    private String getMultiFailureStack(MultipleFailureException multiException) {
        StringBuilder sb = new StringBuilder(String.format("MultipleFailureException, There were %d errors:", multiException.getFailures().size()));
        for (Throwable e : multiException.getFailures()) {
            sb.append(String.format("\n  %s", StreamUtil.getStackTrace(e)));
        }
        return sb.toString();
    }

    private class LogUploaderThread
    extends Thread {
        private Description mDescription;
        private AtomicBoolean mIsCancelled = new AtomicBoolean(false);

        public LogUploaderThread(Description description) {
            this.mDescription = description;
        }

        @Override
        public void run() {
            while (!this.mIsCancelled.get()) {
                JUnit4ResultForwarder.this.pollLogsAndUpload(this.mDescription);
            }
        }

        public void cancel() {
            this.mIsCancelled.set(true);
        }
    }
}

