/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.junit4;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.testtype.junit4.CarryInterruptedException;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

public class RunNotifierWrapper
extends RunNotifier {
    private DeviceNotAvailableException mDnae;
    private RunNotifier notifier;
    private TestInformation mTestInfo;

    public RunNotifierWrapper(RunNotifier notifier) {
        this.notifier = notifier;
    }

    public void setTestInfo(TestInformation testInfo) {
        this.mTestInfo = testInfo;
    }

    @Override
    public void addFirstListener(RunListener listener) {
        this.notifier.addFirstListener(listener);
    }

    @Override
    public void fireTestRunStarted(Description description) {
        this.notifier.fireTestRunStarted(description);
    }

    @Override
    public void fireTestRunFinished(Result result) {
        this.notifier.fireTestRunFinished(result);
    }

    @Override
    public void fireTestSuiteStarted(Description description) {
        this.notifier.fireTestSuiteStarted(description);
    }

    @Override
    public void fireTestSuiteFinished(Description description) {
        this.notifier.fireTestSuiteFinished(description);
    }

    @Override
    public void pleaseStop() {
        this.notifier.pleaseStop();
    }

    @Override
    public void addListener(RunListener listener) {
        this.notifier.addListener(listener);
    }

    @Override
    public void removeListener(RunListener listener) {
        this.notifier.removeListener(listener);
    }

    @Override
    public void fireTestFailure(Failure failure) {
        this.notifier.fireTestFailure(failure);
        if (failure.getException() instanceof DeviceNotAvailableException) {
            this.mDnae = (DeviceNotAvailableException)failure.getException();
        } else if (failure.getException() instanceof InterruptedException) {
            throw new CarryInterruptedException((InterruptedException)failure.getException());
        }
    }

    @Override
    public void fireTestAssumptionFailed(Failure failure) {
        this.notifier.fireTestAssumptionFailed(failure);
    }

    @Override
    public void fireTestFinished(Description description) {
        this.notifier.fireTestFinished(description);
    }

    @Override
    public void fireTestStarted(Description description) {
        this.notifier.fireTestStarted(description);
        if (this.mTestInfo != null && this.mTestInfo.isTestTimedOut()) {
            this.notifier.fireTestIgnored(description);
            throw new CarryInterruptedException(new InterruptedException());
        }
    }

    @Override
    public void fireTestIgnored(Description description) {
        this.notifier.fireTestIgnored(description);
    }

    public DeviceNotAvailableException getDeviceNotAvailableException() {
        return this.mDnae;
    }
}

