/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.mobly;

import com.android.tradefed.testtype.mobly.IMoblyYamlResultHandler;
import com.android.tradefed.testtype.mobly.MoblyYamlResultHandlerFactory;
import java.util.Map;

public class MoblyYamlResultSummaryHandler
implements IMoblyYamlResultHandler {
    private static final String EXECUTED = "Executed";
    private static final String SKIPPED = "Skipped";

    @Override
    public Summary handle(Map<String, Object> docMap) {
        Summary.Builder builder = Summary.builder();
        builder.setExecuted(String.valueOf(docMap.get(EXECUTED)));
        builder.setSkipped(String.valueOf(docMap.get(SKIPPED)));
        return builder.build();
    }

    public static class Summary
    implements IMoblyYamlResultHandler.ITestResult {
        private int mExecuted;
        private int mSkipped;

        private Summary(String executed, String skipped) {
            this.mExecuted = Integer.parseInt(executed);
            this.mSkipped = Integer.parseInt(skipped);
        }

        @Override
        public MoblyYamlResultHandlerFactory.Type getType() {
            return MoblyYamlResultHandlerFactory.Type.SUMMARY;
        }

        public int getExecuted() {
            return this.mExecuted;
        }

        public int getSkipped() {
            return this.mSkipped;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String mExecuted;
            private String mSkipped;

            public Builder setExecuted(String executed) {
                this.mExecuted = executed;
                return this;
            }

            public Builder setSkipped(String skipped) {
                this.mSkipped = skipped;
                return this;
            }

            public Summary build() {
                return new Summary(this.mExecuted, this.mSkipped);
            }
        }
    }
}

