/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.rust;

import com.android.ddmlib.MultiLineReceiver;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RustBenchmarkResultParser
extends MultiLineReceiver {
    private String mCurrentTestFile;
    private String mCurrentTestName;
    private String mCurrentTestStatus;
    private Matcher mCurrentMatcher;
    private TestDescription mLastTestId;
    private boolean mAnyTestSeen = false;
    private boolean mDoneDone = false;
    private Collection<ITestInvocationListener> mListeners = new ArrayList<ITestInvocationListener>();
    private List<String> mTrackLogsSinceLastStart = new ArrayList<String>();
    static final Pattern CRITERION_START_PATTERN = Pattern.compile("Benchmarking ([^\\s]*)");
    static final Pattern CRITERION_END_PATTERN = Pattern.compile(".*time:.*");

    public RustBenchmarkResultParser(ITestInvocationListener listener, String runName) {
        this(Arrays.asList(listener), runName);
    }

    public RustBenchmarkResultParser(Collection<ITestInvocationListener> listeners, String runName) {
        this.mListeners.addAll(listeners);
        this.mCurrentTestFile = runName;
    }

    @Override
    public void processNewLines(String[] lines) {
        for (String line : lines) {
            this.mTrackLogsSinceLastStart.add(line);
            Matcher startMatcher = CRITERION_START_PATTERN.matcher(line);
            Matcher endMatcher = CRITERION_END_PATTERN.matcher(line);
            if (startMatcher.matches()) {
                if (this.mLastTestId != null) {
                    for (ITestInvocationListener listener : this.mListeners) {
                        listener.testFailed(this.mLastTestId, String.join((CharSequence)"\n", this.mTrackLogsSinceLastStart));
                        listener.testEnded(this.mLastTestId, new HashMap<String, MetricMeasurement.Metric>());
                    }
                    this.mLastTestId = null;
                }
                this.mLastTestId = new TestDescription(this.mCurrentTestFile, startMatcher.group(1));
                for (ITestInvocationListener listener : this.mListeners) {
                    listener.testStarted(this.mLastTestId);
                }
                this.mTrackLogsSinceLastStart.clear();
                this.mAnyTestSeen = true;
                continue;
            }
            if (!endMatcher.matches()) continue;
            if (this.mLastTestId != null) {
                for (ITestInvocationListener listener : this.mListeners) {
                    listener.testEnded(this.mLastTestId, new HashMap<String, MetricMeasurement.Metric>());
                }
                this.mLastTestId = null;
                continue;
            }
            LogUtil.CLog.e("End of test matched before its start. Is it a bug?");
        }
    }

    @Override
    public void done() {
        if (this.mDoneDone) {
            return;
        }
        this.mDoneDone = true;
        if (!this.mAnyTestSeen) {
            for (ITestInvocationListener listener : this.mListeners) {
                listener.testRunFailed(String.format("test did not report any run:\n%s", String.join((CharSequence)"\n", this.mTrackLogsSinceLastStart)));
            }
        }
        if (this.mLastTestId != null) {
            for (ITestInvocationListener listener : this.mListeners) {
                listener.testFailed(this.mLastTestId, String.join((CharSequence)"\n", this.mTrackLogsSinceLastStart));
                listener.testEnded(this.mLastTestId, new HashMap<String, MetricMeasurement.Metric>());
                listener.testRunFailed(this.mCurrentTestFile + " execution failed.");
            }
        }
    }

    @Override
    public boolean isCancelled() {
        return false;
    }
}

