/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.rust;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.build.BuildInfoKey;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.error.TestErrorIdentifier;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.rust.RustTestBase;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.TestRunnerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@OptionClass(alias="rust-host")
public class RustBinaryHostTest
extends RustTestBase
implements IBuildReceiver {
    static final String RUST_LOG_STDERR_FORMAT = "%s-stderr";
    static final String RUST_LOG_STDOUT_FORMAT = "%s-stdout";
    @Option(name="test-file", description="The test file name or file path.")
    private Set<String> mBinaryNames = new HashSet<String>();
    private IBuildInfo mBuildInfo;

    @Override
    public void setBuild(IBuildInfo buildInfo) {
        this.mBuildInfo = buildInfo;
    }

    @Override
    public final void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        try {
            List<File> rustFilesList = this.findFiles();
            for (File file2 : rustFilesList) {
                if (!file2.exists()) {
                    LogUtil.CLog.d("ignoring %s which doesn't look like a test file.", file2.getAbsolutePath());
                    continue;
                }
                file2.setExecutable(true);
                this.runSingleRustFile(listener, file2);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<File> findFiles() throws IOException {
        File testsDir = this.mBuildInfo.getFile(BuildInfoKey.BuildInfoFileKey.HOST_LINKED_DIR);
        if (testsDir == null && this.mBuildInfo instanceof IDeviceBuildInfo) {
            testsDir = ((IDeviceBuildInfo)this.mBuildInfo).getTestsDir();
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String fileName : this.mBinaryNames) {
            File res = null;
            File filePath = new File(fileName);
            String paths = "";
            if (filePath.isAbsolute()) {
                res = filePath;
            } else {
                if (testsDir == null) {
                    throw new RuntimeException(String.format("Cannot find %s without test directory", fileName));
                }
                paths = testsDir + "\n";
                String baseName = filePath.getName();
                if (!baseName.equals(fileName)) {
                    try {
                        Set<File> candidates = FileUtil.findFilesObject(testsDir, baseName);
                        for (File f : candidates) {
                            paths = paths + String.format("  found: %s\n", f.getPath());
                            if (!f.getPath().endsWith(fileName)) continue;
                            res = f;
                            break;
                        }
                        if (res == null) {
                            LogUtil.CLog.e("Cannot find %s; try to find %s", fileName, baseName);
                        }
                    }
                    catch (IOException e) {
                        res = null;
                    }
                }
                if (res == null && (res = FileUtil.findFile(baseName, this.getAbi(), testsDir)) != null && res.isDirectory()) {
                    File byBaseName;
                    File currentDir = res;
                    res = FileUtil.findFile(baseName, this.getAbi(), currentDir);
                    if (res == null && (byBaseName = FileUtil.findFile(baseName + ".*", this.getAbi(), currentDir)) != null && byBaseName.isFile()) {
                        res = byBaseName;
                    }
                }
            }
            if (res == null) {
                throw new RuntimeException(String.format("Cannot find %s under %s", fileName, paths));
            }
            files.add(res);
        }
        return files;
    }

    private void runSingleRustFile(ITestInvocationListener listener, File file2) {
        LogUtil.CLog.d("Run single Rust File: %s", file2.getAbsolutePath());
        List<RustTestBase.Invocation> invocations = this.generateInvocations(file2);
        HashSet<String> foundTests = new HashSet<String>();
        for (RustTestBase.Invocation invocation : invocations) {
            boolean success = this.countTests(invocation, foundTests);
            if (success) continue;
            FailureDescription failure = FailureDescription.create("Could not count the number of tests", TestRecordProto.FailureStatus.TEST_FAILURE);
            listener.testRunStarted(file2.getName(), 0);
            listener.testRunFailed(failure);
            listener.testRunEnded(0L, new HashMap<String, MetricMeasurement.Metric>());
            LogUtil.CLog.e(failure.getErrorMessage());
            return;
        }
        int testCount = foundTests.size();
        LogUtil.CLog.d("Total test count: %d", testCount);
        long startTimeMs = System.currentTimeMillis();
        listener.testRunStarted(file2.getName(), testCount, 0, startTimeMs);
        if (testCount > 0) {
            for (RustTestBase.Invocation invocation : invocations) {
                try {
                    this.runTest(listener, invocation, file2.getName());
                }
                catch (IOException e) {
                    listener.testRunFailed(e.getMessage());
                    long testTimeMs = System.currentTimeMillis() - startTimeMs;
                    listener.testRunEnded(testTimeMs, new HashMap<String, MetricMeasurement.Metric>());
                    throw new RuntimeException(e);
                }
            }
        }
        long testTimeMs = System.currentTimeMillis() - startTimeMs;
        listener.testRunEnded(testTimeMs, new HashMap<String, MetricMeasurement.Metric>());
    }

    private boolean countTests(RustTestBase.Invocation invocation, Set<String> foundTests) {
        CommandResult listResult = this.runInvocation(invocation, "--list");
        if (listResult.getStatus() == CommandStatus.SUCCESS) {
            this.collectTestLines(listResult.getStdout().split("\n"), foundTests);
            return true;
        }
        LogUtil.CLog.w("Could not run command '%s' to get test list.\nstdout: %s\nstderr: %s", String.join((CharSequence)" ", invocation.command) + " --list", listResult.getStdout(), listResult.getStderr());
        return false;
    }

    private CommandResult runInvocation(RustTestBase.Invocation invocation, String ... extraArgs) {
        String ldLibraryPath;
        IRunUtil runUtil = this.getRunUtil();
        runUtil.setWorkingDir(invocation.workingDir);
        boolean ldLibraryPathSetInEnv = false;
        for (RustTestBase.EnvPair envPair : invocation.env) {
            runUtil.setEnvVariable(envPair.key, envPair.val);
            if (!"LD_LIBRARY_PATH".equals(envPair.key)) continue;
            ldLibraryPathSetInEnv = true;
        }
        if (!ldLibraryPathSetInEnv && (ldLibraryPath = TestRunnerUtil.getLdLibraryPath(new File(invocation.command[0]))) != null) {
            runUtil.setEnvVariable("LD_LIBRARY_PATH", ldLibraryPath);
        }
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(invocation.command));
        command.addAll(Arrays.asList(extraArgs));
        return runUtil.runTimedCmd(this.mTestTimeout, command.toArray(new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(ITestInvocationListener listener, RustTestBase.Invocation invocation, String runName) throws IOException {
        CommandResult result = this.runInvocation(invocation, new String[0]);
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            String message2 = String.format("Something went wrong when running the rust binary:Exit Code: %s\nstdout: %s\nstderr: %s", result.getExitCode(), result.getStdout(), result.getStderr());
            FailureDescription failure = FailureDescription.create(message2, TestRecordProto.FailureStatus.TEST_FAILURE).setErrorIdentifier(TestErrorIdentifier.TEST_BINARY_EXIT_CODE_ERROR);
            listener.testRunFailed(failure);
            LogUtil.CLog.e(message2);
        }
        File resultFile = null;
        try {
            FileInputStreamSource data;
            resultFile = FileUtil.createTempFile("rust-res", ".txt");
            if (result.getStderr().length() > 0) {
                FileUtil.writeToFile(result.getStderr(), resultFile);
                data = new FileInputStreamSource(resultFile);
                try {
                    listener.testLog(String.format(RUST_LOG_STDERR_FORMAT, runName), LogDataType.TEXT, data);
                }
                finally {
                    data.close();
                }
            }
            if (result.getStdout().length() > 0) {
                FileUtil.writeToFile(result.getStdout(), resultFile);
                data = new FileInputStreamSource(resultFile);
                try {
                    listener.testLog(String.format(RUST_LOG_STDOUT_FORMAT, runName), LogDataType.TEXT, data);
                }
                finally {
                    data.close();
                }
            }
            IShellOutputReceiver parser = this.createParser(listener, runName);
            parser.addOutput(result.getStdout().getBytes(), 0, result.getStdout().length());
            parser.flush();
        }
        catch (RuntimeException e) {
            listener.testRunFailed(String.format("Failed to parse the rust test output: %s", e.getMessage()));
            LogUtil.CLog.e(e);
        }
        finally {
            FileUtil.deleteFile(resultFile);
        }
    }

    IRunUtil getRunUtil() {
        return new RunUtil();
    }
}

