/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.rust;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.testtype.rust.RustBenchmarkResultParser;
import com.android.tradefed.testtype.rust.RustTestResultParser;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@OptionClass(alias="rust-test")
public abstract class RustTestBase
implements IRemoteTest,
ITestFilterReceiver,
IAbiReceiver {
    @Option(name="native-test-flag", description="Option string to be passed to the binary when running")
    private List<String> mTestOptions = new ArrayList<String>();
    @Option(name="test-timeout", description="Timeout for a single test file to terminate.", isTimeVal=true)
    protected long mTestTimeout = 60000L;
    @Option(name="is-benchmark", description="Set to true if module is a benchmark. Module is treated as test by default.")
    private boolean mIsBenchmark = false;
    @Option(name="include-filter", description="A substr filter of test case names to run.")
    private Set<String> mIncludeFilters = new LinkedHashSet<String>();
    @Option(name="exclude-filter", description="A substr filter of test case names to skip.")
    private Set<String> mExcludeFilters = new LinkedHashSet<String>();
    @Option(name="ld-library-path", description="LD_LIBRARY_PATH value to include in the Rust test execution command.")
    private String mLdLibraryPath = null;
    @Option(name="ld-library-path-32", description="LD_LIBRARY_PATH value to include in the Rust test execution command for 32-bit tests. If both `--ld-library-path` and `--ld-library-path-32` are set, only the latter is honored for 32-bit tests.")
    private String mLdLibraryPath32 = null;
    @Option(name="ld-library-path-64", description="LD_LIBRARY_PATH value to include in the Rust test execution command for 64-bit tests. If both `--ld-library-path` and `--ld-library-path-64` are set, only the latter is honored for 64-bit tests.")
    private String mLdLibraryPath64 = null;
    private IAbi mAbi;

    @Override
    public void setAbi(IAbi abi) {
        this.mAbi = abi;
    }

    @Override
    public IAbi getAbi() {
        return this.mAbi;
    }

    @VisibleForTesting
    IShellOutputReceiver createParser(ITestInvocationListener listener, String runName) {
        if (!this.mIsBenchmark) {
            return new RustTestResultParser(listener, runName);
        }
        return new RustBenchmarkResultParser(listener, runName);
    }

    @Override
    public void addIncludeFilter(String filter) {
        this.mIncludeFilters.add(filter);
    }

    @Override
    public void addExcludeFilter(String filter) {
        this.mExcludeFilters.add(filter);
    }

    @Override
    public void addAllIncludeFilters(Set<String> filters) {
        this.mIncludeFilters.addAll(filters);
    }

    @Override
    public void addAllExcludeFilters(Set<String> filters) {
        this.mExcludeFilters.addAll(filters);
    }

    @Override
    public void clearIncludeFilters() {
        this.mIncludeFilters.clear();
    }

    @Override
    public void clearExcludeFilters() {
        this.mExcludeFilters.clear();
    }

    @Override
    public Set<String> getIncludeFilters() {
        return this.mIncludeFilters;
    }

    @Override
    public Set<String> getExcludeFilters() {
        return this.mExcludeFilters;
    }

    protected void collectTestLines(String[] testList, Set<String> foundTests) {
        String tag = this.mIsBenchmark ? ": bench" : ": test";
        int counter = 0;
        for (String line : testList) {
            if (!line.endsWith(tag)) continue;
            ++counter;
            foundTests.add(line);
        }
        LogUtil.CLog.d("Found %d tests", counter);
    }

    private String cleanFilter(String filter) {
        return filter.replaceFirst(".*#", "");
    }

    private List<String> getListOfIncludeFilters() {
        if (this.mIncludeFilters.isEmpty()) {
            return new ArrayList<String>(List.of(""));
        }
        return new ArrayList<String>(this.mIncludeFilters);
    }

    private void addFiltersToArgs(List<String> args, String filter) {
        if (this.mIsBenchmark) {
            LogUtil.CLog.w("b/294857452 -- filters are not yet supported for rust benchmarks");
            return;
        }
        if (!"".equals(filter)) {
            args.add(this.cleanFilter(filter));
        }
        args.add("--exact");
        for (String s : this.mExcludeFilters) {
            args.add("--skip");
            args.add(this.cleanFilter(s));
        }
    }

    private String ldLibraryPath() {
        if (this.mLdLibraryPath32 != null && "32".equals(this.getAbi().getBitness())) {
            return this.mLdLibraryPath32;
        }
        if (this.mLdLibraryPath64 != null && "64".equals(this.getAbi().getBitness())) {
            return this.mLdLibraryPath64;
        }
        if (this.mLdLibraryPath != null) {
            return this.mLdLibraryPath;
        }
        return null;
    }

    protected List<Invocation> generateInvocations(File target) {
        File workingDir = target.getParentFile();
        ArrayList<String> commandTemplate = new ArrayList<String>();
        commandTemplate.add(target.getAbsolutePath());
        commandTemplate.addAll(this.mTestOptions);
        if (!this.mIsBenchmark) {
            commandTemplate.add("-Zunstable-options");
            commandTemplate.add("--report-time");
        }
        if (this.mIsBenchmark) {
            commandTemplate.add("--bench");
            commandTemplate.add("--color");
            commandTemplate.add("never");
        }
        ArrayList<Invocation> out = new ArrayList<Invocation>();
        for (String filter : this.getListOfIncludeFilters()) {
            ArrayList<String> command = new ArrayList<String>(commandTemplate);
            this.addFiltersToArgs(command, filter);
            ArrayList<EnvPair> env = new ArrayList<EnvPair>();
            env.add(new EnvPair("RUST_BACKTRACE", "full"));
            if (this.ldLibraryPath() != null) {
                env.add(new EnvPair("LD_LIBRARY_PATH", this.ldLibraryPath()));
            }
            out.add(new Invocation(command.toArray(new String[0]), env, workingDir));
        }
        return out;
    }

    protected class EnvPair {
        public String key;
        public String val;

        public EnvPair(String key, String val) {
            this.key = key;
            this.val = val;
        }
    }

    protected class Invocation {
        public String[] command;
        public ArrayList<EnvPair> env;
        public File workingDir;

        public Invocation(String[] command, ArrayList<EnvPair> env, File workingDir) {
            this.command = command;
            this.env = env;
            this.workingDir = workingDir;
        }
    }
}

