/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite;

import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationFactory;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.SubprocessResultsReporter;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.testtype.InstrumentationTest;
import com.android.tradefed.testtype.IsolatedHostTest;
import com.android.tradefed.testtype.suite.BaseTestSuite;
import com.android.tradefed.testtype.suite.ITestSuite;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AtestRunner
extends BaseTestSuite {
    private static final Pattern CONFIG_RE = Pattern.compile(".*/(?<config>[^/]+).config", 2);
    @Option(name="all-abi", description="Determine run all abi or not.")
    private boolean mAllAbi = false;
    @Option(name="wait-for-debugger", description="For InstrumentationTests, we pass debug to the instrumentation run.")
    private boolean mDebug = false;
    @Option(name="disable-target-preparers", description="Skip the target preparer steps enumerated in test config. Skips the teardown step as well.")
    private boolean mSkipSetUp = false;
    @Option(name="disable-teardown", description="Skip the teardown of the target preparers.")
    private boolean mSkipTearDown = false;
    @Option(name="subprocess-report-port", description="the port where to connect to send theevents.")
    private Integer mReportPort = null;
    @Option(name="atest-include-filter", description="the include filters to pass to a module. The expected format is\"<module-name>:<include-filter-value>\"", importance=Option.Importance.ALWAYS)
    private List<String> mIncludeFilters = new ArrayList<String>();
    @Option(name="tf-config-path", description="Allows to run a specific TF configuration path.")
    private List<String> mTfConfigPaths = new ArrayList<String>();
    @Option(name="module-config-path", description="Allows to run a specific module configuration path.")
    private List<File> mModuleConfigPaths = new ArrayList<File>();

    public AtestRunner() {
        this.setMultiDeviceStrategy(ITestSuite.MultiDeviceModuleStrategy.RUN);
    }

    @Override
    public LinkedHashMap<String, IConfiguration> loadingStrategy(Set<IAbi> abis, List<File> testsDirs, String suitePrefix, String suiteTag) {
        if (this.mTfConfigPaths.isEmpty() && this.mModuleConfigPaths.isEmpty()) {
            return super.loadingStrategy(abis, testsDirs, suitePrefix, suiteTag);
        }
        LinkedHashMap<String, IConfiguration> loadedConfigs = new LinkedHashMap<String, IConfiguration>();
        loadedConfigs.putAll(this.getModuleLoader().loadTfConfigsFromSpecifiedPaths(this.mTfConfigPaths, abis, suiteTag));
        loadedConfigs.putAll(this.getModuleLoader().loadConfigsFromSpecifiedPaths(this.mModuleConfigPaths, abis, suiteTag));
        return loadedConfigs;
    }

    @Override
    public LinkedHashMap<String, IConfiguration> loadTests() {
        if (this.getRequestedAbi() == null && !this.mAllAbi) {
            this.setPrimaryAbiRun(true);
        }
        LinkedHashMap<String, IConfiguration> configMap = super.loadTests();
        LinkedHashMap<String, HashSet<String>> includeFilters = this.getIncludeFilters();
        for (IConfiguration testConfig : configMap.values()) {
            HashSet<String> moduleFilters;
            if (this.mSkipSetUp || this.mSkipTearDown) {
                this.disableTargetPreparers(testConfig, this.mSkipSetUp, this.mSkipTearDown);
            }
            if (this.mDebug) {
                this.addDebugger(testConfig);
            }
            if ((moduleFilters = includeFilters.get(this.canonicalizeConfigName(testConfig.getName()))) == null) continue;
            for (String filter : moduleFilters) {
                this.addFilter(testConfig, filter);
            }
        }
        return configMap;
    }

    private LinkedHashMap<String, HashSet<String>> getIncludeFilters() {
        LinkedHashMap<String, HashSet<String>> includeFilters = new LinkedHashMap<String, HashSet<String>>();
        for (String filter : this.mIncludeFilters) {
            int moduleSep = filter.indexOf(":");
            if (moduleSep == -1) {
                throw new RuntimeException("Expected delimiter ':' for module or class.");
            }
            String moduleName = this.canonicalizeConfigName(filter.substring(0, moduleSep));
            String moduleFilter = filter.substring(moduleSep + 1);
            HashSet<String> moduleFilters = includeFilters.get(moduleName);
            if (moduleFilters == null) {
                moduleFilters = new LinkedHashSet<String>();
                includeFilters.put(moduleName, moduleFilters);
            }
            moduleFilters.add(moduleFilter);
        }
        return includeFilters;
    }

    private String canonicalizeConfigName(String originalName) {
        Matcher match = CONFIG_RE.matcher(originalName);
        if (match.find()) {
            return match.group("config");
        }
        return originalName;
    }

    private void addFilter(IConfiguration testConfig, String filter) {
        List<IRemoteTest> tests = testConfig.getTests();
        for (IRemoteTest test : tests) {
            if (test instanceof ITestFilterReceiver) {
                LogUtil.CLog.d("%s:%s - Applying filter (%s)", testConfig.getName(), test.getClass().getSimpleName(), filter);
                ((ITestFilterReceiver)((Object)test)).addIncludeFilter(filter);
                continue;
            }
            LogUtil.CLog.e("Test Class (%s) does not support filtering. Cannot apply filter: %s.\nPlease update test to use a class that implements ITestFilterReceiver. Running entire test module instead.", test.getClass().getSimpleName(), filter);
        }
    }

    public IConfigurationFactory loadConfigFactory() {
        return ConfigurationFactory.getInstance();
    }

    @Override
    protected List<ITestInvocationListener> createModuleListeners() {
        List<ITestInvocationListener> listeners = super.createModuleListeners();
        if (this.mReportPort != null) {
            SubprocessResultsReporter subprocessResult = new SubprocessResultsReporter();
            OptionCopier.copyOptionsNoThrow(this, subprocessResult);
            listeners.add(subprocessResult);
        }
        return listeners;
    }

    private void addDebugger(IConfiguration testConfig) {
        for (IRemoteTest test : testConfig.getTests()) {
            if (test instanceof InstrumentationTest) {
                ((InstrumentationTest)test).setDebug(true);
            }
            if (!(test instanceof IsolatedHostTest)) continue;
            ((IsolatedHostTest)test).setDebug(true);
        }
    }

    private void disableTargetPreparers(IConfiguration testConfig, boolean skipSetUp, boolean skipTearDown) {
        for (ITargetPreparer targetPreparer : testConfig.getTargetPreparers()) {
            if (skipSetUp) {
                LogUtil.CLog.d("%s: Disabling Target Preparer (%s)", testConfig.getName(), targetPreparer.getClass().getSimpleName());
                targetPreparer.setDisable(true);
                continue;
            }
            if (!skipTearDown) continue;
            LogUtil.CLog.d("%s: Disabling Target Preparer TearDown (%s)", testConfig.getName(), targetPreparer.getClass().getSimpleName());
            targetPreparer.setDisableTearDown(true);
        }
    }
}

