/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite;

import com.android.tradefed.build.BuildInfoKey;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceFoldableState;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestFileFilterReceiver;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.testtype.suite.ITestSuite;
import com.android.tradefed.testtype.suite.ModuleDefinition;
import com.android.tradefed.testtype.suite.SuiteModuleLoader;
import com.android.tradefed.testtype.suite.SuiteTestFilter;
import com.android.tradefed.testtype.suite.params.FoldableExpandingHandler;
import com.android.tradefed.testtype.suite.params.IModuleParameterHandler;
import com.android.tradefed.testtype.suite.params.ModuleParameters;
import com.android.tradefed.testtype.suite.params.ModuleParametersHelper;
import com.android.tradefed.testtype.suite.params.NegativeHandler;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.FileUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@OptionClass(alias="base-suite")
public class BaseTestSuite
extends ITestSuite {
    public static final String INCLUDE_FILTER_OPTION = "include-filter";
    public static final String EXCLUDE_FILTER_OPTION = "exclude-filter";
    public static final String MODULE_OPTION = "module";
    public static final char MODULE_OPTION_SHORT_NAME = 'm';
    public static final String TEST_ARG_OPTION = "test-arg";
    public static final String TEST_OPTION = "test";
    public static final char TEST_OPTION_SHORT_NAME = 't';
    public static final String CONFIG_PATTERNS_OPTION = "config-patterns";
    private static final String MODULE_ARG_OPTION = "module-arg";
    private static final String REVERSE_EXCLUDE_FILTERS = "reverse-exclude-filters";
    private static final int MAX_FILTER_DISPLAY = 20;
    @Option(name="include-filter", description="the include module filters to apply. Format: '[abi] <module-name> [test]'. See documentation:https://source.android.com/docs/core/tests/tradefed/testing/through-suite/option-passing", importance=Option.Importance.ALWAYS)
    private Set<String> mIncludeFilters = new LinkedHashSet<String>();
    @Option(name="exclude-filter", description="the exclude module filters to apply. Format: '[abi] <module-name> [test]'. See documentation:https://source.android.com/docs/core/tests/tradefed/testing/through-suite/option-passing", importance=Option.Importance.ALWAYS)
    private Set<String> mExcludeFilters = new LinkedHashSet<String>();
    @Option(name="reverse-exclude-filters", description="Flip exclude-filters into include-filters, in order to run only the excluded set.")
    private boolean mReverseExcludeFilters = false;
    @Option(name="module", shortName=109, description="the test module to run. Only works for configuration in the tests dir.", importance=Option.Importance.IF_UNSET)
    private String mModuleName = null;
    @Option(name="test", shortName=116, description="the test to run.", importance=Option.Importance.IF_UNSET)
    private String mTestName = null;
    @Option(name="module-arg", description="the arguments to pass to a module. The expected format is\"<module-name>:[{alias}]<arg-name>:[<arg-key>:=]<arg-value>\"", importance=Option.Importance.ALWAYS)
    private List<String> mModuleArgs = new ArrayList<String>();
    @Option(name="test-arg", description="The arguments to pass to a test or its preparers. The expected format is\"<test-class>:<arg-name>:[<arg-key>:=]<arg-value>\"", importance=Option.Importance.ALWAYS)
    private List<String> mTestArgs = new ArrayList<String>();
    @Option(name="run-suite-tag", description="The tag that must be run. If specified, only configurations containing the matching suite tag will be able to run.")
    private String mSuiteTag = null;
    @Option(name="prioritize-host-config", description="If there are duplicate test configs for host/target, prioritize the host config, otherwise use the target config.")
    private boolean mPrioritizeHostConfig = false;
    @Option(name="suite-config-prefix", description="Search only configs with given prefix for suite tags.")
    private String mSuitePrefix = null;
    @Option(name="skip-loading-config-jar", description="Whether or not to skip loading configurations from the JAR on the classpath.")
    private boolean mSkipJarLoading = false;
    @Option(name="config-patterns", description="The pattern(s) of the configurations that should be loaded from a directory. If none is explicitly specified, .*.xml and .*.config will be used. Can be repeated.")
    private List<String> mConfigPatterns = new ArrayList<String>();
    @Option(name="enable-parameterized-modules", description="Whether or not to enable parameterized modules. This is a feature flag for work in development.")
    private boolean mEnableParameter = false;
    @Option(name="enable-mainline-parameterized-modules", description="Whether or not to enable mainline parameterized modules. This is a feature flag for work in development.")
    private boolean mEnableMainlineParameter = false;
    @Option(name="enable-optional-parameterization", description="Whether or not to enable optional parameters. Optional parameters are parameters not usually used by default.")
    private boolean mEnableOptionalParameter = false;
    @Option(name="module-parameter", description="Allows to run only one module parameter type instead of all the combinations. For example: 'instant_app' would only run the instant_app version of modules")
    private ModuleParameters mForceParameter = null;
    @Option(name="exclude-module-parameters", description="Exclude some modules parameter from being evaluated in the run combinations.For example: 'instant_app' would exclude all the instant_app version of modules.")
    private Set<ModuleParameters> mExcludedModuleParameters = new HashSet<ModuleParameters>();
    @Option(name="fail-on-everything-filtered", description="Whether or not to fail the invocation in case test filter returns an empty result.")
    private boolean mFailOnEverythingFiltered = false;
    @Option(name="ignore-non-preloaded-mainline-module", description="Skip installing the module(s) when the module(s) that are notpreloaded on device. Otherwise an exception will be thrown.")
    private boolean mIgnoreNonPreloadedMainlineModule = false;
    @Option(name="load-configs-with-include-filters", description="An experimental flag to improve the performance of loading test configs with given module defined in include-filter.")
    private boolean mLoadConfigsWithIncludeFilters = false;
    private SuiteModuleLoader mModuleRepo;
    private Map<String, LinkedHashSet<SuiteTestFilter>> mIncludeFiltersParsed = new LinkedHashMap<String, LinkedHashSet<SuiteTestFilter>>();
    private Map<String, LinkedHashSet<SuiteTestFilter>> mExcludeFiltersParsed = new LinkedHashMap<String, LinkedHashSet<SuiteTestFilter>>();
    private List<File> mConfigPaths = new ArrayList<File>();
    private Set<IAbi> mAbis = new LinkedHashSet<IAbi>();
    private Set<DeviceFoldableState> mFoldableStates = new LinkedHashSet<DeviceFoldableState>();

    public void setSkipjarLoading(boolean skipJarLoading) {
        this.mSkipJarLoading = skipJarLoading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<String, IConfiguration> loadTests() {
        try {
            File testsDir = this.getTestsDir();
            try {
                this.mFoldableStates = this.getFoldableStates(this.getDevice());
            }
            catch (UnsupportedOperationException e) {
                LogUtil.CLog.e(e);
            }
            this.setupFilters(testsDir);
            this.mAbis = this.getAbis(this.getDevice());
            if (this.mReverseExcludeFilters) {
                if (this.mExcludeFilters.isEmpty()) {
                    return new LinkedHashMap<String, IConfiguration>();
                }
                this.mIncludeFilters.clear();
                this.mIncludeFilters.addAll(this.mExcludeFilters);
                this.mExcludeFilters.clear();
            }
            SuiteModuleLoader.addFilters(this.mIncludeFilters, this.mIncludeFiltersParsed, this.mAbis, this.mFoldableStates);
            SuiteModuleLoader.addFilters(this.mExcludeFilters, this.mExcludeFiltersParsed, this.mAbis, this.mFoldableStates);
            String includeFilters = "";
            if (this.mIncludeFiltersParsed.size() > 20) {
                if (this.isSplitting()) {
                    includeFilters = "Includes: <too long to display>";
                } else {
                    File suiteIncludeFilters = null;
                    try {
                        suiteIncludeFilters = FileUtil.createTempFile("suite-include-filters", ".txt");
                        FileUtil.writeToFile(this.mIncludeFiltersParsed.toString(), suiteIncludeFilters);
                        this.logFilterFile(suiteIncludeFilters, suiteIncludeFilters.getName(), LogDataType.TEXT);
                        includeFilters = String.format("Includes: See %s", suiteIncludeFilters.getName());
                    }
                    catch (IOException e) {
                        LogUtil.CLog.e(e);
                    }
                    finally {
                        FileUtil.deleteFile(suiteIncludeFilters);
                    }
                }
            } else if (this.mIncludeFiltersParsed.size() > 0) {
                includeFilters = String.format("Includes: %s", this.mIncludeFiltersParsed.toString());
            }
            String excludeFilters = "";
            if (this.mExcludeFiltersParsed.size() > 20) {
                if (this.isSplitting()) {
                    excludeFilters = "Excludes: <too long to display>";
                } else {
                    File suiteExcludeFilters = null;
                    try {
                        suiteExcludeFilters = FileUtil.createTempFile("suite-exclude-filters", ".txt");
                        FileUtil.writeToFile(this.mExcludeFiltersParsed.toString(), suiteExcludeFilters);
                        this.logFilterFile(suiteExcludeFilters, suiteExcludeFilters.getName(), LogDataType.TEXT);
                        excludeFilters = String.format("Excludes: See %s", suiteExcludeFilters.getName());
                    }
                    catch (IOException e) {
                        LogUtil.CLog.e(e);
                    }
                    finally {
                        FileUtil.deleteFile(suiteExcludeFilters);
                    }
                }
            } else if (this.mExcludeFiltersParsed.size() > 0) {
                excludeFilters = String.format("Excludes: %s", this.mExcludeFiltersParsed.toString());
            }
            LogUtil.CLog.d("Initializing ModuleRepo\nABIs:%s\nTest Args:%s\nModule Args:%s\n%s\n%s", this.mAbis, this.mTestArgs, this.mModuleArgs, includeFilters, excludeFilters);
            if (!this.mFoldableStates.isEmpty()) {
                LogUtil.CLog.d("Foldable states: %s", this.mFoldableStates);
            }
            this.mModuleRepo = this.createModuleLoader(this.mIncludeFiltersParsed, this.mExcludeFiltersParsed, this.mTestArgs, this.mModuleArgs);
            if (this.mForceParameter != null && !this.mEnableParameter) {
                throw new IllegalArgumentException("'module-parameter' option was specified without 'enable-parameterized-modules'");
            }
            if (this.mEnableOptionalParameter && !this.mEnableParameter) {
                throw new IllegalArgumentException("'enable-optional-parameterization' option was specified without 'enable-parameterized-modules'");
            }
            if (this.mEnableMainlineParameter) {
                this.mModuleRepo.setMainlineParameterizedModules(this.mEnableMainlineParameter);
                this.mModuleRepo.setInvocationContext(this.getInvocationContext());
                this.mModuleRepo.setOptimizeMainlineTest(this.getConfiguration().getCommandOptions().getOptimizeMainlineTest());
                this.mModuleRepo.setIgnoreNonPreloadedMainlineModule(this.mIgnoreNonPreloadedMainlineModule);
            }
            this.mModuleRepo.setParameterizedModules(this.mEnableParameter);
            this.mModuleRepo.setOptionalParameterizedModules(this.mEnableOptionalParameter);
            this.mModuleRepo.setModuleParameter(this.mForceParameter);
            this.mModuleRepo.setExcludedModuleParameters(this.mExcludedModuleParameters);
            this.mModuleRepo.setFoldableStates(this.mFoldableStates);
            this.mModuleRepo.setLoadConfigsWithIncludeFilters(this.mLoadConfigsWithIncludeFilters);
            ArrayList<File> testsDirectories = new ArrayList<File>();
            if (this.mPrioritizeHostConfig) {
                File hostSubDir = this.getBuildInfo().getFile(BuildInfoKey.BuildInfoFileKey.HOST_LINKED_DIR);
                if (hostSubDir != null && hostSubDir.exists()) {
                    testsDirectories.add(hostSubDir);
                }
            } else {
                File targetSubDir = this.getBuildInfo().getFile(BuildInfoKey.BuildInfoFileKey.TARGET_LINKED_DIR);
                if (targetSubDir != null && targetSubDir.exists()) {
                    testsDirectories.add(targetSubDir);
                }
            }
            testsDirectories.add(testsDir);
            long start = System.currentTimeMillis();
            LinkedHashMap<String, IConfiguration> loadedTests = this.loadingStrategy(this.mAbis, testsDirectories, this.mSuitePrefix, this.mSuiteTag);
            long duration = System.currentTimeMillis() - start;
            InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.LOAD_TEST_CONFIGS_TIME, duration);
            if (this.mFailOnEverythingFiltered && loadedTests.isEmpty() && !this.mIncludeFiltersParsed.isEmpty()) {
                Map includeFiltersCleaned = this.mIncludeFiltersParsed.entrySet().stream().filter(entry -> entry.getValue() != null && !((LinkedHashSet)entry.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (x, y) -> y, LinkedHashMap::new));
                String errorMessage = String.format("Include filter '%s' was specified but resulted in an empty test set.", includeFiltersCleaned.toString());
                if (errorMessage.length() > 1000) {
                    LogUtil.CLog.e(errorMessage);
                    errorMessage = String.format("Include filter was specified for %d modules but resulted in an empty test set. Check host log for complete list of include filters.", includeFiltersCleaned.size());
                }
                throw new HarnessRuntimeException(errorMessage, InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
            }
            return loadedTests;
        }
        catch (DeviceNotAvailableException e) {
            throw new HarnessRuntimeException(e.getMessage(), e);
        }
        catch (FileNotFoundException fnfe) {
            throw new HarnessRuntimeException(fnfe.getMessage(), fnfe, InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
        }
    }

    public LinkedHashMap<String, IConfiguration> loadingStrategy(Set<IAbi> abis, List<File> testsDirs, String suitePrefix, String suiteTag) {
        LinkedHashMap<String, IConfiguration> loadedConfigs = new LinkedHashMap<String, IConfiguration>();
        if (!this.mConfigPaths.isEmpty()) {
            LogUtil.CLog.d("Loading the specified configs path '%s' and skip loading from the resources.", this.mConfigPaths);
            return this.getModuleLoader().loadConfigsFromSpecifiedPaths(this.mConfigPaths, abis, suiteTag);
        }
        if (!this.mSkipJarLoading) {
            loadedConfigs.putAll(this.getModuleLoader().loadConfigsFromJars(abis, suitePrefix, suiteTag));
        }
        if (this.mConfigPatterns.isEmpty()) {
            this.mConfigPatterns.add(".*\\.config$");
            this.mConfigPatterns.add(".*\\.xml$");
        }
        loadedConfigs.putAll(this.getModuleLoader().loadConfigsFromDirectory(testsDirs, abis, suitePrefix, suiteTag, this.mConfigPatterns));
        return loadedConfigs;
    }

    @Override
    public void setBuild(IBuildInfo buildInfo) {
        super.setBuild(buildInfo);
    }

    public void setIncludeFilter(Set<String> includeFilters) {
        this.mIncludeFilters.addAll(includeFilters);
    }

    public Set<String> getIncludeFilter() {
        return new LinkedHashSet<String>(this.mIncludeFilters);
    }

    public void clearIncludeFilter() {
        this.mIncludeFilters.clear();
    }

    public void setExcludeFilter(Set<String> excludeFilters) {
        this.mExcludeFilters.addAll(excludeFilters);
    }

    public void clearExcludeFilter() {
        this.mExcludeFilters.clear();
    }

    public Set<String> getExcludeFilter() {
        return new HashSet<String>(this.mExcludeFilters);
    }

    public SuiteModuleLoader getModuleLoader() {
        return this.mModuleRepo;
    }

    public void reevaluateFilters() {
        SuiteModuleLoader.addFilters(this.mIncludeFilters, this.mIncludeFiltersParsed, this.mAbis, this.mFoldableStates);
        SuiteModuleLoader.addFilters(this.mExcludeFilters, this.mExcludeFiltersParsed, this.mAbis, this.mFoldableStates);
        if (this.getDirectModule() != null) {
            this.mExcludeFiltersParsed.keySet().removeIf(key -> !key.equals(this.getDirectModule().getId()));
            for (String filterString : new HashSet<String>(this.mExcludeFilters)) {
                SuiteTestFilter parentFilter = SuiteTestFilter.createFrom(filterString);
                if (parentFilter.getModuleId().equals(this.getDirectModule().getId())) continue;
                this.mExcludeFilters.remove(filterString);
            }
        }
    }

    public void addModuleArgs(Set<String> moduleArgs) {
        this.mModuleArgs.addAll(moduleArgs);
    }

    void clearModuleArgs() {
        this.mModuleArgs.clear();
    }

    public void addConfigPatterns(List<String> patterns) {
        this.mConfigPatterns.addAll(patterns);
    }

    public void setEnableParameterizedModules(boolean enableParameter) {
        this.mEnableParameter = enableParameter;
    }

    public void setEnableOptionalParameterizedModules(boolean enableOptionalParameter) {
        this.mEnableOptionalParameter = enableOptionalParameter;
    }

    public void setModuleParameter(ModuleParameters forceParameter) {
        this.mForceParameter = forceParameter;
    }

    public SuiteModuleLoader createModuleLoader(Map<String, LinkedHashSet<SuiteTestFilter>> includeFiltersFormatted, Map<String, LinkedHashSet<SuiteTestFilter>> excludeFiltersFormatted, List<String> testArgs, List<String> moduleArgs) {
        return new SuiteModuleLoader(includeFiltersFormatted, excludeFiltersFormatted, testArgs, moduleArgs);
    }

    protected void setupFilters(File testsDir) throws FileNotFoundException {
        if (this.mModuleName == null) {
            if (this.mTestName != null) {
                throw new IllegalArgumentException("Test name given without module name. Add --module <module-name>");
            }
            return;
        }
        Set<File> modules = SuiteModuleLoader.getModuleNamesMatching(testsDir, this.mSuitePrefix, String.format(".*%s.*.config", this.mModuleName));
        if (modules.size() > 1) {
            HashSet<File> newModules = new HashSet<File>();
            String exactModuleName = String.format("%s.config", this.mModuleName);
            for (File module : modules) {
                if (!module.getName().equals(exactModuleName)) continue;
                newModules.add(module);
                modules = newModules;
                break;
            }
        }
        if (modules.size() == 0) {
            throw new HarnessRuntimeException(String.format("No modules found matching %s", this.mModuleName), InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        if (modules.size() > 1) {
            throw new HarnessRuntimeException(String.format("Multiple modules found matching %s:\n%s\nWhich one did you mean?\n", this.mModuleName, ArrayUtil.join("\n", modules)), InfraErrorIdentifier.OPTION_CONFIGURATION_ERROR);
        }
        File mod = modules.iterator().next();
        String moduleName = mod.getName().replace(".config", "");
        BaseTestSuite.checkFilters(this.mIncludeFilters, moduleName);
        BaseTestSuite.checkFilters(this.mExcludeFilters, moduleName);
        this.mIncludeFilters.add(new SuiteTestFilter(this.getRequestedAbi(), moduleName, this.mTestName).toString());
        if (this.mEnableParameter) {
            for (ModuleParameters param : ModuleParameters.values()) {
                Map<ModuleParameters, IModuleParameterHandler> moduleParamExpanded = ModuleParametersHelper.resolveParam(param, this.mEnableOptionalParameter);
                if (moduleParamExpanded == null) continue;
                for (Map.Entry<ModuleParameters, IModuleParameterHandler> moduleParam : moduleParamExpanded.entrySet()) {
                    if (moduleParam.getValue() instanceof NegativeHandler) continue;
                    if (moduleParam.getValue() instanceof FoldableExpandingHandler) {
                        List<IModuleParameterHandler> foldableHandlers = ((FoldableExpandingHandler)moduleParam.getValue()).expandHandler(this.mFoldableStates);
                        for (IModuleParameterHandler foldableHandler : foldableHandlers) {
                            String paramModuleName = String.format("%s[%s]", moduleName, foldableHandler.getParameterIdentifier());
                            this.mIncludeFilters.add(new SuiteTestFilter(this.getRequestedAbi(), paramModuleName, this.mTestName).toString());
                        }
                        continue;
                    }
                    String paramModuleName = String.format("%s[%s]", moduleName, moduleParam.getValue().getParameterIdentifier());
                    this.mIncludeFilters.add(new SuiteTestFilter(this.getRequestedAbi(), paramModuleName, this.mTestName).toString());
                }
            }
        }
    }

    @Override
    public void cleanUpSuiteSetup() {
        super.cleanUpSuiteSetup();
        this.mIncludeFilters.clear();
        this.mExcludeFilters.clear();
        this.mIncludeFiltersParsed.clear();
        this.mExcludeFiltersParsed.clear();
    }

    void addConfigPaths(File configPath) {
        this.mConfigPaths.add(configPath);
    }

    void clearConfigPaths() {
        this.mConfigPaths.clear();
    }

    private static void checkFilters(Set<String> filters, String moduleName) {
        HashSet<String> cleanedFilters = new HashSet<String>();
        for (String filter : filters) {
            SuiteTestFilter filterObject = SuiteTestFilter.createFrom(filter);
            String filterName = filterObject.getName();
            String filterBaseName = filterObject.getBaseName();
            if (!moduleName.equals(filterName) && !moduleName.equals(filterBaseName)) continue;
            cleanedFilters.add(filter);
        }
        filters.clear();
        filters.addAll(cleanedFilters);
    }

    boolean getPrioritizeHostConfig() {
        return this.mPrioritizeHostConfig;
    }

    @VisibleForTesting
    protected void setPrioritizeHostConfig(boolean prioritizeHostConfig) {
        this.mPrioritizeHostConfig = prioritizeHostConfig;
    }

    private void logFilterFile(File filterFile, String dataName, LogDataType type) {
        if (this.getCurrentTestLogger() == null) {
            return;
        }
        try (FileInputStreamSource source = new FileInputStreamSource(filterFile);){
            this.getCurrentTestLogger().testLog(dataName, type, source);
        }
    }

    @Override
    protected boolean shouldModuleRun(ModuleDefinition module) {
        String moduleId = module.getId();
        LinkedHashSet<SuiteTestFilter> excludeFilters = this.mExcludeFiltersParsed.get(moduleId);
        LogUtil.CLog.d("Filters for '%s': %s", moduleId, excludeFilters);
        if (excludeFilters == null || excludeFilters.isEmpty()) {
            return true;
        }
        for (SuiteTestFilter filter : excludeFilters) {
            if (filter.getTest() == null) {
                LogUtil.CLog.d("Skipping %s, it previously passed.", moduleId);
                return false;
            }
            for (IRemoteTest test : module.getTests()) {
                if (test instanceof ITestFileFilterReceiver) {
                    File excludeFilterFile = ((ITestFileFilterReceiver)((Object)test)).getExcludeTestFile();
                    if (excludeFilterFile == null) {
                        try {
                            excludeFilterFile = FileUtil.createTempFile(EXCLUDE_FILTER_OPTION, ".txt");
                        }
                        catch (IOException e) {
                            throw new HarnessRuntimeException(e.getMessage(), e, InfraErrorIdentifier.FAIL_TO_CREATE_FILE);
                        }
                        ((ITestFileFilterReceiver)((Object)test)).setExcludeTestFile(excludeFilterFile);
                    }
                    try {
                        FileUtil.writeToFile(filter.getTest() + "\n", excludeFilterFile, true);
                    }
                    catch (IOException e) {
                        LogUtil.CLog.e(e);
                    }
                    continue;
                }
                if (!(test instanceof ITestFilterReceiver)) continue;
                ((ITestFilterReceiver)((Object)test)).addExcludeFilter(filter.getTest());
            }
        }
        return true;
    }

    protected Set<DeviceFoldableState> getFoldableStates(ITestDevice device) throws DeviceNotAvailableException {
        if (device == null || device.getIDevice() instanceof StubDevice) {
            return this.mFoldableStates;
        }
        if (!this.mFoldableStates.isEmpty()) {
            return this.mFoldableStates;
        }
        this.mFoldableStates = device.getFoldableStates();
        return this.mFoldableStates;
    }

    public String getRunSuiteTag() {
        return this.mSuiteTag;
    }
}

