/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite;

import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.config.ConfigurationDescriptor;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.metric.CollectorHelper;
import com.android.tradefed.device.metric.CountTestCasesCollector;
import com.android.tradefed.device.metric.IMetricCollector;
import com.android.tradefed.device.metric.IMetricCollectorReceiver;
import com.android.tradefed.error.IHarnessException;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ILogSaver;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ResultAndLogForwarder;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.retry.IRetryDecision;
import com.android.tradefed.retry.MergeStrategy;
import com.android.tradefed.retry.RetryLogSaverResultForwarder;
import com.android.tradefed.retry.RetryStatistics;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestCollector;
import com.android.tradefed.testtype.suite.ModuleDefinition;
import com.android.tradefed.testtype.suite.ModuleListener;
import com.android.tradefed.testtype.suite.RemoteTestTimeOutEnforcer;
import com.android.tradefed.testtype.suite.TestFailureListener;
import com.android.tradefed.util.StreamUtil;
import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GranularRetriableTestWrapper
implements IRemoteTest,
ITestCollector {
    private IRetryDecision mRetryDecision;
    private IRemoteTest mTest;
    private ModuleDefinition mModule;
    private List<IMetricCollector> mRunMetricCollectors;
    private TestFailureListener mFailureListener;
    private IInvocationContext mModuleInvocationContext;
    private IConfiguration mModuleConfiguration;
    private ModuleListener mMainGranularRunListener;
    private RetryLogSaverResultForwarder mRetryAttemptForwarder;
    private List<ITestInvocationListener> mModuleLevelListeners;
    private ITestInvocationListener mRemoteTestTimeOutEnforcer;
    private ILogSaver mLogSaver;
    private String mModuleId;
    private int mMaxRunLimit;
    private boolean mCollectTestsOnly = false;
    private RetryStatistics mRetryStats = null;
    private int mCountRetryUsed = 0;

    public GranularRetriableTestWrapper(IRemoteTest test, ITestInvocationListener mainListener, TestFailureListener failureListener, List<ITestInvocationListener> moduleLevelListeners, int maxRunLimit) {
        this(test, null, mainListener, failureListener, moduleLevelListeners, maxRunLimit);
    }

    public GranularRetriableTestWrapper(IRemoteTest test, ModuleDefinition module, ITestInvocationListener mainListener, TestFailureListener failureListener, List<ITestInvocationListener> moduleLevelListeners, int maxRunLimit) {
        this.mTest = test;
        this.mModule = module;
        IInvocationContext context = null;
        if (module != null) {
            context = module.getModuleInvocationContext();
        }
        this.initializeGranularRunListener(mainListener, context);
        this.mFailureListener = failureListener;
        this.mModuleLevelListeners = moduleLevelListeners;
        this.mMaxRunLimit = maxRunLimit;
    }

    public void setRetryDecision(IRetryDecision decision) {
        this.mRetryDecision = decision;
    }

    public void setModuleId(String moduleId) {
        this.mModuleId = moduleId;
    }

    public void setMarkTestsSkipped(boolean skipTestCases) {
        this.mMainGranularRunListener.setMarkTestsSkipped(skipTestCases);
    }

    public void setMetricCollectors(List<IMetricCollector> runMetricCollectors) {
        this.mRunMetricCollectors = runMetricCollectors;
    }

    public void setModuleConfig(IConfiguration moduleConfiguration) {
        this.mModuleConfiguration = moduleConfiguration;
    }

    public void setInvocationContext(IInvocationContext moduleInvocationContext) {
        this.mModuleInvocationContext = moduleInvocationContext;
    }

    public void setLogSaver(ILogSaver logSaver) {
        this.mLogSaver = logSaver;
    }

    private void initializeGranularRunListener(ITestInvocationListener listener, IInvocationContext moduleContext) {
        this.mMainGranularRunListener = new ModuleListener(listener, moduleContext);
        if (this.mModule != null) {
            List<String> testMappingSources;
            ConfigurationDescriptor configDesc = this.mModule.getModuleInvocationContext().getConfigurationDescriptor();
            if (configDesc.getMetaData("remote-test-timeout") != null) {
                Duration duration = Duration.parse(configDesc.getMetaData("remote-test-timeout").get(0));
                this.mRemoteTestTimeOutEnforcer = new RemoteTestTimeOutEnforcer(this.mMainGranularRunListener, this.mModule, this.mTest, duration);
            }
            if ((testMappingSources = configDesc.getMetaData(Integer.toString(this.mTest.hashCode()))) != null) {
                this.mMainGranularRunListener.setTestMappingSources(testMappingSources);
            }
        }
    }

    private ITestInvocationListener initializeListeners() throws DeviceNotAvailableException {
        ArrayList<ITestInvocationListener> currentTestListener = new ArrayList<ITestInvocationListener>();
        if (this.mModuleLevelListeners != null) {
            currentTestListener.addAll(this.mModuleLevelListeners);
        }
        currentTestListener.add(this.mMainGranularRunListener);
        if (this.mRemoteTestTimeOutEnforcer != null) {
            currentTestListener.add(this.mRemoteTestTimeOutEnforcer);
        }
        ITestInvocationListener runListener = this.mRetryAttemptForwarder = new RetryLogSaverResultForwarder(this.mLogSaver, currentTestListener);
        if (this.mFailureListener != null) {
            this.mFailureListener.setLogger(this.mRetryAttemptForwarder);
            currentTestListener.add(this.mFailureListener);
        }
        for (IMetricCollector collector : CollectorHelper.cloneCollectors(this.mModuleConfiguration.getMetricCollectors())) {
            if (collector.isDisabled()) {
                LogUtil.CLog.d("%s has been disabled. Skipping.", collector);
                continue;
            }
            try (CloseableTraceScope ignored = new CloseableTraceScope("init_attempt_" + collector.getClass().getSimpleName());){
                if (collector instanceof IConfigurationReceiver) {
                    ((IConfigurationReceiver)((Object)collector)).setConfiguration(this.mModuleConfiguration);
                }
                runListener = collector.init(this.mModuleInvocationContext, runListener);
            }
        }
        return runListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        this.mMainGranularRunListener.setCollectTestsOnly(this.mCollectTestsOnly);
        ITestInvocationListener allListeners = this.initializeListeners();
        DeviceNotAvailableException dnae = this.intraModuleRun(testInfo, allListeners, 0);
        if (!(this.mMaxRunLimit > 1 || dnae != null && this.mModule.shouldRecoverVirtualDevice())) {
            if (dnae != null) {
                throw dnae;
            }
            return;
        }
        if (this.mRetryDecision == null) {
            LogUtil.CLog.e("RetryDecision is null. Something is misconfigured this shouldn't happen");
            return;
        }
        if (!this.mRetryDecision.shouldRetry(this.mTest, this.mModule, 0, this.mMainGranularRunListener.getTestRunForAttempts(0), dnae)) {
            return;
        }
        boolean firstCheck = true;
        long startTime = System.currentTimeMillis();
        try {
            LogUtil.CLog.d("Starting intra-module retry.");
            for (int attemptNumber = 1; attemptNumber < this.mMaxRunLimit; ++attemptNumber) {
                boolean retry;
                if (!firstCheck && !(retry = this.mRetryDecision.shouldRetry(this.mTest, this.mModule, attemptNumber - 1, this.mMainGranularRunListener.getTestRunForAttempts(attemptNumber - 1), dnae))) {
                    return;
                }
                firstCheck = false;
                ++this.mCountRetryUsed;
                LogUtil.CLog.d("Intra-module retry attempt number %s", attemptNumber);
                dnae = this.intraModuleRun(testInfo, allListeners, attemptNumber);
            }
            this.mRetryDecision.addLastAttempt(this.mMainGranularRunListener.getTestRunForAttempts(this.mMaxRunLimit - 1));
        }
        finally {
            this.mRetryStats = this.mRetryDecision.getRetryStatistics();
            this.mRetryStats.mRetryTime = System.currentTimeMillis() - startTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DeviceNotAvailableException intraModuleRun(TestInformation testInfo, ITestInvocationListener runListener, int attempt) {
        DeviceNotAvailableException exception = null;
        this.mMainGranularRunListener.setAttemptIsolation(CurrentInvocation.runCurrentIsolation());
        StartEndCollector startEndCollector = new StartEndCollector(runListener);
        runListener = startEndCollector;
        try (CloseableTraceScope ignored = new CloseableTraceScope("attempt " + attempt + " " + this.mTest.getClass().getCanonicalName());){
            List<IMetricCollector> clonedCollectors = this.cloneCollectors(this.mRunMetricCollectors);
            if (this.mTest instanceof IMetricCollectorReceiver) {
                ((IMetricCollectorReceiver)((Object)this.mTest)).setMetricCollectors(clonedCollectors);
                this.mTest.run(testInfo, runListener);
            } else {
                if (this.mModuleConfiguration.getCommandOptions().reportTestCaseCount()) {
                    CountTestCasesCollector counter = new CountTestCasesCollector(this.mTest);
                    clonedCollectors.add(counter);
                }
                for (IMetricCollector collector : clonedCollectors) {
                    if (collector.isDisabled()) {
                        LogUtil.CLog.d("%s has been disabled. Skipping.", collector);
                        continue;
                    }
                    try (CloseableTraceScope ignoreCollector = new CloseableTraceScope("init_run_" + collector.getClass().getSimpleName());){
                        if (collector instanceof IConfigurationReceiver) {
                            ((IConfigurationReceiver)((Object)collector)).setConfiguration(this.mModuleConfiguration);
                        }
                        runListener = collector.init(this.mModuleInvocationContext, runListener);
                    }
                }
                this.mTest.run(testInfo, runListener);
            }
        }
        catch (AssertionError | RuntimeException re) {
            LogUtil.CLog.e("Module '%s' - test '%s' threw exception:", this.mModuleId, this.mTest.getClass());
            LogUtil.CLog.e((Throwable)re);
            LogUtil.CLog.e("Proceeding to the next test.");
            if (!startEndCollector.mRunStartReported) {
                LogUtil.CLog.e("Event mismatch ! the test runner didn't report any testRunStart.");
                runListener.testRunStarted(this.mModule.getId(), 0);
            }
            runListener.testRunFailed(this.createFromException((Throwable)re));
            if (!startEndCollector.mRunEndedReported) {
                LogUtil.CLog.e("Event mismatch ! the test runner didn't report any testRunEnded.");
                runListener.testRunEnded(0L, new HashMap<String, MetricMeasurement.Metric>());
            }
        }
        catch (DeviceUnresponsiveException due) {
            LogUtil.CLog.w("Ignored DeviceUnresponsiveException because recovery was successful, proceeding with next module. Stack trace:");
            LogUtil.CLog.w(due);
            LogUtil.CLog.w("Proceeding to the next test.");
            if (!this.mMainGranularRunListener.hasLastAttemptFailed()) {
                runListener.testRunFailed(this.createFromException(due));
            }
        }
        catch (DeviceNotAvailableException dnae) {
            LogUtil.CLog.e("Run in progress was not completed due to:");
            LogUtil.CLog.e(dnae);
            if (!this.mMainGranularRunListener.hasLastAttemptFailed()) {
                runListener.testRunFailed(this.createFromException(dnae));
            }
            exception = dnae;
        }
        finally {
            this.mRetryAttemptForwarder.incrementAttempt();
            CurrentInvocation.setRunIsolation(CurrentInvocation.IsolationGrade.NOT_ISOLATED);
        }
        return exception;
    }

    public final List<TestRunResult> getFinalTestRunResults() {
        MergeStrategy strategy = MergeStrategy.getMergeStrategy(this.mRetryDecision.getRetryStrategy());
        this.mMainGranularRunListener.setMergeStrategy(strategy);
        return this.mMainGranularRunListener.getMergedTestRunResults();
    }

    @VisibleForTesting
    Map<String, List<TestRunResult>> getTestRunResultCollected() {
        LinkedHashMap<String, List<TestRunResult>> runResultMap = new LinkedHashMap<String, List<TestRunResult>>();
        for (String runName : this.mMainGranularRunListener.getTestRunNames()) {
            runResultMap.put(runName, this.mMainGranularRunListener.getTestRunAttempts(runName));
        }
        return runResultMap;
    }

    @VisibleForTesting
    List<IMetricCollector> cloneCollectors(List<IMetricCollector> originalCollectors) {
        return CollectorHelper.cloneCollectors(originalCollectors);
    }

    public final int getExpectedTestsCount() {
        return this.mMainGranularRunListener.getExpectedTests();
    }

    public final Set<TestDescription> getPassedTests() {
        LinkedHashSet<TestDescription> nonFailedTests = new LinkedHashSet<TestDescription>();
        for (TestRunResult runResult : this.mMainGranularRunListener.getMergedTestRunResults()) {
            nonFailedTests.addAll(runResult.getTestsInState(Arrays.asList(TestResult.TestStatus.PASSED, TestResult.TestStatus.IGNORED, TestResult.TestStatus.ASSUMPTION_FAILURE)));
        }
        return nonFailedTests;
    }

    public ModuleListener getResultListener() {
        return this.mMainGranularRunListener;
    }

    public int getRetryCount() {
        return this.mCountRetryUsed;
    }

    @Override
    public void setCollectTestsOnly(boolean shouldCollectTest) {
        this.mCollectTestsOnly = shouldCollectTest;
    }

    private FailureDescription createFromException(Throwable exception) {
        String message2 = exception.getMessage() == null ? String.format("No error message reported for: %s", StreamUtil.getStackTrace(exception)) : exception.getMessage();
        FailureDescription failure = CurrentInvocation.createFailure(message2, null).setCause(exception);
        if (exception instanceof IHarnessException) {
            ErrorIdentifier id = ((IHarnessException)((Object)exception)).getErrorId();
            failure.setErrorIdentifier(id);
            if (id != null) {
                failure.setFailureStatus(id.status());
            }
            failure.setOrigin(((IHarnessException)((Object)exception)).getOrigin());
        }
        return failure;
    }

    public class StartEndCollector
    extends ResultAndLogForwarder {
        public boolean mRunStartReported;
        public boolean mRunEndedReported;

        StartEndCollector(ITestInvocationListener listener) {
            super(listener);
            this.mRunStartReported = false;
            this.mRunEndedReported = false;
        }

        @Override
        public void testRunStarted(String runName, int testCount) {
            super.testRunStarted(runName, testCount);
            this.mRunStartReported = true;
        }

        @Override
        public void testRunStarted(String runName, int testCount, int attemptNumber) {
            super.testRunStarted(runName, testCount, attemptNumber);
            this.mRunStartReported = true;
        }

        @Override
        public void testRunStarted(String runName, int testCount, int attemptNumber, long startTime) {
            super.testRunStarted(runName, testCount, attemptNumber, startTime);
            this.mRunStartReported = true;
        }

        @Override
        public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
            super.testRunEnded(elapsedTime, runMetrics);
            this.mRunEndedReported = true;
        }

        @Override
        public void testRunEnded(long elapsedTimeMillis, Map<String, String> runMetrics) {
            super.testRunEnded(elapsedTimeMillis, runMetrics);
            this.mRunEndedReported = true;
        }
    }
}

