/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite;

import com.android.ddmlib.Log;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.DynamicRemoteFileResolver;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.NullDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.device.cloud.NestedRemoteDevice;
import com.android.tradefed.device.metric.CollectorHelper;
import com.android.tradefed.device.metric.IMetricCollector;
import com.android.tradefed.device.metric.IMetricCollectorReceiver;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.error.IHarnessException;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.logger.TfObjectTracker;
import com.android.tradefed.invoker.shard.token.ITokenRequest;
import com.android.tradefed.invoker.shard.token.TokenProperty;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ITestLoggerReceiver;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.result.error.TestErrorIdentifier;
import com.android.tradefed.retry.IRetryDecision;
import com.android.tradefed.retry.RetryStrategy;
import com.android.tradefed.service.TradefedFeatureClient;
import com.android.tradefed.suite.checker.ISystemStatusChecker;
import com.android.tradefed.suite.checker.ISystemStatusCheckerReceiver;
import com.android.tradefed.suite.checker.StatusCheckerResult;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.testtype.Abi;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IReportNotExecuted;
import com.android.tradefed.testtype.IRuntimeHintProvider;
import com.android.tradefed.testtype.IShardableTest;
import com.android.tradefed.testtype.ITestCollector;
import com.android.tradefed.testtype.suite.ModuleDefinition;
import com.android.tradefed.testtype.suite.ModuleSplitter;
import com.android.tradefed.testtype.suite.TestFailureListener;
import com.android.tradefed.testtype.suite.TestSuiteInfo;
import com.android.tradefed.testtype.suite.ValidateSuiteConfigHelper;
import com.android.tradefed.util.AbiFormatter;
import com.android.tradefed.util.AbiUtils;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.TimeUtil;
import com.google.common.collect.ImmutableSet;
import com.proto.tradefed.feature.FeatureResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class ITestSuite
implements IRemoteTest,
IDeviceTest,
IBuildReceiver,
ISystemStatusCheckerReceiver,
IShardableTest,
ITestCollector,
IInvocationContextReceiver,
IRuntimeHintProvider,
IMetricCollectorReceiver,
IConfigurationReceiver,
IReportNotExecuted,
ITokenRequest,
ITestLoggerReceiver {
    public static final String MODULE_START_TIME = "MODULE_START_TIME";
    public static final String MODULE_END_TIME = "MODULE_END_TIME";
    public static final String SKIP_SYSTEM_STATUS_CHECKER = "skip-system-status-check";
    public static final String RUNNER_WHITELIST = "runner-whitelist";
    public static final String PREPARER_WHITELIST = "preparer-whitelist";
    public static final String MODULE_CHECKER_PRE = "PreModuleChecker";
    public static final String MODULE_CHECKER_POST = "PostModuleChecker";
    public static final String ABI_OPTION = "abi";
    public static final String SKIP_HOST_ARCH_CHECK = "skip-host-arch-check";
    public static final String PRIMARY_ABI_RUN = "primary-abi-only";
    public static final String PARAMETER_KEY = "parameter";
    public static final String MAINLINE_PARAMETER_KEY = "mainline-param";
    public static final String ACTIVE_MAINLINE_PARAMETER_KEY = "active-mainline-parameter";
    public static final String TOKEN_KEY = "token";
    public static final String MODULE_METADATA_INCLUDE_FILTER = "module-metadata-include-filter";
    public static final String MODULE_METADATA_EXCLUDE_FILTER = "module-metadata-exclude-filter";
    public static final String RANDOM_SEED = "random-seed";
    public static final String SKIP_STAGING_ARTIFACTS = "skip-staging-artifacts";
    private static final String PRODUCT_CPU_ABI_KEY = "ro.product.cpu.abi";
    private static final Set<String> ALLOWED_PREPARERS_CONFIGS = ImmutableSet.of("/suite/allowed-preparers.txt", "/suite/google-allowed-preparers.txt");
    @Option(name="bugreport-on-failure", description="Take a bugreport on every test failure. Warning: This may require a lotof storage space of the machine running the tests.")
    private boolean mBugReportOnFailure = false;
    @Deprecated
    @Option(name="logcat-on-failure", description="Take a logcat snapshot on every test failure.")
    private boolean mLogcatOnFailure = false;
    @Deprecated
    @Option(name="logcat-on-failure-size", description="The max number of logcat data in bytes to capture when --logcat-on-failure is on. Should be an amount that can comfortably fit in memory.")
    private int mMaxLogcatBytes = 512000;
    @Deprecated
    @Option(name="screenshot-on-failure", description="Take a screenshot on every test failure.")
    private boolean mScreenshotOnFailure = false;
    @Option(name="reboot-on-failure", description="Reboot the device after every test failure.")
    private boolean mRebootOnFailure = false;
    @Option(name="reboot-per-module", description="Reboot the device before every module run.")
    private boolean mRebootPerModule = false;
    @Option(name="skip-all-system-status-check", description="Whether all system status check between modules should be skipped")
    private boolean mSkipAllSystemStatusCheck = false;
    @Option(name="skip-system-status-check", description="Disable specific system status checkers.Specify zero or more SystemStatusChecker as canonical class names. e.g. \"com.android.tradefed.suite.checker.KeyguardStatusChecker\" If not specified, all configured or whitelisted system status checkers will run.")
    private Set<String> mSystemStatusCheckBlacklist = new HashSet<String>();
    @Option(name="report-system-checkers", description="Whether reporting system checkers as test or not.")
    private boolean mReportSystemChecker = false;
    @Option(name="random-order", description="Whether randomizing the order of the modules to be ran or not.")
    private boolean mRandomOrder = false;
    @Option(name="random-seed", description="Seed to randomize the order of the modules.")
    private long mRandomSeed = -1L;
    @Option(name="collect-tests-only", description="Only invoke the suite to collect list of applicable test cases. All test run callbacks will be triggered, but test execution will not be actually carried out.")
    private boolean mCollectTestsOnly = false;
    @Option(name="abi", shortName=97, description="the abi to test. For example: 'arm64-v8a'.", importance=Option.Importance.IF_UNSET)
    private String mAbiName = null;
    @Option(name="skip-host-arch-check", description="Whether host architecture check should be skipped.")
    private boolean mSkipHostArchCheck = false;
    @Option(name="primary-abi-only", description="Whether to run tests with only the device primary abi. This is overriden by the --abi option.")
    private boolean mPrimaryAbiRun = false;
    @Option(name="module-metadata-include-filter", description="Include modules for execution based on matching of metadata fields: for any of the specified filter name and value, if a module has a metadata field with the same name and value, it will be included. When both module inclusion and exclusion rules are applied, inclusion rules will be evaluated first. Using this together with test filter inclusion rules may result in no tests to execute if the rules don't overlap.")
    private MultiMap<String, String> mModuleMetadataIncludeFilter = new MultiMap();
    @Option(name="module-metadata-exclude-filter", description="Exclude modules for execution based on matching of metadata fields: for any of the specified filter name and value, if a module has a metadata field with the same name and value, it will be excluded. When both module inclusion and exclusion rules are applied, inclusion rules will be evaluated first.")
    private MultiMap<String, String> mModuleMetadataExcludeFilter = new MultiMap();
    @Option(name="runner-whitelist", description="Runner class(es) that are allowed to run.")
    private Set<String> mAllowedRunners = new HashSet<String>();
    @Option(name="preparer-whitelist", description="Preparer class(es) that are allowed to run. This mostly usefeul for dry-runs.")
    private Set<String> mAllowedPreparers = new HashSet<String>();
    @Option(name="enable-module-dynamic-download", description="Whether or not to allow the downloading of dynamic @option files at module level.")
    private boolean mEnableDynamicDownload = false;
    @Option(name="intra-module-sharding", description="Whether or not to allow intra-module sharding.")
    private boolean mIntraModuleSharding = true;
    @Option(name="isolated-module", description="Whether or not to attempt the module isolation between modules")
    private boolean mIsolatedModule = false;
    @Option(name="recover-device-by-cvd", description="Try to recover the device by cvd tool when the device is gone during test running.")
    protected boolean mRecoverDeviceByCvd = false;
    @Deprecated
    @Option(name="retry-strategy", description="The retry strategy to be used when re-running some tests with --max-testcase-run-count")
    private RetryStrategy mRetryStrategy = RetryStrategy.NO_RETRY;
    @Option(name="merge-attempts", description="Whether or not to use the merge the results of the different attempts.")
    private boolean mMergeAttempts = true;
    @Option(name="partial-download-via-feature", description="Feature flag to test partial download via feature service.")
    private boolean mStageArtifactsViaFeature = true;
    @Option(name="skip-staging-artifacts", description="Skip staging artifacts with remote-files if already staged.")
    private boolean mSkipStagingArtifacts = false;
    @Option(name="multi-devices-modules", description="Running strategy for modules that require multiple devices.")
    private MultiDeviceModuleStrategy mMultiDevicesStrategy = MultiDeviceModuleStrategy.EXCLUDE_ALL;
    private ITestDevice mDevice;
    private IBuildInfo mBuildInfo;
    private List<ISystemStatusChecker> mSystemStatusCheckers;
    private IInvocationContext mContext;
    private List<IMetricCollector> mMetricCollectors;
    private IConfiguration mMainConfiguration;
    private Set<IAbi> mAbis = new LinkedHashSet<IAbi>();
    private boolean mIsSharded = false;
    private ModuleDefinition mDirectModule = null;
    private boolean mShouldMakeDynamicModule = true;
    private List<ModuleDefinition> mRunModules = null;
    private ModuleDefinition mModuleInProgress = null;
    private ITestLogger mCurrentLogger = null;
    private boolean mIsSplitting = false;
    private boolean mDisableAutoRetryTimeReporting = false;
    private DynamicRemoteFileResolver mDynamicResolver = new DynamicRemoteFileResolver();

    void setDynamicResolver(DynamicRemoteFileResolver resolver) {
        this.mDynamicResolver = resolver;
    }

    public void setDirectModule(ModuleDefinition module) {
        this.mDirectModule = module;
        this.mIsSharded = true;
    }

    public abstract LinkedHashMap<String, IConfiguration> loadTests();

    private ITestSuite createInstance() {
        try {
            return (ITestSuite)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public File getTestsDir() throws FileNotFoundException {
        IBuildInfo build = this.getBuildInfo();
        File testsDir = null;
        if (build instanceof IDeviceBuildInfo) {
            testsDir = ((IDeviceBuildInfo)build).getTestsDir();
        }
        if (testsDir != null && testsDir.exists()) {
            return testsDir;
        }
        throw new FileNotFoundException("Could not found a tests dir folder.");
    }

    private LinkedHashMap<String, IConfiguration> loadAndFilter() {
        LinkedHashMap<String, IConfiguration> runConfig = this.loadTests();
        if (runConfig.isEmpty()) {
            LogUtil.CLog.i("No config were loaded. Nothing to run.");
            return runConfig;
        }
        HashSet<String> moduleNames = new HashSet<String>();
        LinkedHashMap<String, IConfiguration> filteredConfig = new LinkedHashMap<String, IConfiguration>();
        block4: for (Map.Entry<String, IConfiguration> config : runConfig.entrySet()) {
            if ((!this.mModuleMetadataIncludeFilter.isEmpty() || !this.mModuleMetadataExcludeFilter.isEmpty()) && !this.filterByConfigMetadata(config.getValue(), this.mModuleMetadataIncludeFilter, this.mModuleMetadataExcludeFilter) || !this.filterByRunnerType(config.getValue(), this.mAllowedRunners)) continue;
            switch (this.mMultiDevicesStrategy) {
                case EXCLUDE_ALL: {
                    if (config.getValue().getDeviceConfig().size() <= 1) break;
                    continue block4;
                }
                case ONLY_MULTI_DEVICES: {
                    if (config.getValue().getDeviceConfig().size() != 1) break;
                    continue block4;
                }
            }
            this.filterPreparers(config.getValue(), this.mAllowedPreparers);
            if (this.mMainConfiguration != null) {
                config.getValue().setCoverageOptions(this.mMainConfiguration.getCoverageOptions());
            }
            filteredConfig.put(config.getKey(), config.getValue());
            moduleNames.add(config.getValue().getConfigurationDescription().getModuleName());
        }
        if (this.mBuildInfo != null && this.mBuildInfo.getRemoteFiles() != null && !this.mBuildInfo.getRemoteFiles().isEmpty()) {
            this.stageTestArtifacts(this.mDevice, moduleNames);
        }
        runConfig.clear();
        return filteredConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stageTestArtifacts(ITestDevice device, Set<String> modules) {
        long startTime;
        block21: {
            if (this.mBuildInfo.getRemoteFiles().isEmpty()) {
                return;
            }
            if (this.mSkipStagingArtifacts || this.mBuildInfo.getBuildAttributes().get(SKIP_STAGING_ARTIFACTS) != null) {
                LogUtil.CLog.d("skip-staging-artifacts is set. Skipping #stageTestArtifacts");
                return;
            }
            LogUtil.CLog.i(String.format("Start to stage test artifacts for %d modules.", modules.size()));
            startTime = System.currentTimeMillis();
            try (CloseableTraceScope ignored = new CloseableTraceScope(InvocationMetricLogger.InvocationMetricKey.stage_suite_test_artifacts.toString());){
                String moduleRegex = modules.stream().map(m -> String.format("/%s/", m)).collect(Collectors.joining("|"));
                List<String> includeFilters = Arrays.asList(moduleRegex);
                List<String> excludeFilters = Arrays.asList("[.]config$");
                if (this.mStageArtifactsViaFeature) {
                    try (TradefedFeatureClient client = new TradefedFeatureClient();){
                        HashMap<String, String> args = new HashMap<String, String>();
                        String destination = this.getTestsDir().getAbsolutePath();
                        if (this.mBuildInfo.getBuildAttributes().containsKey("ROOT_DIR")) {
                            destination = this.mBuildInfo.getBuildAttributes().get("ROOT_DIR");
                        }
                        LogUtil.CLog.d("downloading to destination: %s the following include_filters: %s", destination, includeFilters);
                        args.put("destination_dir", destination);
                        args.put("include_filters", String.join((CharSequence)";", includeFilters));
                        args.put("exclude_filters", String.join((CharSequence)";", excludeFilters));
                        String remotePaths = this.mBuildInfo.getRemoteFiles().stream().map(p -> p.toString()).collect(Collectors.joining(";"));
                        args.put("remote_paths", remotePaths);
                        FeatureResponse rep = client.triggerFeature("resolvePartialDownload", args);
                        if (rep.hasErrorInfo()) {
                            throw new HarnessRuntimeException(rep.getErrorInfo().getErrorTrace(), InfraErrorIdentifier.ARTIFACT_DOWNLOAD_ERROR);
                        }
                        break block21;
                    }
                    catch (FileNotFoundException e) {
                        throw new HarnessRuntimeException(e.getMessage(), e, InfraErrorIdentifier.ARTIFACT_DOWNLOAD_ERROR);
                    }
                }
                this.mDynamicResolver.setDevice(device);
                this.mDynamicResolver.addExtraArgs(this.mMainConfiguration.getCommandOptions().getDynamicDownloadArgs());
                for (File remoteFile : this.mBuildInfo.getRemoteFiles()) {
                    try {
                        this.mDynamicResolver.resolvePartialDownloadZip(this.getTestsDir(), remoteFile.toString(), includeFilters, excludeFilters);
                    }
                    catch (BuildRetrievalError | FileNotFoundException e) {
                        String message2 = String.format("Failed to download partial zip from %s for modules: %s", remoteFile, String.join((CharSequence)", ", modules));
                        LogUtil.CLog.e(message2);
                        LogUtil.CLog.e(e);
                        if (e instanceof IHarnessException) {
                            throw new HarnessRuntimeException(message2, (IHarnessException)((Object)e));
                        }
                        throw new HarnessRuntimeException(message2, e, InfraErrorIdentifier.ARTIFACT_DOWNLOAD_ERROR);
                    }
                }
            }
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.STAGE_TESTS_TIME, elapsedTime);
        LogUtil.CLog.i(String.format("Staging test artifacts for %d modules finished in %s.", modules.size(), TimeUtil.formatElapsedTime(elapsedTime)));
    }

    private List<ModuleDefinition> createExecutionList() {
        ArrayList<ModuleDefinition> runModules = new ArrayList<ModuleDefinition>();
        if (this.mDirectModule != null) {
            runModules.add(this.mDirectModule);
            this.mDirectModule.setDevice(this.mDevice);
            this.mDirectModule.setBuild(this.mBuildInfo);
            return runModules;
        }
        try (CloseableTraceScope ignore = new CloseableTraceScope("suite:createExecutionList");){
            LinkedHashMap<String, IConfiguration> runConfig = this.loadAndFilter();
            if (runConfig.isEmpty()) {
                LogUtil.CLog.i("No config were loaded. Nothing to run.");
                ArrayList<ModuleDefinition> arrayList = runModules;
                return arrayList;
            }
            Map<String, List<ITargetPreparer>> suitePreparersPerDevice = this.getAllowedPreparerPerDevice(this.mMainConfiguration);
            for (Map.Entry<String, IConfiguration> config : runConfig.entrySet()) {
                ValidateSuiteConfigHelper.validateConfig(config.getValue());
                Map<String, List<ITargetPreparer>> preparersPerDevice = this.getPreparerPerDevice(config.getValue());
                ModuleDefinition module = new ModuleDefinition(config.getKey(), config.getValue().getTests(), preparersPerDevice, suitePreparersPerDevice, config.getValue().getMultiTargetPreparers(), config.getValue());
                if (this.mDisableAutoRetryTimeReporting) {
                    module.disableAutoRetryReportingTime();
                }
                module.setDevice(this.mDevice);
                module.setBuild(this.mBuildInfo);
                runModules.add(module);
            }
            if (this.mRandomOrder) {
                this.randomizeTestModules(runModules, this.mRandomSeed);
            }
            LogUtil.CLog.logAndDisplay(Log.LogLevel.DEBUG, "[Total Unique Modules = %s]", runModules.size());
            runConfig = null;
            ArrayList<ModuleDefinition> arrayList = runModules;
            return arrayList;
        }
    }

    void randomizeTestModules(List<ModuleDefinition> runModules, long randomSeed) {
        if (randomSeed == -1L) {
            randomSeed = System.currentTimeMillis();
        }
        LogUtil.CLog.i("Randomizing all the modules with seed: %s", randomSeed);
        Collections.shuffle(runModules, new Random(randomSeed));
        this.mBuildInfo.addBuildAttribute(RANDOM_SEED, String.valueOf(randomSeed));
    }

    private void checkClassLoad(Set<String> classes, String type) {
        for (String c : classes) {
            try {
                Class.forName(c);
            }
            catch (ClassNotFoundException e) {
                ConfigurationException ex = new ConfigurationException(String.format("--%s must contains valid class, %s was not found", type, c), e);
                throw new RuntimeException(ex);
            }
        }
    }

    private Map<String, List<ITargetPreparer>> getPreparerPerDevice(IConfiguration config) {
        LinkedHashMap<String, List<ITargetPreparer>> res = new LinkedHashMap<String, List<ITargetPreparer>>();
        for (IDeviceConfiguration holder : config.getDeviceConfig()) {
            ArrayList<ITargetPreparer> preparers = new ArrayList<ITargetPreparer>();
            res.put(holder.getDeviceName(), preparers);
            preparers.addAll(holder.getTargetPreparers());
        }
        return res;
    }

    private Map<String, List<ITargetPreparer>> getAllowedPreparerPerDevice(IConfiguration config) {
        List<String> preparers;
        if (config == null) {
            return new LinkedHashMap<String, List<ITargetPreparer>>();
        }
        HashSet<String> allowedSuitePreparers = new HashSet<String>();
        for (String resource : ALLOWED_PREPARERS_CONFIGS) {
            try {
                InputStream resStream = ITestSuite.class.getResourceAsStream(resource);
                try {
                    if (resStream == null) {
                        LogUtil.CLog.d("Resource not found for allowed preparers: %s", resource);
                        continue;
                    }
                    preparers = Arrays.asList(StreamUtil.getStringFromStream(resStream).split("\n"));
                    allowedSuitePreparers.addAll(preparers);
                }
                finally {
                    if (resStream == null) continue;
                    resStream.close();
                }
            }
            catch (IOException e) {
                LogUtil.CLog.e(e);
            }
        }
        LinkedHashMap<String, List<ITargetPreparer>> res = new LinkedHashMap<String, List<ITargetPreparer>>();
        for (IDeviceConfiguration holder : config.getDeviceConfig()) {
            preparers = new ArrayList<String>();
            for (ITargetPreparer preparer : holder.getTargetPreparers()) {
                if (!allowedSuitePreparers.contains(preparer.getClass().getCanonicalName())) continue;
                preparers.add((String)((Object)preparer));
            }
            res.put(holder.getDeviceName(), preparers);
        }
        return res;
    }

    public void cleanUpSuiteSetup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        this.mCurrentLogger = listener;
        this.checkClassLoad(this.mSystemStatusCheckBlacklist, SKIP_SYSTEM_STATUS_CHECKER);
        this.checkClassLoad(this.mAllowedRunners, RUNNER_WHITELIST);
        this.checkClassLoad(this.mAllowedPreparers, PREPARER_WHITELIST);
        this.mRunModules = this.createExecutionList();
        if (this.mRunModules.isEmpty()) {
            LogUtil.CLog.i("No tests to be run.");
            return;
        }
        for (ISystemStatusChecker checker : this.mSystemStatusCheckers) {
            if (!(checker instanceof ITestLoggerReceiver)) continue;
            ((ITestLoggerReceiver)((Object)checker)).setTestLogger(listener);
        }
        TestFailureListener failureListener = new TestFailureListener(this.mContext.getDevices(), this.mBugReportOnFailure, this.mRebootOnFailure);
        List<ITestInvocationListener> moduleListeners = this.createModuleListeners();
        if (this.mRunModules.get(0).hasTests()) {
            LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, "%s running %s modules: %s", this.mDevice.getSerialNumber(), this.mRunModules.size(), this.mRunModules);
        }
        try {
            while (!this.mRunModules.isEmpty()) {
                ModuleDefinition module = this.mRunModules.remove(0);
                if (!this.shouldModuleRun(module) || module.hasTests()) continue;
                try (CloseableTraceScope ignore = new CloseableTraceScope(module.getId());){
                    for (String string : this.mContext.getDeviceConfigNames()) {
                        module.getModuleInvocationContext().addAllocatedDevice(string, this.mContext.getDevice(string));
                        module.getModuleInvocationContext().addDeviceBuildInfo(string, this.mContext.getBuildInfo(string));
                    }
                    if (!CurrentInvocation.IsolationGrade.NOT_ISOLATED.equals((Object)CurrentInvocation.moduleCurrentIsolation())) {
                        module.getModuleInvocationContext().addInvocationAttribute("module-isolated", CurrentInvocation.moduleCurrentIsolation().toString());
                    }
                    ITestInvocationListener listenerWithCollectors = listener;
                    if (this.mMetricCollectors != null) {
                        for (IMetricCollector collector : CollectorHelper.cloneCollectors(this.mMetricCollectors)) {
                            if (collector.isDisabled()) {
                                LogUtil.CLog.d("%s has been disabled. Skipping.", collector);
                                continue;
                            }
                            if (!collector.captureModuleLevel()) {
                                LogUtil.CLog.d("%s isn't applicable at module level. Skipping.", collector);
                                continue;
                            }
                            if (collector instanceof IConfigurationReceiver) {
                                ((IConfigurationReceiver)((Object)collector)).setConfiguration(module.getModuleConfiguration());
                            }
                            try (CloseableTraceScope ignored = new CloseableTraceScope("init_for_module_" + collector.getClass().getSimpleName());){
                                listenerWithCollectors = collector.init(module.getModuleInvocationContext(), listenerWithCollectors);
                                TfObjectTracker.countWithParents(collector.getClass());
                            }
                        }
                    }
                    module.getModuleInvocationContext().addInvocationAttribute(MODULE_START_TIME, Long.toString(System.currentTimeMillis()));
                    listenerWithCollectors.testModuleStarted(module.getModuleInvocationContext());
                    this.mModuleInProgress = module;
                    new ResultForwarder(moduleListeners).testModuleStarted(module.getModuleInvocationContext());
                    TestInformation testInformation = TestInformation.createModuleTestInfo(testInfo, module.getModuleInvocationContext());
                    try {
                        this.runSingleModule(module, testInformation, listener, moduleListeners, failureListener);
                    }
                    finally {
                        module.getModuleInvocationContext().addInvocationAttribute(MODULE_END_TIME, Long.toString(System.currentTimeMillis()));
                        new ResultForwarder(moduleListeners).testModuleEnded();
                        listenerWithCollectors.testModuleEnded();
                        this.mModuleInProgress = null;
                        CurrentInvocation.setModuleIsolation(CurrentInvocation.IsolationGrade.NOT_ISOLATED);
                    }
                    this.moduleIsolation(this.mContext, listener);
                }
            }
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e("A DeviceNotAvailableException occurred, following modules did not run: %s", this.mRunModules);
            this.reportNotExecuted(listener, "Module did not run due to device not available.");
            throw e;
        }
    }

    protected List<ITestInvocationListener> createModuleListeners() {
        return new ArrayList<ITestInvocationListener>();
    }

    private void moduleIsolation(IInvocationContext context, ITestLogger logger) throws DeviceNotAvailableException {
        boolean res;
        ITestDevice device = context.getDevices().get(0);
        if (this.mIsolatedModule && device instanceof NestedRemoteDevice && !(res = ((NestedRemoteDevice)device).resetVirtualDevice())) {
            String serial = device.getSerialNumber();
            throw new DeviceNotAvailableException(String.format("Failed to reset the AVD '%s' during module isolation.", serial), serial);
        }
    }

    private void runSingleModule(ModuleDefinition module, TestInformation moduleInfo, ITestInvocationListener listener, List<ITestInvocationListener> moduleListeners, TestFailureListener failureListener) throws DeviceNotAvailableException {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        try (CloseableTraceScope ignored = new CloseableTraceScope("module_pre_check");){
            if (this.mRebootPerModule) {
                if ("user".equals(this.mDevice.getProperty("ro.build.type"))) {
                    LogUtil.CLog.e("reboot-per-module should only be used during development, this is a\" user\" build device");
                } else {
                    LogUtil.CLog.d("Rebooting device before starting next module");
                    this.mDevice.reboot();
                }
            }
            if (!this.mSkipAllSystemStatusCheck && !this.mSystemStatusCheckers.isEmpty()) {
                properties.putAll(this.runPreModuleCheck(module.getId(), this.mSystemStatusCheckers, this.mDevice, listener));
            }
            if (this.mCollectTestsOnly) {
                module.setCollectTestsOnly(this.mCollectTestsOnly);
            }
            if (this.mRecoverDeviceByCvd) {
                module.setRecoverVirtualDevice(this.mRecoverDeviceByCvd);
            }
            module.setMetricCollectors(CollectorHelper.cloneCollectors(this.mMetricCollectors));
            module.setLogSaver(this.mMainConfiguration.getLogSaver());
            IRetryDecision decision = this.mMainConfiguration.getRetryDecision();
            if (this.mMergeAttempts && decision.getMaxRetryCount() > 1 && !RetryStrategy.NO_RETRY.equals((Object)decision.getRetryStrategy())) {
                LogUtil.CLog.d("Overriding '--merge-attempts' to false for auto-retry.");
                this.mMergeAttempts = false;
            }
            module.setMergeAttemps(this.mMergeAttempts);
            module.setRetryDecision(decision);
            if (decision instanceof IConfigurationReceiver) {
                ((IConfigurationReceiver)((Object)decision)).setConfiguration(this.mMainConfiguration);
            }
            module.setEnableDynamicDownload(this.mEnableDynamicDownload);
            module.transferSuiteLevelOptions(this.mMainConfiguration);
        }
        module.run(moduleInfo, listener, moduleListeners, failureListener, this.getConfiguration().getRetryDecision().getMaxRetryCount());
        if (!this.mSkipAllSystemStatusCheck && !this.mSystemStatusCheckers.isEmpty()) {
            ignored = new CloseableTraceScope("module_post_check");
            try {
                properties.putAll(this.runPostModuleCheck(module.getId(), this.mSystemStatusCheckers, this.mDevice, listener));
            }
            finally {
                ignored.close();
            }
        }
        for (Map.Entry entry : properties.entrySet()) {
            module.getModuleInvocationContext().addInvocationAttribute((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private Map<String, String> runPreModuleCheck(String moduleName, List<ISystemStatusChecker> checkers, ITestDevice device, ITestInvocationListener listener) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        LogUtil.CLog.i("Running system status checker before module execution: %s", moduleName);
        LinkedHashMap<String, String> failures = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        boolean bugreportNeeded = false;
        for (ISystemStatusChecker checker : checkers) {
            TfObjectTracker.countWithParents(checker.getClass());
            if (this.mSystemStatusCheckBlacklist.contains(checker.getClass().getName())) {
                LogUtil.CLog.d("%s was skipped via %s", checker.getClass().getName(), SKIP_SYSTEM_STATUS_CHECKER);
                continue;
            }
            StatusCheckerResult result = new StatusCheckerResult(StatusCheckerResult.CheckStatus.FAILED);
            try {
                result = checker.preExecutionCheck(device);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e(e);
                result.setErrorMessage(e.getMessage());
                result.setBugreportNeeded(true);
            }
            properties.putAll(result.getModuleProperties());
            if (StatusCheckerResult.CheckStatus.SUCCESS.equals((Object)result.getStatus())) continue;
            String errorMessage = result.getErrorMessage() == null ? "" : result.getErrorMessage();
            failures.put(checker.getClass().getCanonicalName(), errorMessage);
            bugreportNeeded |= result.isBugreportNeeded();
            LogUtil.CLog.w("System status checker [%s] failed.", checker.getClass().getCanonicalName());
        }
        if (!failures.isEmpty()) {
            LogUtil.CLog.w("There are failed system status checkers: %s", ((Object)failures).toString());
            if (bugreportNeeded && !(device.getIDevice() instanceof StubDevice)) {
                device.logBugreport(String.format("bugreport-checker-pre-module-%s", moduleName), listener);
            }
        }
        this.reportModuleCheckerResult(MODULE_CHECKER_PRE, moduleName, failures, startTime, listener);
        InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.STATUS_CHECKER_PAIR, startTime, System.currentTimeMillis());
        return properties;
    }

    private Map<String, String> runPostModuleCheck(String moduleName, List<ISystemStatusChecker> checkers, ITestDevice device, ITestInvocationListener listener) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        LogUtil.CLog.i("Running system status checker after module execution: %s", moduleName);
        LinkedHashMap<String, String> failures = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        boolean bugreportNeeded = false;
        for (ISystemStatusChecker checker : checkers) {
            if (this.mSystemStatusCheckBlacklist.contains(checker.getClass().getName())) continue;
            StatusCheckerResult result = new StatusCheckerResult(StatusCheckerResult.CheckStatus.FAILED);
            try {
                result = checker.postExecutionCheck(device);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e(e);
                result.setErrorMessage(e.getMessage());
                result.setBugreportNeeded(true);
            }
            catch (DeviceNotAvailableException dnae) {
                String message2 = String.format("Device became unavailable after %s due to: %s", moduleName, dnae.getMessage());
                DeviceNotAvailableException wrapper = new DeviceNotAvailableException(message2, (Throwable)dnae, dnae.getSerial());
                throw wrapper;
            }
            properties.putAll(result.getModuleProperties());
            if (StatusCheckerResult.CheckStatus.SUCCESS.equals((Object)result.getStatus())) continue;
            String errorMessage = result.getErrorMessage() == null ? "" : result.getErrorMessage();
            failures.put(checker.getClass().getCanonicalName(), errorMessage);
            bugreportNeeded |= result.isBugreportNeeded();
            LogUtil.CLog.w("System status checker [%s] failed", checker.getClass().getCanonicalName());
        }
        if (!failures.isEmpty()) {
            LogUtil.CLog.w("There are failed system status checkers: %s", ((Object)failures).toString());
            if (bugreportNeeded && !(device.getIDevice() instanceof StubDevice)) {
                device.logBugreport(String.format("bugreport-checker-post-module-%s", moduleName), listener);
            }
        }
        this.reportModuleCheckerResult(MODULE_CHECKER_POST, moduleName, failures, startTime, listener);
        InvocationMetricLogger.addInvocationPairMetrics(InvocationMetricLogger.InvocationMetricKey.STATUS_CHECKER_PAIR, startTime, System.currentTimeMillis());
        return properties;
    }

    private void reportModuleCheckerResult(String identifier, String moduleName, Map<String, String> failures, long startTime, ITestInvocationListener listener) {
        if (!this.mReportSystemChecker) {
            return;
        }
        listener.testRunStarted(identifier + "_" + moduleName, 0, 0, System.currentTimeMillis());
        if (!failures.isEmpty()) {
            FailureDescription description = FailureDescription.create(String.format("%s failed '%s' checkers", moduleName, failures)).setErrorIdentifier(TestErrorIdentifier.MODULE_CHANGED_SYSTEM_STATUS);
            listener.testRunFailed(description);
        }
        listener.testRunEnded(System.currentTimeMillis() - startTime, new HashMap<String, MetricMeasurement.Metric>());
    }

    public boolean isSplitting() {
        return this.mIsSplitting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<IRemoteTest> split(Integer shardCountHint, TestInformation testInfo) {
        if (shardCountHint == null || shardCountHint <= 1 || this.mIsSharded) {
            return null;
        }
        this.setBuild(testInfo.getBuildInfo());
        this.setDevice(testInfo.getDevice());
        this.setInvocationContext(testInfo.getContext());
        this.mIsSplitting = true;
        try {
            LinkedHashMap<String, IConfiguration> runConfig = this.loadAndFilter();
            if (runConfig.isEmpty()) {
                LogUtil.CLog.i("No config were loaded. Nothing to run.");
                Collection<IRemoteTest> collection = null;
                return collection;
            }
            this.injectInfo(runConfig, testInfo);
            List<ModuleDefinition> splitModules = ModuleSplitter.splitConfiguration(testInfo, runConfig, this.getAllowedPreparerPerDevice(this.mMainConfiguration), shardCountHint, this.mShouldMakeDynamicModule, this.mIntraModuleSharding);
            runConfig.clear();
            runConfig = null;
            this.cleanUpSuiteSetup();
            ArrayList<ITestSuite> splitTests = new ArrayList<ITestSuite>();
            for (ModuleDefinition m : splitModules) {
                ITestSuite suite = this.createInstance();
                OptionCopier.copyOptionsNoThrow(this, suite);
                suite.mIsSharded = true;
                suite.mDirectModule = m;
                splitTests.add(suite);
            }
            ArrayList<ITestSuite> arrayList = splitTests;
            return arrayList;
        }
        finally {
            this.mIsSplitting = false;
        }
    }

    private void injectInfo(LinkedHashMap<String, IConfiguration> runConfig, TestInformation testInfo) {
        for (IConfiguration config : runConfig.values()) {
            for (IRemoteTest test : config.getTests()) {
                if (test instanceof IBuildReceiver) {
                    ((IBuildReceiver)((Object)test)).setBuild(testInfo.getBuildInfo());
                }
                if (test instanceof IDeviceTest) {
                    ((IDeviceTest)((Object)test)).setDevice(testInfo.getDevice());
                }
                if (test instanceof IInvocationContextReceiver) {
                    ((IInvocationContextReceiver)((Object)test)).setInvocationContext(testInfo.getContext());
                }
                if (!(test instanceof ITestCollector)) continue;
                ((ITestCollector)((Object)test)).setCollectTestsOnly(this.mCollectTestsOnly);
            }
        }
    }

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setAbiName(String abiName) {
        this.mAbiName = abiName;
    }

    @Override
    public void setBuild(IBuildInfo buildInfo) {
        this.mBuildInfo = buildInfo;
    }

    public IBuildInfo getBuildInfo() {
        return this.mBuildInfo;
    }

    public void setPrimaryAbiRun(boolean primaryAbiRun) {
        this.mPrimaryAbiRun = primaryAbiRun;
    }

    @Override
    public void setSystemStatusChecker(List<ISystemStatusChecker> systemCheckers) {
        this.mSystemStatusCheckers = systemCheckers;
    }

    @Override
    public void setCollectTestsOnly(boolean shouldCollectTest) {
        this.mCollectTestsOnly = shouldCollectTest;
    }

    @Override
    public void setMetricCollectors(List<IMetricCollector> collectors) {
        this.mMetricCollectors = collectors;
    }

    public void setShouldMakeDynamicModule(boolean dynamicModule) {
        this.mShouldMakeDynamicModule = dynamicModule;
    }

    @Override
    public void setInvocationContext(IInvocationContext invocationContext) {
        this.mContext = invocationContext;
    }

    public IInvocationContext getInvocationContext() {
        return this.mContext;
    }

    @Override
    public void setTestLogger(ITestLogger testLogger) {
        this.mCurrentLogger = testLogger;
    }

    public ITestLogger getCurrentTestLogger() {
        return this.mCurrentLogger;
    }

    @Override
    public long getRuntimeHint() {
        if (this.mDirectModule != null) {
            LogUtil.CLog.d("    %s: %s", this.mDirectModule.getId(), TimeUtil.formatElapsedTime(this.mDirectModule.getRuntimeHint()));
            return this.mDirectModule.getRuntimeHint();
        }
        return 0L;
    }

    @Override
    public void setConfiguration(IConfiguration configuration) {
        this.mMainConfiguration = configuration;
    }

    public final IConfiguration getConfiguration() {
        return this.mMainConfiguration;
    }

    @Override
    public void reportNotExecuted(ITestInvocationListener listener) {
        this.reportNotExecuted(listener, "Test did not run. This is a placeholder.");
    }

    @Override
    public void reportNotExecuted(ITestInvocationListener listener, String message2) {
        List<ModuleDefinition> runModules = null;
        if (this.mRunModules != null) {
            runModules = new ArrayList<ModuleDefinition>(this.mRunModules);
        }
        if (runModules == null) {
            runModules = this.createExecutionList();
        }
        if (this.mModuleInProgress != null) {
            String inProgressMessage = String.format("Module %s was interrupted after starting. Results might not be accurate or complete.", this.mModuleInProgress.getId());
            this.mModuleInProgress.reportNotExecuted(listener, inProgressMessage);
        }
        while (!runModules.isEmpty()) {
            ModuleDefinition module = runModules.remove(0);
            module.reportNotExecuted(listener, message2);
        }
    }

    public MultiMap<String, String> getModuleMetadataIncludeFilters() {
        return this.mModuleMetadataIncludeFilter;
    }

    public void addModuleMetadataIncludeFilters(MultiMap<String, String> filters) {
        this.mModuleMetadataIncludeFilter.putAll(filters);
    }

    public void addModuleMetadataExcludeFilters(MultiMap<String, String> filters) {
        this.mModuleMetadataExcludeFilter.putAll(filters);
    }

    public ModuleDefinition getDirectModule() {
        return this.mDirectModule;
    }

    @Override
    public Set<TokenProperty> getRequiredTokens(TestInformation testInfo) {
        if (this.mDirectModule == null) {
            return null;
        }
        return this.mDirectModule.getRequiredTokens(testInfo);
    }

    public Set<IAbi> getAbis(ITestDevice device) throws DeviceNotAvailableException {
        if (!this.mAbis.isEmpty()) {
            return this.mAbis;
        }
        LinkedHashSet<IAbi> abis = new LinkedHashSet<IAbi>();
        Set<String> archAbis = this.getAbisForBuildTargetArch();
        if (this.mPrimaryAbiRun) {
            if (this.mAbiName == null) {
                this.mAbiName = this.getPrimaryAbi(device);
            } else {
                LogUtil.CLog.d("Option --%s supersedes the option --%s, using abi: %s", ABI_OPTION, PRIMARY_ABI_RUN, this.mAbiName);
            }
        }
        if (this.mAbiName != null) {
            if (!this.mSkipHostArchCheck && !archAbis.contains(this.mAbiName) || !AbiUtils.isAbiSupportedByCompatibility(this.mAbiName)) {
                throw new IllegalArgumentException(String.format("Your tests suite hasn't been built with abi '%s' support, this suite currently supports '%s'.", this.mAbiName, archAbis));
            }
            abis.add(new Abi(this.mAbiName, AbiUtils.getBitness(this.mAbiName)));
            return abis;
        }
        List<String> deviceAbis = this.getDeviceAbis(device);
        if (deviceAbis.isEmpty()) {
            throw new HarnessRuntimeException(String.format("Couldn't determinate the abi of the device '%s'.", device.getSerialNumber()), DeviceErrorIdentifier.DEVICE_UNEXPECTED_RESPONSE);
        }
        for (String abi : deviceAbis) {
            if ((this.mSkipHostArchCheck || archAbis.contains(abi)) && AbiUtils.isAbiSupportedByCompatibility(abi)) {
                abis.add(new Abi(abi, AbiUtils.getBitness(abi)));
                continue;
            }
            LogUtil.CLog.d("abi '%s' is supported by device but not by this suite build (%s), tests will not run against it.", abi, archAbis);
        }
        if (abis.isEmpty()) {
            throw new IllegalArgumentException(String.format("None of the abi supported by this tests suite build ('%s') are supported by the device ('%s').", archAbis, deviceAbis));
        }
        return abis;
    }

    private String getPrimaryAbi(ITestDevice device) throws DeviceNotAvailableException {
        if (device.getIDevice() instanceof NullDevice) {
            Set<String> hostAbis = this.getHostAbis();
            return hostAbis.iterator().next();
        }
        String property = device.getProperty(PRODUCT_CPU_ABI_KEY);
        if (property == null) {
            String serial = device.getSerialNumber();
            throw new DeviceNotAvailableException(String.format("Device '%s' was not online to query %s", serial, PRODUCT_CPU_ABI_KEY), serial, (ErrorIdentifier)DeviceErrorIdentifier.DEVICE_UNAVAILABLE);
        }
        return property.trim();
    }

    private List<String> getDeviceAbis(ITestDevice device) throws DeviceNotAvailableException {
        if (device.getIDevice() instanceof NullDevice) {
            return new ArrayList<String>(this.getHostAbis());
        }
        return new ArrayList<String>(Arrays.asList(AbiFormatter.getSupportedAbis(device, "")));
    }

    protected Set<String> getAbisForBuildTargetArch() {
        return ITestSuite.getAbisForBuildTargetArchFromSuite();
    }

    public static Set<String> getAbisForBuildTargetArchFromSuite() {
        LinkedHashSet<String> abis = new LinkedHashSet<String>();
        for (String arch : TestSuiteInfo.getInstance().getTargetArchs()) {
            abis.addAll(AbiUtils.getAbisForArch(arch));
        }
        return abis;
    }

    protected Set<String> getHostAbis() {
        return AbiUtils.getHostAbi();
    }

    public final String getRequestedAbi() {
        return this.mAbiName;
    }

    public boolean filterByConfigMetadata(IConfiguration config, MultiMap<String, String> include, MultiMap<String, String> exclude) {
        HashSet<String> filters;
        MultiMap<String, String> metadata = config.getConfigurationDescription().getAllMetaData();
        boolean shouldInclude = false;
        for (String key : include.keySet()) {
            filters = new HashSet<String>(include.get(key));
            if (!metadata.containsKey(key)) continue;
            filters.retainAll(metadata.get(key));
            if (filters.isEmpty()) continue;
            shouldInclude = true;
            break;
        }
        if (!include.isEmpty() && !shouldInclude) {
            return false;
        }
        for (String key : exclude.keySet()) {
            filters = new HashSet<String>(exclude.get(key));
            if (!metadata.containsKey(key)) continue;
            filters.retainAll(metadata.get(key));
            if (filters.isEmpty()) continue;
            return false;
        }
        return true;
    }

    void filterPreparers(IConfiguration config, Set<String> preparerWhiteList) {
        if (preparerWhiteList.isEmpty()) {
            return;
        }
        for (IDeviceConfiguration deviceConfig : config.getDeviceConfig()) {
            ArrayList<ITargetPreparer> preparers = new ArrayList<ITargetPreparer>(deviceConfig.getTargetPreparers());
            for (ITargetPreparer prep : preparers) {
                if (preparerWhiteList.contains(prep.getClass().getName())) continue;
                deviceConfig.getTargetPreparers().remove(prep);
            }
        }
    }

    protected boolean filterByRunnerType(IConfiguration config, Set<String> allowedRunners) {
        if (allowedRunners.isEmpty()) {
            return true;
        }
        Iterator<IRemoteTest> iterator2 = config.getTests().iterator();
        while (iterator2.hasNext()) {
            IRemoteTest test = iterator2.next();
            if (allowedRunners.contains(test.getClass().getName())) continue;
            LogUtil.CLog.d("Runner '%s' in module '%s' was skipped by the runner whitelist: '%s'.", test.getClass().getName(), config.getName(), allowedRunners);
            iterator2.remove();
        }
        if (config.getTests().isEmpty()) {
            LogUtil.CLog.d("Module %s does not have any more tests, skipping it.", config.getName());
            return false;
        }
        return true;
    }

    void disableAutoRetryTimeReporting() {
        this.mDisableAutoRetryTimeReporting = true;
    }

    void setModuleInProgress(ModuleDefinition moduleInProgress) {
        this.mModuleInProgress = moduleInProgress;
    }

    public final void setAbis(Set<IAbi> abis) {
        this.mAbis.addAll(abis);
    }

    protected boolean shouldModuleRun(ModuleDefinition module) {
        return true;
    }

    public void setMultiDeviceStrategy(MultiDeviceModuleStrategy strategy) {
        this.mMultiDevicesStrategy = strategy;
    }

    public MultiDeviceModuleStrategy getMultiDeviceStrategy() {
        return this.mMultiDevicesStrategy;
    }

    public void setIntraModuleSharding(boolean intraModuleSharding) {
        this.mIntraModuleSharding = intraModuleSharding;
    }

    public static enum MultiDeviceModuleStrategy {
        EXCLUDE_ALL,
        RUN,
        ONLY_MULTI_DEVICES;

    }
}

