/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite;

import com.android.ddmlib.Log;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.ConfigurationDescriptor;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.DynamicRemoteFileResolver;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.dependencies.ExternalDependency;
import com.android.tradefed.dependencies.IExternalDependency;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.StubDevice;
import com.android.tradefed.device.metric.IMetricCollector;
import com.android.tradefed.device.metric.LogcatOnFailureCollector;
import com.android.tradefed.device.metric.ScreenshotOnFailureCollector;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.error.IHarnessException;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.invoker.logger.InvocationMetricLogger;
import com.android.tradefed.invoker.logger.TfObjectTracker;
import com.android.tradefed.invoker.shard.token.TokenProperty;
import com.android.tradefed.invoker.tracing.CloseableTraceScope;
import com.android.tradefed.log.ILogRegistry;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogRegistry;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ILogSaver;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ITestLoggerReceiver;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.MultiFailureDescription;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.result.error.TestErrorIdentifier;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.retry.IRetryDecision;
import com.android.tradefed.retry.RetryStatistics;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.targetprep.multi.IMultiTargetPreparer;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IRuntimeHintProvider;
import com.android.tradefed.testtype.ITestCollector;
import com.android.tradefed.testtype.ITestFileFilterReceiver;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.testtype.suite.GranularRetriableTestWrapper;
import com.android.tradefed.testtype.suite.ModuleListener;
import com.android.tradefed.testtype.suite.TestFailureListener;
import com.android.tradefed.testtype.suite.module.BaseModuleController;
import com.android.tradefed.testtype.suite.module.IModuleController;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.SystemUtil;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.google.api.client.util.Joiner;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ModuleDefinition
implements Comparable<ModuleDefinition>,
ITestCollector {
    public static final String MODULE_NAME = "module-name";
    public static final String MODULE_ABI = "module-abi";
    public static final String MODULE_PARAMETERIZATION = "module-param";
    public static final String MODULE_EXTERNAL_DEPENDENCIES = "module-external-dependencies";
    public static final String MODULE_ID = "module-id";
    public static final String MODULE_ISOLATED = "module-isolated";
    public static final String MODULE_CACHED = "module-cached";
    public static final String SPARSE_MODULE = "sparse-module";
    public static final String MODULE_CONTROLLER = "module_controller";
    public static final String PREPARATION_TIME = "PREP_TIME";
    public static final String TEAR_DOWN_TIME = "TEARDOWN_TIME";
    public static final String TEST_TIME = "TEST_TIME";
    public static final String MODULE_TEST_COUNT = "MODULE_TEST_COUNT";
    public static final String RETRY_TIME = "MODULE_RETRY_TIME";
    public static final String ISOLATION_COST = "ISOLATION_COST";
    public static final String RETRY_SUCCESS_COUNT = "MODULE_RETRY_SUCCESS";
    public static final String RETRY_FAIL_COUNT = "MODULE_RETRY_FAILED";
    private final IInvocationContext mModuleInvocationContext;
    private final IConfiguration mModuleConfiguration;
    private IConfiguration mInternalTestConfiguration;
    private IConfiguration mInternalTargetPreparerConfiguration;
    private ILogSaver mLogSaver;
    private TestInformation mModuleInfo;
    private ITestInvocationListener mInvocationListener;
    private final String mId;
    private Collection<IRemoteTest> mTests = null;
    private Map<String, List<ITargetPreparer>> mPreparersPerDevice = null;
    private Map<String, List<ITargetPreparer>> mSuitePreparersPerDevice = null;
    private List<IMultiTargetPreparer> mMultiPreparers = new ArrayList<IMultiTargetPreparer>();
    private IBuildInfo mBuild;
    private ITestDevice mDevice;
    private List<IMetricCollector> mRunMetricCollectors = new ArrayList<IMetricCollector>();
    private boolean mCollectTestsOnly = false;
    private List<TestRunResult> mTestsResults = new ArrayList<TestRunResult>();
    private List<ModuleListener> mRunListenersResults = new ArrayList<ModuleListener>();
    private int mExpectedTests = 0;
    private boolean mIsFailedModule = false;
    private boolean mRetriedModulePreparationSuccess = false;
    private long mElapsedPreparation = 0L;
    private long mElapsedTearDown = 0L;
    private long mStartTestTime = 0L;
    private Long mStartModuleRunDate = null;
    private List<RetryStatistics> mRetryStats = new ArrayList<RetryStatistics>();
    private boolean mDisableAutoRetryTimeReporting = false;
    private boolean mMergeAttempts = true;
    private IRetryDecision mRetryDecision;
    private Set<TokenProperty> mRequiredTokens = new HashSet<TokenProperty>();
    private boolean mEnableDynamicDownload = false;
    private GranularRetriableTestWrapper mCurrentTestWrapper = null;
    private int mMaxRetry = 1;
    private int mTargetPreparerRetryCount = 0;
    private Set<TestDescription> mPassThroughFilters = new LinkedHashSet<TestDescription>();
    private boolean mRecoverVirtualDevice = false;

    @VisibleForTesting
    public ModuleDefinition() {
        this.mModuleInvocationContext = null;
        this.mModuleConfiguration = null;
        this.mId = "";
    }

    public ModuleDefinition(String name, Collection<IRemoteTest> tests, Map<String, List<ITargetPreparer>> preparersPerDevice, List<IMultiTargetPreparer> multiPreparers, IConfiguration moduleConfig) {
        this(name, tests, preparersPerDevice, null, multiPreparers, moduleConfig);
    }

    public ModuleDefinition(String name, Collection<IRemoteTest> tests, Map<String, List<ITargetPreparer>> preparersPerDevice, Map<String, List<ITargetPreparer>> suitePreparersPerDevice, List<IMultiTargetPreparer> multiPreparers, IConfiguration moduleConfig) {
        String parameterization;
        this.mId = name;
        this.mTests = tests;
        this.mModuleConfiguration = moduleConfig;
        ConfigurationDescriptor configDescriptor = moduleConfig.getConfigurationDescription();
        this.mModuleInvocationContext = new InvocationContext();
        this.mModuleInvocationContext.setConfigurationDescriptor(configDescriptor.clone());
        if (configDescriptor.getAbi() != null) {
            this.mModuleInvocationContext.addInvocationAttribute(MODULE_ABI, configDescriptor.getAbi().getName());
        }
        if (configDescriptor.getModuleName() != null) {
            this.mModuleInvocationContext.addInvocationAttribute(MODULE_NAME, configDescriptor.getModuleName());
        }
        if ((parameterization = configDescriptor.getAllMetaData().getUniqueMap().get("active-parameter")) != null) {
            this.mModuleInvocationContext.addInvocationAttribute(MODULE_PARAMETERIZATION, parameterization);
        }
        this.mModuleInvocationContext.addInvocationAttribute(MODULE_ID, this.mId);
        LinkedHashSet<ExternalDependency> externalDependencies = new LinkedHashSet<ExternalDependency>();
        for (IDeviceConfiguration deviceConfig : moduleConfig.getDeviceConfig()) {
            for (Object obj : deviceConfig.getAllObjects()) {
                if (!(obj instanceof IExternalDependency)) continue;
                externalDependencies.addAll(((IExternalDependency)obj).getDependencies());
            }
        }
        if (!externalDependencies.isEmpty()) {
            List dependencyClassNames = externalDependencies.stream().map(dependency -> dependency.getClass().getName()).collect(Collectors.toList());
            this.mModuleInvocationContext.addInvocationAttribute(MODULE_EXTERNAL_DEPENDENCIES, String.join((CharSequence)", ", dependencyClassNames));
        }
        this.mMultiPreparers.addAll(multiPreparers);
        this.mPreparersPerDevice = preparersPerDevice;
        this.mSuitePreparersPerDevice = suitePreparersPerDevice;
        List<String> tokens = configDescriptor.getMetaData("token");
        if (tokens != null) {
            for (String token : tokens) {
                this.mRequiredTokens.add(TokenProperty.valueOf(token.toUpperCase()));
            }
        }
    }

    public int neededDevices() {
        return this.mModuleConfiguration.getDeviceConfig().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IRemoteTest poll() {
        Collection<IRemoteTest> collection = this.mTests;
        synchronized (collection) {
            if (this.mTests.isEmpty()) {
                return null;
            }
            IRemoteTest test = this.mTests.iterator().next();
            this.mTests.remove(test);
            return test;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTests(List<IRemoteTest> test) {
        Collection<IRemoteTest> collection = this.mTests;
        synchronized (collection) {
            this.mTests.addAll(test);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numTests() {
        Collection<IRemoteTest> collection = this.mTests;
        synchronized (collection) {
            return this.mTests.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasTests() {
        Collection<IRemoteTest> collection = this.mTests;
        synchronized (collection) {
            return this.mTests.isEmpty();
        }
    }

    public String getId() {
        return this.mId;
    }

    @Override
    public int compareTo(ModuleDefinition moduleDef) {
        return this.getId().compareTo(moduleDef.getId());
    }

    public void setBuild(IBuildInfo build) {
        this.mBuild = build;
    }

    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    public void setMetricCollectors(List<IMetricCollector> collectors) {
        if (collectors == null) {
            return;
        }
        this.mRunMetricCollectors.addAll(collectors);
    }

    public void setLogSaver(ILogSaver logSaver) {
        this.mLogSaver = logSaver;
    }

    public final void run(TestInformation moduleInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        this.run(moduleInfo, listener, null, null);
    }

    public final void run(TestInformation moduleInfo, ITestInvocationListener listener, List<ITestInvocationListener> moduleLevelListeners, TestFailureListener failureListener) throws DeviceNotAvailableException {
        this.run(moduleInfo, listener, moduleLevelListeners, failureListener, 1);
    }

    /*
     * Exception decompiling
     */
    public final void run(TestInformation moduleInfo, ITestInvocationListener listener, List<ITestInvocationListener> moduleLevelListeners, TestFailureListener failureListener, int maxRunLimit) throws DeviceNotAvailableException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 64[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    GranularRetriableTestWrapper prepareGranularRetriableWrapper(IRemoteTest test, ITestInvocationListener listener, TestFailureListener failureListener, List<ITestInvocationListener> moduleLevelListeners, boolean skipTestCases, int maxRunLimit) {
        GranularRetriableTestWrapper retriableTest = new GranularRetriableTestWrapper(test, this, listener, failureListener, moduleLevelListeners, maxRunLimit);
        retriableTest.setModuleId(this.getId());
        retriableTest.setMarkTestsSkipped(skipTestCases);
        retriableTest.setMetricCollectors(this.mRunMetricCollectors);
        retriableTest.setModuleConfig(this.mModuleConfiguration);
        retriableTest.setInvocationContext(this.mModuleInvocationContext);
        retriableTest.setLogSaver(this.mLogSaver);
        retriableTest.setRetryDecision(this.mRetryDecision);
        return retriableTest;
    }

    private void captureBugreport(ITestLogger listener, String moduleId, FailureDescription failure) {
        TestRecordProto.FailureStatus status = failure.getFailureStatus();
        if (!TestRecordProto.FailureStatus.LOST_SYSTEM_UNDER_TEST.equals(status) && !TestRecordProto.FailureStatus.SYSTEM_UNDER_TEST_CRASHED.equals(status)) {
            return;
        }
        for (ITestDevice device : this.mModuleInvocationContext.getDevices()) {
            if (device.getIDevice() instanceof StubDevice) continue;
            device.logBugreport(String.format("module-%s-failure-%s-bugreport", moduleId, device.getSerialNumber()), listener);
        }
    }

    private void logDeviceEvent(ILogRegistry.EventType event, String serial, Throwable t, String moduleId) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("serial", serial);
        args.put("trace", StreamUtil.getStackTrace(t));
        args.put(MODULE_ID, moduleId);
        LogRegistry.getLogRegistry().logEvent(Log.LogLevel.DEBUG, event, args);
    }

    private void reportFinalResults(ITestInvocationListener listener, int totalExpectedTests, List<TestRunResult> listResults, Integer attempt, RuntimeException tearDownException) {
        long elapsedTime = 0L;
        HashMap<String, MetricMeasurement.Metric> metricsProto = new HashMap<String, MetricMeasurement.Metric>();
        if (attempt != null) {
            long startTime = listResults.isEmpty() ? this.mStartTestTime : listResults.get(0).getStartTime();
            listener.testRunStarted(this.getId(), totalExpectedTests, attempt + this.mTargetPreparerRetryCount, startTime);
        } else {
            listener.testRunStarted(this.getId(), totalExpectedTests, this.mTargetPreparerRetryCount, this.mStartTestTime);
        }
        int numResults = 0;
        MultiMap<String, LogFile> aggLogFiles = new MultiMap<String, LogFile>();
        ArrayList<FailureDescription> runFailureMessages = new ArrayList<FailureDescription>();
        for (TestRunResult runResult : listResults) {
            numResults += runResult.getTestResults().size();
            this.forwardTestResults(runResult.getTestResults(), listener);
            if (runResult.isRunFailure()) {
                runFailureMessages.add(runResult.getRunFailureDescription());
            }
            elapsedTime += runResult.getElapsedTime();
            metricsProto.putAll(runResult.getRunProtoMetrics());
            aggLogFiles.putAll(runResult.getRunLoggedFiles());
        }
        metricsProto.put(PREPARATION_TIME, TfMetricProtoUtil.createSingleValue(this.mElapsedPreparation, "milliseconds"));
        metricsProto.put(TEAR_DOWN_TIME, TfMetricProtoUtil.createSingleValue(this.mElapsedTearDown, "milliseconds"));
        metricsProto.put(TEST_TIME, TfMetricProtoUtil.createSingleValue(elapsedTime, "milliseconds"));
        metricsProto.put(MODULE_TEST_COUNT, TfMetricProtoUtil.createSingleValue(numResults, "int"));
        if (!this.mRetryStats.isEmpty()) {
            if (attempt != null) {
                long cost = RetryStatistics.isolationCostPerAttempt(attempt, this.mRetryStats);
                if (cost != 0L) {
                    metricsProto.put(ISOLATION_COST, TfMetricProtoUtil.createSingleValue(cost, "milliseconds"));
                }
            } else {
                RetryStatistics agg = RetryStatistics.aggregateStatistics(this.mRetryStats);
                metricsProto.put(RETRY_TIME, TfMetricProtoUtil.createSingleValue(agg.mRetryTime, "milliseconds"));
                metricsProto.put(RETRY_SUCCESS_COUNT, TfMetricProtoUtil.createSingleValue(agg.mRetrySuccess, ""));
                metricsProto.put(RETRY_FAIL_COUNT, TfMetricProtoUtil.createSingleValue(agg.mRetryFailure, ""));
            }
        }
        if (runFailureMessages.isEmpty() && totalExpectedTests != numResults) {
            String error = String.format("Module %s only ran %d out of %d expected tests.", this.getId(), numResults, totalExpectedTests);
            FailureDescription mismatch = FailureDescription.create(error).setFailureStatus(TestRecordProto.FailureStatus.TEST_FAILURE).setErrorIdentifier(InfraErrorIdentifier.EXPECTED_TESTS_MISMATCH);
            runFailureMessages.add(mismatch);
            LogUtil.CLog.e(error);
        }
        if (tearDownException != null) {
            FailureDescription failure = CurrentInvocation.createFailure(StreamUtil.getStackTrace(tearDownException), null).setCause(tearDownException);
            runFailureMessages.add(failure);
        }
        if (!runFailureMessages.isEmpty()) {
            if (runFailureMessages.size() == 1) {
                listener.testRunFailed((FailureDescription)runFailureMessages.get(0));
            } else {
                listener.testRunFailed(new MultiFailureDescription(runFailureMessages));
            }
            this.mIsFailedModule = true;
        }
        for (String key : aggLogFiles.keySet()) {
            for (LogFile logFile : aggLogFiles.get(key)) {
                if (!(listener instanceof ILogSaverListener)) continue;
                ((ILogSaverListener)listener).logAssociation(key, logFile);
            }
        }
        if (attempt != null) {
            listener.testRunEnded(elapsedTime, metricsProto);
        } else {
            listener.testRunEnded(this.getCurrentTime() - this.mStartTestTime, metricsProto);
        }
    }

    private void forwardTestResults(Map<TestDescription, TestResult> testResults, ITestInvocationListener listener) {
        for (Map.Entry<TestDescription, TestResult> testEntry : testResults.entrySet()) {
            listener.testStarted(testEntry.getKey(), testEntry.getValue().getStartTime());
            switch (testEntry.getValue().getStatus()) {
                case FAILURE: {
                    listener.testFailed(testEntry.getKey(), testEntry.getValue().getFailure());
                    break;
                }
                case ASSUMPTION_FAILURE: {
                    listener.testAssumptionFailure(testEntry.getKey(), testEntry.getValue().getFailure());
                    break;
                }
                case IGNORED: {
                    listener.testIgnored(testEntry.getKey());
                    break;
                }
                case INCOMPLETE: {
                    listener.testFailed(testEntry.getKey(), FailureDescription.create("Test did not complete due to exception.", TestRecordProto.FailureStatus.TEST_FAILURE));
                    break;
                }
            }
            for (Map.Entry<String, LogFile> logFile : testEntry.getValue().getLoggedFiles().entrySet()) {
                if (!(listener instanceof ILogSaverListener)) continue;
                ((ILogSaverListener)listener).logAssociation(logFile.getKey(), logFile.getValue());
            }
            listener.testEnded(testEntry.getKey(), testEntry.getValue().getEndTime(), testEntry.getValue().getProtoMetrics());
        }
    }

    public Throwable runPreparation(boolean includeSuitePreparers) {
        Throwable preparationException = null;
        long prepStartTime = this.getCurrentTime();
        if (includeSuitePreparers) {
            preparationException = this.runTargetPreparation(this.mSuitePreparersPerDevice);
        }
        if (preparationException == null) {
            preparationException = this.runTargetPreparation(this.mPreparersPerDevice);
        }
        if (preparationException == null) {
            for (IMultiTargetPreparer multiPreparer : this.mMultiPreparers) {
                preparationException = this.runMultiPreparerSetup(multiPreparer);
                if (preparationException == null) continue;
                this.mIsFailedModule = true;
                LogUtil.CLog.e("Some preparation step failed. failing the module %s", this.getId());
                break;
            }
        }
        this.mElapsedPreparation = this.getCurrentTime() - prepStartTime;
        return preparationException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Throwable runPreparerSetup(ITargetPreparer preparer, int deviceIndex) {
        if (preparer.isDisabled()) {
            return null;
        }
        TfObjectTracker.countWithParents(preparer.getClass());
        LogUtil.CLog.d("Running setup preparer: %s", preparer.getClass().getSimpleName());
        try {
            CloseableTraceScope ignored = new CloseableTraceScope(preparer.getClass().getName());
            try {
                if (preparer instanceof IConfigurationReceiver) {
                    ((IConfigurationReceiver)((Object)preparer)).setConfiguration(this.mModuleConfiguration);
                }
                if (preparer instanceof ITestLoggerReceiver) {
                    ((ITestLoggerReceiver)((Object)preparer)).setTestLogger(this.mInvocationListener);
                }
                if (preparer instanceof IInvocationContextReceiver) {
                    ((IInvocationContextReceiver)((Object)preparer)).setInvocationContext(this.mModuleInvocationContext);
                }
                this.mModuleInfo.setActiveDeviceIndex(deviceIndex);
                preparer.setUp(this.mModuleInfo);
                Throwable throwable = null;
                ignored.close();
                return throwable;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (DeviceNotAvailableException | BuildError | TargetSetupError | AssertionError | LinkageError | RuntimeException e) {
                    LogUtil.CLog.e("Unexpected Exception from preparer: %s", preparer.getClass().getName());
                    LogUtil.CLog.e((Throwable)e);
                    Object object = e;
                    return object;
                }
            }
        }
        finally {
            this.mModuleInfo.setActiveDeviceIndex(0);
        }
    }

    private Throwable runMultiPreparerSetup(IMultiTargetPreparer preparer) {
        if (preparer.isDisabled()) {
            return null;
        }
        TfObjectTracker.countWithParents(preparer.getClass());
        LogUtil.CLog.d("Running setup multi preparer: %s", preparer.getClass().getSimpleName());
        CloseableTraceScope ignored = new CloseableTraceScope(preparer.getClass().getName());
        try {
            if (preparer instanceof IConfigurationReceiver) {
                ((IConfigurationReceiver)((Object)preparer)).setConfiguration(this.mModuleConfiguration);
            }
            if (preparer instanceof ITestLoggerReceiver) {
                ((ITestLoggerReceiver)((Object)preparer)).setTestLogger(this.mInvocationListener);
            }
            if (preparer instanceof IInvocationContextReceiver) {
                ((IInvocationContextReceiver)((Object)preparer)).setInvocationContext(this.mModuleInvocationContext);
            }
            preparer.setUp(this.mModuleInfo);
            Throwable throwable = null;
            ignored.close();
            return throwable;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (DeviceNotAvailableException | BuildError | TargetSetupError | AssertionError | LinkageError | RuntimeException e) {
                LogUtil.CLog.e("Unexpected Exception from preparer: %s", preparer.getClass().getName());
                LogUtil.CLog.e((Throwable)e);
                return e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTearDown(TestInformation moduleInfo, Throwable exception) throws DeviceNotAvailableException {
        ArrayList<IMultiTargetPreparer> cleanerList = new ArrayList<IMultiTargetPreparer>(this.mMultiPreparers);
        Collections.reverse(cleanerList);
        for (IMultiTargetPreparer multiCleaner : cleanerList) {
            if (multiCleaner.isDisabled() || multiCleaner.isTearDownDisabled()) continue;
            LogUtil.CLog.d("Running teardown multi cleaner: %s", multiCleaner.getClass().getSimpleName());
            multiCleaner.tearDown(moduleInfo, exception);
        }
        for (int i = 0; i < this.mModuleInvocationContext.getDeviceConfigNames().size(); ++i) {
            String deviceName = this.mModuleInvocationContext.getDeviceConfigNames().get(i);
            ITestDevice device = this.mModuleInvocationContext.getDevice(deviceName);
            if (i >= this.mPreparersPerDevice.size()) {
                LogUtil.CLog.d("Main configuration has more devices than the module configuration. '%s' will not run any tear down.", deviceName);
                continue;
            }
            List<ITargetPreparer> preparers = this.mPreparersPerDevice.get(deviceName);
            if (preparers == null) {
                LogUtil.CLog.w("Module configuration devices mismatch the main configuration (Missing device '%s'), resolving preparers by index.", deviceName);
                String key = new ArrayList<String>(this.mPreparersPerDevice.keySet()).get(i);
                preparers = this.mPreparersPerDevice.get(key);
            }
            ListIterator<ITargetPreparer> itr = preparers.listIterator(preparers.size());
            while (itr.hasPrevious()) {
                ITargetPreparer preparer = itr.previous();
                if (preparer.isDisabled() || preparer.isTearDownDisabled()) {
                    LogUtil.CLog.d("%s has been disabled. skipping.", preparer);
                    continue;
                }
                ITestDevice.RecoveryMode origMode = null;
                try {
                    try (CloseableTraceScope ignored = new CloseableTraceScope(preparer.getClass().getName());){
                        if (exception != null && exception instanceof DeviceNotAvailableException) {
                            origMode = device.getRecoveryMode();
                            device.setRecoveryMode(ITestDevice.RecoveryMode.NONE);
                        }
                        moduleInfo.setActiveDeviceIndex(i);
                        preparer.tearDown(moduleInfo, exception);
                    }
                    moduleInfo.setActiveDeviceIndex(0);
                    if (origMode == null) continue;
                }
                catch (Throwable throwable) {
                    moduleInfo.setActiveDeviceIndex(0);
                    if (origMode != null) {
                        device.setRecoveryMode(origMode);
                    }
                    throw throwable;
                }
                device.setRecoveryMode(origMode);
            }
        }
    }

    private void checkEndModuleDevice(TestInformation testInfo) throws DeviceNotAvailableException {
        if (SystemUtil.isLocalMode()) {
            LogUtil.CLog.d("Skipping check for device availability after end of module for local run.");
            return;
        }
        try (CloseableTraceScope check = new CloseableTraceScope("checkEndModuleDevice");){
            for (ITestDevice device : testInfo.getDevices()) {
                if (device.getIDevice() instanceof StubDevice) continue;
                try {
                    device.waitForDeviceAvailable();
                }
                catch (DeviceNotAvailableException e) {
                    String error_msg = String.format("Device went offline after running module '%s'", this.mId);
                    if (!this.mRecoverVirtualDevice) {
                        throw new DeviceNotAvailableException(error_msg, (Throwable)e, e.getSerial(), DeviceErrorIdentifier.DEVICE_UNAVAILABLE);
                    }
                    LogUtil.CLog.d(error_msg);
                    device.getConnection().recoverVirtualDevice(device, e);
                }
            }
        }
    }

    private void recoverDevice(TestInformation testInfo, DeviceNotAvailableException e) throws DeviceNotAvailableException {
        if (SystemUtil.isLocalMode()) {
            LogUtil.CLog.d("Skipping device recovery for local run.");
            throw e;
        }
        if (!this.mRecoverVirtualDevice) {
            LogUtil.CLog.d("Skipping device recovery for as option recover-device-by-cvd is not enabled.");
            throw e;
        }
        try (CloseableTraceScope check = new CloseableTraceScope("recover_device");){
            for (ITestDevice device : testInfo.getDevices()) {
                if (device.getIDevice() instanceof StubDevice) continue;
                device.getConnection().recoverVirtualDevice(device, e);
            }
        }
    }

    private long getCurrentTime() {
        return System.currentTimeMillis();
    }

    @Override
    public void setCollectTestsOnly(boolean collectTestsOnly) {
        this.mCollectTestsOnly = collectTestsOnly;
    }

    public void setRecoverVirtualDevice(boolean recoverVirtualDevice) {
        this.mRecoverVirtualDevice = recoverVirtualDevice;
    }

    public boolean shouldRecoverVirtualDevice() {
        return this.mRecoverVirtualDevice;
    }

    public final void setMergeAttemps(boolean mergeAttempts) {
        this.mMergeAttempts = mergeAttempts;
    }

    public final void setRetryDecision(IRetryDecision decision) {
        this.mRetryDecision = decision;
        this.mModuleConfiguration.setRetryDecision(decision);
    }

    List<TestRunResult> getTestsResults() {
        return this.mTestsResults;
    }

    int getNumExpectedTests() {
        return this.mExpectedTests;
    }

    public boolean hasModuleFailed() {
        return this.mIsFailedModule;
    }

    public Set<TokenProperty> getRequiredTokens(TestInformation testInfo) {
        List<?> ctrlObjectList = this.mModuleConfiguration.getConfigurationObjectList(MODULE_CONTROLLER);
        if (ctrlObjectList == null) {
            return this.mRequiredTokens;
        }
        InvocationContext clonedContext = InvocationContext.fromProto(this.mModuleInvocationContext.toProto());
        for (String deviceName : testInfo.getContext().getDeviceConfigNames()) {
            clonedContext.addAllocatedDevice(deviceName, testInfo.getContext().getDevice(deviceName));
            clonedContext.addDeviceBuildInfo(deviceName, testInfo.getContext().getBuildInfo(deviceName));
        }
        try {
            if (!IModuleController.RunStrategy.RUN.equals((Object)this.shouldRunWithController(clonedContext))) {
                return null;
            }
        }
        catch (DeviceNotAvailableException | RuntimeException e) {
            LogUtil.CLog.e(e);
        }
        return this.mRequiredTokens;
    }

    public String toString() {
        return this.getId();
    }

    public long getRuntimeHint() {
        long hint = 0L;
        for (IRemoteTest test : this.mTests) {
            if (test instanceof IRuntimeHintProvider) {
                hint += ((IRuntimeHintProvider)((Object)test)).getRuntimeHint();
                continue;
            }
            hint += 60000L;
        }
        return hint;
    }

    @VisibleForTesting
    List<IRemoteTest> getTests() {
        return new ArrayList<IRemoteTest>(this.mTests);
    }

    @VisibleForTesting
    List<ITargetPreparer> getTargetPreparerForDevice(String deviceName) {
        return this.mPreparersPerDevice.get(deviceName);
    }

    @VisibleForTesting
    List<ITargetPreparer> getSuitePreparerForDevice(String deviceName) {
        return this.mSuitePreparersPerDevice.get(deviceName);
    }

    @VisibleForTesting
    void disableAutoRetryReportingTime() {
        this.mDisableAutoRetryTimeReporting = true;
    }

    public IInvocationContext getModuleInvocationContext() {
        return this.mModuleInvocationContext;
    }

    public IConfiguration getModuleConfiguration() {
        return this.mModuleConfiguration;
    }

    public final void reportNotExecuted(ITestInvocationListener listener, String message2) {
        if (this.mStartModuleRunDate == null) {
            listener.testModuleStarted(this.getModuleInvocationContext());
        }
        if (this.mCurrentTestWrapper != null) {
            this.mRunListenersResults.add(this.mCurrentTestWrapper.getResultListener());
            HarnessRuntimeException interruptedException = new HarnessRuntimeException(message2, TestErrorIdentifier.MODULE_DID_NOT_EXECUTE);
            for (int i = 0; i < this.mMaxRetry; ++i) {
                ArrayList<TestRunResult> runResultList = new ArrayList<TestRunResult>();
                int expectedCount = 0;
                for (ModuleListener attemptListener : this.mRunListenersResults) {
                    for (String runName : attemptListener.getTestRunNames()) {
                        TestRunResult run = attemptListener.getTestRunAtAttempt(runName, i);
                        if (run == null) continue;
                        runResultList.add(run);
                        expectedCount += run.getExpectedTestCount();
                    }
                }
                if (!runResultList.isEmpty()) {
                    this.reportFinalResults(listener, expectedCount, runResultList, i, interruptedException);
                    continue;
                }
                LogUtil.CLog.d("No results to be forwarded for attempt %s.", i);
            }
        } else {
            listener.testRunStarted(this.getId(), 0, this.mTargetPreparerRetryCount, System.currentTimeMillis());
            FailureDescription description = FailureDescription.create(message2).setFailureStatus(TestRecordProto.FailureStatus.NOT_EXECUTED).setErrorIdentifier(TestErrorIdentifier.MODULE_DID_NOT_EXECUTE);
            listener.testRunFailed(description);
            listener.testRunEnded(0L, new HashMap<String, MetricMeasurement.Metric>());
        }
        listener.testModuleEnded();
    }

    public void setEnableDynamicDownload(boolean enableDynamicDownload) {
        this.mEnableDynamicDownload = enableDynamicDownload;
    }

    public void transferSuiteLevelOptions(IConfiguration mSuiteConfiguration) {
        this.mModuleConfiguration.getCommandOptions().getDynamicDownloadArgs().putAll(mSuiteConfiguration.getCommandOptions().getDynamicDownloadArgs());
        this.mModuleConfiguration.getCommandOptions().setReportTestCaseCount(mSuiteConfiguration.getCommandOptions().reportTestCaseCount());
    }

    private IModuleController.RunStrategy applyConfigurationControl(TestFailureListener failureListener) throws DeviceNotAvailableException {
        List<?> ctrlObjectList = this.mModuleConfiguration.getConfigurationObjectList(MODULE_CONTROLLER);
        if (ctrlObjectList == null) {
            return IModuleController.RunStrategy.RUN;
        }
        for (Object ctrlObject : ctrlObjectList) {
            if (!(ctrlObject instanceof BaseModuleController)) continue;
            BaseModuleController controller = (BaseModuleController)ctrlObject;
            TfObjectTracker.countWithParents(controller.getClass());
            if (failureListener != null) {
                failureListener.applyModuleConfiguration(controller.shouldCaptureBugreport());
            }
            if (!controller.shouldCaptureLogcat()) {
                this.mRunMetricCollectors.removeIf(c -> c instanceof LogcatOnFailureCollector);
            }
            if (controller.shouldCaptureScreenshot()) continue;
            this.mRunMetricCollectors.removeIf(c -> c instanceof ScreenshotOnFailureCollector);
        }
        return this.shouldRunWithController(this.mModuleInvocationContext);
    }

    private IModuleController.RunStrategy shouldRunWithController(IInvocationContext context) throws DeviceNotAvailableException {
        List<?> ctrlObjectList = this.mModuleConfiguration.getConfigurationObjectList(MODULE_CONTROLLER);
        if (ctrlObjectList == null) {
            return IModuleController.RunStrategy.RUN;
        }
        IModuleController.RunStrategy current = IModuleController.RunStrategy.RUN;
        for (Object ctrlObject : ctrlObjectList) {
            if (!(ctrlObject instanceof BaseModuleController)) continue;
            BaseModuleController controller = (BaseModuleController)ctrlObject;
            IModuleController.RunStrategy strategy = controller.shouldRunModule(context);
            if (IModuleController.RunStrategy.FULL_MODULE_BYPASS.equals((Object)strategy)) {
                current = strategy;
                continue;
            }
            if (!IModuleController.RunStrategy.SKIP_MODULE_TESTCASES.equals((Object)strategy) || !IModuleController.RunStrategy.RUN.equals((Object)current)) continue;
            current = strategy;
        }
        return current;
    }

    private void addRetryTime(long retryTimeMs) {
        if (retryTimeMs <= 0L || this.mDisableAutoRetryTimeReporting) {
            return;
        }
        InvocationMetricLogger.addInvocationMetrics(InvocationMetricLogger.InvocationMetricKey.AUTO_RETRY_TIME, retryTimeMs);
    }

    private Throwable runTargetPreparation(Map<String, List<ITargetPreparer>> preparersPerDevice) {
        Throwable preparationException = null;
        for (int i = 0; i < this.mModuleInvocationContext.getDeviceConfigNames().size(); ++i) {
            String deviceName = this.mModuleInvocationContext.getDeviceConfigNames().get(i);
            if (i >= preparersPerDevice.size()) {
                LogUtil.CLog.d("Main configuration has more devices than the module configuration. '%s' will not run any preparation.", deviceName);
                continue;
            }
            List<ITargetPreparer> preparers = preparersPerDevice.get(deviceName);
            if (preparers == null) {
                LogUtil.CLog.w("Module configuration devices mismatch the main configuration (Missing device '%s'), resolving preparers by index.", deviceName);
                String key = new ArrayList<String>(preparersPerDevice.keySet()).get(i);
                preparers = preparersPerDevice.get(key);
            }
            for (ITargetPreparer preparer : preparers) {
                preparationException = this.runPreparerSetup(preparer, i);
                if (preparationException == null) continue;
                this.mIsFailedModule = true;
                LogUtil.CLog.e("Some preparation step failed. failing the module %s", this.getId());
                return preparationException;
            }
        }
        return null;
    }

    private Exception invokeRemoteDynamic(ITestDevice device, IConfiguration moduleConfiguration) {
        if (!this.mEnableDynamicDownload) {
            return null;
        }
        try {
            LogUtil.CLog.d("Attempting to resolve dynamic files from %s", this.getId());
            DynamicRemoteFileResolver resolver = new DynamicRemoteFileResolver();
            resolver.setDevice(device);
            resolver.addExtraArgs(moduleConfiguration.getCommandOptions().getDynamicDownloadArgs());
            moduleConfiguration.resolveDynamicOptions(resolver);
            return null;
        }
        catch (BuildRetrievalError | ConfigurationException | RuntimeException e) {
            this.mIsFailedModule = true;
            return e;
        }
    }

    private void reportSetupFailure(Throwable setupException, ITestInvocationListener invocListener, List<ITestInvocationListener> moduleListeners, int attemptNumber, boolean shouldFail) throws DeviceNotAvailableException {
        ArrayList<ITestInvocationListener> allListeners = new ArrayList<ITestInvocationListener>();
        allListeners.add(invocListener);
        if (moduleListeners != null) {
            allListeners.addAll(moduleListeners);
        }
        ResultForwarder forwarder = new ResultForwarder(allListeners);
        forwarder.testRunStarted(this.getId(), 1, attemptNumber, System.currentTimeMillis());
        FailureDescription failureDescription = CurrentInvocation.createFailure(StreamUtil.getStackTrace(setupException), null);
        if (setupException instanceof IHarnessException && ((IHarnessException)((Object)setupException)).getErrorId() != null) {
            ErrorIdentifier id = ((IHarnessException)((Object)setupException)).getErrorId();
            failureDescription.setErrorIdentifier(id);
            failureDescription.setFailureStatus(id.status());
            failureDescription.setOrigin(((IHarnessException)((Object)setupException)).getOrigin());
        } else if (setupException instanceof RuntimeException) {
            failureDescription.setFailureStatus(TestRecordProto.FailureStatus.UNSET);
            failureDescription.setErrorIdentifier(InfraErrorIdentifier.MODULE_SETUP_RUNTIME_EXCEPTION);
        } else {
            failureDescription.setFailureStatus(TestRecordProto.FailureStatus.UNSET);
        }
        failureDescription.setCause(setupException);
        forwarder.testRunFailed(failureDescription);
        HashMap<String, MetricMeasurement.Metric> metricsProto = new HashMap<String, MetricMeasurement.Metric>();
        metricsProto.put(TEST_TIME, TfMetricProtoUtil.createSingleValue(0L, "milliseconds"));
        forwarder.testRunEnded(0L, metricsProto);
        if (setupException instanceof DeviceNotAvailableException) {
            if (!shouldFail) {
                LogUtil.CLog.i("Do not report the exception as module error, returning...");
                return;
            }
            throw (DeviceNotAvailableException)setupException;
        }
    }

    private void applyFilterToTest(IRemoteTest test, Set<TestDescription> filters) {
        Set<String> filterNames = filters.stream().map(f -> f.toString()).collect(Collectors.toSet());
        if (test instanceof ITestFileFilterReceiver) {
            File excludeFilterFile = ((ITestFileFilterReceiver)((Object)test)).getExcludeTestFile();
            if (excludeFilterFile == null) {
                try {
                    excludeFilterFile = FileUtil.createTempFile("exclude-filter", ".txt");
                }
                catch (IOException e) {
                    throw new HarnessRuntimeException(e.getMessage(), e, InfraErrorIdentifier.FAIL_TO_CREATE_FILE);
                }
                ((ITestFileFilterReceiver)((Object)test)).setExcludeTestFile(excludeFilterFile);
            }
            try {
                FileUtil.writeToFile(Joiner.on('\n').join(filterNames), excludeFilterFile, true);
            }
            catch (IOException e) {
                LogUtil.CLog.e(e);
            }
        } else if (test instanceof ITestFilterReceiver) {
            ((ITestFilterReceiver)((Object)test)).addAllExcludeFilters(filterNames);
        }
    }
}

