/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite;

import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.TestResult;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.logger.CurrentInvocation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.LogSaverResultForwarder;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ModuleListener
extends CollectingTestListener {
    private boolean mSkip = false;
    private TestResult.TestStatus mTestStatus;
    private String mTrace;
    private int mTestsRan = 1;
    private final ITestInvocationListener mMainListener;
    private final IInvocationContext mModuleContext;
    private boolean mCollectTestsOnly = false;
    private boolean mRunInProgress = false;
    private CurrentInvocation.IsolationGrade mAttemptIsolation = CurrentInvocation.IsolationGrade.NOT_ISOLATED;
    private List<String> mTestMappingSources = new ArrayList<String>();
    private static final String TEST_MAPPING_SOURCE = "test_mapping_source";

    public ModuleListener(ITestInvocationListener listener, IInvocationContext moduleContext) {
        this.mMainListener = listener;
        this.mModuleContext = moduleContext;
        this.mRunInProgress = false;
        this.setIsAggregrateMetrics(true);
    }

    public void setAttemptIsolation(CurrentInvocation.IsolationGrade isolation) {
        this.mAttemptIsolation = isolation;
    }

    public void setCollectTestsOnly(boolean collectTestsOnly) {
        this.mCollectTestsOnly = collectTestsOnly;
    }

    public void setTestMappingSources(List<String> testMappingSources) {
        this.mTestMappingSources = testMappingSources;
    }

    @VisibleForTesting
    List<String> getTestMappingSources() {
        return this.mTestMappingSources;
    }

    @Override
    public void testRunStarted(String name, int numTests, int attemptNumber) {
        this.testRunStarted(name, numTests, attemptNumber, System.currentTimeMillis());
    }

    @Override
    public void testRunStarted(String name, int numTests, int attemptNumber, long startTime) {
        this.mRunInProgress = true;
        if (this.getTestRunAtAttempt(name, attemptNumber) != null) {
            numTests = 0;
        }
        super.testRunStarted(name, numTests, attemptNumber, startTime);
        if (attemptNumber != 0) {
            this.mTestsRan = 1;
        }
        LogUtil.CLog.d("ModuleListener.testRunStarted(%s, %s, %s) on %s", name, numTests, attemptNumber, this.getSerial());
    }

    @Override
    public void testRunFailed(String errorMessage) {
        LogUtil.CLog.d("ModuleListener.testRunFailed(%s) on %s", errorMessage, this.getSerial());
        super.testRunFailed(errorMessage);
    }

    @Override
    public void testRunFailed(FailureDescription failure) {
        LogUtil.CLog.d("ModuleListener.testRunFailed(%s|%s|%s) on %s", failure.getFailureStatus(), failure.getErrorIdentifier(), failure.getErrorMessage(), this.getSerial());
        super.testRunFailed(failure);
    }

    @Override
    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        LogUtil.CLog.d("ModuleListener.testRunEnded(%s) on %s", elapsedTime, this.getSerial());
        if (!CurrentInvocation.IsolationGrade.NOT_ISOLATED.equals((Object)this.mAttemptIsolation)) {
            runMetrics.put("run-isolated", TfMetricProtoUtil.stringToMetric(this.mAttemptIsolation.toString()));
            this.mAttemptIsolation = CurrentInvocation.IsolationGrade.NOT_ISOLATED;
        }
        super.testRunEnded(elapsedTime, runMetrics);
        this.mRunInProgress = false;
    }

    public boolean hasLastAttemptFailed() {
        return this.getCurrentRunResults().isRunFailure();
    }

    @Override
    public void testStarted(TestDescription test, long startTime) {
        if (!this.mCollectTestsOnly) {
            LogUtil.CLog.d("ModuleListener.testStarted(%s) on %s", test.toString(), this.getSerial());
        }
        this.mTestStatus = TestResult.TestStatus.PASSED;
        this.mTrace = null;
        super.testStarted(test, startTime);
        if (this.mSkip) {
            super.testIgnored(test);
            this.mTestStatus = TestResult.TestStatus.IGNORED;
        }
    }

    private void logTestStatus(TestDescription testName, TestResult.TestStatus status) {
        if (!this.mCollectTestsOnly) {
            String runName = "";
            if (!testName.getClassName().startsWith(this.getCurrentRunResults().getName())) {
                runName = this.getCurrentRunResults().getName() + " ";
            }
            String runAndTestCase = String.format("%s%s", runName, testName.toString());
            String message2 = String.format("[%d/%d] %s %s %s", new Object[]{this.mTestsRan, this.getExpectedTests(), this.getSerial(), runAndTestCase, status});
            if (this.mTrace != null) {
                message2 = message2 + ": " + this.mTrace;
            }
            if (TestResult.TestStatus.PASSED.equals((Object)status)) {
                LogUtil.CLog.i(message2);
            } else {
                LogUtil.CLog.logAndDisplay(Log.LogLevel.INFO, message2);
            }
        }
        ++this.mTestsRan;
    }

    @Override
    public void testEnded(TestDescription test, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        this.testEnded(test, System.currentTimeMillis(), testMetrics);
    }

    @Override
    public void testEnded(TestDescription test, long endTime, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        this.logTestStatus(test, this.mTestStatus);
        if (!this.mTestMappingSources.isEmpty()) {
            testMetrics.put(TEST_MAPPING_SOURCE, TfMetricProtoUtil.stringToMetric(this.mTestMappingSources.toString()));
        }
        super.testEnded(test, endTime, testMetrics);
    }

    @Override
    public void testIgnored(TestDescription test) {
        super.testIgnored(test);
        this.mTestStatus = TestResult.TestStatus.IGNORED;
    }

    @Override
    public void testAssumptionFailure(TestDescription test, String trace) {
        super.testAssumptionFailure(test, trace);
        this.mTestStatus = TestResult.TestStatus.ASSUMPTION_FAILURE;
        this.mTrace = trace;
    }

    @Override
    public void testAssumptionFailure(TestDescription test, FailureDescription failure) {
        super.testAssumptionFailure(test, failure);
        this.mTestStatus = TestResult.TestStatus.ASSUMPTION_FAILURE;
        this.mTrace = failure.toString();
    }

    @Override
    public void testFailed(TestDescription test, String trace) {
        if (this.mSkip) {
            return;
        }
        this.mTestStatus = TestResult.TestStatus.FAILURE;
        this.mTrace = trace;
        super.testFailed(test, trace);
    }

    @Override
    public void testFailed(TestDescription test, FailureDescription failure) {
        if (this.mSkip) {
            return;
        }
        this.mTestStatus = TestResult.TestStatus.FAILURE;
        this.mTrace = failure.toString();
        super.testFailed(test, failure);
    }

    public void setMarkTestsSkipped(boolean skip) {
        this.mSkip = skip;
    }

    @Override
    public void testLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
        if (this.mMainListener instanceof LogSaverResultForwarder) {
            ((LogSaverResultForwarder)this.mMainListener).testLogForward(dataName, dataType, dataStream);
        } else {
            super.testLog(dataName, dataType, dataStream);
        }
    }

    @Override
    public void testLogSaved(String dataName, LogDataType dataType, InputStreamSource dataStream, LogFile logFile) {
        super.testLogSaved(dataName, dataType, dataStream, logFile);
        if (this.mMainListener instanceof ILogSaverListener) {
            ((ILogSaverListener)this.mMainListener).testLogSaved(dataName, dataType, dataStream, logFile);
        }
    }

    @Override
    public void logAssociation(String dataName, LogFile logFile) {
        if (this.mRunInProgress) {
            super.logAssociation(dataName, logFile);
        } else if (this.mMainListener instanceof ILogSaverListener) {
            ((ILogSaverListener)this.mMainListener).logAssociation(dataName, logFile);
        }
    }

    private String getSerial() {
        if (this.mModuleContext == null || this.mModuleContext.getDevices().isEmpty()) {
            return "";
        }
        return this.mModuleContext.getDevices().get(0).getSerialNumber();
    }
}

