/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite;

import com.android.tradefed.testtype.suite.ITestSuite;
import com.android.tradefed.testtype.suite.ModuleDefinition;

public class ModuleMerger {
    private static void mergeModules(ModuleDefinition module1, ModuleDefinition module2) {
        if (!module1.getId().equals(module2.getId())) {
            throw new IllegalArgumentException(String.format("Modules must have the same id to be mergeable: received %s and %s", module1.getId(), module2.getId()));
        }
        module1.addTests(module2.getTests());
    }

    public static void mergeSplittedITestSuite(ITestSuite suite1, ITestSuite suite2) {
        if (suite1.getDirectModule() == null) {
            throw new IllegalArgumentException("suite was not a splitted suite.");
        }
        if (suite2.getDirectModule() == null) {
            throw new IllegalArgumentException("suite was not a splitted suite.");
        }
        ModuleMerger.mergeModules(suite1.getDirectModule(), suite2.getDirectModule());
    }

    public static boolean arePartOfSameSuite(ITestSuite suite1, ITestSuite suite2) {
        if (suite1.getDirectModule() == null) {
            return false;
        }
        if (suite2.getDirectModule() == null) {
            return false;
        }
        return suite1.getDirectModule().getId().equals(suite2.getDirectModule().getId());
    }
}

