/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.targetprep.multi.IMultiTargetPreparer;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IShardableTest;
import com.android.tradefed.testtype.suite.ModuleDefinition;
import com.android.tradefed.testtype.suite.ValidateSuiteConfigHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModuleSplitter {
    private static final int MAX_MODULE_LOCAL_SHARDING = 8;

    public static List<ModuleDefinition> splitConfiguration(TestInformation testInfo, LinkedHashMap<String, IConfiguration> runConfig, Map<String, List<ITargetPreparer>> suitePreparersPerDevice, int shardCount, boolean dynamicModule, boolean intraModuleSharding) {
        if (dynamicModule) {
            shardCount *= 2;
        }
        ArrayList<ModuleDefinition> runModules = new ArrayList<ModuleDefinition>();
        for (Map.Entry<String, IConfiguration> configMap : runConfig.entrySet()) {
            ValidateSuiteConfigHelper.validateConfig(configMap.getValue());
            try {
                ModuleSplitter.createAndAddModule(testInfo, runModules, configMap.getKey(), configMap.getValue(), shardCount, dynamicModule, intraModuleSharding, suitePreparersPerDevice);
            }
            catch (RuntimeException e) {
                LogUtil.CLog.e("Exception while creating module for '%s'", configMap.getKey());
                throw e;
            }
        }
        return runModules;
    }

    private static void createAndAddModule(TestInformation testInfo, List<ModuleDefinition> currentList, String moduleName, IConfiguration config, int shardCount, boolean dynamicModule, boolean intraModuleSharding, Map<String, List<ITargetPreparer>> suitePreparersPerDevice) {
        List<IRemoteTest> tests = config.getTests();
        config.setTests(new ArrayList<IRemoteTest>());
        if (config.getConfigurationDescription().isNotIRemoteTestShardable()) {
            ModuleDefinition module = new ModuleDefinition(moduleName, tests, ModuleSplitter.clonePreparersMap(config), ModuleSplitter.clonePreparersMap(suitePreparersPerDevice), ModuleSplitter.clonePreparers(config.getMultiTargetPreparers()), config);
            currentList.add(module);
            ModuleSplitter.clearPreparersFromConfig(config);
            return;
        }
        if (!intraModuleSharding || config.getConfigurationDescription().isNotShardable() || !dynamicModule && config.getConfigurationDescription().isNotStrictShardable()) {
            for (int i = 0; i < tests.size(); ++i) {
                if (dynamicModule) {
                    ModuleDefinition module = new ModuleDefinition(moduleName, tests, ModuleSplitter.clonePreparersMap(config), ModuleSplitter.clonePreparersMap(suitePreparersPerDevice), ModuleSplitter.clonePreparers(config.getMultiTargetPreparers()), config);
                    currentList.add(module);
                    continue;
                }
                ModuleSplitter.addModuleToListFromSingleTest(currentList, tests.get(i), moduleName, config, suitePreparersPerDevice);
            }
            ModuleSplitter.clearPreparersFromConfig(config);
            return;
        }
        for (IRemoteTest test : tests) {
            int shard;
            Collection<IRemoteTest> shardedTests;
            if (test instanceof IShardableTest && (shardedTests = ((IShardableTest)test).split(shard = Math.min(8, shardCount), testInfo)) != null) {
                if (dynamicModule) {
                    for (int i = 0; i < shardedTests.size(); ++i) {
                        ModuleDefinition module = new ModuleDefinition(moduleName, shardedTests, ModuleSplitter.clonePreparersMap(config), ModuleSplitter.clonePreparersMap(suitePreparersPerDevice), ModuleSplitter.clonePreparers(config.getMultiTargetPreparers()), config);
                        currentList.add(module);
                    }
                    continue;
                }
                for (IRemoteTest moduleTest : shardedTests) {
                    ModuleSplitter.addModuleToListFromSingleTest(currentList, moduleTest, moduleName, config, suitePreparersPerDevice);
                }
                continue;
            }
            ModuleSplitter.addModuleToListFromSingleTest(currentList, test, moduleName, config, suitePreparersPerDevice);
        }
        ModuleSplitter.clearPreparersFromConfig(config);
    }

    private static void addModuleToListFromSingleTest(List<ModuleDefinition> currentList, IRemoteTest test, String moduleName, IConfiguration config, Map<String, List<ITargetPreparer>> suitePreparersPerDevice) {
        ArrayList<IRemoteTest> testList = new ArrayList<IRemoteTest>();
        testList.add(test);
        ModuleDefinition module = new ModuleDefinition(moduleName, testList, ModuleSplitter.clonePreparersMap(config), ModuleSplitter.clonePreparersMap(suitePreparersPerDevice), ModuleSplitter.clonePreparers(config.getMultiTargetPreparers()), config);
        currentList.add(module);
    }

    private static <T> List<T> clonePreparers(List<T> preparerList) {
        ArrayList clones = new ArrayList();
        for (T prep : preparerList) {
            try {
                Object clone = prep.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                OptionCopier.copyOptions(prep, clone);
                if (clone instanceof IAbiReceiver) {
                    ((IAbiReceiver)clone).setAbi(((IAbiReceiver)prep).getAbi());
                }
                clones.add(clone);
            }
            catch (ConfigurationException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return clones;
    }

    private static Map<String, List<ITargetPreparer>> clonePreparersMap(IConfiguration config) {
        LinkedHashMap<String, List<ITargetPreparer>> res = new LinkedHashMap<String, List<ITargetPreparer>>();
        for (IDeviceConfiguration holder : config.getDeviceConfig()) {
            ArrayList<ITargetPreparer> preparers = new ArrayList<ITargetPreparer>();
            res.put(holder.getDeviceName(), preparers);
            preparers.addAll(ModuleSplitter.clonePreparers(holder.getTargetPreparers()));
        }
        return res;
    }

    private static Map<String, List<ITargetPreparer>> clonePreparersMap(Map<String, List<ITargetPreparer>> suitePreparersPerDevice) {
        LinkedHashMap<String, List<ITargetPreparer>> res = new LinkedHashMap<String, List<ITargetPreparer>>();
        for (String device : suitePreparersPerDevice.keySet()) {
            ArrayList<ITargetPreparer> preparers = new ArrayList<ITargetPreparer>();
            res.put(device, preparers);
            preparers.addAll(ModuleSplitter.clonePreparers(suitePreparersPerDevice.get(device)));
        }
        return res;
    }

    private static void clearPreparersFromConfig(IConfiguration config) {
        try {
            for (IDeviceConfiguration holder : config.getDeviceConfig()) {
                holder.removeObjectType("target_preparer");
            }
            config.setMultiTargetPreparers(new ArrayList<IMultiTargetPreparer>());
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

