/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite;

import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FailureDescription;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.suite.ModuleDefinition;
import com.android.tradefed.testtype.suite.ModuleListener;
import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

public class RemoteTestTimeOutEnforcer
implements ITestInvocationListener {
    public static final String REMOTE_TEST_TIMEOUT_OPTION = "remote-test-timeout";
    public static final String REMOTE_TEST_TIMEOUT_DESCRIPTION = "The timeout that will be applied to each remote test object of the run.";
    private IRemoteTest mIRemoteTest;
    private Duration mTimeOut;
    private ModuleDefinition mModuleDefinition;
    private ModuleListener mListener;

    public RemoteTestTimeOutEnforcer(ModuleListener listener, ModuleDefinition moduleDefinition, IRemoteTest test, Duration timeOut) {
        this.mListener = listener;
        this.mIRemoteTest = test;
        this.mModuleDefinition = moduleDefinition;
        this.mTimeOut = timeOut;
    }

    @Override
    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        if (elapsedTime >= this.mTimeOut.toMillis()) {
            String failureString = String.format("%s defined in %s took %s seconds while timeout is %s seconds", this.mModuleDefinition.getId(), this.mModuleDefinition.getModuleInvocationContext().getConfigurationDescriptor().getMetaData(Integer.toString(this.mIRemoteTest.hashCode())), TimeUnit.MILLISECONDS.toSeconds(elapsedTime), this.mTimeOut.toSeconds());
            if (!this.mListener.hasLastAttemptFailed()) {
                FailureDescription failure = FailureDescription.create(failureString, TestRecordProto.FailureStatus.TIMED_OUT).setRetriable(false);
                this.mListener.testRunFailed(failure);
            }
        }
    }
}

