/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.config.DynamicRemoteFileResolver;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.service.IRemoteFeature;
import com.android.tradefed.testtype.ITestInformationReceiver;
import com.android.tradefed.util.StreamUtil;
import com.proto.tradefed.feature.ErrorInfo;
import com.proto.tradefed.feature.FeatureRequest;
import com.proto.tradefed.feature.FeatureResponse;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class ResolvePartialDownload
implements IRemoteFeature,
ITestInformationReceiver {
    public static final String RESOLVE_PARTIAL_DOWNLOAD_FEATURE_NAME = "resolvePartialDownload";
    public static final String INCLUDE_FILTERS = "include_filters";
    public static final String EXCLUDE_FILTERS = "exclude_filters";
    public static final String DESTINATION_DIR = "destination_dir";
    public static final String REMOTE_PATHS = "remote_paths";
    private TestInformation mTestInformation;
    private DynamicRemoteFileResolver mResolver;

    public ResolvePartialDownload() {
    }

    protected ResolvePartialDownload(DynamicRemoteFileResolver resolver) {
        this();
        this.mResolver = resolver;
    }

    @Override
    public void setTestInformation(TestInformation testInformation) {
        this.mTestInformation = testInformation;
    }

    @Override
    public TestInformation getTestInformation() {
        return this.mTestInformation;
    }

    @Override
    public String getName() {
        return RESOLVE_PARTIAL_DOWNLOAD_FEATURE_NAME;
    }

    @Override
    public FeatureResponse execute(FeatureRequest request) {
        FeatureResponse.Builder responseBuilder = FeatureResponse.newBuilder();
        try {
            DynamicRemoteFileResolver dynamicResolver = this.getResolver();
            dynamicResolver.setDevice(this.mTestInformation.getDevice());
            HashMap<String, String> args = new HashMap<String, String>(request.getArgsMap());
            String destDir = (String)args.remove(DESTINATION_DIR);
            String includeFilter = (String)args.remove(INCLUDE_FILTERS);
            List<String> includeFilterList = null;
            if (includeFilter != null) {
                includeFilterList = Arrays.asList(includeFilter);
            }
            String excludeFilter = (String)args.remove(EXCLUDE_FILTERS);
            List<String> excludeFilterList = null;
            if (excludeFilter != null) {
                excludeFilterList = Arrays.asList(excludeFilter);
            }
            dynamicResolver.addExtraArgs(args);
            String remotePaths = (String)args.remove(REMOTE_PATHS);
            HashSet<String> allPaths = new HashSet<String>();
            List<String> remotePathList = null;
            if (remotePaths != null) {
                remotePathList = Arrays.asList(remotePaths.split(";"));
                allPaths.addAll(remotePathList);
            }
            for (File remotePath : this.mTestInformation.getBuildInfo().getRemoteFiles()) {
                allPaths.add(remotePath.toString());
            }
            for (String path : allPaths) {
                dynamicResolver.resolvePartialDownloadZip(new File(destDir), path, includeFilterList, excludeFilterList);
            }
            if (allPaths.isEmpty()) {
                responseBuilder.setResponse("No remote paths specified. Nothing downloaded.");
            }
        }
        catch (BuildRetrievalError | RuntimeException e) {
            responseBuilder.setErrorInfo(ErrorInfo.newBuilder().setErrorTrace(StreamUtil.getStackTrace(e)));
            LogUtil.CLog.e(e);
        }
        return responseBuilder.build();
    }

    private DynamicRemoteFileResolver getResolver() {
        if (this.mResolver == null) {
            return new DynamicRemoteFileResolver();
        }
        return this.mResolver;
    }
}

