/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.suite;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.ConfigurationUtil;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationFactory;
import com.android.tradefed.config.IDeviceConfiguration;
import com.android.tradefed.config.OptionDef;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.DeviceFoldableState;
import com.android.tradefed.error.HarnessRuntimeException;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.ITestFileFilterReceiver;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.testtype.suite.SuiteTestFilter;
import com.android.tradefed.testtype.suite.params.FoldableExpandingHandler;
import com.android.tradefed.testtype.suite.params.IModuleParameterHandler;
import com.android.tradefed.testtype.suite.params.MainlineModuleHandler;
import com.android.tradefed.testtype.suite.params.ModuleParameters;
import com.android.tradefed.testtype.suite.params.ModuleParametersHelper;
import com.android.tradefed.testtype.suite.params.NegativeHandler;
import com.android.tradefed.testtype.suite.params.NotMultiAbiHandler;
import com.android.tradefed.util.AbiUtils;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import com.google.common.base.Strings;
import com.google.common.net.UrlEscapers;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SuiteModuleLoader {
    public static final String CONFIG_EXT = ".config";
    private Map<String, List<OptionDef>> mTestOrPreparerOptions = new HashMap<String, List<OptionDef>>();
    private Map<String, List<OptionDef>> mModuleOptions = new HashMap<String, List<OptionDef>>();
    private boolean mIncludeAll;
    private Map<String, LinkedHashSet<SuiteTestFilter>> mIncludeFilters = new HashMap<String, LinkedHashSet<SuiteTestFilter>>();
    private Map<String, LinkedHashSet<SuiteTestFilter>> mExcludeFilters = new HashMap<String, LinkedHashSet<SuiteTestFilter>>();
    private IConfigurationFactory mConfigFactory = ConfigurationFactory.getInstance();
    private IInvocationContext mContext;
    private boolean mAllowParameterizedModules = false;
    private boolean mAllowMainlineParameterizedModules = false;
    private boolean mOptimizeMainlineTest = false;
    private boolean mIgnoreNonPreloadedMainlineModule = false;
    private boolean mAllowOptionalParameterizedModules = false;
    private boolean mLoadConfigsWithIncludeFilters = false;
    private ModuleParameters mForcedModuleParameter = null;
    private Set<ModuleParameters> mExcludedModuleParameters = new HashSet<ModuleParameters>();
    private Set<DeviceFoldableState> mFoldableStates = new LinkedHashSet<DeviceFoldableState>();
    private static final Set<String> MAINLINE_PARAMETERS_TO_VALIDATE = new HashSet<String>(Arrays.asList(".apk", ".apks", ".apex"));

    public SuiteModuleLoader(Map<String, LinkedHashSet<SuiteTestFilter>> includeFilters, Map<String, LinkedHashSet<SuiteTestFilter>> excludeFilters, List<String> testArgs, List<String> moduleArgs) {
        this.mIncludeAll = includeFilters.isEmpty();
        this.mIncludeFilters = includeFilters;
        this.mExcludeFilters = excludeFilters;
        this.parseArgs(testArgs, this.mTestOrPreparerOptions);
        this.parseArgs(moduleArgs, this.mModuleOptions);
    }

    public final void setInvocationContext(IInvocationContext context) {
        this.mContext = context;
    }

    public final void setParameterizedModules(boolean allowed) {
        this.mAllowParameterizedModules = allowed;
    }

    public final void setMainlineParameterizedModules(boolean allowed) {
        this.mAllowMainlineParameterizedModules = allowed;
    }

    public final void setOptimizeMainlineTest(boolean allowed) {
        this.mOptimizeMainlineTest = allowed;
    }

    public final void setIgnoreNonPreloadedMainlineModule(boolean ignore) {
        this.mIgnoreNonPreloadedMainlineModule = ignore;
    }

    public final void setOptionalParameterizedModules(boolean allowed) {
        this.mAllowOptionalParameterizedModules = allowed;
    }

    public final void setLoadConfigsWithIncludeFilters(boolean allowed) {
        this.mLoadConfigsWithIncludeFilters = allowed;
    }

    public final void setModuleParameter(ModuleParameters param) {
        this.mForcedModuleParameter = param;
    }

    public final void setExcludedModuleParameters(Set<ModuleParameters> excludedParams) {
        this.mExcludedModuleParameters = excludedParams;
    }

    public final void setFoldableStates(Set<DeviceFoldableState> foldableStates) {
        this.mFoldableStates = foldableStates;
    }

    public LinkedHashMap<String, IConfiguration> loadConfigsFromSpecifiedPaths(List<File> listConfigFiles, Set<IAbi> abis, String suiteTag) {
        LinkedHashMap<String, IConfiguration> toRun = new LinkedHashMap<String, IConfiguration>();
        for (File configFile : listConfigFiles) {
            toRun.putAll(this.loadOneConfig(configFile.getName(), configFile.getAbsolutePath(), abis, suiteTag));
        }
        return toRun;
    }

    public LinkedHashMap<String, IConfiguration> loadConfigsFromDirectory(List<File> testsDirs, Set<IAbi> abis, String suitePrefix, String suiteTag, List<String> patterns) {
        LinkedHashMap<String, IConfiguration> toRun = new LinkedHashMap<String, IConfiguration>();
        ArrayList<File> listConfigFiles = new ArrayList<File>();
        listConfigFiles.addAll(ConfigurationUtil.getConfigNamesFileFromDirs(suitePrefix, testsDirs, patterns));
        if (this.mLoadConfigsWithIncludeFilters && !this.mIncludeFilters.isEmpty()) {
            LogUtil.CLog.i("Loading test configs based on the given include-filter.");
            HashSet<String> filteredConfigNames = new HashSet<String>();
            for (LinkedHashSet<SuiteTestFilter> entry : this.mIncludeFilters.values()) {
                for (SuiteTestFilter file2 : entry) {
                    filteredConfigNames.add(String.format("%s.config", file2.getBaseName()));
                }
            }
            List filteredConfigs = listConfigFiles.stream().filter(f -> filteredConfigNames.contains(f.getName())).collect(Collectors.toList());
            listConfigFiles.clear();
            listConfigFiles.addAll(filteredConfigs);
        }
        Collections.sort(listConfigFiles);
        toRun.putAll(this.loadConfigsFromSpecifiedPaths(listConfigFiles, abis, suiteTag));
        return toRun;
    }

    public LinkedHashMap<String, IConfiguration> loadConfigsFromJars(Set<IAbi> abis, String suitePrefix, String suiteTag) {
        LinkedHashMap<String, IConfiguration> toRun = new LinkedHashMap<String, IConfiguration>();
        IConfigurationFactory configFactory = ConfigurationFactory.getInstance();
        List<String> configs = configFactory.getConfigList(suitePrefix, false);
        Collections.sort(configs);
        toRun.putAll(this.loadTfConfigsFromSpecifiedPaths(configs, abis, suiteTag));
        return toRun;
    }

    public LinkedHashMap<String, IConfiguration> loadTfConfigsFromSpecifiedPaths(List<String> configs, Set<IAbi> abis, String suiteTag) {
        LinkedHashMap<String, IConfiguration> toRun = new LinkedHashMap<String, IConfiguration>();
        for (String configName : configs) {
            toRun.putAll(this.loadOneConfig(configName, configName, abis, suiteTag));
        }
        return toRun;
    }

    public void addFiltersToTest(IRemoteTest test, IAbi abi, String moduleId, Map<String, LinkedHashSet<SuiteTestFilter>> includeFilters, Map<String, LinkedHashSet<SuiteTestFilter>> excludeFilters) {
        if (!(test instanceof ITestFilterReceiver)) {
            LogUtil.CLog.e("Test (%s) in module %s does not implement ITestFilterReceiver.", test.getClass().getName(), moduleId);
            return;
        }
        LinkedHashSet<SuiteTestFilter> mdIncludes = SuiteModuleLoader.getFilterList(includeFilters, moduleId);
        LinkedHashSet<SuiteTestFilter> mdExcludes = SuiteModuleLoader.getFilterList(excludeFilters, moduleId);
        if (!mdIncludes.isEmpty()) {
            this.addTestIncludes((ITestFilterReceiver)((Object)test), mdIncludes, moduleId);
        }
        if (!mdExcludes.isEmpty()) {
            this.addTestExcludes((ITestFilterReceiver)((Object)test), mdExcludes, moduleId);
        }
    }

    private LinkedHashMap<String, IConfiguration> loadOneConfig(String configName, String configFullName, Set<IAbi> abis, String suiteTag) {
        LinkedHashMap<String, IConfiguration> toRun = new LinkedHashMap<String, IConfiguration>();
        String name = configName.replace(CONFIG_EXT, "");
        String[] pathArg = new String[]{configFullName};
        try {
            boolean primaryAbi = true;
            boolean shouldCreateMultiAbi = true;
            HashSet<IModuleParameterHandler> mForcedParameters = null;
            HashSet mForcedParameterClasses = null;
            if (this.mForcedModuleParameter != null) {
                mForcedParameters = new HashSet<IModuleParameterHandler>();
                Map<ModuleParameters, IModuleParameterHandler> moduleParameters = ModuleParametersHelper.resolveParam(this.mForcedModuleParameter, this.mAllowOptionalParameterizedModules);
                mForcedParameterClasses = new HashSet();
                for (IModuleParameterHandler parameter : moduleParameters.values()) {
                    if (parameter instanceof FoldableExpandingHandler) {
                        for (IModuleParameterHandler fParam : ((FoldableExpandingHandler)parameter).expandHandler(this.mFoldableStates)) {
                            mForcedParameterClasses.add(fParam.getClass());
                        }
                        continue;
                    }
                    mForcedParameterClasses.add(parameter.getClass());
                }
            }
            for (IAbi abi : abis) {
                String nameWithParam;
                String fullId;
                if (!shouldCreateMultiAbi && !primaryAbi) continue;
                String baseId = AbiUtils.createId(abi.getName(), name);
                IConfiguration config = null;
                try {
                    config = this.mConfigFactory.createConfigurationFromArgs(pathArg);
                }
                catch (ConfigurationException e) {
                    if (!this.shouldRunModule(baseId)) {
                        primaryAbi = false;
                        continue;
                    }
                    throw e;
                }
                if (!Strings.isNullOrEmpty(suiteTag) && !config.getConfigurationDescription().getSuiteTags().contains(suiteTag)) continue;
                boolean skipCreatingBaseConfig = false;
                List<IModuleParameterHandler> params = null;
                List<Object> mainlineParams = new ArrayList();
                try {
                    params = this.getModuleParameters(name, config);
                    mainlineParams = this.getMainlineModuleParameters(config);
                }
                catch (ConfigurationException e) {
                    if (!this.shouldRunModule(baseId)) {
                        primaryAbi = false;
                        continue;
                    }
                    throw e;
                }
                shouldCreateMultiAbi = this.shouldCreateMultiAbiForBase(params);
                if (this.mAllowParameterizedModules) {
                    if (params.isEmpty() && mForcedParameters != null && mForcedParameters.size() == 1 && !(mForcedParameters.iterator().next() instanceof NegativeHandler)) continue;
                    for (IModuleParameterHandler iModuleParameterHandler : params) {
                        if (iModuleParameterHandler instanceof NegativeHandler) {
                            if (mForcedParameters == null || mForcedParameterClasses.contains(iModuleParameterHandler.getClass())) continue;
                            skipCreatingBaseConfig = true;
                            continue;
                        }
                        if (mForcedParameters != null) {
                            if (!mForcedParameterClasses.contains(iModuleParameterHandler.getClass())) continue;
                            skipCreatingBaseConfig = true;
                        }
                        if (!primaryAbi) continue;
                        fullId = String.format("%s[%s]", baseId, iModuleParameterHandler.getParameterIdentifier());
                        if (!this.shouldRunParameterized(baseId, fullId, nameWithParam = String.format("%s[%s]", name, iModuleParameterHandler.getParameterIdentifier()), mForcedParameters)) continue;
                        IConfiguration paramConfig = this.mConfigFactory.createConfigurationFromArgs(pathArg);
                        paramConfig.getConfigurationDescription().addMetadata("active-parameter", iModuleParameterHandler.getParameterIdentifier());
                        iModuleParameterHandler.addParameterSpecificConfig(paramConfig);
                        this.setUpConfig(name, nameWithParam, baseId, fullId, paramConfig, abi);
                        iModuleParameterHandler.applySetup(paramConfig);
                        toRun.put(fullId, paramConfig);
                    }
                }
                if (this.mAllowMainlineParameterizedModules) {
                    if (mainlineParams.isEmpty()) continue;
                    for (String string : mainlineParams) {
                        fullId = String.format("%s[%s]", baseId, string);
                        if (!this.shouldRunParameterized(baseId, fullId, nameWithParam = String.format("%s[%s]", name, string), null)) continue;
                        MainlineModuleHandler handler = new MainlineModuleHandler(string, abi, this.mContext, this.mOptimizeMainlineTest, this.mIgnoreNonPreloadedMainlineModule);
                        skipCreatingBaseConfig = true;
                        IConfiguration paramConfig = this.mConfigFactory.createConfigurationFromArgs(pathArg);
                        paramConfig.getConfigurationDescription().addMetadata("active-mainline-parameter", string);
                        this.setUpConfig(name, nameWithParam, baseId, fullId, paramConfig, abi);
                        handler.applySetup(paramConfig);
                        toRun.put(fullId, paramConfig);
                    }
                }
                primaryAbi = false;
                if (skipCreatingBaseConfig || !this.shouldRunModule(baseId)) continue;
                this.setUpConfig(name, null, baseId, baseId, config, abi);
                toRun.put(baseId, config);
            }
        }
        catch (ConfigurationException e) {
            throw new HarnessRuntimeException(String.format("Error parsing configuration: %s: '%s'", configFullName, e.getMessage()), e);
        }
        return toRun;
    }

    public static Set<File> getModuleNamesMatching(File directory, String suitePrefix, String pattern) {
        List<File> extraTestCasesDirs = Arrays.asList(directory);
        ArrayList<String> patterns = new ArrayList<String>();
        patterns.add(pattern);
        Set<File> modules = ConfigurationUtil.getConfigNamesFileFromDirs(suitePrefix, extraTestCasesDirs, patterns);
        return modules;
    }

    public static void addFilters(Set<String> stringFilters, Map<String, LinkedHashSet<SuiteTestFilter>> filters, Set<IAbi> abis, Set<DeviceFoldableState> foldableStates) {
        for (String filterString : stringFilters) {
            SuiteTestFilter parentFilter = SuiteTestFilter.createFrom(filterString);
            List<SuiteTestFilter> expanded = SuiteModuleLoader.expandFoldableFilters(parentFilter, foldableStates);
            for (SuiteTestFilter filter : expanded) {
                String abi = filter.getAbi();
                if (abi == null) {
                    for (IAbi a : abis) {
                        SuiteModuleLoader.addFilter(a.getName(), filter, filters);
                    }
                    continue;
                }
                SuiteModuleLoader.addFilter(abi, filter, filters);
            }
        }
    }

    private static List<SuiteTestFilter> expandFoldableFilters(SuiteTestFilter filter, Set<DeviceFoldableState> foldableStates) {
        ArrayList<SuiteTestFilter> expandedFilters = new ArrayList<SuiteTestFilter>();
        if (foldableStates == null || foldableStates.isEmpty()) {
            expandedFilters.add(filter);
            return expandedFilters;
        }
        if (!ModuleParameters.ALL_FOLDABLE_STATES.toString().equals(filter.getParameterName())) {
            expandedFilters.add(filter);
            return expandedFilters;
        }
        for (DeviceFoldableState state : foldableStates) {
            String name = filter.getBaseName() + "[" + state.toString() + "]";
            expandedFilters.add(new SuiteTestFilter(filter.getShardIndex(), filter.getAbi(), name, filter.getTest()));
        }
        return expandedFilters;
    }

    private static void addFilter(String abi, SuiteTestFilter filter, Map<String, LinkedHashSet<SuiteTestFilter>> filters) {
        SuiteModuleLoader.getFilterList(filters, AbiUtils.createId(abi, filter.getName())).add(filter);
    }

    private static LinkedHashSet<SuiteTestFilter> getFilterList(Map<String, LinkedHashSet<SuiteTestFilter>> filters, String id) {
        LinkedHashSet<SuiteTestFilter> fs = filters.get(id);
        if (fs == null) {
            fs = new LinkedHashSet();
            filters.put(id, fs);
        }
        return fs;
    }

    private boolean shouldRunModule(String moduleId) {
        LinkedHashSet<SuiteTestFilter> mdIncludes = SuiteModuleLoader.getFilterList(this.mIncludeFilters, moduleId);
        LinkedHashSet<SuiteTestFilter> mdExcludes = SuiteModuleLoader.getFilterList(this.mExcludeFilters, moduleId);
        return (this.mIncludeAll || !mdIncludes.isEmpty()) && !this.containsModuleExclude(mdExcludes);
    }

    private boolean shouldRunParameterized(String baseModuleId, String parameterModuleId, String nameWithParam, Set<IModuleParameterHandler> forcedModuleParameters) {
        LinkedHashSet<SuiteTestFilter> baseInclude;
        LinkedHashSet<SuiteTestFilter> excluded = SuiteModuleLoader.getFilterList(this.mExcludeFilters, parameterModuleId);
        LinkedHashSet<SuiteTestFilter> excludedParam = SuiteModuleLoader.getFilterList(this.mExcludeFilters, nameWithParam);
        if (this.containsModuleExclude(excluded) || this.containsModuleExclude(excludedParam)) {
            return false;
        }
        if (forcedModuleParameters != null && !(baseInclude = SuiteModuleLoader.getFilterList(this.mIncludeFilters, baseModuleId)).isEmpty()) {
            return true;
        }
        LinkedHashSet<SuiteTestFilter> included = SuiteModuleLoader.getFilterList(this.mIncludeFilters, parameterModuleId);
        LinkedHashSet<SuiteTestFilter> includedParam = SuiteModuleLoader.getFilterList(this.mIncludeFilters, nameWithParam);
        return this.mIncludeAll || !included.isEmpty() || !includedParam.isEmpty();
    }

    private void addTestIncludes(ITestFilterReceiver test, Collection<SuiteTestFilter> includes, String moduleId) {
        if (test instanceof ITestFileFilterReceiver) {
            String escapedFileName = this.escapeFilterFileName(moduleId);
            File includeFile = this.createFilterFile(escapedFileName, ".include", includes);
            ((ITestFileFilterReceiver)((Object)test)).setIncludeTestFile(includeFile);
        } else {
            for (SuiteTestFilter include : includes) {
                String filterTestName = include.getTest();
                if (filterTestName == null) continue;
                test.addIncludeFilter(filterTestName);
            }
        }
    }

    private void addTestExcludes(ITestFilterReceiver test, Collection<SuiteTestFilter> excludes, String moduleId) {
        if (test instanceof ITestFileFilterReceiver) {
            String escapedFileName = this.escapeFilterFileName(moduleId);
            File excludeFile = this.createFilterFile(escapedFileName, ".exclude", excludes);
            ((ITestFileFilterReceiver)((Object)test)).setExcludeTestFile(excludeFile);
        } else {
            for (SuiteTestFilter exclude : excludes) {
                test.addExcludeFilter(exclude.getTest());
            }
        }
    }

    private String escapeFilterFileName(String moduleId) {
        String escaped = UrlEscapers.urlPathSegmentEscaper().escape(moduleId);
        return escaped;
    }

    private File createFilterFile(String prefix, String suffix, Collection<SuiteTestFilter> filters) {
        File filterFile = null;
        PrintWriter out = null;
        try {
            filterFile = FileUtil.createTempFile(prefix, suffix);
            out = new PrintWriter(filterFile);
            for (SuiteTestFilter filter : filters) {
                String filterTest = filter.getTest();
                if (filterTest == null) continue;
                out.println(filterTest);
            }
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new HarnessRuntimeException("Failed to create filter file", e, InfraErrorIdentifier.FAIL_TO_CREATE_FILE);
            }
            catch (Throwable throwable) {
                StreamUtil.close(out);
                throw throwable;
            }
        }
        StreamUtil.close(out);
        filterFile.deleteOnExit();
        return filterFile;
    }

    private boolean containsModuleExclude(Collection<SuiteTestFilter> excludes) {
        for (SuiteTestFilter exclude : excludes) {
            if (exclude.getTest() != null) continue;
            return true;
        }
        return false;
    }

    private void parseArgs(List<String> args, Map<String, List<OptionDef>> moduleOptions) {
        for (String arg : args) {
            int optionNameSep;
            int moduleSep = arg.indexOf(":");
            if (moduleSep == -1) {
                throw new RuntimeException("Expected delimiter ':' for module or class.");
            }
            String moduleName = arg.substring(0, moduleSep);
            String remainder = arg.substring(moduleSep + 1);
            List<OptionDef> listOption = moduleOptions.get(moduleName);
            if (listOption == null) {
                listOption = new ArrayList<OptionDef>();
                moduleOptions.put(moduleName, listOption);
            }
            if ((optionNameSep = remainder.indexOf(":")) == -1) {
                throw new RuntimeException("Expected delimiter ':' between option name and values.");
            }
            String optionName = remainder.substring(0, optionNameSep);
            Pattern pattern = Pattern.compile("\\{(.*)\\}(.*)");
            Matcher match = pattern.matcher(optionName);
            if (match.find()) {
                String alias = match.group(1);
                String name = match.group(2);
                optionName = alias + ":" + name;
            }
            String optionValueString = remainder.substring(optionNameSep + 1);
            String[] tokens = optionValueString.split(":=", 2);
            OptionDef option = null;
            if (tokens.length == 1) {
                option = new OptionDef(optionName, tokens[0], moduleName);
            } else if (tokens.length == 2) {
                option = new OptionDef(optionName, tokens[0], tokens[1], moduleName);
            }
            listOption.add(option);
        }
    }

    private List<IModuleParameterHandler> getModuleParameters(String moduleName, IConfiguration config) throws ConfigurationException {
        ArrayList<IModuleParameterHandler> params = new ArrayList<IModuleParameterHandler>();
        HashSet<String> processedParameterArgs = new HashSet<String>();
        LinkedHashMap<String, ModuleParameters> duplicateModule = new LinkedHashMap<String, ModuleParameters>();
        List<String> parameters = config.getConfigurationDescription().getMetaData("parameter");
        if (parameters == null || parameters.isEmpty()) {
            return params;
        }
        HashSet<ModuleParameters> expandedExcludedModuleParameters = new HashSet<ModuleParameters>();
        for (ModuleParameters moduleParameters : this.mExcludedModuleParameters) {
            expandedExcludedModuleParameters.addAll(ModuleParametersHelper.resolveParam(moduleParameters, this.mAllowOptionalParameterizedModules).keySet());
        }
        for (String p : parameters) {
            if (!processedParameterArgs.add(p)) continue;
            Map<ModuleParameters, IModuleParameterHandler> suiteParams = ModuleParametersHelper.resolveParam(ModuleParameters.valueOf(p.toUpperCase()), this.mAllowOptionalParameterizedModules);
            for (Map.Entry<ModuleParameters, IModuleParameterHandler> suiteParamEntry : suiteParams.entrySet()) {
                ModuleParameters suiteParam = suiteParamEntry.getKey();
                String family = suiteParam.getFamily();
                if (duplicateModule.containsKey(family)) {
                    throw new ConfigurationException(String.format("Module %s is declaring parameter: %s and %s when only one expected.", new Object[]{moduleName, suiteParam, duplicateModule.get(family)}));
                }
                duplicateModule.put(suiteParam.getFamily(), suiteParam);
                if (expandedExcludedModuleParameters.contains((Object)suiteParam)) continue;
                if (suiteParamEntry.getValue() instanceof FoldableExpandingHandler) {
                    List<IModuleParameterHandler> foldableHandlers = ((FoldableExpandingHandler)suiteParamEntry.getValue()).expandHandler(this.mFoldableStates);
                    params.addAll(foldableHandlers);
                    continue;
                }
                params.add(suiteParamEntry.getValue());
            }
        }
        return params;
    }

    List<String> getMainlineModuleParameters(IConfiguration config) throws ConfigurationException {
        ArrayList<String> params = new ArrayList<String>();
        List<String> parameters = config.getConfigurationDescription().getMetaData("mainline-param");
        if (parameters == null || parameters.isEmpty()) {
            return params;
        }
        return new ArrayList<String>(this.dedupMainlineParameters(parameters, config.getName()));
    }

    Set<String> dedupMainlineParameters(List<String> parameters, String configName) throws ConfigurationException {
        HashSet<String> results = new HashSet<String>();
        for (String param : parameters) {
            if (!this.isValidMainlineParam(param)) {
                throw new ConfigurationException(String.format("Illegal mainline module parameter: \"%s\" configured in the test config: %s. Parameter must end with .apk/.apex/.apks and have no any spaces configured.", param, configName));
            }
            if (!this.isInAlphabeticalOrder(param)) {
                throw new ConfigurationException(String.format("Illegal mainline module parameter: \"%s\" configured in the test config: %s. Parameter must be configured in alphabetical order or with no duplicated modules.", param, configName));
            }
            results.add(param);
        }
        return results;
    }

    boolean isInAlphabeticalOrder(String param) {
        String previousString = "";
        for (String currentString : param.split(String.format("\\+", new Object[0]))) {
            if (currentString.compareTo(previousString) <= 0) {
                return false;
            }
            previousString = currentString;
        }
        return true;
    }

    boolean isValidMainlineParam(String param) {
        if (param.contains(" ")) {
            return false;
        }
        for (String m : param.split(String.format("\\+", new Object[0]))) {
            if (MAINLINE_PARAMETERS_TO_VALIDATE.stream().anyMatch(entry -> m.endsWith((String)entry))) continue;
            return false;
        }
        return true;
    }

    private void setUpConfig(String name, String nameWithParam, String id, String fullId, IConfiguration config, IAbi abi) throws ConfigurationException {
        ArrayList<OptionDef> optionsToInject = new ArrayList<OptionDef>();
        if (this.mModuleOptions.containsKey(name)) {
            optionsToInject.addAll((Collection)this.mModuleOptions.get(name));
        }
        if (nameWithParam != null && this.mModuleOptions.containsKey(nameWithParam)) {
            optionsToInject.addAll((Collection)this.mModuleOptions.get(nameWithParam));
        }
        if (this.mModuleOptions.containsKey(id)) {
            optionsToInject.addAll((Collection)this.mModuleOptions.get(id));
        }
        if (this.mModuleOptions.containsKey(fullId)) {
            optionsToInject.addAll((Collection<OptionDef>)this.mModuleOptions.get(fullId));
        }
        config.injectOptionValues(optionsToInject);
        for (IDeviceConfiguration holder : config.getDeviceConfig()) {
            for (ITargetPreparer preparer : holder.getTargetPreparers()) {
                String className = preparer.getClass().getName();
                if (this.mTestOrPreparerOptions.containsKey(className)) {
                    OptionSetter preparerSetter = new OptionSetter(preparer);
                    for (OptionDef def : this.mTestOrPreparerOptions.get(className)) {
                        preparerSetter.setOptionValue(def.name, def.key, def.value);
                    }
                }
                if (!(preparer instanceof IAbiReceiver)) continue;
                ((IAbiReceiver)((Object)preparer)).setAbi(abi);
            }
        }
        List<IRemoteTest> tests = config.getTests();
        for (IRemoteTest test : tests) {
            String className = test.getClass().getName();
            if (this.mTestOrPreparerOptions.containsKey(className)) {
                OptionSetter preparerSetter = new OptionSetter(test);
                for (OptionDef def : this.mTestOrPreparerOptions.get(className)) {
                    preparerSetter.setOptionValue(def.name, def.key, def.value);
                }
            }
            this.addFiltersToTest(test, abi, fullId, this.mIncludeFilters, this.mExcludeFilters);
            if (!(test instanceof IAbiReceiver)) continue;
            ((IAbiReceiver)((Object)test)).setAbi(abi);
        }
        config.getConfigurationDescription().setAbi(abi);
        config.getConfigurationDescription().setModuleName(name);
        config.validateOptions();
    }

    private boolean shouldCreateMultiAbiForBase(List<IModuleParameterHandler> params) {
        for (IModuleParameterHandler param : params) {
            if (!(param instanceof NotMultiAbiHandler)) continue;
            return false;
        }
        return true;
    }

    public static class ConfigFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(SuiteModuleLoader.CONFIG_EXT);
        }
    }
}

